/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.utils.DeformationModelFileParser;
import scratch.UCERF3.utils.GeologicSlipRate;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class GeologicSlipRateLoader {
    private static String getCellAsString(HSSFCell cell) {
        if (cell.getCellType() == 1) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == 0) {
            return "" + cell.getNumericCellValue();
        }
        if (cell.getCellType() == 3) {
            return null;
        }
        throw new IllegalStateException("cell is neither a string, blank, nor numeric");
    }

    public static ArrayList<GeologicSlipRate> loadExcelFile(URL url) throws FileNotFoundException, IOException {
        return GeologicSlipRateLoader.loadExcelFile(new BufferedInputStream(url.openStream()));
    }

    public static ArrayList<GeologicSlipRate> loadExcelFile(File excelFile) throws FileNotFoundException, IOException {
        return GeologicSlipRateLoader.loadExcelFile(new FileInputStream(excelFile));
    }

    public static ArrayList<GeologicSlipRate> loadExcelFile(InputStream is) throws FileNotFoundException, IOException {
        int idCol;
        int valCol;
        int lonCol;
        int latCol;
        ArrayList<GeologicSlipRate> rates = new ArrayList<GeologicSlipRate>();
        POIFSFileSystem fs = new POIFSFileSystem(is);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        wb.setMissingCellPolicy(Row.CREATE_NULL_AS_BLANK);
        HSSFSheet sheet = wb.getSheetAt(0);
        boolean newTable = sheet.getRow(0).getCell(8).getStringCellValue().startsWith("ID");
        boolean newerTable = sheet.getRow(0).getCell(10).getStringCellValue().startsWith("Site-specific Data");
        if (newTable) {
            latCol = 21;
            lonCol = 20;
            valCol = 17;
            idCol = 8;
        } else if (newerTable) {
            latCol = 12;
            lonCol = 11;
            valCol = 9;
            idCol = 1;
        } else {
            latCol = 10;
            lonCol = 9;
            valCol = 16;
            idCol = -1;
        }
        for (int rowInd = 2; rowInd <= sheet.getLastRowNum(); ++rowInd) {
            GeologicSlipRate geo;
            double lon;
            double lat;
            HSSFRow row = sheet.getRow(rowInd);
            try {
                String latStr;
                String lonStr = GeologicSlipRate.numbersSpacesOnly(GeologicSlipRateLoader.getCellAsString(row.getCell(lonCol)), true);
                if (lonStr == null || lonStr.length() == 0 || (latStr = GeologicSlipRate.numbersSpacesOnly(GeologicSlipRateLoader.getCellAsString(row.getCell(latCol)), true)) == null || lonStr.length() == 0) continue;
                lat = Double.parseDouble(latStr);
                lon = Double.parseDouble(lonStr);
            }
            catch (Exception e) {
                System.out.println("Error parsint location: " + e.getMessage());
                continue;
            }
            Location loc = new Location(lat, lon);
            String valStr = GeologicSlipRateLoader.getCellAsString(row.getCell(valCol));
            if (valStr == null || valStr.length() == 0) {
                System.out.println("Skipping empty value at loc: " + String.valueOf(loc));
                continue;
            }
            try {
                geo = GeologicSlipRate.fromString(loc, valStr);
            }
            catch (Exception e) {
                System.out.println("Couldn't parse slip rate: " + valStr + " (" + e.getMessage() + ")");
                continue;
            }
            if (idCol >= 0) {
                String idStr = GeologicSlipRate.numbersSpacesOnly(GeologicSlipRateLoader.getCellAsString(row.getCell(idCol)), true);
                geo.setSectID((int)Double.parseDouble(idStr));
            }
            rates.add(geo);
        }
        return rates;
    }

    private static void writeMinisectionAssociations(FaultModels fm, File file) throws FileNotFoundException, IOException {
        ArrayList<GeologicSlipRate> rates = GeologicSlipRateLoader.loadExcelFile(UCERF3_DataUtils.locateResourceAsStream("DeformationModels", "geologic_slip_rate_sites_2012_07_11.xls"));
        Map<Integer, FaultSection> sects = fm.getFaultSectionIDMap();
        CSVFile csv = new CSVFile(true);
        csv.addLine(Lists.newArrayList((Object[])new String[]{"Minisection", "Name", "Site Lon", "Site Lat", "Minisection Distance (KM)", "UCERF3 Preferred Rate"}));
        for (GeologicSlipRate r : rates) {
            Location loc = r.getLocation();
            FaultSection sect = sects.get(r.getSectID());
            if (sect == null) {
                System.out.println("No section ID found with ID: " + r.getSectID());
                ArrayList line = Lists.newArrayList((Object[])new String[]{r.getSectID() + " ??", "", "" + (float)r.getLocation().getLongitude(), "" + (float)r.getLocation().getLatitude(), "", "" + (float)r.getValue()});
                csv.addLine(line);
                continue;
            }
            double minDist = Double.MAX_VALUE;
            int closestMini = -1;
            FaultTrace trace = sect.getFaultTrace();
            for (int mini = 0; mini < trace.size() - 1; ++mini) {
                FaultTrace subTrace = new FaultTrace("" + mini);
                subTrace.add((Location)trace.get(mini));
                subTrace.add((Location)trace.get(mini + 1));
                StirlingGriddedSurface surf = new StirlingGriddedSurface(subTrace, sect.getAveDip(), sect.getOrigAveUpperDepth(), sect.getAveLowerDepth(), 1.0, sect.getDipDirection());
                for (Location surfLoc : surf) {
                    double d = LocationUtils.linearDistanceFast(loc, surfLoc);
                    if (!(d < minDist)) continue;
                    minDist = d;
                    closestMini = mini;
                }
            }
            int[] miniSection = new int[]{sect.getSectionId(), closestMini + 1};
            String miniStr = DeformationModelFileParser.getMinisectionString(miniSection);
            ArrayList line = Lists.newArrayList((Object[])new String[]{miniStr, sect.getName(), "" + (float)r.getLocation().getLongitude(), "" + (float)r.getLocation().getLatitude(), "" + (float)minDist, "" + (float)r.getValue()});
            if (minDist > 5.0) {
                System.out.println("WARNING - assignment for " + sect.getSectionName() + " (" + sect.getSectionId() + ") is far: " + minDist + " km");
            }
            csv.addLine(line);
        }
        csv.writeToFile(file);
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        ArrayList<GeologicSlipRate> rates = GeologicSlipRateLoader.loadExcelFile(new File("/tmp/UCERF3_Geologic_Slip Rates_version 3_2011_08_03.xls"));
        System.out.println("Loading new slips!");
        rates = GeologicSlipRateLoader.loadExcelFile(UCERF3_DataUtils.locateResourceAsStream("DeformationModels", "geologic_slip_rate_sites_2012_07_11.xls"));
        for (GeologicSlipRate r : rates) {
            System.out.println(r.getSectID() + "\t" + r.getValue());
        }
        GeologicSlipRateLoader.writeMinisectionAssociations(FaultModels.FM3_1, new File("/tmp/fm_3_1_geologic_mini_assignment.csv"));
        GeologicSlipRateLoader.writeMinisectionAssociations(FaultModels.FM3_2, new File("/tmp/fm_3_2_geologic_mini_assignment.csv"));
    }
}

