/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.JsonAdapter;
import org.dom4j.Element;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.geo.Region;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.utils.MFD_InversionConstraint;

@JsonAdapter(value=MFD_InversionConstraint.Adapter.class)
public class MFD_WeightedInversionConstraint
extends MFD_InversionConstraint {
    public static final String XML_METADATA_NAME = "MFD_WeightedInversionConstraint";
    EvenlyDiscretizedFunc weights;

    public MFD_WeightedInversionConstraint(IncrementalMagFreqDist mfd, Region region, EvenlyDiscretizedFunc weights) {
        super(mfd, region);
        this.weights = weights;
        this.validateDiscretization();
    }

    private void validateDiscretization() {
        Preconditions.checkState((this.mfd.getMinX() == this.weights.getMinX() ? 1 : 0) != 0, (String)"minX of mfd and weight objects must be equal", (Object)this.mfd.getMinX(), (Object)this.weights.getMinX());
        Preconditions.checkState((this.mfd.getMaxX() == this.weights.getMaxX() ? 1 : 0) != 0, (String)"maxX of mfd and weight objects must be equal", (Object)this.mfd.getMaxX(), (Object)this.weights.getMaxX());
        Preconditions.checkState((this.mfd.size() == this.weights.size() ? 1 : 0) != 0, (String)"size of mfd and weight objects must be equal", (int)this.mfd.size(), (int)this.weights.size());
    }

    public void setWeights(EvenlyDiscretizedFunc weights) {
        this.weights = weights;
        this.validateDiscretization();
    }

    public EvenlyDiscretizedFunc getWeights() {
        return this.weights;
    }

    @Override
    @Deprecated
    public Element toXMLMetadata(Element root) {
        throw new UnsupportedOperationException("No more XML, sorry");
    }
}

