/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils.ModUCERF2;

import java.util.ArrayList;
import java.util.Collections;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.B_FaultsFetcherForMeanUCERF;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.A_FaultsFetcher;
import org.opensha.sha.earthquake.util.EqkSourceNameComparator;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.utils.ModUCERF2.ModMeanUCERF2;
import scratch.UCERF3.utils.ModUCERF2.UnsegmentedSource;

public class ModMeanUCERF2_FM2pt2
extends ModMeanUCERF2 {
    protected static String C = new String("MeanUCERF2 Modified, FM 2.2");
    public static final String NAME = new String("WGCEP (2007) UCERF2 - Single Branch, Modified, Fault Model 2.1 only");

    private void mkB_FaultSources() {
        A_FaultsFetcher aFaultsFetcher = this.ucerf2.getA_FaultsFetcher();
        B_FaultsFetcherForMeanUCERF bFaultsFetcher = new B_FaultsFetcherForMeanUCERF(aFaultsFetcher, true);
        this.bFaultSources = new ArrayList();
        double rupOffset = (Double)this.rupOffsetParam.getValue();
        double empiricalModelWt = 0.0;
        String probModel = (String)this.probModelParam.getValue();
        if (probModel.equals("BPT") || probModel.equals("Poisson")) {
            empiricalModelWt = 0.0;
        } else if (probModel.equals("Empirical")) {
            empiricalModelWt = 1.0;
        } else if (probModel.equals("WGCEP Preferred Blend")) {
            empiricalModelWt = 0.3;
        }
        double duration = this.timeSpan.getDuration();
        double wt = 0.5;
        boolean ddwCorr = (Boolean)this.cybershakeDDW_CorrParam.getValue();
        int floaterType = this.getFloaterType();
        ArrayList<FaultSegmentData> faultSegDataList = bFaultsFetcher.getB_FaultsCommonConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 1.0;
        faultSegDataList = bFaultsFetcher.getB_FaultsCommonNoConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 0.5;
        faultSegDataList = bFaultsFetcher.getB_FaultsUniqueToF2_2ConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 1.0;
        faultSegDataList = bFaultsFetcher.getB_FaultsUniqueToF2_2NoConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 0.75;
        faultSegDataList = bFaultsFetcher.getB_FaultsCommonWithUniqueConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        if (this.calcSummedMFDs) {
            this.bFaultSummedMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
            for (int srcIndex = 0; srcIndex < this.bFaultSources.size(); ++srcIndex) {
                UnsegmentedSource source = (UnsegmentedSource)this.bFaultSources.get(srcIndex);
                int numRups = source.getNumRuptures();
                for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
                    ProbEqkRupture rup = source.getRupture(rupIndex);
                    double mag = rup.getMag();
                    double rate = rup.getMeanAnnualRate(duration);
                    this.bFaultSummedMFD.add(mag, rate);
                }
            }
        }
    }

    private void addToB_FaultSources(double rupOffset, double empiricalModelWt, double duration, double wt, ArrayList<FaultSegmentData> faultSegDataList, boolean ddwCorr, int floaterType) {
        for (int i = 0; i < faultSegDataList.size(); ++i) {
            if (faultSegDataList.get(i).getFaultName().equalsIgnoreCase("Mendocino")) continue;
            this.bFaultSources.add(new UnsegmentedSource(faultSegDataList.get(i), this.empiricalModel, rupOffset, wt, empiricalModelWt, duration, ddwCorr, floaterType, Double.NaN));
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void updateForecast() {
        if (this.parameterChangeFlag) {
            super.updateForecast();
            this.allSources = new ArrayList();
            String backSeis = (String)this.backSeisParam.getValue();
            if (!backSeis.equalsIgnoreCase(UCERF2.BACK_SEIS_ONLY)) {
                this.mkB_FaultSources();
                Collections.sort(this.bFaultSources, new EqkSourceNameComparator());
                this.allSources.addAll(this.aFaultSegmentedSources);
                this.allSources.addAll(this.aFaultUnsegmentedSources);
                this.allSources.addAll(this.bFaultSources);
                this.allSources.addAll(this.nonCA_bFaultSources);
            }
            if (backSeis.equalsIgnoreCase(UCERF2.BACK_SEIS_INCLUDE) || backSeis.equalsIgnoreCase(UCERF2.BACK_SEIS_ONLY)) {
                this.allSources.addAll(this.nshmp_gridSrcGen.getAllFixedStrikeSources(this.timeSpan.getDuration()));
            }
        }
        this.parameterChangeFlag = false;
    }
}

