/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.scec.getfile.GetFile;

public class UCERF3_Downloader
extends GetFile {
    private static final List<URI> ENDPOINTS = List.of(URI.create("https://g-3a9041.a78b8.36fe.data.globus.org/getfile/ucerf3/ucerf3.json"), URI.create("https://data.opensha.org/getfile/ucerf3/ucerf3.json"), URI.create("https://opensha.scec.org/getfile/ucerf3/ucerf3.json"));

    public UCERF3_Downloader(File storeDir, boolean showProgress) {
        super("UCERF3", new File(storeDir, "ucerf3_client.json"), ENDPOINTS, showProgress);
    }

    public UCERF3_Downloader(boolean showProgress) {
        this(UCERF3_Downloader.getStoreDir(), showProgress);
    }

    public UCERF3_Downloader(File storeDir) {
        this(storeDir, true);
    }

    public UCERF3_Downloader() {
        this(true);
    }

    public static File getStoreDir() {
        Path storeDir = Paths.get(System.getProperty("user.home"), ".opensha", "ucerf3");
        try {
            Files.createDirectories(storeDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("UCERF3_Downloader failed to create storeDir at " + String.valueOf(storeDir));
            e.printStackTrace();
        }
        return storeDir.toFile();
    }
}

