/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils.UpdatedUCERF2;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.opensha.nshmp2.erf.NSHMP2008;
import org.opensha.nshmp2.erf.source.GridERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import scratch.UCERF3.utils.UpdatedUCERF2.U2GridSources;

public class NSHMP08_GridSourceGenerator {
    private NSHMP2008 gridListERF;
    private int[] erfIndices;

    public NSHMP08_GridSourceGenerator(U2GridSources id) {
        this.gridListERF = id == U2GridSources.ALL ? NSHMP2008.createCaliforniaGridded() : (id == U2GridSources.FIX_STRK ? NSHMP2008.createCaliforniaFixedStrk() : NSHMP2008.createCaliforniaPointSrc());
        ArrayList indexList = Lists.newArrayList();
        int total = 0;
        for (ERF erf : this.gridListERF) {
            indexList.add(total);
            total += erf.getNumSources();
        }
        this.erfIndices = Ints.toArray((Collection)indexList);
        for (ERF erf : this.gridListERF) {
            GridERF gerf = (GridERF)erf;
            gerf.scaleRatesToWeight();
        }
    }

    public ProbEqkSource getSource(int srcIdx) {
        int erfIdx = Arrays.binarySearch(this.erfIndices, srcIdx);
        erfIdx = erfIdx < 0 ? -(erfIdx + 2) : erfIdx;
        return this.gridListERF.getERF(erfIdx).getSource(srcIdx -= this.erfIndices[erfIdx]);
    }

    public int getNumSources() {
        return this.gridListERF.getSourceCount();
    }

    public void setForecastDuration(double duration) {
        this.gridListERF.getTimeSpan().setDuration(duration);
    }
}

