/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.dom4j.DocumentException;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.utils.U3FaultSystemIO;

class SubSectCoruptureRateCalc {
    SubSectCoruptureRateCalc() {
    }

    public static void main(String[] args) throws IOException, DocumentException {
        int i;
        int[] indexes = null;
        String[] names = new String[]{"San Andreas (Mojave S), Subsection 14", "San Andreas (San Bernardino N), Subsection 2", "San Jacinto (San Bernardino), Subsection 1"};
        double[] minMags = new double[]{0.0, 7.0};
        File fssFile = new File("/home/kevin/workspace/opensha-ucerf3/src/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip");
        U3FaultSystemSolution fss = U3FaultSystemIO.loadSol(fssFile);
        FaultSystemRupSet rupSet = ((FaultSystemSolution)fss).getRupSet();
        if (indexes == null) {
            System.out.println("Determining indexes from names");
            indexes = new int[names.length];
            for (i = 0; i < names.length; ++i) {
                indexes[i] = -1;
                for (int j = 0; j < rupSet.getNumSections(); ++j) {
                    if (!rupSet.getFaultSectionData(j).getName().equals(names[i])) continue;
                    indexes[i] = j;
                    break;
                }
                Preconditions.checkState((indexes[i] >= 0 ? 1 : 0) != 0, (Object)("No match found for: " + names[i]));
            }
        } else {
            names = new String[indexes.length];
            for (i = 0; i < indexes.length; ++i) {
                names[i] = rupSet.getFaultSectionData(indexes[i]).getName();
            }
        }
        ArrayList<HashSet<Integer>> rupLists = new ArrayList<HashSet<Integer>>();
        for (int s : indexes) {
            rupLists.add(new HashSet<Integer>(rupSet.getRupturesForSection(s)));
        }
        for (double minMag : minMags) {
            System.out.println();
            if (minMag > 0.0) {
                System.out.println("Minimum magnitude: " + (float)minMag);
            } else {
                System.out.println("All supra-seismogenic magnitudes");
            }
            for (int i2 = 0; i2 < indexes.length; ++i2) {
                for (int j = i2 + 1; j < indexes.length; ++j) {
                    HashSet rups = new HashSet((Collection)rupLists.get(i2));
                    rups.retainAll((Collection)rupLists.get(j));
                    double rate = 0.0;
                    Iterator iterator = rups.iterator();
                    while (iterator.hasNext()) {
                        int r = (Integer)iterator.next();
                        if (!(rupSet.getMagForRup(r) >= minMag)) continue;
                        rate += fss.getRateForRup(r);
                    }
                    System.out.println("Corupture rate, '" + names[i2] + "' and '" + names[j] + "': " + (float)rate);
                }
            }
        }
    }
}

