/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Region;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.U3CompoundFaultSystemSolution;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.logicTree.U3APrioriBranchWeightProvider;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;

class UCERF3_MFD_CSV_Writer {
    UCERF3_MFD_CSV_Writer() {
    }

    public static void main(String[] args) throws ZipException, IOException {
        U3CompoundFaultSystemSolution cfss = U3CompoundFaultSystemSolution.fromZipFile(new File("/home/kevin/workspace/opensha-ucerf3/src/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL.zip"));
        FaultModels fm = FaultModels.FM3_1;
        DeformationModels dm = DeformationModels.GEOLOGIC;
        CaliforniaRegions.RELM_NOCAL region = new CaliforniaRegions.RELM_NOCAL();
        File outputDir = new File("/home/kevin/OpenSHA/UCERF3/mfd_csv_files/nocal");
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        U3APrioriBranchWeightProvider weightProv = new U3APrioriBranchWeightProvider();
        ArrayList<IncrementalMagFreqDist> offMFDs = new ArrayList<IncrementalMagFreqDist>();
        ArrayList<IncrementalMagFreqDist> subMFDs = new ArrayList<IncrementalMagFreqDist>();
        ArrayList<IncrementalMagFreqDist> supraMFDs = new ArrayList<IncrementalMagFreqDist>();
        ArrayList<Double> weights = new ArrayList<Double>();
        double totWeight = 0.0;
        for (U3LogicTreeBranch branch : cfss.getBranches()) {
            if (fm != null && branch.getValue(FaultModels.class) != fm || dm != null && branch.getValue(DeformationModels.class) != dm) continue;
            InversionFaultSystemSolution sol = cfss.getSolution(branch);
            double weight = weightProv.getWeight(branch);
            totWeight += weight;
            weights.add(weight);
            IncrementalMagFreqDist offMFD = sol.getFinalTrulyOffFaultMFD();
            SummedMagFreqDist subMFD = sol.getFinalTotalSubSeismoOnFaultMFD();
            IncrementalMagFreqDist supraMFD = sol.calcNucleationMFD_forRegion((Region)region, 0.05, 8.95, 90, true);
            Preconditions.checkState((offMFD.size() == subMFD.size() ? 1 : 0) != 0, (String)"%s != %s", (int)offMFD.size(), (int)subMFD.size());
            Preconditions.checkState((offMFD.size() == supraMFD.size() ? 1 : 0) != 0, (String)"%s != %s", (int)offMFD.size(), (int)supraMFD.size());
            Preconditions.checkState((offMFD.getMinX() == subMFD.getMinX() ? 1 : 0) != 0);
            Preconditions.checkState((offMFD.getMinX() == supraMFD.getMinX() ? 1 : 0) != 0);
            for (int i = 0; i < offMFD.size(); ++i) {
                double x = offMFD.getX(i);
                Preconditions.checkState((boolean)Double.isFinite(offMFD.getY(i)), (String)"Non-finite value for x=%s: %s", (Object)x, (Object)offMFD.getY(i));
                Preconditions.checkState((boolean)Double.isFinite(subMFD.getY(i)), (String)"Non-finite value for x=%s: %s", (Object)x, (Object)subMFD.getY(i));
                Preconditions.checkState((boolean)Double.isFinite(supraMFD.getY(i)), (String)"Non-finite value for x=%s: %s", (Object)x, (Object)supraMFD.getY(i));
            }
            offMFDs.add(offMFD);
            subMFDs.add(subMFD);
            supraMFDs.add(supraMFD);
            if (offMFDs.size() % 10 != 0) continue;
            System.out.println("Done with " + offMFDs.size() + " branches");
        }
        System.out.println("Loaded MFDs for " + supraMFDs.size() + " branches");
        Object fm_dm_prefix = "";
        if (fm != null) {
            fm_dm_prefix = fm.encodeChoiceString() + "_";
        }
        if (dm != null) {
            fm_dm_prefix = (String)fm_dm_prefix + dm.encodeChoiceString() + "_";
        }
        String[] prefixes = new String[]{(String)fm_dm_prefix + "supra_seis", (String)fm_dm_prefix + "supra_plus_sub_seis", (String)fm_dm_prefix + "total"};
        List<SummedMagFreqDist> subPlusSupra = UCERF3_MFD_CSV_Writer.sumMFDs(supraMFDs, subMFDs);
        List<SummedMagFreqDist> total = UCERF3_MFD_CSV_Writer.sumMFDs(supraMFDs, subMFDs);
        ArrayList<List<IncrementalMagFreqDist>> mfdLists = new ArrayList<List<IncrementalMagFreqDist>>();
        mfdLists.add(supraMFDs);
        mfdLists.add(subPlusSupra);
        mfdLists.add(total);
        for (int i = 0; i < prefixes.length; ++i) {
            for (boolean cumulative : new boolean[]{false, true}) {
                EvenlyDiscretizedFunc[] array = UCERF3_MFD_CSV_Writer.getMeanMinMax((List)mfdLists.get(i), weights, totWeight, cumulative);
                EvenlyDiscretizedFunc meanFunc = array[0];
                EvenlyDiscretizedFunc minFunc = array[1];
                EvenlyDiscretizedFunc maxFunc = array[2];
                CSVFile<String> csv = new CSVFile<String>(true);
                csv.addLine("Magnitude", "Mean", "Min", "Max");
                for (int j = 0; j < meanFunc.size(); ++j) {
                    csv.addLine("" + meanFunc.getX(j), "" + meanFunc.getY(j), "" + minFunc.getY(j), "" + maxFunc.getY(j));
                }
                Object myPrefix = prefixes[i];
                myPrefix = cumulative ? (String)myPrefix + "_cumulative" : (String)myPrefix + "_incremental";
                csv.writeToFile(new File(outputDir, (String)myPrefix + ".csv"));
            }
        }
    }

    private static List<SummedMagFreqDist> sumMFDs(List<IncrementalMagFreqDist> list1, List<IncrementalMagFreqDist> list2) {
        ArrayList<SummedMagFreqDist> ret = new ArrayList<SummedMagFreqDist>();
        for (int i = 0; i < list1.size(); ++i) {
            IncrementalMagFreqDist mfd1 = list1.get(i);
            IncrementalMagFreqDist mfd2 = list2.get(i);
            SummedMagFreqDist summedMFD = new SummedMagFreqDist(mfd1.getMinX(), mfd1.getMaxX(), mfd1.size());
            summedMFD.addIncrementalMagFreqDist(mfd1);
            summedMFD.addIncrementalMagFreqDist(mfd2);
            ret.add(summedMFD);
        }
        return ret;
    }

    private static EvenlyDiscretizedFunc[] getMeanMinMax(List<? extends IncrementalMagFreqDist> mfds, List<Double> weights, double totWeight, boolean cumulative) {
        EvenlyDiscretizedFunc minFunc = null;
        EvenlyDiscretizedFunc maxFunc = null;
        EvenlyDiscretizedFunc meanFunc = null;
        for (int i = 0; i < mfds.size(); ++i) {
            int j;
            EvenlyDiscretizedFunc mfd = cumulative ? mfds.get(i).getCumRateDistWithOffset() : (EvenlyDiscretizedFunc)mfds.get(i);
            double weight = weights.get(i) / totWeight;
            if (minFunc == null) {
                minFunc = new EvenlyDiscretizedFunc(mfd.getMinX(), mfd.getMaxX(), mfd.size());
                for (j = 0; j < minFunc.size(); ++j) {
                    minFunc.set(j, Double.POSITIVE_INFINITY);
                }
                maxFunc = new EvenlyDiscretizedFunc(mfd.getMinX(), mfd.getMaxX(), mfd.size());
                meanFunc = new EvenlyDiscretizedFunc(mfd.getMinX(), mfd.getMaxX(), mfd.size());
            }
            Preconditions.checkState((mfd.size() == minFunc.size() ? 1 : 0) != 0);
            for (j = 0; j < mfd.size(); ++j) {
                double val = mfd.getY(j);
                minFunc.set(j, Math.min(val, minFunc.getY(j)));
                maxFunc.set(j, Math.max(val, maxFunc.getY(j)));
                meanFunc.add(j, val * weight);
            }
        }
        for (int j = 0; j < minFunc.size(); ++j) {
            if (!Double.isInfinite(minFunc.getY(j))) continue;
            minFunc.set(j, 0.0);
        }
        return new EvenlyDiscretizedFunc[]{meanFunc, minFunc, maxFunc};
    }
}

