/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;

public class SamplingM7ProbPlot
extends ETAS_AbstractPlot {
    private static final double minMag = 7.0;
    private static final int subsetSize = 5000;
    private static final int numSubsets = 10000;
    private static double[] durations = new double[]{0.019164955509924708, 1.0, 10.0};
    private List<List<Boolean>> hasMatches = new ArrayList<List<Boolean>>();
    private long[] maxOTs = new long[durations.length];

    protected SamplingM7ProbPlot(ETAS_Config config, ETAS_Launcher launcher) {
        super(config, launcher);
        for (int i = 0; i < this.maxOTs.length; ++i) {
            this.maxOTs[i] = (long)((double)config.getSimulationStartTimeMillis() + 3.15576E10 * durations[i]);
            this.hasMatches.add(new ArrayList());
        }
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public boolean isFilterSpontaneous() {
        return false;
    }

    @Override
    protected void doProcessCatalog(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
        boolean[] hasIts = new boolean[this.maxOTs.length];
        for (ETAS_EqkRupture rup : completeCatalog) {
            if (!(rup.getMag() >= 7.0)) continue;
            for (int i = 0; i < this.maxOTs.length; ++i) {
                if (rup.getOriginTime() > this.maxOTs[i]) continue;
                hasIts[i] = true;
            }
        }
        for (int i = 0; i < hasIts.length; ++i) {
            this.hasMatches.get(i).add(hasIts[i]);
        }
    }

    @Override
    protected List<? extends Runnable> doFinalize(File outputDir, FaultSystemSolution fss, ExecutorService exec) throws IOException {
        for (int d = 0; d < this.maxOTs.length; ++d) {
            double totalProb = SamplingM7ProbPlot.calcProb(0, this.hasMatches.get(d)) * 100.0;
            System.out.println("Total prob: " + totalProb);
            HistogramFunction probsHist = HistogramFunction.getEncompassingHistogram(0.0, 3.0 * totalProb, totalProb / 25.0);
            for (int i = 0; i < 10000; ++i) {
                double prob = SamplingM7ProbPlot.calcProb(5000, this.hasMatches.get(d));
                probsHist.add(probsHist.getClosestXIndex(prob * 100.0), 1.0);
            }
            double maxY = probsHist.getMaxY() * 1.2;
            ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            funcs.add(probsHist);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.GRAY));
            funcs.add(SamplingM7ProbPlot.vertLine(totalProb, maxY, "Mean=" + (float)totalProb + " %"));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
            double[] simConf = ETAS_Utils.getBinomialProportion95confidenceInterval(totalProb / 100.0, this.hasMatches.size());
            double[] subsetConf = ETAS_Utils.getBinomialProportion95confidenceInterval(totalProb / 100.0, 5000.0);
            funcs.add(SamplingM7ProbPlot.vertLine(simConf[0] * 100.0, maxY, "95% conf"));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK));
            funcs.add(SamplingM7ProbPlot.vertLine(simConf[1] * 100.0, maxY, null));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK));
            funcs.add(SamplingM7ProbPlot.vertLine(subsetConf[0] * 100.0, maxY, "Subset 95% conf"));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.RED));
            funcs.add(SamplingM7ProbPlot.vertLine(subsetConf[1] * 100.0, maxY, null));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.RED));
            String prefix = "prob_var_hist_" + SamplingM7ProbPlot.getTimeShortLabel(durations[d]).replaceAll(" ", "");
            PlotSpec plot = new PlotSpec(funcs, chars, SamplingM7ProbPlot.getTimeLabel(durations[d], false) + " M7.0 variability, subsets of N=5000 catalogs", "Probability (%)", "");
            plot.setLegendVisible(true);
            HeadlessGraphPanel gp = SamplingM7ProbPlot.buildGraphPanel();
            gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
            gp.drawGraphPanel(plot, false, false, new Range(0.0, probsHist.getMaxX() + 0.5 * probsHist.getDelta()), new Range(0.0, maxY));
            gp.getChartPanel().setSize(1000, 800);
            gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        }
        return null;
    }

    private static XY_DataSet vertLine(double x, double maxY, String name) {
        DefaultXY_DataSet line = new DefaultXY_DataSet();
        line.set(x, 0.0);
        line.set(x, maxY);
        line.setName(name);
        return line;
    }

    private static double calcProb(int numToInclude, List<Boolean> matches) {
        if (numToInclude < matches.size() && numToInclude > 0) {
            ArrayList<Boolean> subMatches = new ArrayList<Boolean>(matches);
            Collections.shuffle(subMatches);
            matches = subMatches.subList(0, numToInclude);
        }
        int numWith = 0;
        int totalNum = matches.size();
        for (boolean match : matches) {
            if (!match) continue;
            ++numWith;
        }
        return (double)numWith / (double)totalNum;
    }

    @Override
    public List<String> generateMarkdown(String relativePathToOutputDir, String topLevelHeading, String topLink) throws IOException {
        return null;
    }

    public static void main(String[] args) throws IOException {
        File simDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2019_11_04-ComCatM7p1_ci38457511_122DaysAfter_ShakeMapSurfaces");
        File binFile = new File(simDir, "results_complete.bin");
        if (!binFile.exists()) {
            binFile = new File(simDir, "results_m5_preserve_chain.bin");
        }
        System.out.println("Bin file: " + binFile.getAbsolutePath());
        ETAS_Config config = ETAS_Config.readJSON(new File(simDir, "config.json"));
        ETAS_Launcher launcher = new ETAS_Launcher(config, false);
        SamplingM7ProbPlot plot = new SamplingM7ProbPlot(config, launcher);
        plot.processCatalogsFile(binFile);
        plot.finalize(simDir, null);
    }
}

