/*
 * Decompiled with CFR 0.152.
 */
package scratch.peter.nshmp;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.nshmp2.tmp.JordanMadridHazardCalc;
import org.opensha.sha.calc.HazardCurveCalculatorAPI;
import org.opensha.sha.calc.params.IncludeMagDistFilterParam;
import org.opensha.sha.calc.params.MagDistCutoffParam;
import org.opensha.sha.calc.params.MaxDistanceParam;
import org.opensha.sha.calc.params.NonSupportedTRT_OptionsParam;
import org.opensha.sha.calc.params.NumStochasticEventSetsParam;
import org.opensha.sha.calc.params.SetTRTinIMR_FromSourceParam;
import org.opensha.sha.calc.params.filters.FixedDistanceCutoffFilter;
import org.opensha.sha.calc.params.filters.MagDependentDistCutoffFilter;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel96.Frankel96_EqkRupForecast;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.BJF_1997_AttenRel;
import org.opensha.sha.util.TRTUtils;
import org.opensha.sha.util.TectonicRegionType;
import scratch.peter.nshmp.DeterministicResult;

public class HazardCurveCalculatorNSHMP
implements HazardCurveCalculatorAPI,
ParameterChangeWarningListener {
    private static final long serialVersionUID = 1L;
    protected static final String C = "HazardCurveCalculator";
    protected static final boolean D = false;
    private FixedDistanceCutoffFilter maxDistFilter = new FixedDistanceCutoffFilter();
    private MaxDistanceParam maxDistanceParam = this.maxDistFilter.getParam();
    private IncludeMagDistFilterParam includeMagDistFilterParam;
    private MagDependentDistCutoffFilter magDistFilter;
    private MagDistCutoffParam magDistCutoffParam;
    private NumStochasticEventSetsParam numStochEventSetRealizationsParam;
    private SetTRTinIMR_FromSourceParam setTRTinIMR_FromSourceParam;
    private NonSupportedTRT_OptionsParam nonSupportedTRT_OptionsParam;
    private ParameterList adjustableParams;
    protected int currRuptures = -1;
    protected int totRuptures = 0;
    protected int sourceIndex;
    protected int numSources;

    public HazardCurveCalculatorNSHMP() {
        this.maxDistanceParam.setValue(300.0);
        this.includeMagDistFilterParam = new IncludeMagDistFilterParam();
        this.magDistFilter = new MagDependentDistCutoffFilter();
        this.magDistCutoffParam = this.magDistFilter.getParam();
        this.numStochEventSetRealizationsParam = new NumStochasticEventSetsParam();
        this.setTRTinIMR_FromSourceParam = new SetTRTinIMR_FromSourceParam();
        this.nonSupportedTRT_OptionsParam = new NonSupportedTRT_OptionsParam();
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.maxDistanceParam);
        this.adjustableParams.addParameter(this.numStochEventSetRealizationsParam);
        this.adjustableParams.addParameter(this.includeMagDistFilterParam);
        this.adjustableParams.addParameter(this.magDistCutoffParam);
        this.adjustableParams.addParameter(this.setTRTinIMR_FromSourceParam);
        this.adjustableParams.addParameter(this.nonSupportedTRT_OptionsParam);
    }

    @Override
    public void setMaxSourceDistance(double distance) {
        this.maxDistanceParam.setValue(distance);
    }

    @Override
    public void setMinMagnitude(double magnitude) {
        throw new RuntimeException("Method not supported");
    }

    @Override
    public void setNumStochEventSetRealizations(int numRealizations) {
        this.numStochEventSetRealizationsParam.setValue(numRealizations);
    }

    @Override
    public double getMaxSourceDistance() {
        return (Double)this.maxDistanceParam.getValue();
    }

    @Override
    public void setMagDistCutoffFunc(ArbitrarilyDiscretizedFunc magDistfunc) {
        this.includeMagDistFilterParam.setValue(true);
        this.magDistCutoffParam.setValue(magDistfunc);
    }

    @Override
    public void setIncludeMagDistCutoff(boolean include) {
        this.includeMagDistFilterParam.setValue(include);
    }

    @Override
    public ArbitrarilyDiscretizedFunc getMagDistCutoffFunc() {
        if (((Boolean)this.includeMagDistFilterParam.getValue()).booleanValue()) {
            return (ArbitrarilyDiscretizedFunc)this.magDistCutoffParam.getValue();
        }
        return null;
    }

    @Override
    public DiscretizedFunc getAnnualizedRates(DiscretizedFunc hazFunction, double years) {
        DiscretizedFunc annualizedRateFunc = hazFunction.deepClone();
        int size = annualizedRateFunc.size();
        for (int i = 0; i < size; ++i) {
            annualizedRateFunc.set(i, -Math.log(1.0 - annualizedRateFunc.getY(i)) / years);
        }
        return annualizedRateFunc;
    }

    @Override
    public DiscretizedFunc getHazardCurve(DiscretizedFunc hazFunction, Site site, ScalarIMR imr, ERF eqkRupForecast) {
        return this.getHazardCurve(hazFunction, site, TRTUtils.wrapInHashMap(imr), eqkRupForecast);
    }

    public DiscretizedFunc getHazardCurve(DiscretizedFunc hazFunction, Site site, ScalarIMR imr, ERF eqkRupForecast, DeterministicResult detResult, JordanMadridHazardCalc.ResWriter writer) {
        return this.getHazardCurve(hazFunction, site, TRTUtils.wrapInHashMap(imr), eqkRupForecast, detResult, writer);
    }

    @Override
    public DiscretizedFunc getHazardCurve(DiscretizedFunc hazFunction, Site site, Map<TectonicRegionType, ScalarIMR> imrMap, ERF eqkRupForecast) {
        return this.getHazardCurve(hazFunction, site, imrMap, eqkRupForecast, null, null);
    }

    public DiscretizedFunc getHazardCurve(DiscretizedFunc hazFunction, Site site, Map<TectonicRegionType, ScalarIMR> imrMap, ERF eqkRupForecast, DeterministicResult detResult, JordanMadridHazardCalc.ResWriter resWriter) {
        boolean setTRTinIMR_FromSource = (Boolean)this.setTRTinIMR_FromSourceParam.getValue();
        HashMap<ScalarIMR, TectonicRegionType> trtOrigVals = null;
        if (setTRTinIMR_FromSource) {
            trtOrigVals = TRTUtils.getTRTsSetInIMRs(imrMap);
        }
        this.currRuptures = -1;
        boolean poissonSource = false;
        DiscretizedFunc condProbFunc = (ArbitrarilyDiscretizedFunc)hazFunction.deepClone();
        ArbitrarilyDiscretizedFunc sourceHazFunc = (ArbitrarilyDiscretizedFunc)hazFunction.deepClone();
        int numPoints = hazFunction.size();
        double maxDistance = (Double)this.maxDistanceParam.getValue();
        boolean includeMagDistFilter = (Boolean)this.includeMagDistFilterParam.getValue();
        double magThresh = 0.0;
        for (ScalarIMR imr : imrMap.values()) {
            imr.resetParameterEventListeners();
            imr.setUserMaxDistance(maxDistance);
            imr.setSite(site);
        }
        this.numSources = eqkRupForecast.getNumSources();
        this.totRuptures = 0;
        this.sourceIndex = 0;
        this.sourceIndex = 0;
        while (this.sourceIndex < this.numSources) {
            this.totRuptures += eqkRupForecast.getSource(this.sourceIndex).getNumRuptures();
            ++this.sourceIndex;
        }
        this.currRuptures = 0;
        int numRupRejected = 0;
        this.initDiscretizeValues(hazFunction, 1.0);
        boolean sourceUsed = false;
        this.sourceIndex = 0;
        while (this.sourceIndex < this.numSources) {
            double distance;
            ProbEqkSource source = eqkRupForecast.getSource(this.sourceIndex);
            TectonicRegionType trt = source.getTectonicRegionType();
            ScalarIMR imr = TRTUtils.getIMRforTRT(imrMap, trt);
            if (setTRTinIMR_FromSource) {
                TRTUtils.setTRTinIMR(imr, trt, this.nonSupportedTRT_OptionsParam, trtOrigVals.get(imr));
            }
            if ((distance = source.getMinDistance(site)) > maxDistance) {
                this.currRuptures += source.getNumRuptures();
            } else {
                int k;
                if (includeMagDistFilter) {
                    magThresh = ((ArbitrarilyDiscretizedFunc)this.magDistCutoffParam.getValue()).getInterpolatedY(distance);
                }
                if (!(poissonSource = source.isSourcePoissonian())) {
                    this.initDiscretizeValues(sourceHazFunc, 0.0);
                }
                int numRuptures = source.getNumRuptures();
                int n = 0;
                while (n < numRuptures) {
                    ProbEqkRupture rupture = source.getRupture(n);
                    try {
                        double qkProb = rupture.getProbability();
                        if (includeMagDistFilter && rupture.getMag() < magThresh) {
                            ++numRupRejected;
                        } else {
                            double median;
                            sourceUsed = true;
                            imr.setEqkRupture(rupture);
                            condProbFunc = imr.getExceedProbabilities(condProbFunc);
                            if (detResult != null && detResult.median < (median = Math.exp(imr.getMean()))) {
                                detResult.median = median;
                                detResult.mag = rupture.getMag();
                                detResult.rRup = rupture.getRuptureSurface().getDistanceRup(site.getLocation());
                                detResult.name = source.getName();
                            }
                            if (poissonSource) {
                                if (Math.log(1.0 - qkProb) < -30.0) {
                                    throw new RuntimeException("Error: The probability for this ProbEqkRupture (" + qkProb + ") is too high for a Possion source (~infinite number of events)");
                                }
                                for (k = 0; k < numPoints; ++k) {
                                    hazFunction.set(k, hazFunction.getY(k) * Math.pow(1.0 - qkProb, condProbFunc.getY(k)));
                                }
                            } else {
                                for (k = 0; k < numPoints; ++k) {
                                    sourceHazFunc.set(k, sourceHazFunc.getY(k) + qkProb * condProbFunc.getY(k));
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        System.err.println("Error occured while calculating hazard curve for rupture:  " + this.sourceIndex + " " + n);
                        System.err.println("Source Name: " + source.getName());
                        System.err.println("Surface Type: " + rupture.getRuptureSurface().getClass().getName());
                        System.err.println("ERF: " + eqkRupForecast.getName());
                        System.err.println("IMR: " + imr.getName());
                        System.err.println("Site: " + String.valueOf(site));
                        System.err.println("Curve: " + String.valueOf(hazFunction));
                        ExceptionUtils.throwAsRuntimeException(t);
                    }
                    ++n;
                    ++this.currRuptures;
                }
                if (!poissonSource) {
                    for (k = 0; k < numPoints; ++k) {
                        hazFunction.set(k, hazFunction.getY(k) * (1.0 - sourceHazFunc.getY(k)));
                    }
                }
            }
            ++this.sourceIndex;
        }
        if (sourceUsed) {
            for (int i = 0; i < numPoints; ++i) {
                hazFunction.set(i, 1.0 - hazFunction.getY(i));
            }
        } else {
            this.initDiscretizeValues(hazFunction, 0.0);
        }
        if (trtOrigVals != null) {
            TRTUtils.resetTRTsInIMRs(trtOrigVals);
        }
        return hazFunction;
    }

    @Override
    public DiscretizedFunc getAverageEventSetHazardCurve(DiscretizedFunc hazFunction, Site site, ScalarIMR imr, ERF eqkRupForecast) {
        System.out.println("Haz Curv Calc: maxDistanceParam.getValue()=" + ((Double)this.maxDistanceParam.getValue()).toString());
        System.out.println("Haz Curv Calc: numStochEventSetRealizationsParam.getValue()=" + ((Integer)this.numStochEventSetRealizationsParam.getValue()).toString());
        System.out.println("Haz Curv Calc: includeMagDistFilterParam.getValue()=" + ((Boolean)this.includeMagDistFilterParam.getValue()).toString());
        if (((Boolean)this.includeMagDistFilterParam.getValue()).booleanValue()) {
            System.out.println("Haz Curv Calc: magDistCutoffParam.getValue()=" + ((ArbitrarilyDiscretizedFunc)this.magDistCutoffParam.getValue()).toString());
        }
        int numEventSets = (Integer)this.numStochEventSetRealizationsParam.getValue();
        DiscretizedFunc hazCurve = hazFunction.deepClone();
        this.initDiscretizeValues(hazFunction, 0.0);
        int numPts = hazCurve.size();
        this.currRuptures = 0;
        for (int i = 0; i < numEventSets; ++i) {
            List<EqkRupture> events = eqkRupForecast.drawRandomEventSet();
            if (i == 0) {
                this.totRuptures = events.size() * numEventSets;
            }
            this.currRuptures += events.size();
            this.getEventSetHazardCurve(hazCurve, site, imr, events, false);
            for (int x = 0; x < numPts; ++x) {
                hazFunction.set(x, hazFunction.getY(x) + hazCurve.getY(x));
            }
        }
        for (int x = 0; x < numPts; ++x) {
            hazFunction.set(x, hazFunction.getY(x) / (double)numEventSets);
        }
        return hazFunction;
    }

    @Override
    public DiscretizedFunc getEventSetHazardCurve(DiscretizedFunc hazFunction, Site site, ScalarIMR imr, List<EqkRupture> eqkRupList, boolean updateCurrRuptures) {
        ArbitrarilyDiscretizedFunc condProbFunc = (ArbitrarilyDiscretizedFunc)hazFunction.deepClone();
        ((AttenuationRelationship)imr).resetParameterEventListeners();
        int numPoints = hazFunction.size();
        double maxDistance = (Double)this.maxDistanceParam.getValue();
        imr.setUserMaxDistance(maxDistance);
        int totRups = eqkRupList.size();
        if (updateCurrRuptures) {
            this.totRuptures = totRups;
            this.currRuptures = 0;
        }
        this.initDiscretizeValues(hazFunction, 1.0);
        imr.setSite(site);
        for (int n = 0; n < totRups; ++n) {
            if (updateCurrRuptures) {
                ++this.currRuptures;
            }
            EqkRupture rupture = eqkRupList.get(n);
            imr.setEqkRupture(rupture);
            condProbFunc = (ArbitrarilyDiscretizedFunc)imr.getExceedProbabilities(condProbFunc);
            for (int k = 0; k < numPoints; ++k) {
                hazFunction.set(k, hazFunction.getY(k) * (1.0 - condProbFunc.getY(k)));
            }
        }
        for (int i = 0; i < numPoints; ++i) {
            hazFunction.set(i, 1.0 - hazFunction.getY(i));
        }
        return hazFunction;
    }

    @Override
    public DiscretizedFunc getHazardCurve(DiscretizedFunc hazFunction, Site site, ScalarIMR imr, EqkRupture rupture) {
        System.out.println("Haz Curv Calc: maxDistanceParam.getValue()=" + ((Double)this.maxDistanceParam.getValue()).toString());
        System.out.println("Haz Curv Calc: numStochEventSetRealizationsParam.getValue()=" + ((Integer)this.numStochEventSetRealizationsParam.getValue()).toString());
        System.out.println("Haz Curv Calc: includeMagDistFilterParam.getValue()=" + ((Boolean)this.includeMagDistFilterParam.getValue()).toString());
        if (((Boolean)this.includeMagDistFilterParam.getValue()).booleanValue()) {
            System.out.println("Haz Curv Calc: magDistCutoffParam.getValue()=" + ((ArbitrarilyDiscretizedFunc)this.magDistCutoffParam.getValue()).toString());
        }
        ((AttenuationRelationship)imr).resetParameterEventListeners();
        imr.setSite(site);
        imr.setEqkRupture(rupture);
        hazFunction = (ArbitrarilyDiscretizedFunc)imr.getExceedProbabilities(hazFunction);
        return hazFunction;
    }

    @Override
    public int getCurrRuptures() {
        return this.currRuptures;
    }

    @Override
    public int getTotRuptures() {
        return this.totRuptures;
    }

    @Override
    public void stopCalc() {
        this.sourceIndex = this.numSources;
    }

    protected void initDiscretizeValues(DiscretizedFunc arb, double val) {
        int num = arb.size();
        for (int i = 0; i < num; ++i) {
            arb.set(i, val);
        }
        Preconditions.checkState((num == arb.size() ? 1 : 0) != 0, (Object)"initializing X values changed size of function! It is possible that there is a NaN or infitite value in the hazard curve.");
    }

    @Override
    public ParameterList getAdjustableParams() {
        return this.adjustableParams;
    }

    @Override
    public void setAdjustableParams(ParameterList paramList) {
        this.adjustableParams = paramList;
        this.maxDistanceParam = (MaxDistanceParam)paramList.getParameter("Maximum Distance");
        this.numStochEventSetRealizationsParam = (NumStochasticEventSetsParam)paramList.getParameter("Num Event Sets");
        this.includeMagDistFilterParam = (IncludeMagDistFilterParam)paramList.getParameter("Use Mag-Distance Filter?");
        this.magDistCutoffParam = (MagDistCutoffParam)paramList.getParameter("Mag-Dist Cutoff Function");
        this.setTRTinIMR_FromSourceParam = (SetTRTinIMR_FromSourceParam)paramList.getParameter("Set TRT From Source?");
        this.nonSupportedTRT_OptionsParam = (NonSupportedTRT_OptionsParam)paramList.getParameter("If source TRT not supported by IMR");
    }

    @Override
    public ListIterator<Parameter<?>> getAdjustableParamsIterator() {
        return this.adjustableParams.getParametersIterator();
    }

    public void testEventSetHazardCurve(int numIterations) {
        this.maxDistanceParam.setValue(300.0);
        this.includeMagDistFilterParam.setValue(false);
        this.numStochEventSetRealizationsParam.setValue(numIterations);
        BJF_1997_AttenRel imr = new BJF_1997_AttenRel(this);
        imr.setParamDefaults();
        imr.setIntensityMeasure("PGA");
        Site site = new Site();
        ListIterator<Parameter<?>> it = imr.getSiteParamsIterator();
        while (it.hasNext()) {
            site.addParameter(it.next());
        }
        site.setLocation(new Location(34.0, -118.0));
        Frankel96_EqkRupForecast eqkRupForecast = new Frankel96_EqkRupForecast();
        eqkRupForecast.updateForecast();
        ArbitrarilyDiscretizedFunc hazCurve = new ArbitrarilyDiscretizedFunc();
        hazCurve.set(-3.0, 1.0);
        hazCurve.set(-2.0, 1.0);
        hazCurve.set(-1.0, 1.0);
        hazCurve.set(1.0, 1.0);
        hazCurve.set(2.0, 1.0);
        hazCurve.setName("Hazard Curve");
        this.getHazardCurve((DiscretizedFunc)hazCurve, site, (ScalarIMR)imr, (ERF)eqkRupForecast);
        System.out.println(hazCurve.toString());
        ArbitrarilyDiscretizedFunc aveCurve = hazCurve.deepClone();
        this.getAverageEventSetHazardCurve(aveCurve, site, imr, eqkRupForecast);
        aveCurve.setName("Ave from " + numIterations + " event sets");
        System.out.println(aveCurve.toString());
    }

    @Override
    public void parameterChangeWarning(ParameterChangeWarningEvent event) {
    }

    @Override
    public List<SourceFilter> getSourceFilters() {
        ArrayList<SourceFilter> filters = new ArrayList<SourceFilter>();
        filters.add(this.maxDistFilter);
        if (((Boolean)this.includeMagDistFilterParam.getValue()).booleanValue()) {
            filters.add(this.magDistFilter);
        }
        return filters;
    }

    @Override
    public void setTrackProgress(boolean trackProgress) {
    }

    @Override
    public boolean isTrackProgress() {
        return true;
    }
}

