/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.J3D_Geometry;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.type.SdoNumberArray;
import oracle.spatial.util.GML;
import oracle.spatial.util.GML3g;
import oracle.spatial.util.GeometryExceptionWithContext;
import oracle.spatial.util.KML;
import oracle.spatial.util.WKB;
import oracle.spatial.util.WKT;
import oracle.sql.ARRAY;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;

public class Adapters {
    protected static final Connection m_conn;
    protected static final WKB m_wkbAdapter;
    protected static final WKT m_wktAdapter;

    public static STRUCT wkbToSTRUCT(BLOB bLOB) throws SQLException {
        return Adapters.wkbToSTRUCT(bLOB, m_conn);
    }

    public static STRUCT wkbToSTRUCT(BLOB bLOB, Connection connection) throws SQLException {
        try {
            return Adapters.wkbToSTRUCT2(bLOB, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static STRUCT wkbToSTRUCT2(BLOB bLOB, Connection connection) throws SQLException, GeometryExceptionWithContext {
        bLOB.open(0);
        byte[] byArray = bLOB.getBytes(1L, (int)bLOB.length());
        bLOB.close();
        return m_wkbAdapter.toSTRUCT(byArray, connection);
    }

    public static STRUCT wktToSTRUCT(CLOB cLOB) throws SQLException {
        return Adapters.wktToSTRUCT(cLOB, m_conn);
    }

    public static STRUCT wktToSTRUCT(CLOB cLOB, Connection connection) throws SQLException {
        try {
            return Adapters.wktToSTRUCT2(cLOB, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static STRUCT wktToSTRUCT2(CLOB cLOB, Connection connection) throws SQLException, GeometryExceptionWithContext {
        cLOB.open(0);
        byte[] byArray = cLOB.getSubString(1L, (int)cLOB.length()).getBytes();
        cLOB.close();
        return m_wktAdapter.toSTRUCT(byArray, connection);
    }

    public static STRUCT wktToSTRUCT(String string) throws SQLException {
        STRUCT sTRUCT;
        try {
            sTRUCT = Adapters.wktToSTRUCT(string, m_conn);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
        return sTRUCT;
    }

    public static STRUCT wktToSTRUCT(String string, Connection connection) throws SQLException {
        try {
            return Adapters.wktToSTRUCT2(string, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static STRUCT wktToSTRUCT2(String string, Connection connection) throws SQLException, GeometryExceptionWithContext {
        byte[] byArray = string.getBytes();
        return m_wktAdapter.toSTRUCT(byArray, connection);
    }

    public static STRUCT gmlToSTRUCT(String string) throws SQLException {
        return Adapters.gmlToSTRUCT(string, m_conn);
    }

    public static STRUCT gml311ToSTRUCT(String string) throws SQLException {
        return Adapters.gml311ToSTRUCT(string, m_conn);
    }

    public static STRUCT kmlToSTRUCT(String string) throws SQLException {
        return Adapters.kmlToSTRUCT(string, m_conn);
    }

    public static STRUCT buffer(STRUCT sTRUCT, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4) throws SQLException, Exception {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        JGeometry jGeometry2 = jGeometry.buffer(nUMBER.doubleValue(), nUMBER2.doubleValue(), nUMBER3.doubleValue(), nUMBER4.doubleValue());
        return JGeometry.store((JGeometry)jGeometry2, (Connection)connection);
    }

    public static String anyInteract(STRUCT sTRUCT, STRUCT sTRUCT2, String string, NUMBER nUMBER) throws Exception {
        Object object;
        Object object2;
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        JGeometry jGeometry2 = JGeometry.load((STRUCT)sTRUCT2);
        if (string.equals("TRUE")) {
            int n;
            int n2;
            if (nUMBER.doubleValue() < 0.05) {
                nUMBER = new NUMBER(0.05);
            }
            if (((double[])(object2 = jGeometry.getMBR())).length != ((double[])(object = jGeometry2.getMBR())).length) {
                throw new DataException("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
            }
            double[] dArray = new double[((double[])object2).length];
            for (n2 = 0; n2 < ((double[])object2).length; ++n2) {
                dArray[n2] = 0.0;
            }
            for (n2 = 0; n2 < ((double[])object2).length / 2; ++n2) {
                for (n = 0; n < 2; ++n) {
                    dArray[((double[])object2).length / 2 * n + n2] = (object2[((double[])object2).length / 2 * n + n2] + object[((double[])object).length / 2 * n + n2]) / 2.0;
                }
            }
            double[] dArray2 = new double[dArray.length / 2];
            for (n = 0; n < dArray.length / 2; ++n) {
                dArray2[n] = (dArray[n + dArray.length / 2] + dArray[n]) / 2.0;
            }
            double d = Math.PI / 180 * dArray2[0];
            double d2 = Math.PI / 180 * dArray2[1];
            jGeometry = jGeometry.projectToGNM_longLat(d, d2);
            jGeometry2 = jGeometry2.projectToGNM_longLat(d, d2);
        }
        object2 = jGeometry.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        object = jGeometry2.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getPoint()[0], jGeometry2.getPoint()[1], jGeometry2.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getElemInfo(), jGeometry2.getOrdinatesArray());
        boolean bl = object2.anyInteract((J3D_Geometry)object, nUMBER.doubleValue());
        if (bl) {
            return "TRUE";
        }
        return "FALSE";
    }

    public static NUMBER distance(STRUCT sTRUCT, STRUCT sTRUCT2, NUMBER nUMBER) throws Exception {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        JGeometry jGeometry2 = JGeometry.load((STRUCT)sTRUCT2);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        J3D_Geometry j3D_Geometry2 = jGeometry2.getElemInfo() == null ? new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getPoint()[0], jGeometry2.getPoint()[1], jGeometry2.getPoint()[2]) : new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getElemInfo(), jGeometry2.getOrdinatesArray());
        NUMBER nUMBER2 = new NUMBER(j3D_Geometry.distance(j3D_Geometry2, nUMBER.doubleValue()));
        return nUMBER2;
    }

    public static NUMBER length(STRUCT sTRUCT, NUMBER nUMBER, NUMBER nUMBER2) throws Exception {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        NUMBER nUMBER3 = new NUMBER(j3D_Geometry.length(nUMBER.intValue(), nUMBER2.doubleValue()));
        return nUMBER3;
    }

    public static NUMBER area(STRUCT sTRUCT, NUMBER nUMBER) throws Exception {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        NUMBER nUMBER2 = new NUMBER(j3D_Geometry.area(nUMBER.doubleValue()));
        return nUMBER2;
    }

    public static NUMBER volume(STRUCT sTRUCT, NUMBER nUMBER) throws Exception {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        NUMBER nUMBER2 = new NUMBER(j3D_Geometry.volume(nUMBER.doubleValue()));
        return nUMBER2;
    }

    public static String validateGeom(STRUCT sTRUCT, String string, NUMBER nUMBER, NUMBER nUMBER2) throws Exception {
        Object object;
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        if (nUMBER.intValue() > 0) {
            if (nUMBER2.doubleValue() < 0.05) {
                nUMBER2 = new NUMBER(0.05);
            }
            if (((double[])(object = jGeometry.getMBR())).length != 6) {
                throw new DataException("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
            }
            jGeometry = jGeometry.projectToGNM_longLat();
        }
        String string2 = "";
        if (jGeometry == null) {
            string2 = "13032: Invalid NULL  SDO_GEOMETRY object;,0,0,0,0,0,0,0";
        } else {
            object = jGeometry.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
            boolean bl = string.equals("TRUE");
            string2 = object.validate(bl, nUMBER2.doubleValue());
        }
        if (string2.substring(0, 4).equals("TRUE")) {
            return "TRUE";
        }
        String string3 = string2.substring(0, 5);
        String string4 = string2.substring(string2.indexOf(";") + 1);
        String string5 = "";
        String string6 = "";
        string6 = string6.concat(string3).concat(" ");
        int n = 0;
        int n2 = 0;
        while (string4.indexOf(",") != -1) {
            string5 = string4.substring(string4.indexOf(",") + 1);
            if (string5.indexOf(",") == -1) {
                n2 = Integer.valueOf(string5);
            } else {
                String string7 = string5.substring(0, string5.indexOf(","));
                n2 = Integer.valueOf(string7);
                string5 = string5.substring(string5.indexOf(","));
            }
            string4 = string5;
            switch (n + 1) {
                case 1: {
                    string6 = string6.concat("Point:");
                    break;
                }
                case 2: {
                    string6 = string6.concat("Edge:");
                    break;
                }
                case 3: {
                    string6 = string6.concat("Ring:");
                    break;
                }
                case 4: {
                    string6 = string6.concat("Polygon:");
                    break;
                }
                case 5: {
                    string6 = string6.concat("Comp-Surf:");
                    break;
                }
                case 6: {
                    string6 = string6.concat("Solid:");
                    break;
                }
                case 7: {
                    string6 = string6.concat("Multi:");
                }
            }
            string6 = string6.concat(String.valueOf(n2)).concat(",");
            ++n;
        }
        return string6;
    }

    public static STRUCT closestPoints(STRUCT sTRUCT, STRUCT sTRUCT2, NUMBER nUMBER) throws Exception {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        JGeometry jGeometry2 = JGeometry.load((STRUCT)sTRUCT2);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        J3D_Geometry j3D_Geometry2 = jGeometry2.getElemInfo() == null ? new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getPoint()[0], jGeometry2.getPoint()[1], jGeometry2.getPoint()[2]) : new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getElemInfo(), jGeometry2.getOrdinatesArray());
        ArrayList arrayList = new ArrayList();
        J3D_Geometry j3D_Geometry3 = null;
        arrayList = j3D_Geometry.closestPoints(j3D_Geometry2, nUMBER.doubleValue());
        J3D_Geometry j3D_Geometry4 = (J3D_Geometry)arrayList.get(0);
        J3D_Geometry j3D_Geometry5 = (J3D_Geometry)arrayList.get(1);
        double[] dArray = new double[6];
        int[] nArray = new int[3];
        dArray[0] = j3D_Geometry4.getOrdinatesArray()[0];
        dArray[1] = j3D_Geometry4.getOrdinatesArray()[1];
        dArray[2] = j3D_Geometry4.getOrdinatesArray()[2];
        dArray[3] = j3D_Geometry5.getOrdinatesArray()[0];
        dArray[4] = j3D_Geometry5.getOrdinatesArray()[1];
        dArray[5] = j3D_Geometry5.getOrdinatesArray()[2];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 2;
        j3D_Geometry3 = new J3D_Geometry(5, j3D_Geometry4.getSRID(), nArray, dArray);
        return JGeometry.store((JGeometry)j3D_Geometry3, (Connection)m_conn);
    }

    public static STRUCT affineTransforms(STRUCT sTRUCT, String string, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, String string2, STRUCT sTRUCT2, NUMBER nUMBER4, NUMBER nUMBER5, NUMBER nUMBER6, String string3, STRUCT sTRUCT3, STRUCT sTRUCT4, NUMBER nUMBER7, NUMBER nUMBER8, String string4, NUMBER nUMBER9, NUMBER nUMBER10, NUMBER nUMBER11, NUMBER nUMBER12, NUMBER nUMBER13, NUMBER nUMBER14, String string5, STRUCT sTRUCT5, STRUCT sTRUCT6, NUMBER nUMBER15, String string6, SdoNumberArray sdoNumberArray, SdoNumberArray sdoNumberArray2) throws Exception {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        JGeometry jGeometry2 = sTRUCT2 == null ? null : JGeometry.load((STRUCT)sTRUCT2);
        JGeometry jGeometry3 = sTRUCT3 == null ? null : JGeometry.load((STRUCT)sTRUCT3);
        JGeometry jGeometry4 = sTRUCT4 == null ? null : JGeometry.load((STRUCT)sTRUCT4);
        JGeometry jGeometry5 = sTRUCT5 == null ? null : JGeometry.load((STRUCT)sTRUCT5);
        JGeometry jGeometry6 = sTRUCT6 == null ? null : JGeometry.load((STRUCT)sTRUCT6);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (string.equals("TRUE")) {
            bl = true;
        }
        if (string2.equals("TRUE")) {
            bl2 = true;
        }
        if (string3.equals("TRUE")) {
            bl3 = true;
        }
        if (string4.equals("TRUE")) {
            bl4 = true;
        }
        if (string5.equals("TRUE")) {
            bl5 = true;
        }
        if (string6.equals("TRUE")) {
            bl6 = true;
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[3];
        if (sdoNumberArray2 != null && sdoNumberArray != null) {
            dArray[0] = sdoNumberArray2.getArray()[0].doubleValue();
            for (int i = 0; i < sdoNumberArray.length(); ++i) {
                dArray2[i] = sdoNumberArray.getArray()[i].doubleValue();
            }
        } else {
            dArray = null;
            dArray2 = null;
        }
        JGeometry jGeometry7 = jGeometry.affineTransforms(bl, nUMBER.doubleValue(), nUMBER2.doubleValue(), nUMBER3.doubleValue(), bl2, jGeometry2, nUMBER4.doubleValue(), nUMBER5.doubleValue(), nUMBER6.doubleValue(), bl3, jGeometry3, jGeometry4, nUMBER7.doubleValue(), nUMBER8.intValue(), bl4, nUMBER9.doubleValue(), nUMBER10.doubleValue(), nUMBER11.doubleValue(), nUMBER12.doubleValue(), nUMBER13.doubleValue(), nUMBER14.doubleValue(), bl5, jGeometry5, jGeometry6, nUMBER15.intValue(), bl6, dArray2, dArray);
        return JGeometry.store((JGeometry)jGeometry7, (Connection)connection);
    }

    public static STRUCT gmlToSTRUCT(String string, String string2) throws SQLException {
        GML.setsrsNameSpace(string2);
        GML.setConnection(m_conn);
        STRUCT sTRUCT = Adapters.gmlToSTRUCT(string, m_conn);
        GML.setsrsNameSpace(null);
        GML.setConnection(null);
        return sTRUCT;
    }

    public static STRUCT gmlToSTRUCT(String string, Connection connection) throws SQLException {
        DOMParser dOMParser = new DOMParser();
        StringReader stringReader = new StringReader(string);
        try {
            dOMParser.parse((Reader)stringReader);
            XMLDocument xMLDocument = dOMParser.getDocument();
            Node node = xMLDocument.getFirstChild();
            JGeometry jGeometry = GML.fromNodeToGeometry(node);
            return JGeometry.store((JGeometry)jGeometry, (Connection)m_conn);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static STRUCT gmlToSTRUCT(CLOB cLOB) throws SQLException {
        cLOB.open(0);
        String string = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.gmlToSTRUCT(string, m_conn);
    }

    public static STRUCT gmlToSTRUCT(CLOB cLOB, String string) throws SQLException {
        cLOB.open(0);
        String string2 = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.gmlToSTRUCT(string2, string);
    }

    public static STRUCT gml311ToSTRUCT(String string, String string2) throws SQLException {
        GML3g.setsrsNameSpace(string2);
        GML3g.setConnection(m_conn);
        STRUCT sTRUCT = Adapters.gml311ToSTRUCT(string, m_conn);
        GML3g.setsrsNameSpace(null);
        GML3g.setConnection(null);
        return sTRUCT;
    }

    public static STRUCT gml311ToSTRUCT(String string, Connection connection) throws SQLException {
        DOMParser dOMParser = new DOMParser();
        StringReader stringReader = new StringReader(string);
        try {
            dOMParser.parse((Reader)stringReader);
            XMLDocument xMLDocument = dOMParser.getDocument();
            Node node = xMLDocument.getFirstChild();
            JGeometry jGeometry = GML3g.fromNodeToGeometry(node);
            return JGeometry.store((JGeometry)jGeometry, (Connection)m_conn);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static STRUCT gml311ToSTRUCT(CLOB cLOB) throws SQLException {
        cLOB.open(0);
        String string = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.gml311ToSTRUCT(string, m_conn);
    }

    public static STRUCT gml311ToSTRUCT(CLOB cLOB, String string) throws SQLException {
        cLOB.open(0);
        String string2 = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.gml311ToSTRUCT(string2, string);
    }

    public static STRUCT kmlToSTRUCT(String string, Connection connection) throws SQLException {
        DOMParser dOMParser = new DOMParser();
        StringReader stringReader = new StringReader(string);
        try {
            dOMParser.parse((Reader)stringReader);
            XMLDocument xMLDocument = dOMParser.getDocument();
            Node node = xMLDocument.getFirstChild();
            JGeometry jGeometry = KML.fromNodeToGeometry(node);
            return JGeometry.store((JGeometry)jGeometry, (Connection)m_conn);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static STRUCT kmlToSTRUCT(CLOB cLOB) throws SQLException {
        cLOB.open(0);
        String string = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.kmlToSTRUCT(string, m_conn);
    }

    public static BLOB structToWkb(STRUCT sTRUCT) throws SQLException {
        return Adapters.structToWkb(sTRUCT, m_conn);
    }

    public static BLOB structToWkb(STRUCT sTRUCT, Connection connection) throws SQLException {
        try {
            return Adapters.structToWkb2(sTRUCT, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static BLOB structToWkb2(STRUCT sTRUCT, Connection connection) throws SQLException, GeometryExceptionWithContext {
        if (sTRUCT == null) {
            return null;
        }
        if (connection == null) {
            throw new RuntimeException("conn is null.");
        }
        try {
            byte[] byArray = m_wkbAdapter.fromSTRUCT(sTRUCT);
            BLOB bLOB = BLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            bLOB.open(1);
            OutputStream outputStream = bLOB.getBinaryOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            outputStream.close();
            bLOB.close();
            return bLOB;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public static CLOB structToWkt(STRUCT sTRUCT) throws SQLException {
        return Adapters.structToWkt(sTRUCT, m_conn);
    }

    public static String structToWktString(STRUCT sTRUCT) throws SQLException {
        try {
            return Adapters.structToWktString2(sTRUCT);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    public static CLOB structToWkt(STRUCT sTRUCT, Connection connection) throws SQLException {
        try {
            return Adapters.structToWkt2(sTRUCT, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static CLOB structToWkt2(STRUCT sTRUCT, Connection connection) throws SQLException, GeometryExceptionWithContext {
        if (sTRUCT == null) {
            return null;
        }
        if (connection == null) {
            throw new RuntimeException("conn is null.");
        }
        try {
            byte[] byArray = m_wktAdapter.fromSTRUCT(sTRUCT);
            CLOB cLOB = CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            cLOB.open(1);
            OutputStream outputStream = cLOB.getAsciiOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            outputStream.close();
            cLOB.close();
            return cLOB;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    protected static String structToWktString2(STRUCT sTRUCT) throws SQLException, GeometryExceptionWithContext {
        if (sTRUCT == null) {
            return null;
        }
        byte[] byArray = m_wktAdapter.fromSTRUCT(sTRUCT);
        if (byArray.length > 4000) {
            return new String(byArray, 0, 4000);
        }
        return new String(byArray);
    }

    public static String validateWkt(CLOB cLOB) {
        return Adapters.validateWkt(cLOB, m_conn);
    }

    public static String validateWkt(CLOB cLOB, Connection connection) {
        try {
            Adapters.wktToSTRUCT2(cLOB, connection);
            return "TRUE";
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            return geometryExceptionWithContext.getOracleErrorMessage() + " " + geometryExceptionWithContext.getContext();
        }
        catch (Exception exception) {
            return "FALSE";
        }
    }

    public static String validateWkt(String string) {
        return Adapters.validateWkt(string, m_conn);
    }

    public static String validateWkt(String string, Connection connection) {
        try {
            Adapters.wktToSTRUCT2(string, connection);
            return "TRUE";
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            return geometryExceptionWithContext.getOracleErrorMessage() + " " + geometryExceptionWithContext.getContext();
        }
        catch (Exception exception) {
            return "FALSE";
        }
    }

    public static String validateWkb(BLOB bLOB) {
        return Adapters.validateWkb(bLOB, m_conn);
    }

    public static String validateWkb(BLOB bLOB, Connection connection) {
        try {
            Adapters.wkbToSTRUCT2(bLOB, connection);
            return "TRUE";
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            return geometryExceptionWithContext.getOracleErrorMessage() + " " + geometryExceptionWithContext.getContext();
        }
        catch (Exception exception) {
            return "FALSE";
        }
    }

    /*
     * Loose catch block
     */
    public static NUMBER validate_layer_with_context_3D(String string, String string2, String string3, NUMBER nUMBER, String string4, NUMBER nUMBER2, NUMBER nUMBER3) throws SQLException, Exception {
        int n;
        block19: {
            ResultSet resultSet = null;
            Statement statement = null;
            Object var9_9 = null;
            Statement statement2 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            Connection connection = null;
            Statement statement3 = null;
            int n2 = 0;
            n = 0;
            int n3 = nUMBER.intValue();
            connection = DriverManager.getConnection("jdbc:default:connection:");
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            string5 = new String();
            string5 = "SELECT rowid, " + string2 + "  FROM " + string;
            resultSet = statement.executeQuery(string5);
            string6 = new String();
            string6 = "INSERT INTO " + string3 + " VALUES (CHARTOROWID(?),?)";
            statement3 = connection.prepareStatement(string6);
            while (resultSet.next()) {
                String string8 = resultSet.getString(1);
                Object object = null;
                object = resultSet.getObject(2);
                ++n;
                String string9 = null;
                string9 = Adapters.validateGeom((STRUCT)object, string4, nUMBER2, nUMBER3);
                if (!string9.substring(0, 4).equals("TRUE")) {
                    statement3.setString(1, string8);
                    statement3.setString(2, string9);
                    statement3.executeUpdate();
                }
                if (++n2 != n3) continue;
                connection.commit();
                n2 = 0;
            }
            statement2 = connection.createStatement();
            string7 = new String();
            string7 = "INSERT INTO " + string3 + " VALUES (NULL, 'Rows Processed " + String.valueOf(n) + "')";
            statement2.executeUpdate(string7);
            connection.commit();
            Object var23_24 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement2 != null) {
                    statement2.close();
                }
                if (statement3 != null) {
                    statement3.close();
                }
                if (statement != null) {
                    statement.close();
                }
                connection.close();
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException.getMessage());
            }
            break block19;
            {
                catch (SQLException sQLException) {
                    throw sQLException;
                }
            }
            catch (Throwable throwable) {
                Object var23_25 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (statement2 != null) {
                        statement2.close();
                    }
                    if (statement3 != null) {
                        statement3.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    connection.close();
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException.getMessage());
                }
                throw throwable;
            }
        }
        return new NUMBER(n);
    }

    public static STRUCT centroid_3d(STRUCT sTRUCT, NUMBER nUMBER) throws Exception, SQLException {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        J3D_Geometry j3D_Geometry2 = null;
        j3D_Geometry2 = j3D_Geometry.centroid3d(nUMBER.doubleValue());
        if (j3D_Geometry2 == null) {
            return null;
        }
        JGeometry jGeometry2 = new JGeometry(j3D_Geometry2.getOrdinatesArray()[0], j3D_Geometry2.getOrdinatesArray()[1], j3D_Geometry2.getOrdinatesArray()[2], j3D_Geometry2.getSRID());
        return JGeometry.store((JGeometry)jGeometry2, (Connection)connection);
    }

    public static STRUCT extrusion2(STRUCT sTRUCT, SdoNumberArray sdoNumberArray, SdoNumberArray sdoNumberArray2, NUMBER nUMBER, NUMBER nUMBER2) throws Exception, SQLException {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        JGeometry jGeometry2 = null;
        double[] dArray = new double[sdoNumberArray.length()];
        double[] dArray2 = new double[sdoNumberArray2.length()];
        try {
            int n = nUMBER2 == null ? 0 : nUMBER2.intValue();
            if (sdoNumberArray.length() == 1) {
                jGeometry2 = J3D_Geometry.extrusion((JGeometry)jGeometry, (double)sdoNumberArray.getArray()[0].doubleValue(), (double)sdoNumberArray2.getArray()[0].doubleValue(), (Connection)connection, (double)nUMBER.doubleValue(), (int)n);
            } else {
                int n2;
                for (n2 = 0; n2 < sdoNumberArray.length(); ++n2) {
                    dArray[n2] = sdoNumberArray.getArray()[n2].doubleValue();
                }
                for (n2 = 0; n2 < sdoNumberArray2.length(); ++n2) {
                    dArray2[n2] = sdoNumberArray2.getArray()[n2].doubleValue();
                }
                jGeometry2 = J3D_Geometry.extrusion((JGeometry)jGeometry, (double[])dArray, (double[])dArray2, (Connection)connection, (double)nUMBER.doubleValue(), (int)n);
            }
        }
        catch (Exception exception) {
            String string = exception.toString();
            string = string.substring(string.indexOf(" ") + 1);
            int n = 0;
            n = string.length() == 5 ? Integer.valueOf(string.substring(string.indexOf(" ") + 1)).intValue() : Integer.valueOf(string.substring(0, 5)).intValue();
            jGeometry2 = new JGeometry(n, 0, new int[]{1, 1, 1}, new double[]{0.0, 0.0, 0.0});
            return JGeometry.store((JGeometry)jGeometry2, (Connection)connection);
        }
        return JGeometry.store((JGeometry)jGeometry2, (Connection)connection);
    }

    public static STRUCT ringUnionApprox(STRUCT sTRUCT, NUMBER nUMBER) throws Exception, SQLException {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        JGeometry jGeometry2 = Adapters.ringUnion(jGeometry, nUMBER.doubleValue());
        return JGeometry.store((JGeometry)jGeometry2, (Connection)connection);
    }

    private static void compStarts(double[] dArray, int[] nArray, int[] nArray2, int n, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n2 = dArray.length / 2;
        for (int i = 0; i < n2 - 1; ++i) {
            d3 = dArray[2 * i];
            double d7 = dArray[2 * i + 1];
            if (i == 0 || d3 <= d2 + d) {
                if (i > 0 && Math.abs(d3 - d2) < d && d7 > d5) continue;
                d5 = d7;
                d2 = d3;
                nArray[n] = i;
            }
            if (i != 0 && !(d3 >= d4 - d) || i > 0 && Math.abs(d3 - d4) < d && d7 < d6) continue;
            d4 = d3;
            d6 = d7;
            nArray2[n] = i;
        }
    }

    private static int getNextIdx(double[] dArray, int n, double d, double d2, double d3) {
        double d4;
        int n2;
        int n3 = dArray.length / 2;
        int n4 = n;
        if (Adapters.samePt(dArray[2 * n], dArray[2 * n + 1], d2, d, d3)) {
            n4 = (n4 + 1) % (dArray.length / 2);
        }
        int n5 = n4;
        double d5 = dArray[2 * n4];
        double d6 = dArray[2 * n4 + 1];
        double d7 = Math.abs(d6 - d);
        int n6 = n5;
        for (n2 = 1; n2 < n3; ++n2) {
            d4 = d5 - dArray[2 * (n6 = (n6 + 1) % n3)];
            double d8 = d4 = d4 < 0.0 ? -d4 : d4;
            if (d4 > d3) break;
            d4 = d - dArray[2 * n6 + 1];
            double d9 = d4 = d4 < 0.0 ? -d4 : d4;
            if (d4 >= d7) break;
            n5 = n6;
        }
        n6 = n5;
        for (n2 = 1; n2 < n3; ++n2) {
            d4 = d5 - dArray[2 * (n6 = (n6 - 1 + n3) % n3)];
            double d10 = d4 = d4 < 0.0 ? -d4 : d4;
            if (d4 > d3) break;
            d4 = d - dArray[2 * n6 + 1];
            double d11 = d4 = d4 < 0.0 ? -d4 : d4;
            if (d4 >= d7) break;
            n5 = n4;
        }
        return n5;
    }

    private static void getFirstPt(double[][] dArray, int[] nArray, int n, boolean bl, int[] nArray2, double[] dArray2, double[] dArray3) {
        double d = 0.0;
        double d2 = 0.0;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                double d3 = dArray[i][2 * n2];
                double d4 = dArray[i][2 * n2 + 1];
                if (i != 0 && !(d3 < d)) continue;
                d = d3;
                d2 = d4;
                nArray2[0] = i;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n3 = nArray[i];
                double d5 = dArray[i][2 * n3];
                double d6 = dArray[i][2 * n3 + 1];
                if (i != 0 && !(d5 > d)) continue;
                d = d5;
                d2 = d6;
                nArray2[0] = i;
            }
        }
        dArray2[0] = d;
        dArray3[0] = d2;
    }

    private static boolean betterCand(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d < 0.0) {
            return false;
        }
        if (Math.abs(d - d4) < d7) {
            if (Math.abs(d) < d7) {
                if (d2 > 0.0 && d5 > 0.0 || d2 < 0.0 && d5 < 0.0) {
                    return Math.abs(d2) < Math.abs(d5);
                }
                return d5 < 0.0;
            }
            if (Math.abs(d2) < d7) {
                return true;
            }
            if (Math.abs(d5) < d7) {
                return false;
            }
            if (d2 > 0.0 && d5 > 0.0 || d2 < 0.0 && d5 < 0.0) {
                return Math.abs(d2) < Math.abs(d5);
            }
            return d5 < 0.0;
        }
        if (Math.abs(d2) < d7 && d < d4) {
            return true;
        }
        return d3 > d6;
    }

    private static boolean getNextPt(double[][] dArray, int[] nArray, int[] nArray2, int[] nArray3, int n, boolean bl, double d, double[] dArray2, double[] dArray3) {
        boolean bl2 = false;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = -1.0;
        double d7 = -1.0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        double d8 = dArray2[0];
        double d9 = dArray3[0];
        n3 = -1;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                int n5;
                double d10;
                if (nArray3[i] == -1) continue;
                int n6 = dArray[i].length / 2;
                while (!Adapters.samePt(dArray[i], nArray3[i], nArray2[i], d) && !((d10 = dArray[i][2 * (n5 = nArray3[i])]) >= d8)) {
                    nArray3[i] = (nArray3[i] + 1) % n6;
                }
                n2 = nArray3[i] != nArray[i] ? nArray3[i] : Adapters.getNextIdx(dArray[i], nArray3[i], d9, d8, d);
                double d11 = dArray[i][2 * n2 + 1];
                d10 = dArray[i][2 * n2];
                if (d10 < d8) continue;
                double d12 = d10 - dArray2[0];
                double d13 = dArray3[0] - d11;
                double d14 = Math.abs(d13) < d ? 0.0 : (Math.abs(d12) < d ? (d13 > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : d13 / d12);
                if (n3 != -1 && !Adapters.betterCand(d12, d13, d14, d6, d7, d5, d)) continue;
                n3 = i;
                d2 = d11;
                d4 = d10;
                d5 = d14;
                d6 = d12;
                d7 = d13;
                n4 = Adapters.samePt(dArray[i], n2, nArray2[n3], d) ? -1 : (n2 + 1) % n6;
            }
            nArray3[n3] = n4;
            dArray2[0] = d4;
            dArray3[0] = d2;
        } else {
            for (int i = 0; i < n; ++i) {
                int n7;
                double d15;
                if (nArray3[i] == -1) continue;
                int n8 = dArray[i].length / 2;
                while (!Adapters.samePt(dArray[i], nArray3[i], nArray[i], d) && !((d15 = dArray[i][2 * (n7 = nArray3[i])]) <= d8)) {
                    nArray3[i] = (nArray3[i] + 1) % n8;
                }
                n2 = nArray3[i] != nArray2[i] ? nArray3[i] : Adapters.getNextIdx(dArray[i], nArray3[i], d9, d8, d);
                double d16 = dArray[i][2 * n2 + 1];
                d15 = dArray[i][2 * n2];
                if (d15 > d8) continue;
                double d17 = dArray2[0] - d15;
                double d18 = d16 - dArray3[0];
                double d19 = Math.abs(d18) < d ? 0.0 : (Math.abs(d17) < d ? (d18 > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : d18 / d17);
                if (n3 != -1 && !Adapters.betterCand(d17, d18, d19, d6, d7, d5, d)) continue;
                n3 = i;
                d3 = d16;
                d4 = d15;
                d5 = d19;
                d6 = d17;
                d7 = d18;
                n4 = Adapters.samePt(dArray[i], n2, nArray[n3], d) ? -1 : (n2 + 1) % n8;
            }
            nArray3[n3] = n4;
            dArray2[0] = d4;
            dArray3[0] = d3;
        }
        return n3 != -1;
    }

    private static boolean samePt(double d, double d2, double d3, double d4, double d5) {
        double d6 = d - d3;
        double d7 = d2 - d4;
        d6 = d6 < 0.0 ? -d6 : d6;
        d7 = d7 < 0.0 ? -d7 : d7;
        return d7 < d5 && d6 < d5;
    }

    private static boolean samePt(double[] dArray, int n, int n2, double d) {
        return Adapters.samePt(dArray[2 * n], dArray[2 * n + 1], dArray[2 * n2], dArray[2 * n2 + 1], d);
    }

    protected static JGeometry ringUnion(JGeometry jGeometry, double d) {
        int n;
        int n2;
        JGeometry jGeometry2 = jGeometry;
        JGeometry[] jGeometryArray = jGeometry.getElements();
        int n3 = jGeometryArray.length;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        double[][] dArrayArray = new double[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            dArrayArray[n2] = jGeometryArray[n2].getOrdinatesArray();
        }
        for (int i = 0; i < n3; ++i) {
            Adapters.compStarts(dArrayArray[i], nArray, nArray2, i, d);
        }
        double[] dArray7 = new double[jGeometry.getOrdinatesArray().length];
        int[] nArray6 = new int[]{1, 1003, 1};
        Adapters.getFirstPt(dArrayArray, nArray, n3, true, nArray5, dArray3, dArray4);
        Adapters.getFirstPt(dArrayArray, nArray2, n3, false, nArray4, dArray5, dArray6);
        for (n2 = 0; n2 < n3; ++n2) {
            nArray3[n2] = nArray[n2];
        }
        dArray[0] = dArray3[0];
        dArray2[0] = dArray4[0];
        n2 = 0;
        while (n2 < dArray7.length) {
            n = 1;
            dArray7[2 * n2] = dArray[0];
            dArray7[2 * n2 + 1] = dArray2[0];
            if (n2 > 0) {
                int n4 = n = !Adapters.samePt(dArray7, n2, n2 - 1, d) ? 1 : 0;
            }
            if (Adapters.samePt(dArray[0], dArray2[0], dArray5[0], dArray6[0], d) || !Adapters.getNextPt(dArrayArray, nArray, nArray2, nArray3, n3, true, d, dArray, dArray2)) break;
            if (n == 0) continue;
            ++n2;
        }
        for (n = 0; n < n3; ++n) {
            nArray3[n] = nArray2[n];
        }
        nArray3[nArray4[0]] = (nArray3[nArray4[0]] + 1) % (dArrayArray[nArray4[0]].length / 2);
        dArray[0] = dArray5[0];
        dArray2[0] = dArray6[0];
        while (n2 < dArray7.length) {
            n = 1;
            dArray7[2 * n2] = dArray[0];
            dArray7[2 * n2 + 1] = dArray2[0];
            if (n2 > 0) {
                int n5 = n = !Adapters.samePt(dArray7, n2, n2 - 1, d) ? 1 : 0;
            }
            if (Adapters.samePt(dArray[0], dArray2[0], dArray3[0], dArray4[0], d) || !Adapters.getNextPt(dArrayArray, nArray, nArray2, nArray3, n3, false, d, dArray, dArray2)) break;
            if (n == 0) continue;
            ++n2;
        }
        if (!Adapters.samePt(dArray7, n2 - 1, 0, d)) {
            dArray7[2 * n2] = dArray7[0];
            dArray7[2 * n2 + 1] = dArray7[1];
            ++n2;
        }
        double[] dArray8 = new double[2 * n2];
        for (int i = 0; i < 2 * n2; ++i) {
            dArray8[i] = dArray7[i];
        }
        jGeometry2 = new JGeometry(2003, jGeometry.getSRID(), nArray6, dArray8);
        return jGeometry2;
    }

    public static STRUCT extract3d(STRUCT sTRUCT, String string) throws Exception {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = sTRUCT == null ? null : JGeometry.load((STRUCT)sTRUCT);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        J3D_Geometry j3D_Geometry2 = j3D_Geometry.getElementByLabel(string);
        return JGeometry.store((JGeometry)j3D_Geometry2, (Connection)connection);
    }

    public static String getlabelbyelement(STRUCT sTRUCT, STRUCT sTRUCT2, NUMBER nUMBER) throws Exception {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = sTRUCT == null ? null : JGeometry.load((STRUCT)sTRUCT);
        JGeometry jGeometry2 = sTRUCT2 == null ? null : JGeometry.load((STRUCT)sTRUCT2);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        J3D_Geometry j3D_Geometry2 = jGeometry2.getElemInfo() == null ? new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getPoint()[0], jGeometry2.getPoint()[1], jGeometry2.getPoint()[2]) : new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getElemInfo(), jGeometry2.getOrdinatesArray());
        String string = "";
        string = j3D_Geometry.getLabelByElement(j3D_Geometry2, nUMBER.doubleValue());
        return string;
    }

    public static String inside3d(STRUCT sTRUCT, STRUCT sTRUCT2, String string, NUMBER nUMBER) throws Exception {
        Object object;
        Object object2;
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        JGeometry jGeometry2 = JGeometry.load((STRUCT)sTRUCT2);
        if (string.equals("TRUE")) {
            int n;
            int n2;
            if (nUMBER.doubleValue() < 0.05) {
                nUMBER = new NUMBER(0.05);
            }
            if (((double[])(object2 = jGeometry.getMBR())).length != ((double[])(object = jGeometry2.getMBR())).length) {
                throw new DataException("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
            }
            double[] dArray = new double[((double[])object2).length];
            for (n2 = 0; n2 < ((double[])object2).length; ++n2) {
                dArray[n2] = 0.0;
            }
            for (n2 = 0; n2 < ((double[])object2).length / 2; ++n2) {
                for (n = 0; n < 2; ++n) {
                    dArray[((double[])object2).length / 2 * n + n2] = (object2[((double[])object2).length / 2 * n + n2] + object[((double[])object).length / 2 * n + n2]) / 2.0;
                }
            }
            double[] dArray2 = new double[dArray.length / 2];
            for (n = 0; n < dArray.length / 2; ++n) {
                dArray2[n] = (dArray[n + dArray.length / 2] + dArray[n]) / 2.0;
            }
            double d = Math.PI / 180 * dArray2[0];
            double d2 = Math.PI / 180 * dArray2[1];
            jGeometry = jGeometry.projectToGNM_longLat(d, d2);
            jGeometry2 = jGeometry2.projectToGNM_longLat(d, d2);
        }
        object2 = jGeometry.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        object = jGeometry2.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getPoint()[0], jGeometry2.getPoint()[1], jGeometry2.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getElemInfo(), jGeometry2.getOrdinatesArray());
        boolean bl = object2.inside3d((J3D_Geometry)object, nUMBER.doubleValue());
        if (bl) {
            return "TRUE";
        }
        return "FALSE";
    }

    public static void readpts(BLOB bLOB, int n, int n2, Ptclass[] ptclassArray) throws SQLException, IOException {
        DataInputStream dataInputStream = new DataInputStream(bLOB.getBinaryStream());
        double[] dArray = new double[n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[j] = dataInputStream.readDouble();
            }
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            ptclassArray[i] = new Ptclass(dArray, n2, n3, n4);
        }
    }

    public static void writepts(BLOB bLOB, int n, int n2, Ptclass[] ptclassArray) throws SQLException, IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(bLOB.setBinaryStream(0L));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dataOutputStream.writeDouble(ptclassArray[i].ords[j]);
            }
            dataOutputStream.writeInt(ptclassArray[i].ptn_id);
            dataOutputStream.writeInt(ptclassArray[i].pt_id);
        }
        dataOutputStream.close();
    }

    public static BLOB pctrclip(STRUCT sTRUCT, STRUCT sTRUCT2, BLOB bLOB, NUMBER nUMBER, NUMBER nUMBER2, BLOB bLOB2, NUMBER nUMBER3, NUMBER nUMBER4) throws SQLException, IOException, Exception {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        BLOB bLOB3 = BLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
        int n = nUMBER2.intValue();
        double d = nUMBER4.doubleValue();
        STRUCT sTRUCT3 = sTRUCT2;
        int n2 = nUMBER.intValue();
        Ptclass[] ptclassArray = new Ptclass[n2];
        Ptclass[] ptclassArray2 = new Ptclass[n2];
        Adapters.readpts(bLOB, n2, n, ptclassArray);
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        double[] dArray = null;
        double[] dArray2 = null;
        int n3 = 0;
        if (sTRUCT2 != null) {
            Datum[] datumArray = sTRUCT2.getOracleAttributes();
            dArray = ((ARRAY)datumArray[0]).getDoubleArray();
            dArray2 = ((ARRAY)datumArray[1]).getDoubleArray();
            if (dArray != null && dArray2 != null) {
                int n4 = n3 = dArray.length < dArray2.length ? dArray.length : dArray2.length;
            }
            if (n3 > n - 3) {
                n3 = n - 3;
            }
        }
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            J3D_Geometry j3D_Geometry2;
            boolean bl = false;
            if (n3 > 0) {
                for (int j = 0; j < n3; ++j) {
                    if (!(dArray[j] > ptclassArray[i].ords[j + 3] + d) && !(dArray2[j] + d < ptclassArray[i].ords[j + 3])) continue;
                    bl = true;
                    break;
                }
            }
            if (bl || !j3D_Geometry.anyInteract(j3D_Geometry2 = new J3D_Geometry(3001, j3D_Geometry.getSRID(), ptclassArray[i].ords[0], ptclassArray[i].ords[1], ptclassArray[i].ords[2]), d)) continue;
            ptclassArray2[n5++] = new Ptclass(ptclassArray[i].ords, n, ptclassArray[i].ptn_id, ptclassArray[i].pt_id);
        }
        if (n5 > 0) {
            Adapters.writepts(bLOB3, n5, n, ptclassArray2);
        }
        return bLOB3;
    }

    public static STRUCT expandG3Dgeoms(STRUCT sTRUCT) throws Exception {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection:");
        JGeometry jGeometry = sTRUCT == null ? null : JGeometry.load((STRUCT)sTRUCT);
        J3D_Geometry j3D_Geometry = null;
        J3D_Geometry j3D_Geometry2 = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        j3D_Geometry = J3D_Geometry.expandGeom((J3D_Geometry)j3D_Geometry2);
        return JGeometry.store((JGeometry)j3D_Geometry, (Connection)connection);
    }

    static {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:default:connection:");
        }
        catch (Exception exception) {
            // empty catch block
        }
        m_conn = connection;
        m_wkbAdapter = new WKB();
        m_wktAdapter = new WKT();
    }

    static class Ptclass {
        protected double[] ords;
        protected int ptn_id;
        protected int pt_id;

        Ptclass(double[] dArray, int n, int n2, int n3) {
            this.ords = new double[n];
            for (int i = 0; i < n; ++i) {
                this.ords[i] = dArray[i];
            }
            this.ptn_id = n2;
            this.pt_id = n3;
        }
    }
}

