/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.driver.OracleDriver;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.AdapterShapefileJGeom;
import oracle.spatial.util.ShapefileReaderJGeom;
import oracle.sql.STRUCT;

public class SampleShapefileToJGeom {
    private static String m_host = "usunnab10";
    private static String m_port = "1521";
    private static String m_sid = "shape";
    private static String m_user = "scott";
    private static String m_password = "tiger";
    private static String m_tableName;
    private static String m_shapefileName;
    private static int m_srid;
    private static String geomMetaDataTable;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 2) {
            m_shapefileName = stringArray[0];
            m_tableName = stringArray[1].toUpperCase();
        } else if (stringArray.length == 1) {
            m_shapefileName = stringArray[0];
            m_tableName = stringArray[0].toUpperCase();
        } else if (stringArray.length == 3) {
            m_shapefileName = stringArray[0];
            m_tableName = stringArray[1].toUpperCase();
            m_srid = Integer.parseInt(stringArray[2]);
        } else {
            System.out.println("Parameters:");
            System.out.println("<Filename>: File name of an input Shapefile (without extension)");
            System.out.println("<Table name>: Table name for the result");
            System.out.println("[SRID]: Valid Oracle SRID for coordinate system");
            return;
        }
        System.out.println("Connecting to DB...");
        String string = "jdbc:oracle:thin:@" + m_host + ":" + m_port + ":" + m_sid;
        Connection connection = null;
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            connection = DriverManager.getConnection(string, m_user, m_password);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ShapefileReaderJGeom shapefileReaderJGeom = new ShapefileReaderJGeom(m_shapefileName);
        double d = shapefileReaderJGeom.getMinMeasure();
        double d2 = shapefileReaderJGeom.getMaxMeasure();
        if (d2 <= -1.0E39) {
            d2 = Double.NaN;
        }
        int n = ShapefileReaderJGeom.getShpDims(shapefileReaderJGeom.getShpFileType(), d2);
        SampleShapefileToJGeom.prepareTableForData(connection, n, d2, shapefileReaderJGeom);
        String string2 = "INSERT INTO " + m_tableName + " VALUES(?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (int i = 0; i < shapefileReaderJGeom.numRecords(); ++i) {
            System.out.println("Converting geometry #" + (i + 1));
            byte[] byArray = shapefileReaderJGeom.getGeometryBytes(i);
            AdapterShapefileJGeom adapterShapefileJGeom = new AdapterShapefileJGeom();
            JGeometry jGeometry = adapterShapefileJGeom.importGeometry(byArray, m_srid);
            STRUCT sTRUCT = JGeometry.store((JGeometry)jGeometry, (Connection)connection);
            int n2 = i + 1;
            preparedStatement.setInt(1, n2);
            preparedStatement.setObject(2, sTRUCT);
            preparedStatement.executeUpdate();
        }
        shapefileReaderJGeom.closeShapefile();
        preparedStatement.close();
        connection.close();
        System.out.println("Done.");
    }

    protected static void prepareTableForData(Connection connection, int n, double d, ShapefileReaderJGeom shapefileReaderJGeom) {
        String string;
        System.out.println("Dropping old table...");
        Statement statement = null;
        try {
            statement = connection.createStatement();
            string = "DROP TABLE " + m_tableName;
            statement.executeUpdate(string);
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
        try {
            statement = connection.createStatement();
            string = "DELETE FROM " + geomMetaDataTable + " WHERE table_name = '" + m_tableName + "'";
            statement.executeUpdate(string);
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
        try {
            System.out.println("Creating new table...");
            statement = connection.createStatement();
            string = "CREATE TABLE " + m_tableName + " (gid NUMBER(38), geometry MDSYS.SDO_GEOMETRY)";
            statement.executeUpdate(string);
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
        try {
            if (n == 2 || n == 0) {
                statement = connection.createStatement();
                string = "INSERT INTO " + geomMetaDataTable + " VALUES ('" + m_tableName + "', 'GEOMETRY', MDSYS.SDO_DIM_ARRAY(" + "MDSYS.SDO_DIM_ELEMENT('X', -180, 180, 0.005), " + "MDSYS.SDO_DIM_ELEMENT('Y', -90, 90, 0.005)), " + m_srid + ")";
                statement.executeUpdate(string);
                statement.close();
            } else if (n == 3 && Double.isNaN(d)) {
                statement = connection.createStatement();
                string = "INSERT INTO " + geomMetaDataTable + " VALUES ('" + m_tableName + "', 'GEOMETRY', MDSYS.SDO_DIM_ARRAY(" + "MDSYS.SDO_DIM_ELEMENT('X', -180, 180, 0.005), " + "MDSYS.SDO_DIM_ELEMENT('Y', -90, 90, 0.005), " + "MDSYS.SDO_DIM_ELEMENT('Z', " + shapefileReaderJGeom.getMinZ() + ", " + shapefileReaderJGeom.getMaxZ() + ", 0.005)), " + m_srid + ")";
                statement.executeUpdate(string);
                statement.close();
            } else if (n == 3) {
                statement = connection.createStatement();
                string = "INSERT INTO " + geomMetaDataTable + " VALUES ('" + m_tableName + "', 'GEOMETRY', MDSYS.SDO_DIM_ARRAY(" + "MDSYS.SDO_DIM_ELEMENT('X', -180, 180, 0.005), " + "MDSYS.SDO_DIM_ELEMENT('Y', -90, 90, 0.005), " + "MDSYS.SDO_DIM_ELEMENT('M', " + shapefileReaderJGeom.getMinMeasure() + ", " + d + ", 0.005)), " + m_srid + ")";
                statement.executeUpdate(string);
                statement.close();
            } else if (n == 4) {
                statement = connection.createStatement();
                string = "INSERT INTO " + geomMetaDataTable + " VALUES ('" + m_tableName + "', 'GEOMETRY', MDSYS.SDO_DIM_ARRAY(" + "MDSYS.SDO_DIM_ELEMENT('X', -180, 180, 0.005), " + "MDSYS.SDO_DIM_ELEMENT('Y', -90, 90, 0.005), " + "MDSYS.SDO_DIM_ELEMENT('Z', " + shapefileReaderJGeom.getMinZ() + ", " + shapefileReaderJGeom.getMaxZ() + ", 0.005), " + "MDSYS.SDO_DIM_ELEMENT('M', " + shapefileReaderJGeom.getMinMeasure() + ", " + d + ", 0.005)), " + m_srid + ")";
                statement.executeUpdate(string);
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
    }

    static {
        m_srid = 0;
        geomMetaDataTable = "user_sdo_geom_metadata";
    }
}

