/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.av.AudioFormat;
import com.jogamp.common.av.AudioSink;
import com.jogamp.common.os.Clock;
import com.jogamp.common.util.LFRingbuffer;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.Ringbuffer;
import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALException;
import com.jogamp.openal.ALExt;
import com.jogamp.openal.sound3d.AudioSystem3D;
import com.jogamp.openal.sound3d.Context;
import com.jogamp.openal.sound3d.Device;
import com.jogamp.openal.sound3d.Source;
import com.jogamp.openal.util.ALHelpers;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import jogamp.openal.Debug;

public final class ALAudioSink
implements AudioSink {
    private static final boolean DEBUG_TRACE;
    private static final ALC alc;
    private static final AL al;
    private static final ALExt alExt;
    private static final boolean staticsInitialized;
    private final Device device;
    private boolean hasSOFTBufferSamples;
    private boolean hasEXTMcFormats;
    private boolean hasEXTFloat32;
    private boolean hasEXTDouble;
    private boolean hasALC_thread_local_context;
    private boolean hasAL_SOFT_events;
    private int sourceCount;
    private float defaultLatency;
    private float latency;
    private final AudioFormat nativeFormat;
    private int userMaxChannels = 8;
    private AudioFormat preferredFormat;
    private final Context context;
    private float playSpeed;
    private float volume = 1.0f;
    private int[] alBufferNames = null;
    private int queueGrowAmount = 0;
    private int queueLimit = 0;
    private float avgFrameDuration = 0.0f;
    private Ringbuffer<ALAudioFrame> alFramesFree = null;
    private Ringbuffer<ALAudioFrame> alFramesPlaying = null;
    private volatile int alBufferBytesQueued = 0;
    private volatile int playingPTS = Integer.MIN_VALUE;
    private volatile int enqueuedFrameCount;
    private final Source alSource = new Source();
    private AudioFormat chosenFormat = null;
    private int alChannelLayout;
    private int alSampleType;
    private int alFormat;
    private volatile boolean available = false;
    private volatile boolean playRequested = false;
    final ALExt.ALEVENTPROCSOFT alEventCallback = new ALExt.ALEVENTPROCSOFT(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callback(int n, int n2, int n3, int n4, String string, ALCcontext aLCcontext) {
            if (6564 == n && ALAudioSink.this.alSource.getID() == n2) {
                Object object = ALAudioSink.this.eventReleasedBuffersLock;
                synchronized (object) {
                    ALAudioSink.this.eventReleasedBuffers += n3;
                    ALAudioSink.this.eventReleasedBuffersLock.notifyAll();
                }
            }
        }
    };
    private final Object eventReleasedBuffersLock = new Object();
    private volatile int eventReleasedBuffers = 0;

    public static boolean isInitialized() {
        return staticsInitialized;
    }

    private static Device createDevice(String string) {
        Device device = new Device(string);
        if (!device.isValid()) {
            throw new ALException(ALAudioSink.getThreadName() + ": ALAudioSink: Error opening OpenAL device '" + string + "'");
        }
        return device;
    }

    public ALAudioSink() throws ALException {
        this((Device)null);
    }

    public ALAudioSink(String string) throws ALException {
        this(ALAudioSink.createDevice(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ALAudioSink(Device device) throws ALException {
        if (!staticsInitialized) {
            this.device = null;
            this.context = null;
            this.nativeFormat = DefaultFormat;
            return;
        }
        if (null == device) {
            this.device = ALAudioSink.createDevice(null);
            if (!this.device.isValid()) {
                throw new ALException(ALAudioSink.getThreadName() + ": ALAudioSink: Couldn't open default device: " + this.device);
            }
        } else {
            this.device = device;
            if (!this.device.open()) {
                throw new ALException(ALAudioSink.getThreadName() + ": ALAudioSink: Error device not open or couldn't be opened " + this.device);
            }
        }
        this.context = new Context(this.device, null);
        if (!this.context.isValid()) {
            throw new ALException(ALAudioSink.getThreadName() + ": ALAudioSink: Error creating OpenAL context " + this.context);
        }
        this.makeCurrent(true);
        try {
            this.hasSOFTBufferSamples = al.alIsExtensionPresent("AL_SOFT_buffer_samples");
            this.hasEXTMcFormats = al.alIsExtensionPresent("AL_EXT_MCFORMATS");
            this.hasEXTFloat32 = al.alIsExtensionPresent("AL_EXT_FLOAT32");
            this.hasEXTDouble = al.alIsExtensionPresent("AL_EXT_DOUBLE");
            this.hasALC_thread_local_context = this.context.hasALC_thread_local_context;
            this.hasAL_SOFT_events = al.alIsExtensionPresent("AL_SOFT_events");
            int n = 1;
            AudioSystem3D.checkError(this.device, "init." + n++, DEBUG, false);
            int n2 = ALAudioSink.DefaultFormat.sampleRate;
            int[] nArray = new int[]{0};
            alc.alcGetIntegerv(this.device.getALDevice(), 4103, 1, nArray, 0);
            if (AudioSystem3D.checkError(this.device, "read ALC_FREQUENCY", DEBUG, false) || 0 == nArray[0]) {
                if (DEBUG) {
                    System.err.println("ALAudioSink.queryDefaultSampleRate: failed, using default " + n2);
                }
            } else {
                n2 = nArray[0];
                if (DEBUG) {
                    System.err.println("ALAudioSink.queryDefaultSampleRate: OK " + n2);
                }
            }
            nArray[0] = 0;
            alc.alcGetIntegerv(this.device.getALDevice(), 4112, 1, nArray, 0);
            if (AudioSystem3D.checkError(this.device, "read ALC_MONO_SOURCES", DEBUG, false)) {
                this.sourceCount = -1;
                if (DEBUG) {
                    System.err.println("ALAudioSink.queryMonoSourceCount: failed");
                }
            } else {
                this.sourceCount = nArray[0];
            }
            nArray[0] = 0;
            alc.alcGetIntegerv(this.device.getALDevice(), 4104, 1, nArray, 0);
            if (AudioSystem3D.checkError(this.device, "read ALC_FREQUENCY", DEBUG, false) || 0 == nArray[0]) {
                this.defaultLatency = 0.02f;
                if (DEBUG) {
                    System.err.println("ALAudioSink.queryDefaultRefreshRate: failed");
                }
            } else {
                this.defaultLatency = 1.0f / (float)nArray[0];
                if (DEBUG) {
                    System.err.println("ALAudioSink.queryDefaultRefreshRate: OK " + nArray[0] + " Hz = " + 1000.0f * this.defaultLatency + " ms");
                }
            }
            this.preferredFormat = this.nativeFormat = new AudioFormat(n2, ALAudioSink.DefaultFormat.sampleSize, this.getMaxSupportedChannels(false), ALAudioSink.DefaultFormat.signed, ALAudioSink.DefaultFormat.fixedP, ALAudioSink.DefaultFormat.planar, ALAudioSink.DefaultFormat.littleEndian);
            if (DEBUG) {
                nArray = new int[]{0, 0};
                System.out.println("ALAudioSink: OpenAL Version: " + al.alGetString(45058));
                System.out.println("ALAudioSink: OpenAL Extensions: " + al.alGetString(45060));
                AudioSystem3D.checkError(this.device, "init." + n++, DEBUG, false);
                System.out.println("ALAudioSink: Null device OpenALC:");
                alc.alcGetIntegerv(null, 4096, 1, nArray, 0);
                alc.alcGetIntegerv(null, 4097, 1, nArray, 1);
                System.out.println("  Version: " + nArray[0] + "." + nArray[1]);
                System.out.println("  Extensions: " + alc.alcGetString(null, 4102));
                AudioSystem3D.checkError(this.device, "init." + n++, DEBUG, false);
                System.out.println("ALAudioSink: Device " + this.device + " OpenALC:");
                alc.alcGetIntegerv(this.device.getALDevice(), 4096, 1, nArray, 0);
                alc.alcGetIntegerv(this.device.getALDevice(), 4097, 1, nArray, 1);
                System.out.println("  Version: " + nArray[0] + "." + nArray[1]);
                System.out.println("  Extensions: " + alc.alcGetString(this.device.getALDevice(), 4102));
                System.out.println("ALAudioSink: hasSOFTBufferSamples " + this.hasSOFTBufferSamples);
                System.out.println("ALAudioSink: hasEXTMcFormats " + this.hasEXTMcFormats);
                System.out.println("ALAudioSink: hasEXTFloat32 " + this.hasEXTFloat32);
                System.out.println("ALAudioSink: hasEXTDouble " + this.hasEXTDouble);
                System.out.println("ALAudioSink: hasALC_thread_local_context " + this.hasALC_thread_local_context);
                System.out.println("ALAudioSink: hasAL_SOFT_events " + this.hasAL_SOFT_events);
                System.out.println("ALAudioSink: maxSupportedChannels " + this.getMaxSupportedChannels(false));
                System.out.println("ALAudioSink: nativeAudioFormat " + this.nativeFormat);
                System.out.println("ALAudioSink: defaultMixerRefreshRate " + 1000.0f * this.defaultLatency + " ms, " + 1.0f / this.defaultLatency + " Hz");
                AudioSystem3D.checkError(this.device, "init." + n++, DEBUG, false);
            }
            if (DEBUG) {
                System.err.println("ALAudioSink: Using device: " + this.device);
            }
            this.available = true;
        }
        finally {
            this.release(true);
        }
    }

    public static final AL getAL() {
        return al;
    }

    public static final ALC getALC() {
        return alc;
    }

    public static final ALExt getALExt() {
        return alExt;
    }

    public final Device getDevice() {
        return this.device;
    }

    public final Context getContext() {
        return this.context;
    }

    public final Source getSource() {
        return this.alSource;
    }

    public final boolean hasSOFTBufferSamples() {
        return this.hasSOFTBufferSamples;
    }

    public final boolean hasEXTMcFormats() {
        return this.hasEXTMcFormats;
    }

    public final boolean hasEXTFloat32() {
        return this.hasEXTFloat32;
    }

    public final boolean hasEXTDouble() {
        return this.hasEXTDouble;
    }

    public final boolean hasALCThreadLocalContext() {
        return this.hasALC_thread_local_context;
    }

    public final int getALChannelLayout() {
        return this.alChannelLayout;
    }

    public final int getALSampleType() {
        return this.alSampleType;
    }

    public final int getALFormat() {
        return this.alFormat;
    }

    @Override
    public final boolean makeCurrent(boolean bl) {
        return this.context.makeCurrent(bl);
    }

    @Override
    public final boolean release(boolean bl) {
        return this.context.release(bl);
    }

    private final void destroyContext() {
        this.context.destroy();
    }

    public final String toString() {
        int n = null != this.alBufferNames ? this.alBufferNames.length : 0;
        int n2 = this.context != null ? this.context.hashCode() : 0;
        int n3 = this.alFramesFree != null ? this.alFramesFree.size() : 0;
        int n4 = this.alFramesPlaying != null ? this.alFramesPlaying.size() : 0;
        return String.format("ALAudioSink[playReq %b, device '%s', ctx 0x%x, alSource %d, chosen %s, al[chan %s, type %s, fmt 0x%x, tlc %b, soft %b, latency %.2f/%.2f ms, sources %d], playSpeed %.2f, buffers[total %d, free %d], queued[%d, apts %d, %.1f ms, %d bytes, avg %.2f ms/frame], queue[g %d ms, l %d ms]]", this.playRequested, this.device.getName(), n2, this.alSource.getID(), this.chosenFormat, ALHelpers.alChannelLayoutName(this.alChannelLayout), ALHelpers.alSampleTypeName(this.alSampleType), this.alFormat, this.hasALC_thread_local_context, this.hasSOFTBufferSamples, Float.valueOf(1000.0f * this.latency), Float.valueOf(1000.0f * this.defaultLatency), this.sourceCount, Float.valueOf(this.playSpeed), n, n3, n4, this.getPTS(), Float.valueOf(1000.0f * this.getQueuedTime()), this.alBufferBytesQueued, Float.valueOf(1000.0f * this.avgFrameDuration), this.queueGrowAmount, this.queueLimit);
    }

    private final String shortString() {
        int n = this.context != null ? this.context.hashCode() : 0;
        int n2 = this.alFramesPlaying != null ? this.alFramesPlaying.size() : 0;
        return String.format("[ctx 0x%x, playReq %b, alSrc %d, queued[%d, apts %d, %.1f ms, %d bytes, avg %.2f ms/frame], queue[g %d ms, l %d ms]]", n, this.playRequested, this.alSource.getID(), n2, this.getPTS(), Float.valueOf(1000.0f * this.getQueuedTime()), this.alBufferBytesQueued, Float.valueOf(1000.0f * this.avgFrameDuration), this.queueGrowAmount, this.queueLimit);
    }

    public final String getPerfString() {
        int n = null != this.alBufferNames ? this.alBufferNames.length : 0;
        return String.format("Play [buffer %d/%d, apts %d, %.1f ms, %d bytes]", this.alFramesPlaying.size(), n, this.getPTS(), Float.valueOf(1000.0f * this.getQueuedTime()), this.alBufferBytesQueued);
    }

    @Override
    public int getSourceCount() {
        return this.sourceCount;
    }

    @Override
    public float getDefaultLatency() {
        return this.defaultLatency;
    }

    @Override
    public float getLatency() {
        return this.latency;
    }

    @Override
    public final AudioFormat getNativeFormat() {
        if (!staticsInitialized) {
            return null;
        }
        return this.nativeFormat;
    }

    @Override
    public final AudioFormat getPreferredFormat() {
        if (!staticsInitialized) {
            return null;
        }
        return this.preferredFormat;
    }

    @Override
    public final void setChannelLimit(int n) {
        this.userMaxChannels = Math.min(8, Math.max(1, n));
        this.preferredFormat = new AudioFormat(this.nativeFormat.sampleRate, this.nativeFormat.sampleSize, this.getMaxSupportedChannels(true), this.nativeFormat.signed, this.nativeFormat.fixedP, this.nativeFormat.planar, this.nativeFormat.littleEndian);
        if (DEBUG) {
            System.out.println("ALAudioSink: channelLimit " + this.userMaxChannels + ", preferredFormat " + this.preferredFormat);
        }
    }

    private final int getMaxSupportedChannels(boolean bl) {
        if (!staticsInitialized) {
            return 0;
        }
        int n = this.hasEXTMcFormats || this.hasSOFTBufferSamples ? 8 : 2;
        return bl ? Math.min(this.userMaxChannels, n) : n;
    }

    @Override
    public final boolean isSupported(AudioFormat audioFormat) {
        if (!staticsInitialized) {
            return false;
        }
        if (audioFormat.planar != this.preferredFormat.planar || audioFormat.littleEndian != this.preferredFormat.littleEndian || audioFormat.sampleRate > this.preferredFormat.sampleRate || audioFormat.channelCount > this.preferredFormat.channelCount) {
            if (DEBUG) {
                System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink.isSupported: NO.0 " + audioFormat);
            }
            return false;
        }
        int n = ALHelpers.getALFormat(audioFormat, al, alExt, this.hasSOFTBufferSamples, this.hasEXTMcFormats, this.hasEXTFloat32, this.hasEXTDouble);
        if (0 != n) {
            if (DEBUG) {
                System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink.isSupported: OK " + audioFormat + ", alFormat " + ALAudioSink.toHexString(n));
            }
            return true;
        }
        if (DEBUG) {
            System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink.isSupported: NO.1 " + audioFormat);
        }
        return false;
    }

    @Override
    public final boolean init(AudioFormat audioFormat, int n, int n2, int n3, int n4) {
        if (!staticsInitialized) {
            return false;
        }
        int n5 = ALHelpers.getDefaultALChannelLayout(audioFormat.channelCount);
        int n6 = ALHelpers.getALSampleType(audioFormat.sampleSize, audioFormat.signed, audioFormat.fixedP);
        int n7 = 0 != n5 && 0 != n6 ? ALHelpers.getALFormat(n5, n6, al, alExt, this.hasSOFTBufferSamples, this.hasEXTMcFormats, this.hasEXTFloat32, this.hasEXTDouble) : 0;
        if (0 == n7) {
            if (DEBUG) {
                System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink.init1: Not supported: " + audioFormat + ", " + this.toString());
            }
            return false;
        }
        return this.initImpl(audioFormat, n5, n6, n7, (float)n / 1000.0f, n2, n3, n4);
    }

    public final boolean init(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        AudioFormat audioFormat = ALHelpers.getAudioFormat(n, n2, n3, n4, n5);
        if (null == audioFormat) {
            if (DEBUG) {
                System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink.init2: Invalid AL channelLayout " + ALAudioSink.toHexString(n) + ", sampleType " + ALAudioSink.toHexString(n2) + ", format " + ALAudioSink.toHexString(n3) + " or sample[rate " + n4 + ", size " + n5 + "]; " + this.toString());
            }
            return false;
        }
        return this.initImpl(audioFormat, n, n2, n3, (float)n6 / 1000.0f, n7, n8, n9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized boolean initImpl(AudioFormat audioFormat, int n, int n2, int n3, float f, int n4, int n5, int n6) {
        this.alChannelLayout = n;
        this.alSampleType = n2;
        this.alFormat = n3;
        this.makeCurrent(true);
        if (this.context.getLockCount() != 1) {
            this.release(false);
            throw new ALException("init() must be called w/o makeCurrent: lockCount " + this.context + ", " + this);
        }
        boolean bl = true;
        try {
            this.stopImpl(true);
            this.destroySource();
            this.destroyBuffers();
            f = f >= 0.001f ? f : 0.032f;
            int n7 = Math.round(1.0f / this.defaultLatency);
            int n8 = Math.round(1.0f / f);
            if (f < this.defaultLatency) {
                if (DEBUG) {
                    System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink.init: Re-create context as latency exp " + 1000.0f * f + " ms (" + n8 + " Hz) < default " + 1000.0f * this.defaultLatency + " ms (" + n7 + " Hz)");
                }
                if (!this.context.recreate(new int[]{4104, n8})) {
                    System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: Error creating OpenAL context " + this.context);
                    boolean bl2 = false;
                    return bl2;
                }
            } else if (DEBUG) {
                System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink.init: Keep context, latency exp " + 1000.0f * f + " ms (" + n8 + " Hz) >= default " + 1000.0f * this.defaultLatency + " ms (" + n7 + " Hz)");
            }
            int[] nArray = new int[]{0};
            alc.alcGetIntegerv(this.device.getALDevice(), 4104, 1, nArray, 0);
            if (AudioSystem3D.checkError(this.device, "read ALC_FREQUENCY", DEBUG, false) || 0 == nArray[0]) {
                this.latency = this.defaultLatency;
                if (DEBUG) {
                    System.err.println("ALAudioSink.queryRefreshRate: failed, claiming default " + 1000.0f * this.latency + " ms");
                }
            } else {
                this.latency = 1.0f / (float)nArray[0];
                if (DEBUG) {
                    System.err.println("ALAudioSink.queryRefreshRate: OK " + nArray[0] + " Hz = " + 1000.0f * this.latency + " ms");
                }
            }
            if (!this.createSource()) {
                this.destroyContext();
                bl = false;
                boolean bl3 = false;
                return bl3;
            }
            int n9 = audioFormat.getFrameCount(n4 > 0 ? (float)n4 / 1000.0f : 0.512f, f);
            this.alBufferNames = new int[n9];
            al.alGenBuffers(n9, this.alBufferNames, 0);
            if (AudioSystem3D.checkALError("alGenBuffers", true, false)) {
                this.alBufferNames = null;
                this.destroySource();
                this.destroyContext();
                bl = false;
                n8 = 0;
                return n8 != 0;
            }
            ALAudioFrame[] aLAudioFrameArray = new ALAudioFrame[n9];
            for (int i = 0; i < n9; ++i) {
                aLAudioFrameArray[i] = new ALAudioFrame(this.alBufferNames[i]);
            }
            this.alFramesFree = new LFRingbuffer<ALAudioFrame>(aLAudioFrameArray);
            this.alFramesPlaying = new LFRingbuffer<ALAudioFrame>(ALAudioFrame[].class, n9);
            this.queueGrowAmount = n5 > 0 ? n5 : 512;
            int n10 = this.queueLimit = n6 > 0 ? n6 : 3072;
            if (DEBUG_TRACE) {
                this.alFramesFree.dump(System.err, "Avail-init");
                this.alFramesPlaying.dump(System.err, "Playi-init");
            }
            if (this.hasAL_SOFT_events) {
                alExt.alEventCallbackSOFT(this.alEventCallback, this.context.getALContext());
                alExt.alEventControlSOFT(1, new int[]{6564}, 0, true);
            }
        }
        finally {
            if (bl) {
                this.release(false);
            }
        }
        this.chosenFormat = audioFormat;
        if (DEBUG) {
            System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink.init: OK " + audioFormat + ", " + this.toString());
        }
        return true;
    }

    @Override
    public final AudioFormat getChosenFormat() {
        return this.chosenFormat;
    }

    private static int[] concat(int[] nArray, int[] nArray2) {
        int[] nArray3 = Arrays.copyOf(nArray, nArray.length + nArray2.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    private boolean growBuffers(int n) {
        if (!this.alFramesFree.isEmpty() || !this.alFramesPlaying.isFull()) {
            throw new InternalError("Buffers: Avail is !empty " + this.alFramesFree + " or Playing is !full " + this.alFramesPlaying + ", while !hasAL_SOFT_events");
        }
        float f = this.chosenFormat.getBytesDuration(n);
        float f2 = this.chosenFormat.getBytesDuration(this.alBufferBytesQueued);
        int n2 = Math.round(1000.0f * (f2 + f));
        if (n2 > this.queueLimit) {
            if (DEBUG) {
                System.err.printf("%s: ALAudioSink.growBuffers: Queue limit %d ms reached (queued %.2f + %.2f)ms: %s%n", ALAudioSink.getThreadName(), this.queueLimit, Float.valueOf(1000.0f * f2), Float.valueOf(1000.0f * f), this.toString());
            }
            return false;
        }
        int n3 = this.chosenFormat.getFrameCount((float)this.queueGrowAmount / 1000.0f, this.avgFrameDuration);
        int[] nArray = new int[n3];
        al.alGenBuffers(n3, nArray, 0);
        if (AudioSystem3D.checkALError("alGenBuffers to " + n3, true, false)) {
            return false;
        }
        this.alBufferNames = ALAudioSink.concat(this.alBufferNames, nArray);
        ALAudioFrame[] aLAudioFrameArray = new ALAudioFrame[n3];
        for (int i = 0; i < n3; ++i) {
            aLAudioFrameArray[i] = new ALAudioFrame(nArray[i]);
        }
        this.alFramesFree.growEmptyBuffer((ALAudioFrame[])aLAudioFrameArray);
        this.alFramesPlaying.growFullBuffer(n3);
        if (this.alFramesFree.isEmpty() || this.alFramesPlaying.isFull()) {
            throw new InternalError("Buffers: Avail is empty " + this.alFramesFree + " or Playing is full " + this.alFramesPlaying);
        }
        if (DEBUG) {
            System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: Buffer grown " + n3 + ": Avail " + this.alFramesFree + ", playing " + this.alFramesPlaying);
        }
        if (DEBUG_TRACE) {
            this.alFramesFree.dump(System.err, "Avail-grow");
            this.alFramesPlaying.dump(System.err, "Playi-grow");
        }
        return true;
    }

    private void destroyBuffers() {
        if (!staticsInitialized) {
            return;
        }
        if (null != this.alBufferNames) {
            block4: {
                try {
                    al.alDeleteBuffers(this.alBufferNames.length, this.alBufferNames, 0);
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block4;
                    System.err.println("Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
            this.alFramesFree.clear();
            this.alFramesFree = null;
            this.alFramesPlaying.clear();
            this.alFramesPlaying = null;
            this.alBufferBytesQueued = 0;
            this.alBufferNames = null;
        }
    }

    private void destroySource() {
        if (!this.alSource.isValid()) {
            return;
        }
        this.alSource.delete();
    }

    private boolean createSource() {
        if (this.alSource.isValid()) {
            return true;
        }
        return this.alSource.create();
    }

    @Override
    public final void destroy() {
        if (!this.available) {
            return;
        }
        this.available = false;
        if (null != this.context) {
            this.makeCurrent(true);
            if (this.hasAL_SOFT_events) {
                alExt.alEventControlSOFT(3, new int[]{6564, 6565, 6566}, 0, false);
                alExt.alEventCallbackSOFT(null, this.context.getALContext());
            }
        }
        try {
            this.stopImpl(true);
            this.destroySource();
            this.destroyBuffers();
        }
        finally {
            this.destroyContext();
        }
        this.device.close();
        this.chosenFormat = null;
    }

    @Override
    public final boolean isAvailable() {
        return this.available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int dequeueBuffer(boolean bl, boolean bl2) {
        int n;
        int n2;
        if (this.alBufferBytesQueued > 0) {
            long l;
            int n3 = this.alFramesPlaying.size();
            n2 = Math.max(1, n3 / 4);
            long l2 = Math.round((double)n2 * 1000.0 * (double)this.avgFrameDuration);
            int n4 = 0;
            long l3 = 0L;
            int n5 = 0;
            boolean bl3 = true;
            long l4 = l = DEBUG ? Clock.currentNanos() : 0L;
            do {
                if (this.hasAL_SOFT_events) {
                    Object object = this.eventReleasedBuffersLock;
                    synchronized (object) {
                        while (bl && this.alBufferBytesQueued > 0 && this.eventReleasedBuffers < n2) {
                            ++n4;
                            try {
                                this.eventReleasedBuffersLock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        int n6 = this.eventReleasedBuffers;
                        int n7 = this.alSource.getBuffersProcessed();
                        n5 = Math.min(n6, n7);
                        this.eventReleasedBuffers = 0;
                        if (DEBUG) {
                            String string = n5 != n6 ? " ** Warning ** " : "";
                            System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink.Event.wait[" + n4 + "]: released buffer count [enqeueud " + n3 + ", event " + n6 + ", query " + n7 + "] -> " + n5 + string + ", limes " + n2 + ", slept " + (l3 += TimeUnit.NANOSECONDS.toMillis(Clock.currentNanos() - l)) + " ms, free total " + this.alFramesFree.size());
                        }
                    }
                } else {
                    n5 = this.alSource.getBuffersProcessed();
                    if (!bl || n5 >= n2) continue;
                    ++n4;
                    int n8 = Math.max(2, Math.min(300, Math.round((float)(n2 - n5) * 1000.0f * this.avgFrameDuration))) - 1;
                    if (l3 + (long)n8 + 1L <= l2) {
                        if (DEBUG) {
                            System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: Dequeue.wait-sleep[" + n4 + "].1:releaseBuffers " + n5 + "/" + n2 + ", sleep " + n8 + "/" + l3 + "/" + l2 + " ms, playImpl " + (4114 == this.getSourceState(false)) + ", " + this.shortString());
                        }
                        this.release(true);
                        try {
                            Thread.sleep(n8);
                            l3 += (long)n8;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            this.makeCurrent(true);
                        }
                    } else {
                        if (DEBUG && bl3) {
                            System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: Dequeue.wait-sleep[" + n4 + "].2:releaseBuffers " + n5 + "/" + n2 + ", sleep " + n8 + "->1/" + l3 + "/" + l2 + " ms, playImpl " + (4114 == this.getSourceState(false)) + ", " + this.shortString());
                            bl3 = false;
                        }
                        this.release(true);
                        try {
                            Thread.sleep(1L);
                            ++l3;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            this.makeCurrent(true);
                        }
                    }
                }
            } while (bl && this.alBufferBytesQueued > 0 && n5 < n2);
            n = n5;
            if (DEBUG) {
                long l5 = Clock.currentNanos();
                System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: Dequeue.wait-done[" + n4 + "]: " + TimeUnit.NANOSECONDS.toMillis(l5 - l) + "ms , releaseBuffers " + n + "/" + n2 + ", slept " + l3 + " ms, playImpl " + (4114 == this.getSourceState(false)) + ", " + this.shortString());
            }
        } else {
            n = 0;
        }
        if (n > 0) {
            int[] nArray = new int[n];
            this.alSource.unqueueBuffers(nArray);
            for (n2 = 0; n2 < n; ++n2) {
                ALAudioFrame aLAudioFrame = this.alFramesPlaying.get();
                if (null == aLAudioFrame) {
                    if (bl2) continue;
                    throw new InternalError("Internal Error: " + this);
                }
                if (DEBUG_TRACE) {
                    System.err.println("<  [al " + nArray[n2] + ", q " + aLAudioFrame.alBuffer + "] <- " + this.shortString() + " @ " + ALAudioSink.getThreadName());
                }
                if (aLAudioFrame.alBuffer != nArray[n2] && !bl2) {
                    this.alFramesFree.dump(System.err, "Avail-deq02-post");
                    this.alFramesPlaying.dump(System.err, "Playi-deq02-post");
                    throw new InternalError("Buffer name mismatch: dequeued: " + nArray[n2] + ", released " + aLAudioFrame + ", " + this);
                }
                this.alBufferBytesQueued -= aLAudioFrame.getByteSize();
                if (!this.alFramesFree.put(aLAudioFrame)) {
                    throw new InternalError("Internal Error: " + this);
                }
                if (!DEBUG_TRACE) continue;
                System.err.println("<< [al " + nArray[n2] + ", q " + aLAudioFrame.alBuffer + "] <- " + this.shortString() + " @ " + ALAudioSink.getThreadName());
            }
        }
        return n;
    }

    private final void dequeueForceAll() {
        if (DEBUG_TRACE) {
            System.err.println("<   _FLUSH_  <- " + this.shortString() + " @ " + ALAudioSink.getThreadName());
        }
        int n = 0;
        al.alSourcei(this.alSource.getID(), 4105, 0);
        if (DEBUG_TRACE) {
            n = this.alSource.getBuffersProcessed();
        }
        int n2 = al.alGetError();
        while (!this.alFramesPlaying.isEmpty()) {
            ALAudioFrame aLAudioFrame = this.alFramesPlaying.get();
            if (null == aLAudioFrame) {
                throw new InternalError("Internal Error: " + this);
            }
            this.alBufferBytesQueued -= aLAudioFrame.getByteSize();
            if (this.alFramesFree.put(aLAudioFrame)) continue;
            throw new InternalError("Internal Error: " + this);
        }
        this.alBufferBytesQueued = 0;
        if (DEBUG_TRACE) {
            System.err.println("<<  _FLUSH_  [al " + n + ", err " + ALAudioSink.toHexString(n2) + "] <- " + this.shortString() + " @ " + ALAudioSink.getThreadName());
            ExceptionUtils.dumpStack(System.err);
        }
    }

    private final int dequeueBuffer(boolean bl, int n, float f) {
        int n2 = this.dequeueBuffer(bl, false);
        ALAudioFrame aLAudioFrame = this.alFramesPlaying.peek();
        this.playingPTS = null != aLAudioFrame ? aLAudioFrame.getPTS() : n;
        if (DEBUG && n2 > 0) {
            System.err.printf("%s: ALAudioSink: Write pts %d ms, %.2f ms, dequeued %d, wait %b, %s%n", ALAudioSink.getThreadName(), n, Float.valueOf(1000.0f * f), n2, bl, this.getPerfString());
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AudioSink.AudioFrame enqueueData(int n, ByteBuffer byteBuffer, int n2) {
        ALAudioFrame aLAudioFrame;
        if (!this.available || null == this.chosenFormat) {
            return null;
        }
        this.makeCurrent(true);
        try {
            float f = this.chosenFormat.getBytesDuration(n2);
            if (this.alFramesFree.isEmpty()) {
                this.avgFrameDuration = this.chosenFormat.getBytesDuration(this.alBufferBytesQueued) / (float)this.alFramesPlaying.size();
                this.dequeueBuffer(false, n, f);
                if (this.alFramesFree.isEmpty()) {
                    this.growBuffers(n2);
                }
                if (this.alFramesFree.isEmpty() && this.alFramesPlaying.size() > 0 && this.isPlayingImpl()) {
                    this.dequeueBuffer(true, n, f);
                }
            }
            if (null == (aLAudioFrame = this.alFramesFree.get())) {
                this.alFramesFree.dump(System.err, "Avail");
                throw new InternalError("Internal Error: avail.get null " + this.alFramesFree + ", " + this);
            }
            aLAudioFrame.setPTS(n);
            aLAudioFrame.setDuration(Math.round(1000.0f * f));
            aLAudioFrame.setByteSize(n2);
            if (!this.alFramesPlaying.put(aLAudioFrame)) {
                throw new InternalError("Internal Error: " + this);
            }
            int[] nArray = new int[]{aLAudioFrame.alBuffer};
            if (this.hasSOFTBufferSamples) {
                int n3 = this.chosenFormat.getBytesSampleCount(n2) / this.chosenFormat.channelCount;
                alExt.alBufferSamplesSOFT(aLAudioFrame.alBuffer, this.chosenFormat.sampleRate, this.alFormat, n3, this.alChannelLayout, this.alSampleType, byteBuffer);
            } else {
                al.alBufferData(aLAudioFrame.alBuffer, this.alFormat, byteBuffer, n2, this.chosenFormat.sampleRate);
            }
            if (DEBUG_TRACE) {
                System.err.println(">  " + aLAudioFrame.alBuffer + " -> " + this.shortString() + " @ " + ALAudioSink.getThreadName());
            }
            this.alSource.queueBuffers(nArray);
            this.alBufferBytesQueued += n2;
            ++this.enqueuedFrameCount;
            if (DEBUG_TRACE) {
                System.err.println(">> " + aLAudioFrame.alBuffer + " -> " + this.shortString() + " @ " + ALAudioSink.getThreadName());
            }
            this.playImpl();
        }
        finally {
            this.release(true);
        }
        return aLAudioFrame;
    }

    @Override
    public final boolean isPlaying() {
        if (!this.available || null == this.chosenFormat) {
            return false;
        }
        if (this.playRequested) {
            this.makeCurrent(true);
            try {
                boolean bl = this.isPlayingImpl();
                return bl;
            }
            finally {
                this.release(true);
            }
        }
        return false;
    }

    private final boolean isPlayingImpl() {
        if (this.playRequested) {
            return 4114 == this.getSourceState(false);
        }
        return false;
    }

    private final int getSourceState(boolean bl) {
        if (!this.alSource.isValid()) {
            String string = ALAudioSink.getThreadName() + ": getSourceState: invalid " + this.alSource;
            if (bl) {
                if (DEBUG) {
                    System.err.println(string);
                }
                return 0;
            }
            throw new ALException(string);
        }
        int[] nArray = new int[]{0};
        al.alGetSourcei(this.alSource.getID(), 4112, nArray, 0);
        if (AudioSystem3D.checkALError("alGetSourcei", true, false)) {
            String string = ALAudioSink.getThreadName() + ": Error while querying SOURCE_STATE. " + this;
            if (bl) {
                if (DEBUG) {
                    System.err.println(string);
                }
                return 0;
            }
            throw new ALException(string);
        }
        return nArray[0];
    }

    @Override
    public final void play() {
        if (!this.available || null == this.chosenFormat) {
            return;
        }
        this.playRequested = true;
        this.makeCurrent(true);
        try {
            this.playImpl();
            if (DEBUG) {
                System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: PLAY playImpl " + (4114 == this.getSourceState(false)) + ", " + this);
            }
        }
        finally {
            this.release(true);
        }
    }

    private final void playImpl() {
        if (this.playRequested && 4114 != this.getSourceState(false)) {
            this.alSource.play();
            AudioSystem3D.checkALError("alSourcePlay", true, true);
        }
    }

    @Override
    public final void pause() {
        if (!this.available || null == this.chosenFormat) {
            return;
        }
        if (this.playRequested) {
            this.makeCurrent(true);
            try {
                this.pauseImpl();
                if (DEBUG) {
                    System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: PAUSE playImpl " + (4114 == this.getSourceState(false)) + ", " + this);
                }
            }
            finally {
                this.release(true);
            }
        }
    }

    private final void pauseImpl() {
        if (this.isPlayingImpl()) {
            this.playRequested = false;
            this.alSource.pause();
            AudioSystem3D.checkALError("alSourcePause", true, true);
        }
    }

    private final void stopImpl(boolean bl) {
        if (!this.alSource.isValid()) {
            return;
        }
        if (4116 != this.getSourceState(bl)) {
            this.playRequested = false;
            this.alSource.stop();
            if (AudioSystem3D.checkALError("alSourcePause", true, false)) {
                String string = "Error while stopping. " + this;
                if (bl) {
                    if (DEBUG) {
                        System.err.println(ALAudioSink.getThreadName() + ": " + string);
                    }
                } else {
                    throw new ALException(ALAudioSink.getThreadName() + ": Error while stopping. " + this);
                }
            }
        }
    }

    @Override
    public final float getPlaySpeed() {
        return this.playSpeed;
    }

    @Override
    public final boolean setPlaySpeed(float f) {
        if (!this.available || null == this.chosenFormat) {
            return false;
        }
        this.makeCurrent(true);
        try {
            if (Math.abs(1.0f - f) < 0.01f) {
                f = 1.0f;
            }
            if (0.5f <= f && f <= 2.0f) {
                this.playSpeed = f;
                this.alSource.setPitch(this.playSpeed);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.release(true);
        }
        return false;
    }

    @Override
    public final float getVolume() {
        return this.volume;
    }

    @Override
    public final boolean setVolume(float f) {
        if (!this.available || null == this.chosenFormat) {
            return false;
        }
        this.makeCurrent(true);
        try {
            if (Math.abs(f) < 0.01f) {
                f = 0.0f;
            } else if (Math.abs(1.0f - f) < 0.01f) {
                f = 1.0f;
            }
            if (0.0f <= f && f <= 1.0f) {
                this.volume = f;
                this.alSource.setGain(f);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.release(true);
        }
        return false;
    }

    @Override
    public final void flush() {
        if (!this.available || null == this.chosenFormat) {
            return;
        }
        this.makeCurrent(true);
        try {
            this.stopImpl(false);
            this.dequeueForceAll();
            if (this.alBufferNames.length != this.alFramesFree.size() || this.alFramesPlaying.size() != 0) {
                throw new InternalError("XXX: " + this);
            }
            if (DEBUG) {
                System.err.println(ALAudioSink.getThreadName() + ": ALAudioSink: FLUSH playImpl " + (4114 == this.getSourceState(false)) + ", " + this);
            }
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public final int getEnqueuedFrameCount() {
        return this.enqueuedFrameCount;
    }

    @Override
    public final int getFrameCount() {
        return null != this.alBufferNames ? this.alBufferNames.length : 0;
    }

    @Override
    public final int getQueuedFrameCount() {
        if (!this.available || null == this.chosenFormat) {
            return 0;
        }
        return this.alFramesPlaying.size();
    }

    @Override
    public final int getFreeFrameCount() {
        if (!this.available || null == this.chosenFormat) {
            return 0;
        }
        return this.alFramesFree.size();
    }

    @Override
    public final int getQueuedByteCount() {
        if (!this.available || null == this.chosenFormat) {
            return 0;
        }
        return this.alBufferBytesQueued;
    }

    @Override
    public final float getQueuedTime() {
        if (!this.available || null == this.chosenFormat) {
            return 0.0f;
        }
        return this.chosenFormat.getBytesDuration(this.alBufferBytesQueued);
    }

    @Override
    public float getAvgFrameDuration() {
        return this.avgFrameDuration;
    }

    @Override
    public final int getPTS() {
        return this.playingPTS;
    }

    private static final String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    private static final String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    private static final String getThreadName() {
        return Thread.currentThread().getName();
    }

    static {
        Debug.initSingleton();
        DEBUG_TRACE = PropertyAccess.isPropertyDefined("joal.debug.AudioSink.trace", true);
        alc = AudioSystem3D.getALC();
        al = AudioSystem3D.getAL();
        alExt = AudioSystem3D.getALExt();
        staticsInitialized = AudioSystem3D.isAvailable();
    }

    static class ALAudioFrame
    extends AudioSink.AudioFrame {
        private final int alBuffer;

        ALAudioFrame(int n) {
            this.alBuffer = n;
        }

        public ALAudioFrame(int n, int n2, int n3, int n4) {
            super(n2, n3, n4);
            this.alBuffer = n;
        }

        public final int getALBuffer() {
            return this.alBuffer;
        }

        @Override
        public String toString() {
            return "ALAudioFrame[pts " + this.pts + " ms, l " + this.duration + " ms, " + this.byteSize + " bytes, buffer " + this.alBuffer + "]";
        }
    }
}

