/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.Bitfield;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.VersionNumberString;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLDebugListener;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLContextShareSet;

public abstract class GLContext {
    public static final boolean DEBUG = Debug.debug("GLContext");
    public static final boolean TRACE_SWITCH = Debug.isPropertyDefined("jogl.debug.GLContext.TraceSwitch", true);
    public static final boolean DEBUG_TRACE_SWITCH = DEBUG || TRACE_SWITCH;
    public static final boolean PROFILE_ALIASING = !Debug.isPropertyDefined("jogl.debug.GLContext.NoProfileAliasing", true);
    public static final boolean DEBUG_GL = Debug.isPropertyDefined("jogl.debug.DebugGL", true);
    public static final boolean TRACE_GL = Debug.isPropertyDefined("jogl.debug.TraceGL", true);
    public static final int CONTEXT_NOT_CURRENT = 0;
    public static final int CONTEXT_CURRENT = 1;
    public static final int CONTEXT_CURRENT_NEW = 2;
    public static final VersionNumber Version1_0 = new VersionNumber(1, 0, 0);
    public static final VersionNumber Version1_10 = new VersionNumber(1, 10, 0);
    public static final VersionNumber Version1_20 = new VersionNumber(1, 20, 0);
    public static final VersionNumber Version1_30 = new VersionNumber(1, 30, 0);
    public static final VersionNumber Version1_40 = new VersionNumber(1, 40, 0);
    public static final VersionNumber Version1_50 = new VersionNumber(1, 50, 0);
    public static final VersionNumber Version1_1 = new VersionNumber(1, 1, 0);
    public static final VersionNumber Version1_2 = new VersionNumber(1, 2, 0);
    public static final VersionNumber Version1_4 = new VersionNumber(1, 4, 0);
    public static final VersionNumber Version1_5 = new VersionNumber(1, 5, 0);
    public static final VersionNumber Version3_0 = new VersionNumber(3, 0, 0);
    public static final VersionNumber Version3_1 = new VersionNumber(3, 1, 0);
    public static final VersionNumber Version3_2 = new VersionNumber(3, 2, 0);
    public static final VersionNumber Version4_3 = new VersionNumber(4, 3, 0);
    protected static final VersionNumber Version8_0 = new VersionNumber(8, 0, 0);
    private static final String S_EMPTY = "";
    protected static final int CTX_IMPL_FULL_MASK = 65535;
    protected static final int CTX_IMPL_CACHE_MASK = 1023;
    protected static final int CTX_IS_ARB_CREATED = 1;
    protected static final int CTX_PROFILE_COMPAT = 2;
    protected static final int CTX_PROFILE_CORE = 4;
    protected static final int CTX_PROFILE_ES = 8;
    protected static final int CTX_OPTION_FORWARD = 16;
    public static final int CTX_OPTION_DEBUG = 32;
    protected static final int CTX_IMPL_ACCEL_SOFT = 64;
    protected static final int CTX_IMPL_ES2_COMPAT = 1024;
    protected static final int CTX_IMPL_ES3_COMPAT = 2048;
    protected static final int CTX_IMPL_ES31_COMPAT = 4096;
    protected static final int CTX_IMPL_ES32_COMPAT = 8192;
    protected static final int CTX_IMPL_FBO = 16384;
    protected static final int CTX_IMPL_FP32_COMPAT_API = 32768;
    private static final ThreadLocal<GLContext> currentContext = new ThreadLocal();
    private final HashMap<String, Object> attachedObjects = new HashMap();
    protected final RecursiveLock lock = LockFactory.createRecursiveLock();
    protected volatile long contextHandle;
    protected VersionNumber ctxVersion;
    protected int ctxOptions;
    protected String ctxVersionString;
    protected VersionNumberString ctxVendorVersion;
    protected VersionNumber ctxGLSLVersion;
    protected GLRendererQuirks glRendererQuirks;
    protected boolean drawableRetargeted;
    protected int currentSwapGroup = -1;
    public static final int[][] GL_VERSIONS = new int[][]{{-1}, {0, 1, 2, 3, 4, 5}, {0, 1}, {0, 1, 2, 3}, {0, 1, 2, 3, 4, 5, 6}};
    public static final int[][] ES_VERSIONS = new int[][]{{-1}, {0, 1}, {0}, {0, 1, 2}};
    protected static final IdentityHashMap<String, Integer> deviceVersionAvailable = new IdentityHashMap();
    private static final IdentityHashMap<String, String> deviceVersionsAvailableSet = new IdentityHashMap();

    protected GLContext() {
        this.resetStates(true);
    }

    protected void resetStates(boolean bl) {
        if (DEBUG) {
            System.err.println(GLContext.getThreadName() + ": GLContext.resetStates(isInit " + bl + ")");
        }
        this.ctxVersion = VersionNumberString.zeroVersion;
        this.ctxVendorVersion = VersionNumberString.zeroVersion;
        this.ctxOptions = 0;
        this.ctxVersionString = null;
        this.ctxGLSLVersion = VersionNumber.zeroVersion;
        this.attachedObjects.clear();
        this.contextHandle = 0L;
        this.glRendererQuirks = null;
        this.drawableRetargeted = false;
    }

    public final boolean isShared() {
        return GLContextShareSet.isShared(this);
    }

    public final GLContext getSharedMaster() {
        return GLContextShareSet.getSharedMaster(this);
    }

    public final List<GLContext> getCreatedShares() {
        return GLContextShareSet.getCreatedShares(this);
    }

    public final List<GLContext> getDestroyedShares() {
        return GLContextShareSet.getDestroyedShares(this);
    }

    public final GLRendererQuirks getRendererQuirks() {
        return this.glRendererQuirks;
    }

    public final boolean hasRendererQuirk(int n) throws IllegalArgumentException {
        return null != this.glRendererQuirks ? this.glRendererQuirks.exist(n) : false;
    }

    public abstract GLDrawable setGLDrawable(GLDrawable var1, boolean var2);

    public abstract GLDrawable getGLDrawable();

    public abstract boolean isGLReadDrawableAvailable();

    public abstract GLDrawable setGLReadDrawable(GLDrawable var1);

    public abstract GLDrawable getGLReadDrawable();

    public abstract int makeCurrent() throws GLException;

    public abstract void release() throws GLException;

    public abstract void copy(GLContext var1, int var2) throws GLException;

    public static GL getCurrentGL() throws GLException {
        GLContext gLContext = GLContext.getCurrent();
        if (null == gLContext) {
            throw new GLException(GLContext.getThreadName() + ": No OpenGL context current on this thread");
        }
        return gLContext.getGL();
    }

    public static GLContext getCurrent() {
        return currentContext.get();
    }

    public final boolean isCurrent() {
        return GLContext.getCurrent() == this;
    }

    public final void validateCurrent() throws GLException {
        if (GLContext.getCurrent() != this) {
            throw new GLException(GLContext.getThreadName() + ": This context is not current. Current context: " + GLContext.getCurrent() + ", this context " + this);
        }
    }

    public static final String makeCurrentResultToString(int n) {
        switch (n) {
            case 0: {
                return "CONTEXT_NOT_CURRENT";
            }
            case 1: {
                return "CONTEXT_CURRENT";
            }
            case 2: {
                return "CONTEXT_CURRENT_NEW";
            }
        }
        return "INVALID_VALUE";
    }

    protected static void setCurrent(GLContext gLContext) {
        if (TRACE_SWITCH) {
            if (null == gLContext) {
                System.err.println(GLContext.getThreadName() + ": GLContext.ContextSwitch: - setCurrent() - NULL");
            } else {
                System.err.println(GLContext.getThreadName() + ": GLContext.ContextSwitch: - setCurrent() - obj " + GLContext.toHexString(gLContext.hashCode()) + ", ctx " + GLContext.toHexString(gLContext.getHandle()));
            }
        }
        currentContext.set(gLContext);
    }

    public abstract void destroy();

    public abstract GL getRootGL();

    public abstract GL getGL();

    public abstract GL setGL(GL var1);

    public final long getHandle() {
        return this.contextHandle;
    }

    public final boolean isCreated() {
        return 0L != this.contextHandle;
    }

    public final Object getAttachedObject(String string) {
        return this.attachedObjects.get(string);
    }

    public final Object attachObject(String string, Object object) {
        return this.attachedObjects.put(string, object);
    }

    public final Object detachObject(String string) {
        return this.attachedObjects.remove(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [");
        this.append(stringBuilder);
        stringBuilder.append("] ");
        return stringBuilder.toString();
    }

    public final StringBuilder append(StringBuilder stringBuilder) {
        stringBuilder.append("Version ").append(this.getGLVersion()).append(" [GL ").append(this.getGLVersionNumber()).append(", vendor ").append(this.getGLVendorVersionNumber());
        stringBuilder.append("], options 0x");
        stringBuilder.append(Integer.toHexString(this.ctxOptions));
        stringBuilder.append(", this ");
        stringBuilder.append(GLContext.toHexString(this.hashCode()));
        stringBuilder.append(", handle ");
        stringBuilder.append(GLContext.toHexString(this.contextHandle));
        stringBuilder.append(", isShared " + this.isShared() + ", ");
        stringBuilder.append(this.getGL());
        stringBuilder.append(",\n\t quirks: ");
        if (null != this.glRendererQuirks) {
            this.glRendererQuirks.toString(stringBuilder);
        } else {
            stringBuilder.append("n/a");
        }
        if (this.getGLDrawable() != this.getGLReadDrawable()) {
            stringBuilder.append(",\n\tRead Drawable : ");
            stringBuilder.append(this.getGLReadDrawable());
            stringBuilder.append(",\n\tWrite Drawable: ");
            stringBuilder.append(this.getGLDrawable());
        } else {
            stringBuilder.append(",\n\tDrawable: ");
            stringBuilder.append(this.getGLDrawable());
        }
        return stringBuilder;
    }

    public abstract boolean isFunctionAvailable(String var1);

    public abstract boolean isExtensionAvailable(String var1);

    public abstract int getPlatformExtensionCount();

    public abstract String getPlatformExtensionsString();

    public abstract int getGLExtensionCount();

    public abstract String getGLExtensionsString();

    public abstract int getContextCreationFlags();

    public abstract void setContextCreationFlags(int var1);

    public final String getGLVersion() {
        return this.ctxVersionString;
    }

    public final VersionNumber getGLVersionNumber() {
        return this.ctxVersion;
    }

    public final VersionNumberString getGLVendorVersionNumber() {
        return this.ctxVendorVersion;
    }

    public final boolean isGLCompatibilityProfile() {
        return 0 != (2 & this.ctxOptions);
    }

    public final boolean isGLCoreProfile() {
        return 0 != (4 & this.ctxOptions);
    }

    public final boolean isGLESProfile() {
        return 0 != (8 & this.ctxOptions);
    }

    public final boolean isGLForwardCompatible() {
        return 0 != (0x10 & this.ctxOptions);
    }

    public final boolean isGLDebugEnabled() {
        return 0 != (0x20 & this.ctxOptions);
    }

    public final boolean isCreatedWithARBMethod() {
        return 0 != (1 & this.ctxOptions);
    }

    public final VersionNumber getGLSLVersionNumber() {
        return this.ctxGLSLVersion;
    }

    public final String getGLSLVersionString() {
        String string;
        if (this.ctxGLSLVersion.isZero()) {
            return S_EMPTY;
        }
        int n = this.ctxGLSLVersion.getMinor();
        if (this.isGLES()) {
            string = this.ctxGLSLVersion.compareTo(Version3_0) >= 0 ? " es" : S_EMPTY;
        } else if (this.isGLCoreProfile()) {
            string = this.ctxGLSLVersion.compareTo(Version1_50) >= 0 ? " core" : S_EMPTY;
        } else if (this.isGLCompatibilityProfile()) {
            string = this.ctxGLSLVersion.compareTo(Version1_50) >= 0 ? " compatibility" : S_EMPTY;
        } else {
            throw new InternalError("Neither ES, Core nor Compat: " + this);
        }
        return "#version " + this.ctxGLSLVersion.getMajor() + (n < 10 ? "0" + n : Integer.valueOf(n)) + string + "\n";
    }

    protected static final VersionNumber getStaticGLSLVersionNumber(int n, int n2, int n3) {
        if (0 != (8 & n3)) {
            if (3 == n) {
                return Version3_0;
            }
            if (2 == n) {
                return Version1_0;
            }
        } else {
            if (1 == n) {
                return Version1_10;
            }
            if (2 == n) {
                switch (n2) {
                    case 0: {
                        return Version1_10;
                    }
                }
                return Version1_20;
            }
            if (3 == n && 2 >= n2) {
                switch (n2) {
                    case 0: {
                        return Version1_30;
                    }
                    case 1: {
                        return Version1_40;
                    }
                }
                return Version1_50;
            }
        }
        return new VersionNumber(n, n2 * 10, 0);
    }

    public final boolean isGLES2Compatible() {
        return 0 != (this.ctxOptions & 0xC00);
    }

    public final boolean isGLES3Compatible() {
        return 0 != (this.ctxOptions & 0x800);
    }

    public final boolean isGLES31Compatible() {
        return 0 != (this.ctxOptions & 0x1000);
    }

    public final boolean isGLES32Compatible() {
        return 0 != (this.ctxOptions & 0x2000);
    }

    public final boolean isHardwareRasterizer() {
        return 0 == (this.ctxOptions & 0x40);
    }

    public final boolean hasGLSL() {
        return this.isGLES3() || this.isGLES2() || this.isGL3() || this.isGL2() && this.ctxVersion.getMajor() > 1;
    }

    public final boolean hasBasicFBOSupport() {
        return 0 != (this.ctxOptions & 0x4000);
    }

    public final boolean hasFullFBOSupport() {
        return this.hasBasicFBOSupport() && !this.hasRendererQuirk(11) && (this.isGL3ES3() || this.isExtensionAvailable("GL_ARB_framebuffer_object") || this.isExtensionAvailable("GL_EXT_framebuffer_object") && this.isExtensionAvailable("GL_EXT_framebuffer_multisample") && this.isExtensionAvailable("GL_EXT_framebuffer_blit") && this.isExtensionAvailable("GL_EXT_packed_depth_stencil"));
    }

    public final boolean hasFP32CompatAPI() {
        return 0 != (this.ctxOptions & 0x8000);
    }

    public final int getMaxRenderbufferSamples() {
        if (this.hasFullFBOSupport()) {
            GL gL = this.getGL();
            int[] nArray = new int[]{0};
            try {
                gL.glGetIntegerv(36183, nArray, 0);
                int n = gL.glGetError();
                if (0 == n) {
                    return nArray[0];
                }
                if (DEBUG) {
                    System.err.println("GLContext.getMaxRenderbufferSamples: GL_MAX_SAMPLES query GL Error 0x" + Integer.toHexString(n));
                }
            }
            catch (GLException gLException) {
                gLException.printStackTrace();
            }
        }
        return 0;
    }

    public boolean isNPOTTextureAvailable() {
        return this.isGL3() || this.isGLES2Compatible() || this.isExtensionAvailable("GL_ARB_texture_non_power_of_two");
    }

    public boolean isTextureFormatBGRA8888Available() {
        return this.isGL2GL3() || this.isExtensionAvailable("GL_EXT_texture_format_BGRA8888") || this.isExtensionAvailable("GL_IMG_texture_format_BGRA8888");
    }

    public final boolean isGL4bc() {
        return 0 != (this.ctxOptions & 2) && this.ctxVersion.getMajor() >= 4;
    }

    public final boolean isGL4() {
        return 0 != (this.ctxOptions & 6) && this.ctxVersion.getMajor() >= 4;
    }

    public final boolean isGL4core() {
        return 0 != (this.ctxOptions & 4) && this.ctxVersion.getMajor() >= 4;
    }

    public final boolean isGL3bc() {
        return 0 != (this.ctxOptions & 2) && this.ctxVersion.compareTo(Version3_1) >= 0;
    }

    public final boolean isGL3() {
        return 0 != (this.ctxOptions & 6) && this.ctxVersion.compareTo(Version3_1) >= 0;
    }

    public final boolean isGL3core() {
        return 0 != (this.ctxOptions & 4) && this.ctxVersion.compareTo(Version3_1) >= 0;
    }

    public final boolean isGLcore() {
        return 0 != (this.ctxOptions & 8) && this.ctxVersion.getMajor() >= 2 || 0 != (this.ctxOptions & 4) && this.ctxVersion.compareTo(Version3_1) >= 0;
    }

    public final boolean isCPUDataSourcingAvail() {
        return this.isGL2ES1() || this.isGLES2();
    }

    public final boolean hasNoDefaultVAO() {
        return 0 != (this.ctxOptions & 1) && 0 != (this.ctxOptions & 4) && this.ctxVersion.compareTo(Version3_1) >= 0;
    }

    public abstract int getDefaultVAO();

    public final boolean isGL2() {
        return 0 != (this.ctxOptions & 2) && this.ctxVersion.getMajor() >= 1;
    }

    public final boolean isGL2GL3() {
        return this.isGL2() || this.isGL3();
    }

    public final boolean isGLES1() {
        return 0 != (this.ctxOptions & 8) && this.ctxVersion.getMajor() == 1;
    }

    public final boolean isGLES2() {
        if (0 != (this.ctxOptions & 8)) {
            int n = this.ctxVersion.getMajor();
            return 2 == n || 3 == n;
        }
        return false;
    }

    public final boolean isGLES3() {
        return 0 != (this.ctxOptions & 8) && this.ctxVersion.getMajor() == 3;
    }

    public final boolean isGLES() {
        return 0 != (8 & this.ctxOptions);
    }

    public final boolean isGL2ES1() {
        return this.isGLES1() || this.isGL2();
    }

    public final boolean isGL2ES2() {
        return this.isGLES2() || this.isGL2GL3();
    }

    public final boolean isGL2ES3() {
        return this.isGL3ES3() || this.isGL2GL3();
    }

    public final boolean isGL3ES3() {
        return this.isGL4ES3() || this.isGL3();
    }

    public final boolean isGL4ES3() {
        return this.isGLES3Compatible();
    }

    public boolean setSwapInterval(int n) throws GLException {
        throw new InternalError("Implemented in GLContextImpl");
    }

    protected boolean setSwapIntervalImpl(int n) {
        throw new InternalError("Implemented in GLContextImpl");
    }

    public int getSwapInterval() {
        throw new InternalError("Implemented in GLContextImpl");
    }

    protected void setDefaultSwapInterval() {
        throw new InternalError("Implemented in GLContextImpl");
    }

    public final boolean queryMaxSwapGroups(int[] nArray, int n, int[] nArray2, int n2) {
        this.validateCurrent();
        return this.queryMaxSwapGroupsImpl(nArray, n, nArray2, n2);
    }

    protected boolean queryMaxSwapGroupsImpl(int[] nArray, int n, int[] nArray2, int n2) {
        return false;
    }

    public final boolean joinSwapGroup(int n) {
        this.validateCurrent();
        return this.joinSwapGroupImpl(n);
    }

    protected boolean joinSwapGroupImpl(int n) {
        return false;
    }

    public int getSwapGroup() {
        return this.currentSwapGroup;
    }

    public final boolean bindSwapBarrier(int n, int n2) {
        this.validateCurrent();
        return this.bindSwapBarrierImpl(n, n2);
    }

    protected boolean bindSwapBarrierImpl(int n, int n2) {
        return false;
    }

    public abstract int getBoundFramebuffer(int var1);

    public abstract int getDefaultDrawFramebuffer();

    public abstract int getDefaultReadFramebuffer();

    public abstract int getDefaultDrawBuffer();

    public abstract int getDefaultReadBuffer();

    public abstract int getDefaultPixelDataType();

    public abstract int getDefaultPixelDataFormat();

    public abstract String getGLDebugMessageExtension();

    public abstract boolean isGLDebugSynchronous();

    public abstract void setGLDebugSynchronous(boolean var1);

    public abstract boolean isGLDebugMessageEnabled();

    public abstract void enableGLDebugMessage(boolean var1) throws GLException;

    public abstract void addGLDebugListener(GLDebugListener var1);

    public abstract void removeGLDebugListener(GLDebugListener var1);

    public abstract void glDebugMessageControl(int var1, int var2, int var3, int var4, IntBuffer var5, boolean var6);

    public abstract void glDebugMessageControl(int var1, int var2, int var3, int var4, int[] var5, int var6, boolean var7);

    public abstract void glDebugMessageInsert(int var1, int var2, int var3, int var4, String var5);

    public static final int getMaxMajor(int n) {
        return 0 != (8 & n) ? ES_VERSIONS.length - 1 : GL_VERSIONS.length - 1;
    }

    public static final int getMaxMinor(int n, int n2) {
        if (1 > n2) {
            return -1;
        }
        if (0 != (8 & n)) {
            if (n2 >= ES_VERSIONS.length) {
                return -1;
            }
            return ES_VERSIONS[n2].length - 1;
        }
        if (n2 >= GL_VERSIONS.length) {
            return -1;
        }
        return GL_VERSIONS[n2].length - 1;
    }

    public static final boolean isValidGLVersion(int n, int n2, int n3) {
        if (1 > n2 || 0 > n3) {
            return false;
        }
        if (1 < Bitfield.Util.bitCount(n & 0xE)) {
            return false;
        }
        return !(0 != (8 & n) ? n2 >= ES_VERSIONS.length + 1 : n2 >= GL_VERSIONS.length + 1);
    }

    public static final boolean clipGLVersion(int n, int[] nArray, int[] nArray2) {
        int n2 = nArray[0];
        int n3 = nArray2[0];
        if (0 != (8 & n)) {
            if (n2 >= ES_VERSIONS.length) {
                nArray[0] = ES_VERSIONS.length - 1;
                nArray2[0] = ES_VERSIONS[nArray[0]].length - 1;
                return true;
            }
            if (n3 >= ES_VERSIONS[n2].length) {
                nArray2[0] = ES_VERSIONS[n2].length - 1;
                return true;
            }
        } else {
            if (n2 >= GL_VERSIONS.length) {
                nArray[0] = GL_VERSIONS.length - 1;
                nArray2[0] = GL_VERSIONS[nArray[0]].length - 1;
                return true;
            }
            if (n3 >= GL_VERSIONS[n2].length) {
                nArray2[0] = GL_VERSIONS[n2].length - 1;
                return true;
            }
        }
        return false;
    }

    public static final boolean decrementGLVersion(int n, int[] nArray, int[] nArray2) {
        if (!GLContext.clipGLVersion(n, nArray, nArray2)) {
            int n2 = nArray[0];
            int n3 = nArray2[0] - 1;
            if (n3 < 0) {
                if (0 != (8 & n)) {
                    n2 = n2 >= 3 ? --n2 : 0;
                    n3 = ES_VERSIONS[n2].length - 1;
                } else {
                    n3 = GL_VERSIONS[--n2].length - 1;
                }
            }
            if (!GLContext.isValidGLVersion(n, n2, n3)) {
                return false;
            }
            nArray[0] = n2;
            nArray2[0] = n3;
        }
        return true;
    }

    protected static int composeBits(int n, int n2, int n3) {
        return (n & 0xFF) << 24 | (n2 & 0xFF) << 16 | n3 & 0xFFFF;
    }

    protected static VersionNumber decomposeBits(int n, int[] nArray) {
        int n2 = (n & 0xFF000000) >>> 24;
        int n3 = (n & 0xFF0000) >>> 16;
        nArray[0] = n & 0xFFFF;
        return new VersionNumber(n2, n3, 0);
    }

    protected static int getCTPFromBits(int n) {
        return n & 0xFFFF;
    }

    protected static void validateProfileBits(int n, String string) {
        int n2 = 0;
        if (0 != (2 & n)) {
            ++n2;
        }
        if (0 != (4 & n)) {
            ++n2;
        }
        if (0 != (8 & n)) {
            ++n2;
        }
        if (1 != n2) {
            throw new GLException("Internal Error: " + string + ": 1 != num-profiles: " + n2);
        }
    }

    protected static void shutdown() {
        deviceVersionAvailable.clear();
        deviceVersionsAvailableSet.clear();
        GLContextImpl.shutdownImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean getAvailableGLVersionsSet(AbstractGraphicsDevice abstractGraphicsDevice) {
        IdentityHashMap<String, String> identityHashMap = deviceVersionsAvailableSet;
        synchronized (identityHashMap) {
            return deviceVersionsAvailableSet.containsKey(abstractGraphicsDevice.getUniqueID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setAvailableGLVersionsSet(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) {
        IdentityHashMap<String, String> identityHashMap = deviceVersionsAvailableSet;
        synchronized (identityHashMap) {
            String string = abstractGraphicsDevice.getUniqueID();
            if (bl) {
                deviceVersionsAvailableSet.put(string, string);
            } else {
                deviceVersionsAvailableSet.remove(string);
            }
            if (DEBUG) {
                System.err.println(GLContext.getThreadName() + ": createContextARB-MapGLVersions SET " + string);
                System.err.println(GLContext.dumpAvailableGLVersions(null).toString());
            }
        }
    }

    protected static String getDeviceVersionAvailableKey(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2) {
        String string = abstractGraphicsDevice.getUniqueID() + "-" + GLContext.toHexString(GLContext.composeBits(n, n2, 0));
        return string.intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static StringBuilder dumpAvailableGLVersions(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        IdentityHashMap<String, Integer> identityHashMap = deviceVersionAvailable;
        synchronized (identityHashMap) {
            Set<String> set = deviceVersionAvailable.keySet();
            boolean bl = false;
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuilder.append(Platform.getNewline());
                }
                String string = iterator.next();
                stringBuilder.append("MapGLVersions ").append(string).append(": ");
                Integer n = deviceVersionAvailable.get(string);
                if (null != n) {
                    int[] nArray = new int[]{0};
                    VersionNumber versionNumber = GLContext.decomposeBits(n, nArray);
                    GLContext.getGLVersion(stringBuilder, versionNumber, nArray[0], null);
                } else {
                    stringBuilder.append("n/a");
                }
                bl = true;
            }
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Integer getAvailableGLVersion(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2) {
        Integer n3;
        String string = GLContext.getDeviceVersionAvailableKey(abstractGraphicsDevice, n, n2);
        IdentityHashMap<String, Integer> identityHashMap = deviceVersionAvailable;
        synchronized (identityHashMap) {
            n3 = deviceVersionAvailable.get(string);
        }
        return n3;
    }

    protected static boolean getAvailableGLVersion(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        Integer n3 = GLContext.getAvailableGLVersion(abstractGraphicsDevice, n, n2);
        if (null == n3) {
            return false;
        }
        int n4 = n3;
        if (null != nArray) {
            nArray[0] = (n4 & 0xFF000000) >>> 24;
        }
        if (null != nArray2) {
            nArray2[0] = (n4 & 0xFF0000) >>> 16;
        }
        if (null != nArray3) {
            nArray3[0] = n4 & 0xFFFF;
        }
        return true;
    }

    protected static String getGLProfile(int n, int n2, int n3) throws GLException {
        if (0 != (2 & n3)) {
            if (n >= 4) {
                return "GL4bc";
            }
            if (n == 3 && n2 >= 1) {
                return "GL3bc";
            }
            return "GL2";
        }
        if (0 != (4 & n3)) {
            if (n >= 4) {
                return "GL4";
            }
            if (n == 3 && n2 >= 1) {
                return "GL3";
            }
        } else if (0 != (8 & n3)) {
            if (n == 3) {
                return "GLES3";
            }
            if (n == 2) {
                return "GLES2";
            }
            if (n == 1) {
                return "GLES1";
            }
        }
        throw new GLException("Unhandled OpenGL version/profile: " + GLContext.getGLVersion(n, n2, n3, null));
    }

    protected static final void getRequestMajorAndCompat(GLProfile gLProfile, int[] nArray) {
        GLProfile gLProfile2 = gLProfile.getImpl();
        nArray[0] = gLProfile2.isGL4() ? 4 : (gLProfile2.isGL3() || gLProfile2.isGLES3() ? 3 : (gLProfile2.isGLES1() ? 1 : 2));
        nArray[1] = gLProfile2.isGLES() ? 8 : (gLProfile2.isGL2() ? 2 : 4);
    }

    protected static final int getAvailableContextProperties(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile) {
        int[] nArray = new int[]{0, 0};
        GLContext.getRequestMajorAndCompat(gLProfile, nArray);
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        if (GLContext.getAvailableGLVersion(abstractGraphicsDevice, nArray[0], nArray[1], nArray2, nArray3, nArray4)) {
            return nArray4[0];
        }
        return 0;
    }

    protected static GLProfile getAvailableGLProfile(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2) throws GLException {
        String string = GLContext.getAvailableGLProfileName(abstractGraphicsDevice, n, n2);
        return null != string ? GLProfile.get(abstractGraphicsDevice, string) : null;
    }

    static String getAvailableGLProfileName(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2) throws GLException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        if (GLContext.getAvailableGLVersion(abstractGraphicsDevice, n, n2, nArray, nArray2, nArray3)) {
            return GLContext.getGLProfile(nArray[0], nArray2[0], nArray3[0]);
        }
        return null;
    }

    protected static String getAvailableGLVersionAsString(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2) {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        if (GLContext.getAvailableGLVersion(abstractGraphicsDevice, n, n2, nArray, nArray2, nArray3)) {
            return GLContext.getGLVersion(nArray[0], nArray2[0], nArray3[0], null);
        }
        return null;
    }

    public static final boolean isFBOAvailable(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile) {
        return 0 != (0x4000 & GLContext.getAvailableContextProperties(abstractGraphicsDevice, gLProfile));
    }

    public static final int isHardwareRasterizer(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile) {
        int n = GLContext.getAvailableContextProperties(abstractGraphicsDevice, gLProfile);
        int n2 = 0 == n ? -1 : (0 == (0x40 & n) ? 1 : 0);
        return n2;
    }

    protected static boolean isGLVersionAvailable(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, boolean[] blArray) {
        Integer n3 = GLContext.getAvailableGLVersion(abstractGraphicsDevice, n, n2);
        if (null == n3) {
            return false;
        }
        blArray[0] = 0 == (n3 & 0x40);
        return true;
    }

    public static boolean isGLES1Available(AbstractGraphicsDevice abstractGraphicsDevice, boolean[] blArray) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 1, 8, blArray);
    }

    public static boolean isGLES2Available(AbstractGraphicsDevice abstractGraphicsDevice, boolean[] blArray) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 2, 8, blArray);
    }

    public static boolean isGLES3Available(AbstractGraphicsDevice abstractGraphicsDevice, boolean[] blArray) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 3, 8, blArray);
    }

    private static final int getGL3ctp(AbstractGraphicsDevice abstractGraphicsDevice) {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        boolean bl = GLContext.getAvailableGLVersion(abstractGraphicsDevice, 3, 8, nArray, nArray2, nArray3);
        if (!bl) {
            bl = GLContext.getAvailableGLVersion(abstractGraphicsDevice, 3, 4, nArray, nArray2, nArray3);
        }
        if (!bl) {
            GLContext.getAvailableGLVersion(abstractGraphicsDevice, 3, 2, nArray, nArray2, nArray3);
        }
        return nArray3[0];
    }

    public static final boolean isGLES3CompatibleAvailable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return 0 != (GLContext.getGL3ctp(abstractGraphicsDevice) & 0x800);
    }

    public static final boolean isGLES31CompatibleAvailable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return 0 != (GLContext.getGL3ctp(abstractGraphicsDevice) & 0x1000);
    }

    public static final boolean isGLES32CompatibleAvailable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return 0 != (GLContext.getGL3ctp(abstractGraphicsDevice) & 0x2000);
    }

    public static boolean isGL4bcAvailable(AbstractGraphicsDevice abstractGraphicsDevice, boolean[] blArray) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 4, 2, blArray);
    }

    public static boolean isGL4Available(AbstractGraphicsDevice abstractGraphicsDevice, boolean[] blArray) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 4, 4, blArray);
    }

    public static boolean isGL3bcAvailable(AbstractGraphicsDevice abstractGraphicsDevice, boolean[] blArray) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 3, 2, blArray);
    }

    public static boolean isGL3Available(AbstractGraphicsDevice abstractGraphicsDevice, boolean[] blArray) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 3, 4, blArray);
    }

    public static boolean isGL2Available(AbstractGraphicsDevice abstractGraphicsDevice, boolean[] blArray) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 2, 2, blArray);
    }

    protected static StringBuilder getGLProfile(StringBuilder stringBuilder, int n) {
        boolean bl = false;
        bl = GLContext.appendString(stringBuilder, "ES profile", bl, 0 != (8 & n));
        bl = GLContext.appendString(stringBuilder, "Compat profile", bl, 0 != (2 & n));
        bl = GLContext.appendString(stringBuilder, "Core profile", bl, 0 != (4 & n));
        bl = GLContext.appendString(stringBuilder, "forward", bl, 0 != (0x10 & n));
        bl = GLContext.appendString(stringBuilder, "arb", bl, 0 != (1 & n));
        bl = GLContext.appendString(stringBuilder, "debug", bl, 0 != (0x20 & n));
        bl = GLContext.appendString(stringBuilder, "compat[", bl, true);
        bl = false;
        bl = GLContext.appendString(stringBuilder, "ES2", bl, 0 != (0x400 & n));
        bl = GLContext.appendString(stringBuilder, "ES3", bl, 0 != (0x800 & n));
        bl = GLContext.appendString(stringBuilder, "ES31", bl, 0 != (0x1000 & n));
        bl = GLContext.appendString(stringBuilder, "ES32", bl, 0 != (0x2000 & n));
        bl = GLContext.appendString(stringBuilder, "FP32", bl, 0 != (0x8000 & n));
        bl = false;
        bl = GLContext.appendString(stringBuilder, "]", bl, true);
        bl = GLContext.appendString(stringBuilder, "FBO", bl, 0 != (0x4000 & n));
        bl = 0 != (0x40 & n) ? GLContext.appendString(stringBuilder, "software", bl, true) : GLContext.appendString(stringBuilder, "hardware", bl, true);
        return stringBuilder;
    }

    protected static StringBuilder getGLVersion(StringBuilder stringBuilder, VersionNumber versionNumber, int n, String string) {
        return GLContext.getGLVersion(stringBuilder, versionNumber.getMajor(), versionNumber.getMinor(), n, string);
    }

    protected static StringBuilder getGLVersion(StringBuilder stringBuilder, int n, int n2, int n3, String string) {
        stringBuilder.append(n);
        stringBuilder.append(".");
        stringBuilder.append(n2);
        stringBuilder.append(" (");
        GLContext.getGLProfile(stringBuilder, n3);
        stringBuilder.append(")");
        if (null != string) {
            stringBuilder.append(" - ");
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    protected static String getGLVersion(int n, int n2, int n3, String string) {
        return GLContext.getGLVersion(new StringBuilder(), n, n2, n3, string).toString();
    }

    protected static String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    protected static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    private static boolean appendString(StringBuilder stringBuilder, String string, boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            bl = true;
        }
        return bl;
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }
}

