/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;

public class GLPixelBuffer {
    public static final GLPixelBufferProvider defaultProviderNoRowStride = new DefaultGLPixelBufferProvider(false);
    public static final GLPixelBufferProvider defaultProviderWithRowStride = new DefaultGLPixelBufferProvider(true);
    public final GLPixelAttributes pixelAttributes;
    public final int width;
    public final int height;
    public final int depth;
    public final boolean pack;
    public final int byteSize;
    public final Buffer buffer;
    public final int bufferElemSize;
    public final boolean allowRowStride;
    private boolean disposed = false;

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(this.pixelAttributes).append(", dim ").append(this.width).append("x").append(this.height).append("x").append(this.depth).append(", pack ").append(this.pack).append(", disposed ").append(this.disposed).append(", valid ").append(this.isValid()).append(", buffer[bytes ").append(this.byteSize).append(", elemSize ").append(this.bufferElemSize).append(", ").append(this.buffer).append("]");
        return stringBuilder;
    }

    public String toString() {
        return "GLPixelBuffer[" + this.toString(null).toString() + "]";
    }

    public GLPixelBuffer(GLPixelAttributes gLPixelAttributes, boolean bl, int n, int n2, int n3, Buffer buffer, boolean bl2) {
        this.pixelAttributes = gLPixelAttributes;
        this.width = n;
        this.height = n2;
        this.depth = n3;
        this.pack = bl;
        this.buffer = buffer;
        this.byteSize = Buffers.remainingBytes(buffer);
        this.bufferElemSize = Buffers.sizeOfBufferElem(buffer);
        this.allowRowStride = bl2;
    }

    public final boolean getAllowRowStride() {
        return this.allowRowStride;
    }

    public boolean isValid() {
        return !this.disposed && 0 < this.byteSize;
    }

    public Buffer rewind() {
        return this.buffer.rewind();
    }

    public int position() {
        return this.buffer.position() * this.bufferElemSize;
    }

    public Buffer position(int n) {
        return this.buffer.position(n / this.bufferElemSize);
    }

    public int capacity() {
        return this.buffer.capacity() * this.bufferElemSize;
    }

    public int limit() {
        return this.buffer.limit() * this.bufferElemSize;
    }

    public Buffer flip() {
        return this.buffer.flip();
    }

    public Buffer clear() {
        return this.buffer.clear();
    }

    public boolean requiresNewBuffer(GL gL, int n, int n2, int n3) {
        if (!this.isValid()) {
            return true;
        }
        if (0 >= n3) {
            int[] nArray = new int[]{0};
            n3 = GLBuffers.sizeof(gL, nArray, this.pixelAttributes.pfmt.comp.bytesPerPixel(), n, n2, 1, true);
        }
        if (this.allowRowStride) {
            return this.byteSize < n3;
        }
        return this.byteSize < n3 || this.width != n;
    }

    public void dispose() {
        this.disposed = true;
        this.buffer.clear();
    }

    public static class GLPixelAttributes {
        public static final GLPixelAttributes UNDEF = new GLPixelAttributes(null, PixelFormat.LUMINANCE, 0, 0, true, false);
        public final int format;
        public final int type;
        public final PixelFormat pfmt;

        public static final PixelFormat getPixelFormat(int n, int n2) {
            PixelFormat pixelFormat = null;
            block0 : switch (n) {
                case 6403: 
                case 6406: 
                case 6409: {
                    pixelFormat = PixelFormat.LUMINANCE;
                    break;
                }
                case 6407: {
                    switch (n2) {
                        case 33636: {
                            pixelFormat = PixelFormat.RGB565;
                            break;
                        }
                        case 33635: {
                            pixelFormat = PixelFormat.BGR565;
                            break;
                        }
                        case 5121: {
                            pixelFormat = PixelFormat.RGB888;
                        }
                    }
                    break;
                }
                case 6408: {
                    switch (n2) {
                        case 33638: {
                            pixelFormat = PixelFormat.RGBA5551;
                            break;
                        }
                        case 32820: {
                            pixelFormat = PixelFormat.ABGR1555;
                            break;
                        }
                        case 5121: 
                        case 33639: {
                            pixelFormat = PixelFormat.RGBA8888;
                            break;
                        }
                        case 32821: {
                            pixelFormat = PixelFormat.ABGR8888;
                        }
                    }
                    break;
                }
                case 32992: {
                    if (5121 != n2) break;
                    pixelFormat = PixelFormat.BGR888;
                    break;
                }
                case 32993: {
                    switch (n2) {
                        case 32821: {
                            pixelFormat = PixelFormat.ARGB8888;
                            break block0;
                        }
                        case 5121: 
                        case 33639: {
                            pixelFormat = PixelFormat.BGRA8888;
                        }
                    }
                }
            }
            return pixelFormat;
        }

        public static GLPixelAttributes convert(GL gL, int n, boolean bl) {
            int n2;
            int n3;
            boolean bl2;
            boolean bl3 = bl2 = bl && gL.isGLES();
            if (1 == n && !bl2) {
                n3 = gL.isGL3ES3() ? 6403 : 6406;
                n2 = 5121;
            } else if (3 == n && !bl2) {
                n3 = 6407;
                n2 = 5121;
            } else if (4 == n || bl2) {
                GLContext gLContext = gL.getContext();
                int n4 = gLContext.getDefaultPixelDataFormat();
                int n5 = GLBuffers.componentCount(n4);
                if (n5 == n || 4 == n5) {
                    int n6 = gLContext.getDefaultPixelDataType();
                    PixelFormat pixelFormat = GLPixelAttributes.getPixelFormat(n4, n6);
                    if (null != pixelFormat) {
                        return new GLPixelAttributes(null, pixelFormat, n4, n6, bl, true);
                    }
                    if (GLContext.DEBUG) {
                        System.err.println("GLPixelAttributes.convert(" + gL.getGLProfile() + ", comps " + n + ", pack " + bl + "): GL-impl default unsupported: [fmt 0x" + Integer.toHexString(n4) + ", type 0x" + Integer.toHexString(n6) + "]: Using std RGBA+UBYTE");
                        Thread.dumpStack();
                    }
                }
                n3 = 6408;
                n2 = 5121;
            } else {
                return null;
            }
            return new GLPixelAttributes(n3, n2);
        }

        public static final GLPixelAttributes convert(GLProfile gLProfile, PixelFormat pixelFormat, boolean bl) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            GLPixelAttributes.convert(gLProfile, pixelFormat, bl, nArray, nArray2);
            if (0 != nArray[0]) {
                return new GLPixelAttributes(null, pixelFormat, nArray[0], nArray2[0], true, true);
            }
            return null;
        }

        private static final int convert(GLProfile gLProfile, PixelFormat pixelFormat, boolean bl, int[] nArray, int[] nArray2) {
            boolean bl2 = bl && gLProfile.isGLES();
            int n = 0;
            int n2 = 5121;
            switch (pixelFormat) {
                case LUMINANCE: {
                    if (bl2) break;
                    if (gLProfile.isGL3ES3()) {
                        n = 6403;
                        break;
                    }
                    n = 6409;
                    break;
                }
                case RGB565: {
                    if (!gLProfile.isGL2GL3()) break;
                    n = 6407;
                    n2 = 33636;
                    break;
                }
                case BGR565: {
                    if (!gLProfile.isGL2GL3()) break;
                    n = 6407;
                    n2 = 33635;
                    break;
                }
                case RGBA5551: {
                    if (!gLProfile.isGL2GL3()) break;
                    n = 6408;
                    n2 = 33638;
                    break;
                }
                case ABGR1555: {
                    if (!gLProfile.isGL2GL3()) break;
                    n = 6408;
                    n2 = 32820;
                    break;
                }
                case RGB888: {
                    if (bl2) break;
                    n = 6407;
                    break;
                }
                case BGR888: {
                    if (!gLProfile.isGL2GL3()) break;
                    n = 32992;
                    break;
                }
                case RGBx8888: 
                case RGBA8888: {
                    n = 6408;
                    break;
                }
                case ABGR8888: {
                    if (!gLProfile.isGL2GL3()) break;
                    n = 6408;
                    n2 = 32821;
                    break;
                }
                case ARGB8888: {
                    if (!gLProfile.isGL2GL3()) break;
                    n = 32993;
                    n2 = 32821;
                    break;
                }
                case BGRx8888: 
                case BGRA8888: {
                    if (!gLProfile.isGL2GL3()) break;
                    n = 32993;
                }
            }
            nArray[0] = n;
            nArray2[0] = n2;
            return n;
        }

        public final int hashCode() {
            int n = this.pfmt.hashCode();
            n = (n << 5) - n + this.format;
            return (n << 5) - n + this.type;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof GLPixelAttributes) {
                GLPixelAttributes gLPixelAttributes = (GLPixelAttributes)object;
                return this.format == gLPixelAttributes.format && this.type == gLPixelAttributes.type && this.pfmt.equals((Object)gLPixelAttributes.pfmt);
            }
            return false;
        }

        public GLPixelAttributes(int n, int n2) throws GLException {
            this(null, null, n, n2, true, true);
        }

        public GLPixelAttributes(GLProfile gLProfile, PixelFormat pixelFormat, boolean bl) throws GLException {
            this(gLProfile, pixelFormat, 0, 0, bl, true);
        }

        private GLPixelAttributes(GLProfile gLProfile, PixelFormat pixelFormat, int n, int n2, boolean bl, boolean bl2) throws GLException {
            int n3;
            if (bl2 && (0 == n || 0 == n2)) {
                if (null == pixelFormat || null == gLProfile) {
                    throw new GLException("Zero format and/or type w/o pixFmt or glp: " + this);
                }
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                if (0 == GLPixelAttributes.convert(gLProfile, pixelFormat, bl, nArray, nArray2)) {
                    throw new GLException("Could not find format and type for " + (Object)((Object)pixelFormat) + " and " + gLProfile + ", " + this);
                }
                this.format = nArray[0];
                this.type = nArray2[0];
                this.pfmt = pixelFormat;
            } else {
                this.format = n;
                this.type = n2;
                PixelFormat pixelFormat2 = this.pfmt = null != pixelFormat ? pixelFormat : GLPixelAttributes.getPixelFormat(n, n2);
                if (null == this.pfmt) {
                    throw new GLException("Could not find PixelFormat for format and/or type: " + this);
                }
            }
            if (bl2 && 0 == (n3 = GLBuffers.bytesPerPixel(this.format, this.type))) {
                throw new GLException("Zero bytesPerPixel: " + this);
            }
        }

        public String toString() {
            return "PixelAttributes[fmt 0x" + Integer.toHexString(this.format) + ", type 0x" + Integer.toHexString(this.type) + ", " + (Object)((Object)this.pfmt) + "]";
        }
    }

    public static class DefaultGLPixelBufferProvider
    implements GLPixelBufferProvider {
        private final boolean allowRowStride;

        public DefaultGLPixelBufferProvider(boolean bl) {
            this.allowRowStride = bl;
        }

        @Override
        public boolean getAllowRowStride() {
            return this.allowRowStride;
        }

        @Override
        public GLPixelAttributes getAttributes(GL gL, int n, boolean bl) {
            GLPixelAttributes gLPixelAttributes = GLPixelAttributes.convert(gL, n, bl);
            if (null == gLPixelAttributes) {
                throw new GLException("Unsupported componentCount " + n + ", contact maintainer to enhance");
            }
            return gLPixelAttributes;
        }

        @Override
        public PixelFormat.Composition getHostPixelComp(GLProfile gLProfile, int n) {
            return null;
        }

        @Override
        public GLPixelBuffer allocate(GL gL, PixelFormat.Composition composition, GLPixelAttributes gLPixelAttributes, boolean bl, int n, int n2, int n3, int n4) {
            if (n4 > 0) {
                return new GLPixelBuffer(gLPixelAttributes, bl, n, n2, n3, Buffers.newDirectByteBuffer(n4), this.getAllowRowStride());
            }
            int[] nArray = new int[]{0};
            int n5 = GLBuffers.sizeof(gL, nArray, gLPixelAttributes.pfmt.comp.bytesPerPixel(), n, n2, n3, bl);
            return new GLPixelBuffer(gLPixelAttributes, bl, n, n2, n3, Buffers.newDirectByteBuffer(n5), this.getAllowRowStride());
        }
    }

    public static interface GLPixelBufferProvider {
        public boolean getAllowRowStride();

        public GLPixelAttributes getAttributes(GL var1, int var2, boolean var3);

        public PixelFormat.Composition getHostPixelComp(GLProfile var1, int var2);

        public GLPixelBuffer allocate(GL var1, PixelFormat.Composition var2, GLPixelAttributes var3, boolean var4, int var5, int var6, int var7, int var8);
    }

    public static interface SingletonGLPixelBufferProvider
    extends GLPixelBufferProvider {
        @Override
        public GLPixelBuffer allocate(GL var1, PixelFormat.Composition var2, GLPixelAttributes var3, boolean var4, int var5, int var6, int var7, int var8);

        public GLPixelBuffer getSingleBuffer(PixelFormat.Composition var1, GLPixelAttributes var2, boolean var3);

        public GLPixelBuffer initSingleton(GLProfile var1, int var2, boolean var3, int var4, int var5, int var6);

        public void dispose();
    }
}

