/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES1;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import jogamp.opengl.Debug;

public class ImmModeSink {
    protected static final boolean DEBUG_BEGIN_END;
    protected static final boolean DEBUG_DRAW;
    protected static final boolean DEBUG_BUFFER;
    public static final int GL_QUADS = 7;
    public static final int GL_QUAD_STRIP = 8;
    public static final int GL_POLYGON = 9;
    private VBOSet vboSet;
    private final ArrayList<VBOSet> vboSetList;

    public static ImmModeSink createFixed(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return new ImmModeSink(n, n2, n3, n4, n5, n6, n7, n8, n9, false, n10, null, 0);
    }

    public static ImmModeSink createGLSL(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, ShaderState shaderState) {
        return new ImmModeSink(n, n2, n3, n4, n5, n6, n7, n8, n9, true, n10, shaderState, 0);
    }

    public static ImmModeSink createGLSL(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        return new ImmModeSink(n, n2, n3, n4, n5, n6, n7, n8, n9, true, n10, null, n11);
    }

    public void destroy(GL gL) {
        this.destroyList(gL);
        this.vboSet.destroy(gL);
    }

    public void reset() {
        this.reset(null);
    }

    public void reset(GL gL) {
        this.destroyList(gL);
        this.vboSet.reset(gL);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ImmModeSink[");
        stringBuilder.append(",\n\tVBO list: " + this.vboSetList.size() + " [");
        Iterator<VBOSet> iterator = this.vboSetList.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append("\n\t");
            stringBuilder.append(iterator.next());
        }
        if (this.vboSetList.size() > 0) {
            stringBuilder.append("\n\t],\nVBO current: NOP]");
        } else {
            stringBuilder.append("\n\t],\nVBO current: \n");
            stringBuilder.append(this.vboSet);
            stringBuilder.append("\n]");
        }
        return stringBuilder.toString();
    }

    public void draw(GL gL, boolean bl) {
        if (DEBUG_DRAW) {
            System.err.println("ImmModeSink.draw(disableBufferAfterDraw: " + bl + "):\n\t" + this);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.vboSetList.size()) {
            this.vboSetList.get(n2).draw(gL, null, bl, n);
            ++n2;
            ++n;
        }
    }

    public void draw(GL gL, Buffer buffer, boolean bl) {
        if (DEBUG_DRAW) {
            System.err.println("ImmModeSink.draw(disableBufferAfterDraw: " + bl + "):\n\t" + this);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.vboSetList.size()) {
            this.vboSetList.get(n2).draw(gL, buffer, bl, n);
            ++n2;
            ++n;
        }
    }

    public void glBegin(int n) {
        this.vboSet.modeOrig = n;
        switch (n) {
            case 8: {
                n = 5;
                break;
            }
            case 9: {
                n = 6;
            }
        }
        this.vboSet.mode = n;
        if (DEBUG_BEGIN_END) {
            System.err.println("ImmModeSink.glBegin(" + this.vboSet.modeOrig + " -> " + this.vboSet.mode + ")");
        }
        this.vboSet.checkSeal(false);
    }

    public final void glEnd(GL gL) {
        this.glEnd(gL, null, true);
    }

    public void glEnd(GL gL, boolean bl) {
        this.glEnd(gL, null, bl);
    }

    public final void glEnd(GL gL, Buffer buffer) {
        this.glEnd(gL, buffer, true);
    }

    private void glEnd(GL gL, Buffer buffer, boolean bl) {
        if (DEBUG_BEGIN_END) {
            System.err.println("ImmModeSink START glEnd(immediate: " + bl + ")");
        }
        if (bl) {
            this.vboSet.seal(gL, true);
            this.vboSet.draw(gL, buffer, true, -1);
            this.reset(gL);
        } else {
            this.vboSet.seal(gL, true);
            this.vboSet.enableBuffer(gL, false);
            this.vboSetList.add(this.vboSet);
            this.vboSet = this.vboSet.regenerate(gL);
        }
        if (DEBUG_BEGIN_END) {
            System.err.println("ImmModeSink END glEnd(immediate: " + bl + ")");
        }
    }

    public void glVertexv(Buffer buffer) {
        this.vboSet.glVertexv(buffer);
    }

    public void glNormalv(Buffer buffer) {
        this.vboSet.glNormalv(buffer);
    }

    public void glColorv(Buffer buffer) {
        this.vboSet.glColorv(buffer);
    }

    public void glTexCoordv(Buffer buffer) {
        this.vboSet.glTexCoordv(buffer);
    }

    public final void glVertex2f(float f, float f2) {
        this.vboSet.glVertex2f(f, f2);
    }

    public final void glVertex3f(float f, float f2, float f3) {
        this.vboSet.glVertex3f(f, f2, f3);
    }

    public final void glNormal3f(float f, float f2, float f3) {
        this.vboSet.glNormal3f(f, f2, f3);
    }

    public final void glColor3f(float f, float f2, float f3) {
        this.vboSet.glColor3f(f, f2, f3);
    }

    public final void glColor4f(float f, float f2, float f3, float f4) {
        this.vboSet.glColor4f(f, f2, f3, f4);
    }

    public final void glTexCoord2f(float f, float f2) {
        this.vboSet.glTexCoord2f(f, f2);
    }

    public final void glTexCoord3f(float f, float f2, float f3) {
        this.vboSet.glTexCoord3f(f, f2, f3);
    }

    public final void glVertex2s(short s, short s2) {
        this.vboSet.glVertex2s(s, s2);
    }

    public final void glVertex3s(short s, short s2, short s3) {
        this.vboSet.glVertex3s(s, s2, s3);
    }

    public final void glNormal3s(short s, short s2, short s3) {
        this.vboSet.glNormal3s(s, s2, s3);
    }

    public final void glColor3s(short s, short s2, short s3) {
        this.vboSet.glColor3s(s, s2, s3);
    }

    public final void glColor4s(short s, short s2, short s3, short s4) {
        this.vboSet.glColor4s(s, s2, s3, s4);
    }

    public final void glTexCoord2s(short s, short s2) {
        this.vboSet.glTexCoord2s(s, s2);
    }

    public final void glTexCoord3s(short s, short s2, short s3) {
        this.vboSet.glTexCoord3s(s, s2, s3);
    }

    public final void glVertex2b(byte by, byte by2) {
        this.vboSet.glVertex2b(by, by2);
    }

    public final void glVertex3b(byte by, byte by2, byte by3) {
        this.vboSet.glVertex3b(by, by2, by3);
    }

    public final void glNormal3b(byte by, byte by2, byte by3) {
        this.vboSet.glNormal3b(by, by2, by3);
    }

    public final void glColor3b(byte by, byte by2, byte by3) {
        this.vboSet.glColor3b(by, by2, by3);
    }

    public final void glColor3ub(byte by, byte by2, byte by3) {
        this.vboSet.glColor3ub(by, by2, by3);
    }

    public final void glColor4b(byte by, byte by2, byte by3, byte by4) {
        this.vboSet.glColor4b(by, by2, by3, by4);
    }

    public final void glColor4ub(byte by, byte by2, byte by3, byte by4) {
        this.vboSet.glColor4ub(by, by2, by3, by4);
    }

    public final void glTexCoord2b(byte by, byte by2) {
        this.vboSet.glTexCoord2b(by, by2);
    }

    public final void glTexCoord3b(byte by, byte by2, byte by3) {
        this.vboSet.glTexCoord3b(by, by2, by3);
    }

    protected ImmModeSink(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, int n10, ShaderState shaderState, int n11) {
        this.vboSet = new VBOSet(n, n2, n3, n4, n5, n6, n7, n8, n9, bl, n10, shaderState, n11);
        this.vboSetList = new ArrayList();
    }

    public boolean getUseVBO() {
        return this.vboSet.getUseVBO();
    }

    public int getResizeElementCount() {
        return this.vboSet.getResizeElementCount();
    }

    public void setResizeElementCount(int n) {
        this.vboSet.setResizeElementCount(n);
    }

    private void destroyList(GL gL) {
        for (int i = 0; i < this.vboSetList.size(); ++i) {
            this.vboSetList.get(i).destroy(gL);
        }
        this.vboSetList.clear();
    }

    static {
        Debug.initSingleton();
        DEBUG_BEGIN_END = PropertyAccess.isPropertyDefined("jogl.debug.ImmModeSink.BeginEnd", true);
        DEBUG_DRAW = PropertyAccess.isPropertyDefined("jogl.debug.ImmModeSink.Draw", true);
        DEBUG_BUFFER = PropertyAccess.isPropertyDefined("jogl.debug.ImmModeSink.Buffer", true);
    }

    protected static class VBOSet {
        private boolean usingShaderProgram = false;
        private final int glBufferUsage;
        private final int initialElementCount;
        private final boolean useVBO;
        private final boolean useGLSL;
        private final ShaderState shaderState;
        private int shaderProgram;
        private int mode;
        private int modeOrig;
        private int resizeElementCount;
        private ByteBuffer buffer;
        private int vboName;
        private static final int VERTEX = 0;
        private static final int COLOR = 1;
        private static final int NORMAL = 2;
        private static final int TEXTCOORD = 3;
        private int vCount;
        private int cCount;
        private int nCount;
        private int tCount;
        private int vOffset;
        private int cOffset;
        private int nOffset;
        private int tOffset;
        private int vElems;
        private int cElems;
        private int nElems;
        private int tElems;
        private final int vComps;
        private final int cComps;
        private final int nComps;
        private final int tComps;
        private final int vCompsBytes;
        private final int cCompsBytes;
        private final int nCompsBytes;
        private final int tCompsBytes;
        private final int vDataType;
        private final int cDataType;
        private final int nDataType;
        private final int tDataType;
        private final boolean vDataTypeSigned;
        private final boolean cDataTypeSigned;
        private final boolean nDataTypeSigned;
        private final boolean tDataTypeSigned;
        private final int pageSize;
        private Buffer vertexArray;
        private Buffer colorArray;
        private Buffer normalArray;
        private Buffer textCoordArray;
        private GLArrayDataWrapper vArrayData;
        private GLArrayDataWrapper cArrayData;
        private GLArrayDataWrapper nArrayData;
        private GLArrayDataWrapper tArrayData;
        private boolean sealed;
        private boolean sealedGL;
        private boolean bufferEnabled;
        private boolean bufferWritten;
        private boolean bufferWrittenOnce;
        private boolean glslLocationSet;

        protected VBOSet(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, int n10, ShaderState shaderState, int n11) {
            this.glBufferUsage = n10;
            this.initialElementCount = n;
            this.useVBO = 0 != n10;
            this.useGLSL = bl;
            this.shaderState = shaderState;
            this.shaderProgram = n11;
            if (bl && null == this.shaderState && 0 == n11) {
                throw new IllegalArgumentException("Using GLSL but neither a valid shader-program nor ShaderState has been passed!");
            }
            this.resizeElementCount = n;
            this.vDataType = n3;
            this.vDataTypeSigned = GLBuffers.isSignedGLType(n3);
            this.vComps = n2;
            this.vCompsBytes = n2 * GLBuffers.sizeOfGLType(n3);
            this.cDataType = n5;
            this.cDataTypeSigned = GLBuffers.isSignedGLType(n5);
            this.cComps = n4;
            this.cCompsBytes = n4 * GLBuffers.sizeOfGLType(n5);
            this.nDataType = n7;
            this.nDataTypeSigned = GLBuffers.isSignedGLType(n7);
            this.nComps = n6;
            this.nCompsBytes = n6 * GLBuffers.sizeOfGLType(n7);
            this.tDataType = n9;
            this.tDataTypeSigned = GLBuffers.isSignedGLType(n9);
            this.tComps = n8;
            this.tCompsBytes = n8 * GLBuffers.sizeOfGLType(n9);
            this.vboName = 0;
            this.vCount = 0;
            this.cCount = 0;
            this.nCount = 0;
            this.tCount = 0;
            this.vElems = 0;
            this.cElems = 0;
            this.nElems = 0;
            this.tElems = 0;
            this.pageSize = Platform.getMachineDataInfo().pageSizeInBytes();
            this.reallocateBuffer(n);
            this.rewind();
            this.sealed = false;
            this.sealedGL = false;
            this.mode = 0;
            this.modeOrig = 0;
            this.bufferEnabled = false;
            this.bufferWritten = false;
            this.bufferWrittenOnce = false;
            this.glslLocationSet = false;
        }

        protected int getResizeElementCount() {
            return this.resizeElementCount;
        }

        protected void setResizeElementCount(int n) {
            this.resizeElementCount = n;
        }

        protected boolean getUseVBO() {
            return this.useVBO;
        }

        protected final VBOSet regenerate(GL gL) {
            return new VBOSet(this.initialElementCount, this.vComps, this.vDataType, this.cComps, this.cDataType, this.nComps, this.nDataType, this.tComps, this.tDataType, this.useGLSL, this.glBufferUsage, this.shaderState, this.shaderProgram);
        }

        protected void checkSeal(boolean bl) throws GLException {
            if (0 == this.mode) {
                throw new GLException("No mode set yet, call glBegin(mode) first:\n\t" + this);
            }
            if (this.sealed != bl) {
                if (bl) {
                    throw new GLException("Not Sealed yet, call glEnd() first:\n\t" + this);
                }
                throw new GLException("Already Sealed, can't modify VBO after glEnd():\n\t" + this);
            }
        }

        protected void useShaderProgram(GL2ES2 gL2ES2, boolean bl) {
            if (bl || !this.usingShaderProgram) {
                if (null != this.shaderState) {
                    this.shaderState.useProgram(gL2ES2, true);
                } else {
                    gL2ES2.glUseProgram(this.shaderProgram);
                }
                this.usingShaderProgram = true;
            }
        }

        protected void draw(GL gL, Buffer buffer, boolean bl, int n) {
            this.enableBuffer(gL, true);
            if (null != this.shaderState || 0 != this.shaderProgram) {
                this.useShaderProgram(gL.getGL2ES2(), false);
            }
            if (DEBUG_DRAW) {
                System.err.println("ImmModeSink.draw[" + n + "].0 (disableBufferAfterDraw: " + bl + "):\n\t" + this);
            }
            if (this.buffer != null) {
                if (null == buffer) {
                    if (7 == this.mode && !gL.isGL2()) {
                        for (int i = 0; i < this.vElems - 3; i += 4) {
                            gL.glDrawArrays(6, i, 4);
                        }
                    } else {
                        gL.glDrawArrays(this.mode, 0, this.vElems);
                    }
                } else {
                    int n2;
                    if (!gL.getContext().isCPUDataSourcingAvail()) {
                        throw new GLException("CPU data sourcing n/a w/ " + gL.getContext());
                    }
                    if (buffer instanceof ByteBuffer) {
                        n2 = 5121;
                    } else if (buffer instanceof ShortBuffer) {
                        n2 = 5123;
                    } else if (buffer instanceof IntBuffer) {
                        n2 = 5125;
                    } else {
                        throw new GLException("Given Buffer Class not supported: " + buffer.getClass() + ", should be ubyte, ushort or uint:\n\t" + this);
                    }
                    int n3 = buffer.remaining();
                    int n4 = buffer.position();
                    if (7 == this.mode && !gL.isGL2()) {
                        if (5121 == n2) {
                            ByteBuffer byteBuffer = (ByteBuffer)buffer;
                            for (int i = 0; i < n3; ++i) {
                                gL.glDrawArrays(6, 0xFF & byteBuffer.get(n4 + i), 4);
                            }
                        } else if (5123 == n2) {
                            ShortBuffer shortBuffer = (ShortBuffer)buffer;
                            for (int i = 0; i < n3; ++i) {
                                gL.glDrawArrays(6, 0xFFFF & shortBuffer.get(n4 + i), 4);
                            }
                        } else {
                            IntBuffer intBuffer = (IntBuffer)buffer;
                            for (int i = 0; i < n3; ++i) {
                                gL.glDrawArrays(6, 0xFFFFFFFF & intBuffer.get(n4 + i), 4);
                            }
                        }
                    } else {
                        ((GL2ES1)gL).glDrawElements(this.mode, n3, n2, buffer);
                    }
                }
            }
            if (bl) {
                this.enableBuffer(gL, false);
            }
            if (DEBUG_DRAW) {
                System.err.println("ImmModeSink.draw[" + n + "].X (disableBufferAfterDraw: " + bl + ")");
            }
        }

        public void glVertexv(Buffer buffer) {
            this.checkSeal(false);
            Buffers.put(this.vertexArray, buffer);
        }

        public void glNormalv(Buffer buffer) {
            this.checkSeal(false);
            Buffers.put(this.normalArray, buffer);
        }

        public void glColorv(Buffer buffer) {
            this.checkSeal(false);
            Buffers.put(this.colorArray, buffer);
        }

        public void glTexCoordv(Buffer buffer) {
            this.checkSeal(false);
            Buffers.put(this.textCoordArray, buffer);
        }

        public void glVertex2b(byte by, byte by2) {
            this.checkSeal(false);
            this.growBuffer(0);
            if (this.vComps > 0) {
                Buffers.putNb(this.vertexArray, this.vDataTypeSigned, by, true);
            }
            if (this.vComps > 1) {
                Buffers.putNb(this.vertexArray, this.vDataTypeSigned, by2, true);
            }
            this.countAndPadding(0, this.vComps - 2);
        }

        public void glVertex3b(byte by, byte by2, byte by3) {
            this.checkSeal(false);
            this.growBuffer(0);
            if (this.vComps > 0) {
                Buffers.putNb(this.vertexArray, this.vDataTypeSigned, by, true);
            }
            if (this.vComps > 1) {
                Buffers.putNb(this.vertexArray, this.vDataTypeSigned, by2, true);
            }
            if (this.vComps > 2) {
                Buffers.putNb(this.vertexArray, this.vDataTypeSigned, by3, true);
            }
            this.countAndPadding(0, this.vComps - 3);
        }

        public void glVertex2s(short s, short s2) {
            this.checkSeal(false);
            this.growBuffer(0);
            if (this.vComps > 0) {
                Buffers.putNs(this.vertexArray, this.vDataTypeSigned, s, true);
            }
            if (this.vComps > 1) {
                Buffers.putNs(this.vertexArray, this.vDataTypeSigned, s2, true);
            }
            this.countAndPadding(0, this.vComps - 2);
        }

        public void glVertex3s(short s, short s2, short s3) {
            this.checkSeal(false);
            this.growBuffer(0);
            if (this.vComps > 0) {
                Buffers.putNs(this.vertexArray, this.vDataTypeSigned, s, true);
            }
            if (this.vComps > 1) {
                Buffers.putNs(this.vertexArray, this.vDataTypeSigned, s2, true);
            }
            if (this.vComps > 2) {
                Buffers.putNs(this.vertexArray, this.vDataTypeSigned, s3, true);
            }
            this.countAndPadding(0, this.vComps - 3);
        }

        public void glVertex2f(float f, float f2) {
            this.checkSeal(false);
            this.growBuffer(0);
            if (this.vComps > 0) {
                Buffers.putNf(this.vertexArray, this.vDataTypeSigned, f);
            }
            if (this.vComps > 1) {
                Buffers.putNf(this.vertexArray, this.vDataTypeSigned, f2);
            }
            this.countAndPadding(0, this.vComps - 2);
        }

        public void glVertex3f(float f, float f2, float f3) {
            this.checkSeal(false);
            this.growBuffer(0);
            if (this.vComps > 0) {
                Buffers.putNf(this.vertexArray, this.vDataTypeSigned, f);
            }
            if (this.vComps > 1) {
                Buffers.putNf(this.vertexArray, this.vDataTypeSigned, f2);
            }
            if (this.vComps > 2) {
                Buffers.putNf(this.vertexArray, this.vDataTypeSigned, f3);
            }
            this.countAndPadding(0, this.vComps - 3);
        }

        public void glNormal3b(byte by, byte by2, byte by3) {
            this.checkSeal(false);
            this.growBuffer(2);
            if (this.nComps > 0) {
                Buffers.putNb(this.normalArray, this.nDataTypeSigned, by, true);
            }
            if (this.nComps > 1) {
                Buffers.putNb(this.normalArray, this.nDataTypeSigned, by2, true);
            }
            if (this.nComps > 2) {
                Buffers.putNb(this.normalArray, this.nDataTypeSigned, by3, true);
            }
            this.countAndPadding(2, this.nComps - 3);
        }

        public void glNormal3s(short s, short s2, short s3) {
            this.checkSeal(false);
            this.growBuffer(2);
            if (this.nComps > 0) {
                Buffers.putNs(this.normalArray, this.nDataTypeSigned, s, true);
            }
            if (this.nComps > 1) {
                Buffers.putNs(this.normalArray, this.nDataTypeSigned, s2, true);
            }
            if (this.nComps > 2) {
                Buffers.putNs(this.normalArray, this.nDataTypeSigned, s3, true);
            }
            this.countAndPadding(2, this.nComps - 3);
        }

        public void glNormal3f(float f, float f2, float f3) {
            this.checkSeal(false);
            this.growBuffer(2);
            if (this.nComps > 0) {
                Buffers.putNf(this.normalArray, this.nDataTypeSigned, f);
            }
            if (this.nComps > 1) {
                Buffers.putNf(this.normalArray, this.nDataTypeSigned, f2);
            }
            if (this.nComps > 2) {
                Buffers.putNf(this.normalArray, this.nDataTypeSigned, f3);
            }
            this.countAndPadding(2, this.nComps - 3);
        }

        public void glColor3b(byte by, byte by2, byte by3) {
            this.checkSeal(false);
            this.growBuffer(1);
            if (this.cComps > 0) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by, true);
            }
            if (this.cComps > 1) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by2, true);
            }
            if (this.cComps > 2) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by3, true);
            }
            this.countAndPadding(1, this.cComps - 3);
        }

        public void glColor3ub(byte by, byte by2, byte by3) {
            this.checkSeal(false);
            this.growBuffer(1);
            if (this.cComps > 0) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by, false);
            }
            if (this.cComps > 1) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by2, false);
            }
            if (this.cComps > 2) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by3, false);
            }
            this.countAndPadding(1, this.cComps - 3);
        }

        public void glColor4b(byte by, byte by2, byte by3, byte by4) {
            this.checkSeal(false);
            this.growBuffer(1);
            if (this.cComps > 0) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by, true);
            }
            if (this.cComps > 1) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by2, true);
            }
            if (this.cComps > 2) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by3, true);
            }
            if (this.cComps > 3) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by4, true);
            }
            this.countAndPadding(1, this.cComps - 4);
        }

        public void glColor4ub(byte by, byte by2, byte by3, byte by4) {
            this.checkSeal(false);
            this.growBuffer(1);
            if (this.cComps > 0) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by, false);
            }
            if (this.cComps > 1) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by2, false);
            }
            if (this.cComps > 2) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by3, false);
            }
            if (this.cComps > 3) {
                Buffers.putNb(this.colorArray, this.cDataTypeSigned, by4, false);
            }
            this.countAndPadding(1, this.cComps - 4);
        }

        public void glColor3s(short s, short s2, short s3) {
            this.checkSeal(false);
            this.growBuffer(1);
            if (this.cComps > 0) {
                Buffers.putNs(this.colorArray, this.cDataTypeSigned, s, true);
            }
            if (this.cComps > 1) {
                Buffers.putNs(this.colorArray, this.cDataTypeSigned, s2, true);
            }
            if (this.cComps > 2) {
                Buffers.putNs(this.colorArray, this.cDataTypeSigned, s3, true);
            }
            this.countAndPadding(1, this.cComps - 3);
        }

        public void glColor4s(short s, short s2, short s3, short s4) {
            this.checkSeal(false);
            this.growBuffer(1);
            if (this.cComps > 0) {
                Buffers.putNs(this.colorArray, this.cDataTypeSigned, s, true);
            }
            if (this.cComps > 1) {
                Buffers.putNs(this.colorArray, this.cDataTypeSigned, s2, true);
            }
            if (this.cComps > 2) {
                Buffers.putNs(this.colorArray, this.cDataTypeSigned, s3, true);
            }
            if (this.cComps > 3) {
                Buffers.putNs(this.colorArray, this.cDataTypeSigned, s4, true);
            }
            this.countAndPadding(1, this.cComps - 4);
        }

        public void glColor3f(float f, float f2, float f3) {
            this.checkSeal(false);
            this.growBuffer(1);
            if (this.cComps > 0) {
                Buffers.putNf(this.colorArray, this.cDataTypeSigned, f);
            }
            if (this.cComps > 1) {
                Buffers.putNf(this.colorArray, this.cDataTypeSigned, f2);
            }
            if (this.cComps > 2) {
                Buffers.putNf(this.colorArray, this.cDataTypeSigned, f3);
            }
            this.countAndPadding(1, this.cComps - 3);
        }

        public void glColor4f(float f, float f2, float f3, float f4) {
            this.checkSeal(false);
            this.growBuffer(1);
            if (this.cComps > 0) {
                Buffers.putNf(this.colorArray, this.cDataTypeSigned, f);
            }
            if (this.cComps > 1) {
                Buffers.putNf(this.colorArray, this.cDataTypeSigned, f2);
            }
            if (this.cComps > 2) {
                Buffers.putNf(this.colorArray, this.cDataTypeSigned, f3);
            }
            if (this.cComps > 3) {
                Buffers.putNf(this.colorArray, this.cDataTypeSigned, f4);
            }
            this.countAndPadding(1, this.cComps - 4);
        }

        public void glTexCoord2b(byte by, byte by2) {
            this.checkSeal(false);
            this.growBuffer(3);
            if (this.tComps > 0) {
                Buffers.putNb(this.textCoordArray, this.tDataTypeSigned, by, true);
            }
            if (this.tComps > 1) {
                Buffers.putNb(this.textCoordArray, this.tDataTypeSigned, by2, true);
            }
            this.countAndPadding(3, this.tComps - 2);
        }

        public void glTexCoord3b(byte by, byte by2, byte by3) {
            this.checkSeal(false);
            this.growBuffer(3);
            if (this.tComps > 0) {
                Buffers.putNb(this.textCoordArray, this.tDataTypeSigned, by, true);
            }
            if (this.tComps > 1) {
                Buffers.putNb(this.textCoordArray, this.tDataTypeSigned, by2, true);
            }
            if (this.tComps > 2) {
                Buffers.putNb(this.textCoordArray, this.tDataTypeSigned, by3, true);
            }
            this.countAndPadding(3, this.tComps - 3);
        }

        public void glTexCoord2s(short s, short s2) {
            this.checkSeal(false);
            this.growBuffer(3);
            if (this.tComps > 0) {
                Buffers.putNs(this.textCoordArray, this.tDataTypeSigned, s, true);
            }
            if (this.tComps > 1) {
                Buffers.putNs(this.textCoordArray, this.tDataTypeSigned, s2, true);
            }
            this.countAndPadding(3, this.tComps - 2);
        }

        public void glTexCoord3s(short s, short s2, short s3) {
            this.checkSeal(false);
            this.growBuffer(3);
            if (this.tComps > 0) {
                Buffers.putNs(this.textCoordArray, this.tDataTypeSigned, s, true);
            }
            if (this.tComps > 1) {
                Buffers.putNs(this.textCoordArray, this.tDataTypeSigned, s2, true);
            }
            if (this.tComps > 2) {
                Buffers.putNs(this.textCoordArray, this.tDataTypeSigned, s3, true);
            }
            this.countAndPadding(3, this.tComps - 3);
        }

        public void glTexCoord2f(float f, float f2) {
            this.checkSeal(false);
            this.growBuffer(3);
            if (this.tComps > 0) {
                Buffers.putNf(this.textCoordArray, this.tDataTypeSigned, f);
            }
            if (this.tComps > 1) {
                Buffers.putNf(this.textCoordArray, this.tDataTypeSigned, f2);
            }
            this.countAndPadding(3, this.tComps - 2);
        }

        public void glTexCoord3f(float f, float f2, float f3) {
            this.checkSeal(false);
            this.growBuffer(3);
            if (this.tComps > 0) {
                Buffers.putNf(this.textCoordArray, this.tDataTypeSigned, f);
            }
            if (this.tComps > 1) {
                Buffers.putNf(this.textCoordArray, this.tDataTypeSigned, f2);
            }
            if (this.tComps > 2) {
                Buffers.putNf(this.textCoordArray, this.tDataTypeSigned, f3);
            }
            this.countAndPadding(3, this.tComps - 3);
        }

        public void rewind() {
            if (null != this.vertexArray) {
                this.vertexArray.rewind();
            }
            if (null != this.colorArray) {
                this.colorArray.rewind();
            }
            if (null != this.normalArray) {
                this.normalArray.rewind();
            }
            if (null != this.textCoordArray) {
                this.textCoordArray.rewind();
            }
        }

        public void setShaderProgram(int n) {
            if (null == this.shaderState && 0 == n) {
                throw new IllegalArgumentException("Not allowed to zero shader program if no ShaderState is set");
            }
            this.shaderProgram = n;
            this.glslLocationSet = false;
        }

        private boolean resetGLSLArrayLocation(GL2ES2 gL2ES2) {
            int n = 0;
            int n2 = 0;
            if (null != this.vArrayData) {
                ++n;
                if (this.vArrayData.setLocation(gL2ES2, this.shaderProgram) >= 0) {
                    ++n2;
                }
            }
            if (null != this.cArrayData) {
                ++n;
                if (this.cArrayData.setLocation(gL2ES2, this.shaderProgram) >= 0) {
                    ++n2;
                }
            }
            if (null != this.nArrayData) {
                ++n;
                if (this.nArrayData.setLocation(gL2ES2, this.shaderProgram) >= 0) {
                    ++n2;
                }
            }
            if (null != this.tArrayData) {
                ++n;
                if (this.tArrayData.setLocation(gL2ES2, this.shaderProgram) >= 0) {
                    ++n2;
                }
            }
            this.glslLocationSet = n == n2;
            return this.glslLocationSet;
        }

        public void destroy(GL gL) {
            this.reset(gL);
            this.vCount = 0;
            this.cCount = 0;
            this.nCount = 0;
            this.tCount = 0;
            this.vertexArray = null;
            this.colorArray = null;
            this.normalArray = null;
            this.textCoordArray = null;
            this.vArrayData = null;
            this.cArrayData = null;
            this.nArrayData = null;
            this.tArrayData = null;
            this.buffer = null;
        }

        public void reset(GL gL) {
            this.enableBuffer(gL, false);
            this.reset();
        }

        public void reset() {
            if (this.buffer != null) {
                this.buffer.clear();
            }
            this.rewind();
            this.mode = 0;
            this.modeOrig = 0;
            this.sealed = false;
            this.sealedGL = false;
            this.bufferEnabled = false;
            this.bufferWritten = false;
            this.vElems = 0;
            this.cElems = 0;
            this.nElems = 0;
            this.tElems = 0;
        }

        public void seal(GL gL, boolean bl) {
            this.seal(bl);
            if (this.sealedGL == bl) {
                return;
            }
            this.sealedGL = bl;
            GL gL2 = gL.getGL();
            if (bl) {
                if (this.useVBO) {
                    if (0 == this.vboName) {
                        int[] nArray = new int[1];
                        gL2.glGenBuffers(1, nArray, 0);
                        this.vboName = nArray[0];
                    }
                    if (null != this.vArrayData) {
                        this.vArrayData.setVBOName(this.vboName);
                    }
                    if (null != this.cArrayData) {
                        this.cArrayData.setVBOName(this.vboName);
                    }
                    if (null != this.nArrayData) {
                        this.nArrayData.setVBOName(this.vboName);
                    }
                    if (null != this.tArrayData) {
                        this.tArrayData.setVBOName(this.vboName);
                    }
                }
                this.enableBuffer(gL2, true);
            } else {
                this.enableBuffer(gL2, false);
            }
        }

        public void seal(boolean bl) {
            if (this.sealed == bl) {
                return;
            }
            this.sealed = bl;
            if (bl) {
                this.bufferWritten = false;
                this.rewind();
            }
        }

        public void enableBuffer(GL gL, boolean bl) {
            if (this.bufferEnabled != bl && this.vElems > 0) {
                if (bl) {
                    this.checkSeal(true);
                }
                this.bufferEnabled = bl;
                if (this.useGLSL) {
                    this.useShaderProgram(gL.getGL2ES2(), true);
                    if (null != this.shaderState) {
                        this.enableBufferGLSLShaderState(gL, bl);
                    } else {
                        this.enableBufferGLSLSimple(gL, bl);
                    }
                } else {
                    this.enableBufferFixed(gL, bl);
                }
            }
        }

        private final void writeBuffer(GL gL) {
            int n = this.vElems * this.vCompsBytes;
            int n2 = this.cElems * this.cCompsBytes;
            int n3 = this.nElems * this.nCompsBytes;
            int n4 = this.tElems * this.tCompsBytes;
            int n5 = this.buffer.limit() - (n + n2 + n3 + n4);
            if (this.bufferWrittenOnce && n5 > this.pageSize) {
                if (0 < n) {
                    gL.glBufferSubData(34962, this.vOffset, n, this.vertexArray);
                }
                if (0 < n2) {
                    gL.glBufferSubData(34962, this.cOffset, n2, this.colorArray);
                }
                if (0 < n3) {
                    gL.glBufferSubData(34962, this.nOffset, n3, this.normalArray);
                }
                if (0 < n4) {
                    gL.glBufferSubData(34962, this.tOffset, n4, this.textCoordArray);
                }
            } else {
                gL.glBufferData(34962, this.buffer.limit(), this.buffer, this.glBufferUsage);
                this.bufferWrittenOnce = true;
            }
        }

        private void enableBufferFixed(GL gL, boolean bl) {
            boolean bl2;
            GL2ES1 gL2ES1 = gL.getGL2ES1();
            boolean bl3 = this.vComps > 0 && this.vElems > 0;
            boolean bl4 = this.cComps > 0 && this.cElems > 0;
            boolean bl5 = this.nComps > 0 && this.nElems > 0;
            boolean bl6 = bl2 = this.tComps > 0 && this.tElems > 0;
            if (DEBUG_DRAW) {
                System.err.println("ImmModeSink.enableFixed.0 " + bl + ": use [ v " + bl3 + ", c " + bl4 + ", n " + bl5 + ", t " + bl2 + "], " + this.getElemUseCountStr() + ", " + this.buffer);
            }
            if (bl) {
                if (this.useVBO) {
                    if (0 == this.vboName) {
                        throw new InternalError("Using VBO but no vboName");
                    }
                    gL2ES1.glBindBuffer(34962, this.vboName);
                    if (!this.bufferWritten) {
                        this.writeBuffer(gL);
                    }
                }
                this.bufferWritten = true;
            }
            if (bl3) {
                if (bl) {
                    gL2ES1.glEnableClientState(32884);
                    gL2ES1.glVertexPointer(this.vArrayData);
                } else {
                    gL2ES1.glDisableClientState(32884);
                }
            }
            if (bl4) {
                if (bl) {
                    gL2ES1.glEnableClientState(32886);
                    gL2ES1.glColorPointer(this.cArrayData);
                } else {
                    gL2ES1.glDisableClientState(32886);
                }
            }
            if (bl5) {
                if (bl) {
                    gL2ES1.glEnableClientState(32885);
                    gL2ES1.glNormalPointer(this.nArrayData);
                } else {
                    gL2ES1.glDisableClientState(32885);
                }
            }
            if (bl2) {
                if (bl) {
                    gL2ES1.glEnableClientState(32888);
                    gL2ES1.glTexCoordPointer(this.tArrayData);
                } else {
                    gL2ES1.glDisableClientState(32888);
                }
            }
            if (bl && this.useVBO) {
                gL.glBindBuffer(34962, 0);
            }
            if (DEBUG_DRAW) {
                System.err.println("ImmModeSink.enableFixed.X ");
            }
        }

        private void enableBufferGLSLShaderState(GL gL, boolean bl) {
            boolean bl2;
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            boolean bl3 = this.vComps > 0 && this.vElems > 0;
            boolean bl4 = this.cComps > 0 && this.cElems > 0;
            boolean bl5 = this.nComps > 0 && this.nElems > 0;
            boolean bl6 = bl2 = this.tComps > 0 && this.tElems > 0;
            if (DEBUG_DRAW) {
                System.err.println("ImmModeSink.enableGLSL.A.0 " + bl + ": use [ v " + bl3 + ", c " + bl4 + ", n " + bl5 + ", t " + bl2 + "], " + this.getElemUseCountStr() + ", " + this.buffer);
            }
            if (bl) {
                if (this.useVBO) {
                    if (0 == this.vboName) {
                        throw new InternalError("Using VBO but no vboName");
                    }
                    gL2ES2.glBindBuffer(34962, this.vboName);
                    if (!this.bufferWritten) {
                        this.writeBuffer(gL);
                    }
                }
                this.bufferWritten = true;
            }
            if (bl3) {
                if (bl) {
                    this.shaderState.enableVertexAttribArray(gL2ES2, this.vArrayData);
                    this.shaderState.vertexAttribPointer(gL2ES2, this.vArrayData);
                } else {
                    this.shaderState.disableVertexAttribArray(gL2ES2, this.vArrayData);
                }
            }
            if (bl4) {
                if (bl) {
                    this.shaderState.enableVertexAttribArray(gL2ES2, this.cArrayData);
                    this.shaderState.vertexAttribPointer(gL2ES2, this.cArrayData);
                } else {
                    this.shaderState.disableVertexAttribArray(gL2ES2, this.cArrayData);
                }
            }
            if (bl5) {
                if (bl) {
                    this.shaderState.enableVertexAttribArray(gL2ES2, this.nArrayData);
                    this.shaderState.vertexAttribPointer(gL2ES2, this.nArrayData);
                } else {
                    this.shaderState.disableVertexAttribArray(gL2ES2, this.nArrayData);
                }
            }
            if (bl2) {
                if (bl) {
                    this.shaderState.enableVertexAttribArray(gL2ES2, this.tArrayData);
                    this.shaderState.vertexAttribPointer(gL2ES2, this.tArrayData);
                } else {
                    this.shaderState.disableVertexAttribArray(gL2ES2, this.tArrayData);
                }
            }
            this.glslLocationSet = true;
            if (bl && this.useVBO) {
                gL2ES2.glBindBuffer(34962, 0);
            }
            if (DEBUG_DRAW) {
                System.err.println("ImmModeSink.enableGLSL.A.X ");
            }
        }

        private void enableBufferGLSLSimple(GL gL, boolean bl) {
            boolean bl2;
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            boolean bl3 = this.vComps > 0 && this.vElems > 0;
            boolean bl4 = this.cComps > 0 && this.cElems > 0;
            boolean bl5 = this.nComps > 0 && this.nElems > 0;
            boolean bl6 = bl2 = this.tComps > 0 && this.tElems > 0;
            if (DEBUG_DRAW) {
                System.err.println("ImmModeSink.enableGLSL.B.0 " + bl + ": use [ v " + bl3 + ", c " + bl4 + ", n " + bl5 + ", t " + bl2 + "], " + this.getElemUseCountStr() + ", " + this.buffer);
            }
            if (!this.glslLocationSet && !this.resetGLSLArrayLocation(gL2ES2)) {
                if (DEBUG_DRAW) {
                    int n = null != this.vArrayData ? this.vArrayData.getLocation() : -1;
                    int n2 = null != this.cArrayData ? this.cArrayData.getLocation() : -1;
                    int n3 = null != this.nArrayData ? this.nArrayData.getLocation() : -1;
                    int n4 = null != this.tArrayData ? this.tArrayData.getLocation() : -1;
                    System.err.println("ImmModeSink.enableGLSL.B.X attribute locations in shader program " + this.shaderProgram + ", incomplete [" + n + ", " + n2 + ", " + n3 + ", " + n4 + "] - glslLocationSet " + this.glslLocationSet);
                }
                return;
            }
            if (bl) {
                if (this.useVBO) {
                    if (0 == this.vboName) {
                        throw new InternalError("Using VBO but no vboName");
                    }
                    gL2ES2.glBindBuffer(34962, this.vboName);
                    if (!this.bufferWritten) {
                        this.writeBuffer(gL);
                    }
                }
                this.bufferWritten = true;
            }
            if (bl3) {
                if (bl) {
                    gL2ES2.glEnableVertexAttribArray(this.vArrayData.getLocation());
                    gL2ES2.glVertexAttribPointer(this.vArrayData);
                } else {
                    gL2ES2.glDisableVertexAttribArray(this.vArrayData.getLocation());
                }
            }
            if (bl4) {
                if (bl) {
                    gL2ES2.glEnableVertexAttribArray(this.cArrayData.getLocation());
                    gL2ES2.glVertexAttribPointer(this.cArrayData);
                } else {
                    gL2ES2.glDisableVertexAttribArray(this.cArrayData.getLocation());
                }
            }
            if (bl5) {
                if (bl) {
                    gL2ES2.glEnableVertexAttribArray(this.nArrayData.getLocation());
                    gL2ES2.glVertexAttribPointer(this.nArrayData);
                } else {
                    gL2ES2.glDisableVertexAttribArray(this.nArrayData.getLocation());
                }
            }
            if (bl2) {
                if (bl) {
                    gL2ES2.glEnableVertexAttribArray(this.tArrayData.getLocation());
                    gL2ES2.glVertexAttribPointer(this.tArrayData);
                } else {
                    gL2ES2.glDisableVertexAttribArray(this.tArrayData.getLocation());
                }
            }
            if (bl && this.useVBO) {
                gL2ES2.glBindBuffer(34962, 0);
            }
            if (DEBUG_DRAW) {
                System.err.println("ImmModeSink.enableGLSL.B.X ");
            }
        }

        public String toString() {
            String string = this.useGLSL ? ", useShaderState " + (null != this.shaderState) + ", shaderProgram " + this.shaderProgram + ", glslLocationSet " + this.glslLocationSet : "";
            return "VBOSet[mode " + this.mode + ", modeOrig " + this.modeOrig + ", use/count " + this.getElemUseCountStr() + ", sealed " + this.sealed + ", sealedGL " + this.sealedGL + ", bufferEnabled " + this.bufferEnabled + ", bufferWritten " + this.bufferWritten + " (once " + this.bufferWrittenOnce + "), useVBO " + this.useVBO + ", vboName " + this.vboName + ", useGLSL " + this.useGLSL + string + ",\n\t" + this.vArrayData + ",\n\t" + this.cArrayData + ",\n\t" + this.nArrayData + ",\n\t" + this.tArrayData + "]";
        }

        protected String getElemUseCountStr() {
            return "[v " + this.vElems + "/" + this.vCount + ", c " + this.cElems + "/" + this.cCount + ", n " + this.nElems + "/" + this.nCount + ", t " + this.tElems + "/" + this.tCount + "]";
        }

        protected boolean fitElementInBuffer(int n) {
            switch (n) {
                case 0: {
                    return this.vCount - this.vElems >= 1;
                }
                case 1: {
                    return this.cCount - this.cElems >= 1;
                }
                case 2: {
                    return this.nCount - this.nElems >= 1;
                }
                case 3: {
                    return this.tCount - this.tElems >= 1;
                }
            }
            throw new InternalError("XXX");
        }

        protected boolean reallocateBuffer(int n) {
            int n2 = n - (this.vCount - this.vElems);
            int n3 = n - (this.cCount - this.cElems);
            int n4 = n - (this.nCount - this.nElems);
            int n5 = n - (this.tCount - this.tElems);
            if (0 >= n2 && 0 >= n3 && 0 >= n4 && 0 >= n5) {
                if (DEBUG_BUFFER) {
                    System.err.println("ImmModeSink.realloc: " + this.getElemUseCountStr() + " + " + n + " -> NOP");
                }
                return false;
            }
            if (DEBUG_BUFFER) {
                System.err.println("ImmModeSink.realloc: " + this.getElemUseCountStr() + " + " + n);
            }
            this.vCount += n2;
            this.cCount += n3;
            this.nCount += n4;
            this.tCount += n5;
            int n6 = this.vCount * this.vCompsBytes;
            int n7 = this.cCount * this.cCompsBytes;
            int n8 = this.nCount * this.nCompsBytes;
            int n9 = this.tCount * this.tCompsBytes;
            this.buffer = Buffers.newDirectByteBuffer(n6 + n7 + n8 + n9);
            this.vOffset = 0;
            this.vertexArray = n6 > 0 ? GLBuffers.sliceGLBuffer(this.buffer, this.vOffset, n6, this.vDataType) : null;
            this.cOffset = this.vOffset + n6;
            this.colorArray = n7 > 0 ? GLBuffers.sliceGLBuffer(this.buffer, this.cOffset, n7, this.cDataType) : null;
            this.nOffset = this.cOffset + n7;
            this.normalArray = n8 > 0 ? GLBuffers.sliceGLBuffer(this.buffer, this.nOffset, n8, this.nDataType) : null;
            this.tOffset = this.nOffset + n8;
            this.textCoordArray = n9 > 0 ? GLBuffers.sliceGLBuffer(this.buffer, this.tOffset, n9, this.tDataType) : null;
            this.buffer.position(this.tOffset + n9);
            this.buffer.flip();
            this.vArrayData = this.vComps > 0 ? GLArrayDataWrapper.createFixed(32884, this.vComps, this.vDataType, GLBuffers.isGLTypeFixedPoint(this.vDataType), 0, this.vertexArray, 0, (long)this.vOffset, 35044, 34962) : null;
            this.cArrayData = this.cComps > 0 ? GLArrayDataWrapper.createFixed(32886, this.cComps, this.cDataType, GLBuffers.isGLTypeFixedPoint(this.cDataType), 0, this.colorArray, 0, (long)this.cOffset, 35044, 34962) : null;
            this.nArrayData = this.nComps > 0 ? GLArrayDataWrapper.createFixed(32885, this.nComps, this.nDataType, GLBuffers.isGLTypeFixedPoint(this.nDataType), 0, this.normalArray, 0, (long)this.nOffset, 35044, 34962) : null;
            this.tArrayData = this.tComps > 0 ? GLArrayDataWrapper.createFixed(32888, this.tComps, this.tDataType, GLBuffers.isGLTypeFixedPoint(this.tDataType), 0, this.textCoordArray, 0, (long)this.tOffset, 35044, 34962) : null;
            this.bufferWrittenOnce = false;
            if (DEBUG_BUFFER) {
                System.err.println("ImmModeSink.realloc.X: " + this.toString());
                ExceptionUtils.dumpStack(System.err);
            }
            return true;
        }

        protected final boolean growBuffer(int n) {
            if (null != this.buffer && !this.sealed && !this.fitElementInBuffer(n)) {
                Buffer buffer = this.vertexArray;
                Buffer buffer2 = this.colorArray;
                Buffer buffer3 = this.normalArray;
                Buffer buffer4 = this.textCoordArray;
                if (this.reallocateBuffer(this.resizeElementCount)) {
                    if (null != buffer) {
                        buffer.flip();
                        Buffers.put(this.vertexArray, buffer);
                    }
                    if (null != buffer2) {
                        buffer2.flip();
                        Buffers.put(this.colorArray, buffer2);
                    }
                    if (null != buffer3) {
                        buffer3.flip();
                        Buffers.put(this.normalArray, buffer3);
                    }
                    if (null != buffer4) {
                        buffer4.flip();
                        Buffers.put(this.textCoordArray, buffer4);
                    }
                    return true;
                }
            }
            return false;
        }

        private void countAndPadding(int n, int n2) {
            int n3;
            boolean bl;
            Buffer buffer;
            if (this.sealed) {
                return;
            }
            switch (n) {
                case 0: {
                    buffer = this.vertexArray;
                    bl = this.vDataTypeSigned;
                    n3 = 4 == this.vComps ? 1 : 0;
                    ++this.vElems;
                    break;
                }
                case 1: {
                    buffer = this.colorArray;
                    bl = this.cDataTypeSigned;
                    n3 = 4 == this.cComps ? 1 : 0;
                    ++this.cElems;
                    break;
                }
                case 2: {
                    buffer = this.normalArray;
                    bl = this.nDataTypeSigned;
                    n3 = 0;
                    ++this.nElems;
                    break;
                }
                case 3: {
                    buffer = this.textCoordArray;
                    bl = this.tDataTypeSigned;
                    n3 = 0;
                    ++this.tElems;
                    break;
                }
                default: {
                    throw new InternalError("Invalid type " + n);
                }
            }
            if (null == buffer) {
                return;
            }
            while (n2 > n3) {
                --n2;
                Buffers.putNf(buffer, bl, 0.0f);
            }
            if (n2 > 0) {
                Buffers.putNf(buffer, bl, 1.0f);
            }
        }
    }
}

