/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av.impl;

import com.jogamp.common.av.AudioFormat;
import com.jogamp.common.av.AudioSink;
import com.jogamp.common.av.AudioSinkFactory;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.util.av.AudioSampleFormat;
import jogamp.opengl.util.av.GLMediaPlayerImpl;
import jogamp.opengl.util.av.VideoPixelFormat;
import jogamp.opengl.util.av.impl.FFMPEGDynamicLibraryBundleInfo;
import jogamp.opengl.util.av.impl.FFMPEGNatives;

public class FFMPEGMediaPlayer
extends GLMediaPlayerImpl {
    static final boolean PREFER_SYSTEM_LIBS;
    private static final int ENOSYS = 38;
    private static final FFMPEGNatives natives;
    private static final int avUtilMajorVersionCC;
    private static final int avFormatMajorVersionCC;
    private static final int avCodecMajorVersionCC;
    private static final int avDeviceMajorVersionCC;
    private static final int swResampleMajorVersionCC;
    private static final boolean available;
    private long moviePtr = 0L;
    private boolean usesTexLookupShader = false;
    private VideoPixelFormat vPixelFmt = null;
    private int vPlanes = 0;
    private int vBitsPerPixel = 0;
    private int vBytesPerPixelPerPlane = 0;
    private int texWidth;
    private int texHeight;
    private String singleTexComp = "r";
    private final GLPixelStorageModes psm;
    private AudioFormat avChosenAudioFormat;
    private int audioSamplesPerFrameAndChannel = 0;
    public static final String dev_video_linux = "/dev/video";

    public static final boolean isAvailable() {
        return available;
    }

    public FFMPEGMediaPlayer() {
        if (!available) {
            throw new RuntimeException("FFMPEGMediaPlayer not available");
        }
        this.psm = new GLPixelStorageModes();
        this.initSelf();
    }

    private void initSelf() {
        this.moviePtr = natives.createInstance0(this, DEBUG_NATIVE);
        if (0L == this.moviePtr) {
            throw new GLException("Couldn't create FFMPEGInstance");
        }
        this.audioSink = null;
    }

    @Override
    protected final void destroyImpl() {
        if (this.moviePtr != 0L) {
            natives.destroyInstance0(this.moviePtr);
            this.moviePtr = 0L;
        }
        this.destroyAudioSink();
    }

    private final void destroyAudioSink() {
        AudioSink audioSink = this.audioSink;
        if (null != audioSink) {
            this.audioSink = null;
            audioSink.destroy();
        }
    }

    @Override
    protected void stopImpl() {
        this.destroyImpl();
        this.initSelf();
    }

    @Override
    protected final void initStreamImpl(int n, int n2) throws IOException {
        int n3;
        String string;
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        if (DEBUG) {
            System.err.println("initStream: p1 " + this);
        }
        String string2 = IOUtil.getUriFilePathOrASCII(this.getUri());
        this.destroyAudioSink();
        this.audioSink = -2 == n2 ? AudioSinkFactory.createNull() : AudioSinkFactory.createDefault(FFMPEGMediaPlayer.class.getClassLoader());
        int n4 = this.getAudioChannelLimit();
        if (n4 >= 1) {
            this.audioSink.setChannelLimit(n4);
        }
        AudioFormat audioFormat = this.audioSink.getPreferredFormat();
        if (DEBUG) {
            System.err.println("initStream: p2 aid " + n2 + ", preferred " + audioFormat + " on " + this.audioSink + ", " + this);
        }
        boolean bl = null != this.cameraPath;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        String string3 = null;
        if (bl) {
            switch (PlatformPropsImpl.OS_TYPE) {
                case ANDROID: 
                case FREEBSD: 
                case HPUX: 
                case LINUX: 
                case SUNOS: {
                    string = dev_video_linux + this.cameraPath.decode();
                    break;
                }
                default: {
                    string = this.cameraPath.decode();
                }
            }
            if (null != this.cameraProps) {
                string3 = (String)this.cameraProps.get("size");
                n3 = FFMPEGMediaPlayer.getPropIntVal(this.cameraProps, "width");
                if (n3 > 0) {
                    n5 = n3;
                }
                if ((n3 = FFMPEGMediaPlayer.getPropIntVal(this.cameraProps, "height")) > 0) {
                    n6 = n3;
                }
                if ((n3 = FFMPEGMediaPlayer.getPropIntVal(this.cameraProps, "rate")) > 0) {
                    n7 = n3;
                }
            }
        } else {
            string = string2;
        }
        n3 = audioFormat.channelCount;
        int n8 = audioFormat.sampleRate;
        if (DEBUG) {
            System.err.println("initStream: p3 cameraPath " + this.cameraPath + ", isCameraInput " + bl);
            System.err.println("initStream: p3 stream " + this.getUri() + " -> " + string2 + " -> " + string);
            System.err.println("initStream: p3 vid " + n + ", sizes " + string3 + ", reqVideo " + n5 + "x" + n6 + "@" + n7 + ", aid " + n2 + ", aMaxChannelCount " + n3 + ", aPrefSampleRate " + n8);
        }
        natives.setStream0(this.moviePtr, string, bl, n, string3, n5, n6, n7, n2, n3, n8);
    }

    @Override
    protected final void initGLImpl(GL gL) throws IOException, GLException {
        int n;
        int n2;
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        if (null != gL && -2 != this.getVID()) {
            final GLContextImpl gLContextImpl = (GLContextImpl)gL.getContext();
            SecurityUtil.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ProcAddressTable procAddressTable = gLContextImpl.getGLProcAddressTable();
                    long l = procAddressTable.getAddressFor("glTexSubImage2D");
                    long l2 = procAddressTable.getAddressFor("glGetError");
                    long l3 = procAddressTable.getAddressFor("glFlush");
                    long l4 = procAddressTable.getAddressFor("glFinish");
                    natives.setGLFuncs0(FFMPEGMediaPlayer.this.moviePtr, l, l2, l3, l4);
                    return null;
                }
            });
            n2 = 3072;
        } else {
            n2 = 1024;
        }
        if (DEBUG) {
            System.err.println("initGL: p3 aid " + this.getAID() + ", avChosen " + this.avChosenAudioFormat + " on " + this.audioSink);
        }
        if (-2 == this.getAID() || null == this.audioSink) {
            if (null != this.audioSink) {
                this.audioSink.destroy();
            }
            this.audioSink = AudioSinkFactory.createNull();
            this.audioSink.init(AudioSink.DefaultFormat, 0, 512, 512, n2);
        } else {
            int n3 = this.audioSamplesPerFrameAndChannel > 0 ? Math.round(1000.0f * this.avChosenAudioFormat.getSamplesDuration(this.audioSamplesPerFrameAndChannel)) : 32;
            n = this.audioSink.init(this.avChosenAudioFormat, n3, 512, 512, n2);
            if (n == 0) {
                System.err.println("AudioSink " + this.audioSink.getClass().getName() + " does not support " + this.avChosenAudioFormat + ", using Null");
                this.audioSink.destroy();
                this.audioSink = AudioSinkFactory.createNull();
                this.audioSink.init(this.avChosenAudioFormat, 0, 512, 512, n2);
            }
        }
        if (DEBUG) {
            System.err.println("initGL: p4 chosen " + this.avChosenAudioFormat);
            System.err.println("initGL: p4 chosen aid " + this.getAID() + ", " + this.audioSink);
        }
        if (null != gL && -2 != this.getVID()) {
            int n4;
            n = 6408;
            switch (this.vBytesPerPixelPerPlane) {
                case 1: {
                    if (gL.isGL3ES3()) {
                        n4 = 6403;
                        n = 6403;
                        this.singleTexComp = "r";
                        break;
                    }
                    n4 = 6406;
                    n = 6406;
                    this.singleTexComp = "a";
                    break;
                }
                case 2: {
                    if (this.vPixelFmt == VideoPixelFormat.YUYV422 || this.vPixelFmt == VideoPixelFormat.UYVY422) {
                        n4 = 6408;
                        n = 6408;
                        break;
                    }
                    n4 = 33319;
                    n = 33319;
                    break;
                }
                case 3: {
                    n4 = 6407;
                    n = 6407;
                    break;
                }
                case 4: {
                    if (this.vPixelFmt == VideoPixelFormat.BGRA) {
                        n4 = 32993;
                        n = 6408;
                        break;
                    }
                    n4 = 6408;
                    n = 6408;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported bytes-per-pixel / plane " + this.vBytesPerPixelPerPlane);
                }
            }
            this.setTextureFormat(n, n4);
            this.setTextureType(5121);
            this.setIsGLOriented(false);
            if (DEBUG) {
                System.err.println("initGL: p5: video " + (Object)((Object)this.vPixelFmt) + ", planes " + this.vPlanes + ", bpp " + this.vBitsPerPixel + "/" + this.vBytesPerPixelPerPlane + ", tex " + this.texWidth + "x" + this.texHeight + ", usesTexLookupShader " + this.usesTexLookupShader);
            }
        }
    }

    @Override
    protected final TextureSequence.TextureFrame createTexImage(GL gL, int n) {
        return new TextureSequence.TextureFrame(this.createTexImageImpl(gL, n, this.texWidth, this.texHeight));
    }

    final boolean isAudioFormatSupported(int n, int n2, int n3) {
        AudioSampleFormat audioSampleFormat = AudioSampleFormat.valueOf(n);
        AudioFormat audioFormat = this.avAudioFormat2Local(audioSampleFormat, n2, n3);
        boolean bl = this.audioSink.isSupported(audioFormat);
        if (DEBUG) {
            System.err.println("AudioSink.isSupported: " + bl + ": av[fmt " + (Object)((Object)audioSampleFormat) + ", rate " + n2 + ", chan " + n3 + "] -> " + audioFormat);
        }
        return bl;
    }

    private final AudioFormat avAudioFormat2Local(AudioSampleFormat audioSampleFormat, int n, int n2) {
        boolean bl;
        int n3;
        boolean bl2 = true;
        boolean bl3 = true;
        switch (audioSampleFormat) {
            case S32: {
                bl2 = false;
            }
            case S32P: {
                n3 = 32;
                bl = true;
                break;
            }
            case S16: {
                bl2 = false;
            }
            case S16P: {
                n3 = 16;
                bl = true;
                break;
            }
            case U8: {
                bl2 = false;
            }
            case U8P: {
                n3 = 8;
                bl = false;
                break;
            }
            case DBL: {
                bl2 = false;
            }
            case DBLP: {
                n3 = 64;
                bl = true;
                bl3 = false;
                break;
            }
            case FLT: {
                bl2 = false;
            }
            case FLTP: {
                n3 = 32;
                bl = true;
                bl3 = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported sampleformat: " + (Object)((Object)audioSampleFormat));
            }
        }
        return new AudioFormat(n, n3, n2, bl, bl3, bl2, true);
    }

    void setupFFAttributes(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        AudioSampleFormat audioSampleFormat;
        this.vPixelFmt = null;
        this.vPlanes = 0;
        this.vBitsPerPixel = 0;
        this.vBytesPerPixelPerPlane = 0;
        this.usesTexLookupShader = false;
        this.texWidth = 0;
        this.texHeight = 0;
        int[] nArray = new int[]{0, 0, 0};
        if (-2 != n) {
            this.vPixelFmt = VideoPixelFormat.valueOf(n2);
            this.vPlanes = n3;
            this.vBitsPerPixel = n4;
            this.vBytesPerPixelPerPlane = n5;
            nArray[0] = n6;
            nArray[1] = n7;
            nArray[2] = n8;
            switch (this.vPixelFmt) {
                case YUVJ420P: 
                case YUV420P: {
                    this.usesTexLookupShader = true;
                    this.texWidth = nArray[0] + nArray[1];
                    this.texHeight = n10;
                    break;
                }
                case YUVJ422P: 
                case YUV422P: {
                    this.usesTexLookupShader = true;
                    this.texWidth = nArray[0] + nArray[1] + nArray[2];
                    this.texHeight = n10;
                    break;
                }
                case YUYV422: 
                case UYVY422: 
                case BGR24: {
                    this.usesTexLookupShader = true;
                    this.texWidth = nArray[0];
                    this.texHeight = n10;
                    break;
                }
                case RGB24: 
                case ARGB: 
                case RGBA: 
                case ABGR: 
                case BGRA: {
                    this.usesTexLookupShader = false;
                    this.texWidth = nArray[0];
                    this.texHeight = n10;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported pixelformat: " + (Object)((Object)this.vPixelFmt));
                }
            }
        }
        this.avChosenAudioFormat = null;
        this.audioSamplesPerFrameAndChannel = 0;
        if (-2 != n11) {
            audioSampleFormat = AudioSampleFormat.valueOf(n12);
            this.avChosenAudioFormat = this.avAudioFormat2Local(audioSampleFormat, n13, n14);
            this.audioSamplesPerFrameAndChannel = n15;
        } else {
            audioSampleFormat = null;
        }
        if (DEBUG) {
            System.err.println("audio: id " + n11 + ", fmt " + (Object)((Object)audioSampleFormat) + ", " + this.avChosenAudioFormat + ", aFrameSize/fc " + n15);
            System.err.println("video: id " + n + ", fmt " + n9 + "x" + n10 + ", " + (Object)((Object)this.vPixelFmt) + ", planes " + this.vPlanes + ", bpp " + this.vBitsPerPixel + "/" + this.vBytesPerPixelPerPlane + ", usesTexLookupShader " + this.usesTexLookupShader);
            for (int i = 0; i < 3; ++i) {
                System.err.println("video: p[" + i + "]: " + nArray[i]);
            }
            System.err.println("video: total tex " + this.texWidth + "x" + this.texHeight);
            System.err.println(this.toString());
        }
    }

    void updateVidAttributes(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
    }

    @Override
    public String setTextureLookupFunctionName(String string) throws IllegalStateException {
        if (this.usesTexLookupShader) {
            this.textureLookupFunctionName = null != string && string.length() > 0 ? string : "ffmpegTexture2D";
            return this.textureLookupFunctionName;
        }
        return super.getTextureLookupFunctionName();
    }

    @Override
    public final String getTextureLookupFragmentShaderImpl() {
        if (!this.usesTexLookupShader) {
            return super.getTextureLookupFragmentShaderImpl();
        }
        float f = (float)this.getWidth() / (float)this.texWidth;
        switch (this.vPixelFmt) {
            case YUVJ420P: 
            case YUV420P: {
                return "vec4 " + this.getTextureLookupFunctionName() + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n  const vec2 u_off = vec2(" + f + ", 0.0);\n  const vec2 v_off = vec2(" + f + ", 0.5);\n  vec2 tc_half = texCoord*0.5;\n  float y,u,v,r,g,b;\n  y = texture2D(image, texCoord)." + this.singleTexComp + ";\n  u = texture2D(image, u_off+tc_half)." + this.singleTexComp + ";\n  v = texture2D(image, v_off+tc_half)." + this.singleTexComp + ";\n  y = 1.1643*(y-0.0625);\n  u = u-0.5;\n  v = v-0.5;\n  r = y+1.5958*v;\n  g = y-0.39173*u-0.81290*v;\n  b = y+2.017*u;\n  return vec4(r, g, b, 1);\n}\n";
            }
            case YUVJ422P: 
            case YUV422P: {
                return "vec4 " + this.getTextureLookupFunctionName() + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n  const vec2 u_off = vec2(" + f + "      , 0.0);\n  const vec2 v_off = vec2(" + f + " * 1.5, 0.0);\n  vec2 tc_halfw = vec2(texCoord.x*0.5, texCoord.y);\n  float y,u,v,r,g,b;\n  y = texture2D(image, texCoord)." + this.singleTexComp + ";\n  u = texture2D(image, u_off+tc_halfw)." + this.singleTexComp + ";\n  v = texture2D(image, v_off+tc_halfw)." + this.singleTexComp + ";\n  y = 1.1643*(y-0.0625);\n  u = u-0.5;\n  v = v-0.5;\n  r = y+1.5958*v;\n  g = y-0.39173*u-0.81290*v;\n  b = y+2.017*u;\n  return vec4(r, g, b, 1);\n}\n";
            }
            case YUYV422: {
                return "vec4 " + this.getTextureLookupFunctionName() + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n    float y1,u,y2,v,y,r,g,b;\n  vec2 tc_halfw = vec2(texCoord.x*0.5, texCoord.y);\n  vec4 yuyv = texture2D(image, tc_halfw).rgba;\n  y1 = yuyv.r;\n  u  = yuyv.g;\n  y2 = yuyv.b;\n  v  = yuyv.a;\n  y = mix( y1, y2, mod(gl_FragCoord.x, 2) ); /* avoid branching! */\n  y = 1.1643*(y-0.0625);\n  u = u-0.5;\n  v = v-0.5;\n  r = y+1.5958*v;\n  g = y-0.39173*u-0.81290*v;\n  b = y+2.017*u;\n  return vec4(r, g, b, 1);\n}\n";
            }
            case UYVY422: {
                return "vec4 " + this.getTextureLookupFunctionName() + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n    float y1,u,y2,v,y,r,g,b;\n  vec2 tc_halfw = vec2(texCoord.x*0.5, texCoord.y);\n  vec4 uyvy = texture2D(image, tc_halfw).rgba;\n  u  = uyvy.r;\n  y1 = uyvy.g;\n  v  = uyvy.b;\n  y2 = uyvy.a;\n  y = mix( y1, y2, mod(gl_FragCoord.x, 2) ); /* avoid branching! */\n  y = 1.1643*(y-0.0625);\n  u = u-0.5;\n  v = v-0.5;\n  r = y+1.5958*v;\n  g = y-0.39173*u-0.81290*v;\n  b = y+2.017*u;\n  return vec4(r, g, b, 1);\n}\n";
            }
            case BGR24: {
                return "vec4 " + this.getTextureLookupFunctionName() + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n    vec3 bgr = texture2D(image, texCoord).rgb;\n  return vec4(bgr.b, bgr.g, bgr.r, 1);\n}\n";
            }
        }
        throw new InternalError("Add proper mapping of: vPixelFmt " + (Object)((Object)this.vPixelFmt) + ", usesTexLookupShader " + this.usesTexLookupShader);
    }

    @Override
    public final boolean resumeImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        int n = natives.play0(this.moviePtr);
        if (DEBUG_NATIVE && n != 0 && n != -38) {
            System.err.println("ffmpeg play err: " + n);
        }
        return true;
    }

    @Override
    public final boolean pauseImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        int n = natives.pause0(this.moviePtr);
        if (DEBUG_NATIVE && n != 0 && n != -38) {
            System.err.println("ffmpeg pause err: " + n);
        }
        return true;
    }

    @Override
    protected final synchronized int seekImpl(int n) {
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        return natives.seek0(this.moviePtr, n);
    }

    @Override
    protected void preNextTextureImpl(GL gL) {
        this.psm.setUnpackAlignment(gL, 1);
        gL.glActiveTexture(33984 + this.getTextureUnit());
    }

    @Override
    protected void postNextTextureImpl(GL gL) {
        this.psm.restore(gL);
    }

    @Override
    protected final int getNextTextureImpl(GL gL, TextureSequence.TextureFrame textureFrame) {
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        int n = Integer.MIN_VALUE;
        if (null != gL) {
            Texture texture = textureFrame.getTexture();
            texture.enable(gL);
            texture.bind(gL);
        }
        for (int i = 0; Integer.MIN_VALUE == n && 10 > i; ++i) {
            n = natives.readNextPacket0(this.moviePtr, this.getTextureTarget(), this.getTextureFormat(), this.getTextureType());
        }
        if (null != textureFrame) {
            textureFrame.setPTS(n);
        }
        return n;
    }

    final void pushSound(ByteBuffer byteBuffer, int n, int n2) {
        this.setFirstAudioPTS2SCR(n2);
        if (1.0f == this.getPlaySpeed() || this.audioSinkPlaySpeedSet) {
            this.audioSink.enqueueData(n2, byteBuffer, n);
        }
    }

    static {
        boolean bl;
        String string = PropertyAccess.getProperty("jogl.ffmpeg.lib", true);
        PREFER_SYSTEM_LIBS = null == string || !string.equals("internal");
        boolean bl2 = FFMPEGDynamicLibraryBundleInfo.initSingleton();
        if (FFMPEGDynamicLibraryBundleInfo.libsLoaded()) {
            natives = FFMPEGDynamicLibraryBundleInfo.getNatives();
            if (null != natives) {
                avCodecMajorVersionCC = natives.getAvCodecMajorVersionCC0();
                avFormatMajorVersionCC = natives.getAvFormatMajorVersionCC0();
                avUtilMajorVersionCC = natives.getAvUtilMajorVersionCC0();
                avDeviceMajorVersionCC = natives.getAvDeviceMajorVersionCC0();
                swResampleMajorVersionCC = natives.getSwResampleMajorVersionCC0();
            } else {
                avUtilMajorVersionCC = 0;
                avFormatMajorVersionCC = 0;
                avCodecMajorVersionCC = 0;
                avDeviceMajorVersionCC = 0;
                swResampleMajorVersionCC = 0;
            }
            VersionNumber versionNumber = FFMPEGDynamicLibraryBundleInfo.avCodecVersion;
            VersionNumber versionNumber2 = FFMPEGDynamicLibraryBundleInfo.avFormatVersion;
            VersionNumber versionNumber3 = FFMPEGDynamicLibraryBundleInfo.avUtilVersion;
            VersionNumber versionNumber4 = FFMPEGDynamicLibraryBundleInfo.avDeviceVersion;
            VersionNumber versionNumber5 = FFMPEGDynamicLibraryBundleInfo.swResampleVersion;
            boolean bl3 = FFMPEGDynamicLibraryBundleInfo.avDeviceLoaded();
            boolean bl4 = FFMPEGDynamicLibraryBundleInfo.swResampleLoaded();
            int n = versionNumber.getMajor();
            int n2 = versionNumber2.getMajor();
            int n3 = versionNumber3.getMajor();
            int n4 = versionNumber4.getMajor();
            int n5 = versionNumber5.getMajor();
            boolean bl5 = bl = avCodecMajorVersionCC == n && avFormatMajorVersionCC == n2 && avUtilMajorVersionCC == n3 && (avDeviceMajorVersionCC == n4 || 0 == n4) && swResampleMajorVersionCC == n5;
            if (!bl) {
                System.err.println("FFmpeg Not Matching Compile-Time / Runtime Major-Version");
            }
            if (!bl || DEBUG) {
                System.err.println("FFmpeg Codec   : " + versionNumber + " [cc " + avCodecMajorVersionCC + "]");
                System.err.println("FFmpeg Format  : " + versionNumber2 + " [cc " + avFormatMajorVersionCC + "]");
                System.err.println("FFmpeg Util    : " + versionNumber3 + " [cc " + avUtilMajorVersionCC + "]");
                System.err.println("FFmpeg Device  : " + versionNumber4 + " [cc " + avDeviceMajorVersionCC + ", loaded " + bl3 + "]");
                System.err.println("FFmpeg Resample: " + versionNumber5 + " [cc " + swResampleMajorVersionCC + ", loaded " + bl4 + "]");
                System.err.println("FFmpeg Class   : " + (null != natives ? natives.getClass().getSimpleName() : "n/a"));
            }
        } else {
            natives = null;
            avUtilMajorVersionCC = 0;
            avFormatMajorVersionCC = 0;
            avCodecMajorVersionCC = 0;
            avDeviceMajorVersionCC = 0;
            swResampleMajorVersionCC = 0;
            bl = false;
        }
        available = bl2 && bl && null != natives;
    }
}

