/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.api.JCodecException;
import org.jcodec.api.MediaInfo;
import org.jcodec.api.UnsupportedFormatException;
import org.jcodec.api.specific.AVCMP4Adaptor;
import org.jcodec.api.specific.ContainerAdaptor;
import org.jcodec.common.DemuxerTrack;
import org.jcodec.common.DemuxerTrackMeta;
import org.jcodec.common.Format;
import org.jcodec.common.JCodecUtil;
import org.jcodec.common.SeekableDemuxerTrack;
import org.jcodec.common.io.FileChannelWrapper;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Picture;
import org.jcodec.containers.mp4.demuxer.MP4Demuxer;

@Deprecated
public class FrameGrab {
    private SeekableDemuxerTrack videoTrack;
    private ContainerAdaptor decoder;
    private ThreadLocal<int[][]> buffers;

    private static int _detectKeyFrame(DemuxerTrack videoTrack, int start) throws IOException {
        int[] seekFrames = videoTrack.getMeta().getSeekFrames();
        if (seekFrames == null) {
            return start;
        }
        int prev = seekFrames[0];
        for (int i = 1; i < seekFrames.length && seekFrames[i] <= start; ++i) {
            prev = seekFrames[i];
        }
        return prev;
    }

    private static ContainerAdaptor _detectDecoder(SeekableDemuxerTrack sdt, Packet frame) throws JCodecException {
        DemuxerTrackMeta meta = sdt.getMeta();
        switch (meta.getCodec()) {
            case H264: {
                return new AVCMP4Adaptor(meta);
            }
        }
        throw new UnsupportedFormatException("Codec is not supported");
    }

    static ContainerAdaptor detectDecoder(SeekableDemuxerTrack sdt) throws IOException, JCodecException {
        int curFrame = (int)sdt.getCurFrame();
        int keyFrame = FrameGrab._detectKeyFrame(sdt, curFrame);
        sdt.gotoFrame(keyFrame);
        Packet frame = sdt.nextFrame();
        ContainerAdaptor decoder = FrameGrab._detectDecoder(sdt, frame);
        return decoder;
    }

    public static FrameGrab createFrameGrab(SeekableByteChannel _in) throws IOException, JCodecException {
        ByteBuffer header = ByteBuffer.allocate(65536);
        _in.read(header);
        header.flip();
        Format detectFormat = JCodecUtil.detectFormatBuffer(header);
        SeekableDemuxerTrack videoTrack = null;
        switch (detectFormat) {
            case MOV: {
                MP4Demuxer d1 = new MP4Demuxer(_in);
                videoTrack = (SeekableDemuxerTrack)d1.getVideoTrack();
                break;
            }
            case MPEG_PS: {
                throw new UnsupportedFormatException("MPEG PS is temporarily unsupported.");
            }
            case MPEG_TS: {
                throw new UnsupportedFormatException("MPEG TS is temporarily unsupported.");
            }
            default: {
                throw new UnsupportedFormatException("Container format is not supported by JCodec");
            }
        }
        return new FrameGrab(videoTrack, FrameGrab.detectDecoder(videoTrack));
    }

    public FrameGrab(SeekableDemuxerTrack videoTrack, ContainerAdaptor decoder) {
        if (decoder == null || videoTrack == null) {
            throw new NullPointerException();
        }
        this.buffers = new ThreadLocal();
        this.videoTrack = videoTrack;
        this.decoder = decoder;
    }

    private SeekableDemuxerTrack sdt() throws JCodecException {
        if (!(this.videoTrack instanceof SeekableDemuxerTrack)) {
            throw new JCodecException("Not a seekable track");
        }
        return this.videoTrack;
    }

    public FrameGrab seekToSecondPrecise(double second) throws IOException, JCodecException {
        this.sdt().seek(second);
        this.decodeLeadingFrames();
        return this;
    }

    public FrameGrab seekToFramePrecise(int frameNumber) throws IOException, JCodecException {
        this.sdt().gotoFrame(frameNumber);
        this.decodeLeadingFrames();
        return this;
    }

    public FrameGrab seekToSecondSloppy(double second) throws IOException, JCodecException {
        this.sdt().seek(second);
        this.goToPrevKeyframe();
        return this;
    }

    public FrameGrab seekToFrameSloppy(int frameNumber) throws IOException, JCodecException {
        this.sdt().gotoFrame(frameNumber);
        this.goToPrevKeyframe();
        return this;
    }

    private void goToPrevKeyframe() throws IOException, JCodecException {
        this.sdt().gotoFrame(this.detectKeyFrame((int)this.sdt().getCurFrame()));
    }

    private void decodeLeadingFrames() throws IOException, JCodecException {
        SeekableDemuxerTrack sdt = this.sdt();
        int curFrame = (int)sdt.getCurFrame();
        int keyFrame = this.detectKeyFrame(curFrame);
        sdt.gotoFrame(keyFrame);
        Packet frame = sdt.nextFrame();
        while (frame.getFrameNo() < (long)curFrame) {
            this.decoder.decodeFrame(frame, this.getBuffer());
            frame = sdt.nextFrame();
        }
        sdt.gotoFrame(curFrame);
    }

    private int[][] getBuffer() {
        int[][] buf = this.buffers.get();
        if (buf == null) {
            buf = this.decoder.allocatePicture();
            this.buffers.set(buf);
        }
        return buf;
    }

    private int detectKeyFrame(int start) throws IOException {
        int[] seekFrames = this.videoTrack.getMeta().getSeekFrames();
        if (seekFrames == null) {
            return start;
        }
        int prev = seekFrames[0];
        for (int i = 1; i < seekFrames.length && seekFrames[i] <= start; ++i) {
            prev = seekFrames[i];
        }
        return prev;
    }

    public Picture getNativeFrame() throws IOException {
        Packet frame = this.videoTrack.nextFrame();
        if (frame == null) {
            return null;
        }
        return this.decoder.decodeFrame(frame, this.getBuffer());
    }

    public MediaInfo getMediaInfo() {
        return this.decoder.getMediaInfo();
    }

    public static Picture getFrameFromChannel(SeekableByteChannel file, int frameNumber) throws JCodecException, IOException {
        return FrameGrab.createFrameGrab(file).seekToFramePrecise(frameNumber).getNativeFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Picture getFrameFromFile(File file, int frameNumber) throws IOException, JCodecException {
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.readableChannel(file);
            Picture picture = FrameGrab.createFrameGrab(ch).seekToFramePrecise(frameNumber).getNativeFrame();
            return picture;
        }
        finally {
            NIOUtils.closeQuietly(ch);
        }
    }

    public static Picture getFrameAtSecFromChannel(SeekableByteChannel file, double second) throws JCodecException, IOException {
        return FrameGrab.createFrameGrab(file).seekToSecondPrecise(second).getNativeFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Picture getFrameAtSec(File file, double second) throws IOException, JCodecException {
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.readableChannel(file);
            Picture picture = FrameGrab.createFrameGrab(ch).seekToSecondPrecise(second).getNativeFrame();
            return picture;
        }
        finally {
            NIOUtils.closeQuietly(ch);
        }
    }

    public SeekableDemuxerTrack getVideoTrack() {
        return this.videoTrack;
    }

    public ContainerAdaptor getDecoder() {
        return this.decoder;
    }
}

