/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.api.JCodecException;
import org.jcodec.api.MediaInfo;
import org.jcodec.api.PictureWithMetadata8Bit;
import org.jcodec.api.UnsupportedFormatException;
import org.jcodec.api.specific.AVCMP4Adaptor;
import org.jcodec.api.specific.ContainerAdaptor;
import org.jcodec.common.DemuxerTrackMeta;
import org.jcodec.common.Format;
import org.jcodec.common.JCodecUtil;
import org.jcodec.common.SeekableDemuxerTrack;
import org.jcodec.common.io.FileChannelWrapper;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Picture8Bit;
import org.jcodec.containers.mp4.demuxer.MP4Demuxer;

public class FrameGrab8Bit {
    private SeekableDemuxerTrack videoTrack;
    private ContainerAdaptor decoder;
    private ThreadLocal<byte[][]> buffers;

    public static FrameGrab8Bit createFrameGrab8Bit(SeekableByteChannel _in) throws IOException, JCodecException {
        SeekableDemuxerTrack videoTrack_;
        ByteBuffer header = ByteBuffer.allocate(65536);
        _in.read(header);
        header.flip();
        Format detectFormat = JCodecUtil.detectFormatBuffer(header);
        switch (detectFormat) {
            case MOV: {
                MP4Demuxer d1 = new MP4Demuxer(_in);
                videoTrack_ = (SeekableDemuxerTrack)d1.getVideoTrack();
                break;
            }
            case MPEG_PS: {
                throw new UnsupportedFormatException("MPEG PS is temporarily unsupported.");
            }
            case MPEG_TS: {
                throw new UnsupportedFormatException("MPEG TS is temporarily unsupported.");
            }
            default: {
                throw new UnsupportedFormatException("Container format is not supported by JCodec");
            }
        }
        FrameGrab8Bit fg = new FrameGrab8Bit(videoTrack_, FrameGrab8Bit.detectDecoder(videoTrack_));
        fg.decodeLeadingFrames();
        return fg;
    }

    public FrameGrab8Bit(SeekableDemuxerTrack videoTrack, ContainerAdaptor decoder) {
        this.videoTrack = videoTrack;
        this.decoder = decoder;
        this.buffers = new ThreadLocal();
    }

    private SeekableDemuxerTrack sdt() throws JCodecException {
        if (!(this.videoTrack instanceof SeekableDemuxerTrack)) {
            throw new JCodecException("Not a seekable track");
        }
        return this.videoTrack;
    }

    public FrameGrab8Bit seekToSecondPrecise(double second) throws IOException, JCodecException {
        this.sdt().seek(second);
        this.decodeLeadingFrames();
        return this;
    }

    public FrameGrab8Bit seekToFramePrecise(int frameNumber) throws IOException, JCodecException {
        this.sdt().gotoFrame(frameNumber);
        this.decodeLeadingFrames();
        return this;
    }

    public FrameGrab8Bit seekToSecondSloppy(double second) throws IOException, JCodecException {
        this.sdt().seek(second);
        this.goToPrevKeyframe();
        return this;
    }

    public FrameGrab8Bit seekToFrameSloppy(int frameNumber) throws IOException, JCodecException {
        this.sdt().gotoFrame(frameNumber);
        this.goToPrevKeyframe();
        return this;
    }

    private void goToPrevKeyframe() throws IOException, JCodecException {
        this.sdt().gotoFrame(this.detectKeyFrame((int)this.sdt().getCurFrame()));
    }

    private void decodeLeadingFrames() throws IOException, JCodecException {
        SeekableDemuxerTrack sdt = this.sdt();
        int curFrame = (int)sdt.getCurFrame();
        int keyFrame = this.detectKeyFrame(curFrame);
        sdt.gotoFrame(keyFrame);
        Packet frame = sdt.nextFrame();
        if (this.decoder == null) {
            this.decoder = FrameGrab8Bit.detectDecoder(sdt);
        }
        while (frame.getFrameNo() < (long)curFrame) {
            this.decoder.decodeFrame8Bit(frame, this.getBuffer());
            frame = sdt.nextFrame();
        }
        sdt.gotoFrame(curFrame);
    }

    private byte[][] getBuffer() {
        byte[][] buf = this.buffers.get();
        if (buf == null) {
            buf = this.decoder.allocatePicture8Bit();
            this.buffers.set(buf);
        }
        return buf;
    }

    private int detectKeyFrame(int start) throws IOException {
        int[] seekFrames = this.videoTrack.getMeta().getSeekFrames();
        if (seekFrames == null) {
            return start;
        }
        int prev = seekFrames[0];
        for (int i = 1; i < seekFrames.length && seekFrames[i] <= start; ++i) {
            prev = seekFrames[i];
        }
        return prev;
    }

    private static ContainerAdaptor detectDecoder(SeekableDemuxerTrack videoTrack) throws JCodecException {
        DemuxerTrackMeta meta = videoTrack.getMeta();
        switch (meta.getCodec()) {
            case H264: {
                return new AVCMP4Adaptor(meta);
            }
        }
        throw new UnsupportedFormatException("Codec is not supported");
    }

    public PictureWithMetadata8Bit getNativeFrameWithMetadata() throws IOException {
        Packet frame = this.videoTrack.nextFrame();
        if (frame == null) {
            return null;
        }
        Picture8Bit picture = this.decoder.decodeFrame8Bit(frame, this.getBuffer());
        return new PictureWithMetadata8Bit(picture, frame.getPtsD(), frame.getDurationD());
    }

    public Picture8Bit getNativeFrame() throws IOException {
        Packet frame = this.videoTrack.nextFrame();
        if (frame == null) {
            return null;
        }
        return this.decoder.decodeFrame8Bit(frame, this.getBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Picture8Bit getFrameAtSec(File file, double second) throws IOException, JCodecException {
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.readableChannel(file);
            Picture8Bit picture8Bit = FrameGrab8Bit.createFrameGrab8Bit(ch).seekToSecondPrecise(second).getNativeFrame();
            return picture8Bit;
        }
        finally {
            NIOUtils.closeQuietly(ch);
        }
    }

    public static Picture8Bit getFrameFromChannelAtSec(SeekableByteChannel file, double second) throws JCodecException, IOException {
        return FrameGrab8Bit.createFrameGrab8Bit(file).seekToSecondPrecise(second).getNativeFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Picture8Bit getFrameFromFile(File file, int frameNumber) throws IOException, JCodecException {
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.readableChannel(file);
            Picture8Bit picture8Bit = FrameGrab8Bit.createFrameGrab8Bit(ch).seekToFramePrecise(frameNumber).getNativeFrame();
            return picture8Bit;
        }
        finally {
            NIOUtils.closeQuietly(ch);
        }
    }

    public static Picture8Bit getFrameFromChannel(SeekableByteChannel file, int frameNumber) throws JCodecException, IOException {
        return FrameGrab8Bit.createFrameGrab8Bit(file).seekToFramePrecise(frameNumber).getNativeFrame();
    }

    public static Picture8Bit getNativeFrameAtFrame(SeekableDemuxerTrack vt, ContainerAdaptor decoder, int frameNumber) throws IOException, JCodecException {
        return new FrameGrab8Bit(vt, decoder).seekToFramePrecise(frameNumber).getNativeFrame();
    }

    public static Picture8Bit getNativeFrameAtSec(SeekableDemuxerTrack vt, ContainerAdaptor decoder, double second) throws IOException, JCodecException {
        return new FrameGrab8Bit(vt, decoder).seekToSecondPrecise(second).getNativeFrame();
    }

    public static Picture8Bit getNativeFrameSloppy(SeekableDemuxerTrack vt, ContainerAdaptor decoder, int frameNumber) throws IOException, JCodecException {
        return new FrameGrab8Bit(vt, decoder).seekToFrameSloppy(frameNumber).getNativeFrame();
    }

    public static Picture8Bit getNativeFrameAtSecSloppy(SeekableDemuxerTrack vt, ContainerAdaptor decoder, double second) throws IOException, JCodecException {
        return new FrameGrab8Bit(vt, decoder).seekToSecondSloppy(second).getNativeFrame();
    }

    public MediaInfo getMediaInfo() {
        return this.decoder.getMediaInfo();
    }

    public SeekableDemuxerTrack getVideoTrack() {
        return this.videoTrack;
    }

    public ContainerAdaptor getDecoder() {
        return this.decoder;
    }
}

