/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.codecs.h264.H264Encoder;
import org.jcodec.common.Codec;
import org.jcodec.common.MuxerTrack;
import org.jcodec.common.VideoCodecMeta;
import org.jcodec.common.VideoEncoder;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.Brand;
import org.jcodec.containers.mp4.muxer.MP4Muxer;
import org.jcodec.scale.ColorUtil;
import org.jcodec.scale.Transform;

@Deprecated
public class SequenceEncoder {
    private SeekableByteChannel ch;
    private Picture toEncode;
    private Transform transform;
    private H264Encoder encoder;
    private MuxerTrack outTrack;
    private ByteBuffer _out;
    private int frameNo;
    private MP4Muxer muxer;
    private ByteBuffer sps;
    private ByteBuffer pps;

    public static SequenceEncoder createSequenceEncoder(File out) throws IOException {
        return new SequenceEncoder(NIOUtils.writableChannel(out));
    }

    public SequenceEncoder(SeekableByteChannel ch) throws IOException {
        this.ch = ch;
        this.muxer = MP4Muxer.createMP4Muxer(ch, Brand.MP4);
        this._out = ByteBuffer.allocate(12441600);
        this.encoder = H264Encoder.createH264Encoder();
        this.transform = ColorUtil.getTransform(ColorSpace.RGB, this.encoder.getSupportedColorSpaces()[0]);
    }

    public void encodeNativeFrame(Picture pic) throws IOException {
        if (this.toEncode == null) {
            this.toEncode = Picture.create(pic.getWidth(), pic.getHeight(), this.encoder.getSupportedColorSpaces()[0]);
        }
        if (this.outTrack == null) {
            this.outTrack = this.muxer.addVideoTrack(Codec.H264, new VideoCodecMeta(new Size(pic.getWidth(), pic.getHeight()), pic.getColor()));
        }
        this.transform.transform(pic, this.toEncode);
        this._out.clear();
        VideoEncoder.EncodedFrame ef = this.encoder.encodeFrame(this.toEncode, this._out);
        ByteBuffer result = ef.getData();
        this.outTrack.addFrame(Packet.createPacket(result, this.frameNo, 25, 1L, this.frameNo, ef.isKeyFrame() ? Packet.FrameType.KEY : Packet.FrameType.INTER, null));
        ++this.frameNo;
    }

    public H264Encoder getEncoder() {
        return this.encoder;
    }

    public void finish() throws IOException {
        this.muxer.finish();
        NIOUtils.closeQuietly(this.ch);
    }
}

