/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api.transcode;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.jaad.aac.AACException;
import org.jcodec.api.transcode.filters.ColorTransformFilter;
import org.jcodec.codecs.aac.AACDecoder;
import org.jcodec.codecs.h264.BufferH264ES;
import org.jcodec.codecs.h264.H264Decoder;
import org.jcodec.codecs.h264.H264Encoder;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.mjpeg.JpegDecoder;
import org.jcodec.codecs.mpeg12.MPEGDecoder;
import org.jcodec.codecs.png.PNGDecoder;
import org.jcodec.codecs.png.PNGEncoder;
import org.jcodec.codecs.prores.ProresDecoder;
import org.jcodec.codecs.prores.ProresEncoder;
import org.jcodec.codecs.raw.RAWVideoDecoder;
import org.jcodec.codecs.vpx.IVFMuxer;
import org.jcodec.codecs.vpx.VP8Decoder;
import org.jcodec.codecs.vpx.VP8Encoder;
import org.jcodec.codecs.wav.WavDemuxer;
import org.jcodec.codecs.wav.WavMuxer;
import org.jcodec.common.AudioCodecMeta;
import org.jcodec.common.AudioDecoder;
import org.jcodec.common.AudioEncoder;
import org.jcodec.common.AudioFormat;
import org.jcodec.common.Codec;
import org.jcodec.common.Demuxer;
import org.jcodec.common.DemuxerTrack;
import org.jcodec.common.DemuxerTrackMeta;
import org.jcodec.common.Format;
import org.jcodec.common.Muxer;
import org.jcodec.common.MuxerTrack;
import org.jcodec.common.SeekableDemuxerTrack;
import org.jcodec.common.Tuple;
import org.jcodec.common.VideoCodecMeta;
import org.jcodec.common.VideoDecoder;
import org.jcodec.common.VideoEncoder;
import org.jcodec.common.io.IOUtils;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.AudioBuffer;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Picture8Bit;
import org.jcodec.common.model.Size;
import org.jcodec.containers.imgseq.ImageSequenceDemuxer;
import org.jcodec.containers.imgseq.ImageSequenceMuxer;
import org.jcodec.containers.mkv.demuxer.MKVDemuxer;
import org.jcodec.containers.mkv.muxer.MKVMuxer;
import org.jcodec.containers.mp4.demuxer.MP4Demuxer;
import org.jcodec.containers.mp4.muxer.MP4Muxer;
import org.jcodec.containers.mps.MPEGDemuxer;
import org.jcodec.containers.mps.MPSDemuxer;
import org.jcodec.containers.mps.MTSDemuxer;
import org.jcodec.containers.webp.WebpDemuxer;
import org.jcodec.containers.y4m.Y4MDemuxer;

public class Transcoder {
    private static final int REORDER_BUFFER_SIZE = 7;
    private ThreadLocal<Picture8Bit> pixelBufferStore = new ThreadLocal();
    private ThreadLocal<ByteBuffer> bufferStore = new ThreadLocal();
    private Format inputFormat;
    private Format outputFormat;
    private Tuple._3<Integer, Integer, Codec> inputVideoCodec;
    private Codec outputVideoCodec;
    private Tuple._3<Integer, Integer, Codec> inputAudioCodec;
    private Codec outputAudioCodec;
    private int seekFrames;
    private int maxFrames;
    private String sourceName;
    private String destName;
    private boolean videoCodecCopy;
    private boolean audioCodecCopy;
    private List<Filter> extraFilters;
    private SeekableByteChannel sourceStream;
    private SeekableByteChannel destStream;
    private Demuxer demuxVideo;
    private Demuxer demuxAudio;
    private Muxer muxer;
    private MuxerTrack videoOutputTrack;
    private DemuxerTrack videoInputTrack;
    private DemuxerTrack audioInputTrack;
    private MuxerTrack audioOutputTrack;
    private AudioDecoder audioDecoder;
    private AudioEncoder audioEncoder;
    private VideoDecoder videoDecoder;
    private VideoEncoder videoEncoder;
    private String profile;
    private Boolean interlaced;
    private Integer downscale;
    private VideoCodecMeta videoCool;
    private List<Filter> filters = new ArrayList<Filter>();
    private boolean framesOutput;

    public Transcoder(String sourceName, String destName, Format inputFormat, Format outputFormat, Tuple._3<Integer, Integer, Codec> inputVideoCodec, Codec outputVideoCodec, Tuple._3<Integer, Integer, Codec> inputAudioCodec, Codec outputAudioCodec, boolean videoCodecCopy, boolean audioCodecCopy, List<Filter> extraFilters) {
        this.sourceName = sourceName;
        this.destName = destName;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.inputVideoCodec = inputVideoCodec;
        this.outputVideoCodec = outputVideoCodec;
        this.inputAudioCodec = inputAudioCodec;
        this.outputAudioCodec = outputAudioCodec;
        this.videoCodecCopy = videoCodecCopy;
        this.audioCodecCopy = audioCodecCopy;
        this.extraFilters = extraFilters;
        if (!outputFormat.isVideo()) {
            this.inputVideoCodec = null;
            this.outputVideoCodec = null;
        }
        if (!outputFormat.isAudio()) {
            this.inputAudioCodec = null;
            this.outputAudioCodec = null;
        }
    }

    public Format getInputFormat() {
        return this.inputFormat;
    }

    public Format getOutputFormat() {
        return this.outputFormat;
    }

    public Tuple._3<Integer, Integer, Codec> getIntputVideoCodec() {
        return this.inputVideoCodec;
    }

    public Codec getOutputVideoCodec() {
        return this.outputVideoCodec;
    }

    public Tuple._3<Integer, Integer, Codec> getInputAudioCode() {
        return this.inputAudioCodec;
    }

    public Codec getOutputAudioCodec() {
        return this.outputAudioCodec;
    }

    public int getSeekFrames() {
        return this.seekFrames;
    }

    public void setSeekFrames(int seekFrames) {
        this.seekFrames = seekFrames;
    }

    public int getMaxFrames() {
        return this.maxFrames;
    }

    public void setMaxFrames(int maxFrames) {
        this.maxFrames = maxFrames;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setInterlaced(Boolean interlaced) {
        this.interlaced = interlaced;
    }

    public void setDownscale(int downscale) {
        this.downscale = downscale;
    }

    protected void initDecode(String sourceName) throws IOException {
        List<? extends DemuxerTrack> audioTracks;
        DemuxerTrackMeta meta;
        List<? extends DemuxerTrack> videoTracks;
        if (this.inputFormat != Format.IMG) {
            this.sourceStream = NIOUtils.readableFileChannel(sourceName);
        }
        switch (this.inputFormat) {
            case MOV: {
                this.demuxVideo = this.demuxAudio = new MP4Demuxer(this.sourceStream);
                break;
            }
            case MKV: {
                this.demuxVideo = this.demuxAudio = new MKVDemuxer(this.sourceStream);
                break;
            }
            case IMG: {
                this.demuxVideo = new ImageSequenceDemuxer(sourceName, this.maxFrames);
                break;
            }
            case WEBP: {
                this.demuxVideo = new WebpDemuxer(this.sourceStream);
                break;
            }
            case MPEG_PS: {
                this.demuxVideo = this.demuxAudio = new MPSDemuxer(this.sourceStream);
                break;
            }
            case Y4M: {
                Y4MDemuxer y4mDemuxer = new Y4MDemuxer(this.sourceStream);
                this.demuxVideo = this.demuxAudio = y4mDemuxer;
                this.videoInputTrack = y4mDemuxer;
                break;
            }
            case H264: {
                this.demuxVideo = new BufferH264ES(NIOUtils.fetchFromChannel(this.sourceStream));
                break;
            }
            case WAV: {
                this.demuxAudio = new WavDemuxer(this.sourceStream);
                break;
            }
            case MPEG_TS: {
                MTSDemuxer mtsDemuxer = new MTSDemuxer(this.sourceStream);
                MPSDemuxer mpsDemuxer = null;
                if (this.inputVideoCodec != null) {
                    mpsDemuxer = new MPSDemuxer(mtsDemuxer.getProgram((Integer)this.inputVideoCodec.v0));
                    this.videoInputTrack = this.openTSTrack(mpsDemuxer, (Integer)this.inputVideoCodec.v1);
                    this.demuxVideo = mpsDemuxer;
                }
                if (this.inputAudioCodec != null) {
                    if (this.inputVideoCodec == null || this.inputVideoCodec.v0 != this.inputAudioCodec.v0) {
                        mpsDemuxer = new MPSDemuxer(mtsDemuxer.getProgram((Integer)this.inputAudioCodec.v0));
                    }
                    this.audioInputTrack = this.openTSTrack(mpsDemuxer, (Integer)this.inputAudioCodec.v1);
                    this.demuxAudio = mpsDemuxer;
                }
                for (int pid : mtsDemuxer.getPrograms()) {
                    if (this.inputVideoCodec != null && pid == (Integer)this.inputVideoCodec.v0 || this.inputAudioCodec != null && pid == (Integer)this.inputAudioCodec.v0) continue;
                    Logger.info("Unused program: " + pid);
                    mtsDemuxer.getProgram(pid).close();
                }
            }
            default: {
                throw new RuntimeException("Input format: " + (Object)((Object)this.inputFormat) + " is not supported.");
            }
        }
        if (this.demuxVideo != null && this.inputVideoCodec != null && (videoTracks = this.demuxVideo.getVideoTracks()).size() > 0) {
            this.videoInputTrack = videoTracks.get((Integer)this.inputVideoCodec.v1);
            meta = this.videoInputTrack.getMeta();
            if (meta != null) {
                this.videoDecoder = this.createVideoDecoder((Codec)((Object)this.inputVideoCodec.v2), this.downscale, meta.getCodecPrivate(), meta.getVideoCodecMeta());
            }
        }
        if (this.demuxAudio != null && this.inputAudioCodec != null && (audioTracks = this.demuxAudio.getAudioTracks()).size() > 0) {
            this.audioInputTrack = audioTracks.get((Integer)this.inputAudioCodec.v1);
            meta = this.audioInputTrack.getMeta();
            if (meta != null) {
                this.audioDecoder = this.createAudioDecoder(meta.getCodecPrivate());
            }
        }
    }

    private AudioDecoder createAudioDecoder(ByteBuffer codecPrivate) throws AACException {
        switch ((Codec)((Object)this.inputAudioCodec.v2)) {
            case AAC: {
                return new AACDecoder(codecPrivate);
            }
            case PCM: {
                return new RawAudioDecoder(this.audioInputTrack.getMeta().getAudioCodecMeta().getFormat());
            }
        }
        return null;
    }

    private VideoDecoder createVideoDecoder(Codec codec, int downscale, ByteBuffer codecPrivate, VideoCodecMeta videoCodecMeta) {
        switch (codec) {
            case H264: {
                return H264Decoder.createH264DecoderFromCodecPrivate(codecPrivate);
            }
            case PNG: {
                return new PNGDecoder();
            }
            case MPEG2: {
                return MPEGDecoder.createMpegDecoder(downscale);
            }
            case PRORES: {
                return ProresDecoder.createProresDecoder(downscale);
            }
            case VP8: {
                return new VP8Decoder();
            }
            case JPEG: {
                return JpegDecoder.createJpegDecoder(downscale);
            }
            case RAW: {
                Size dim = videoCodecMeta.getSize();
                return new RAWVideoDecoder(dim.getWidth(), dim.getHeight());
            }
        }
        return null;
    }

    private MPEGDemuxer.MPEGDemuxerTrack openTSTrack(MPSDemuxer demuxerVideo, Integer selectedTrack) {
        int trackNo = 0;
        for (MPEGDemuxer.MPEGDemuxerTrack track : demuxerVideo.getTracks()) {
            if (trackNo == selectedTrack) {
                return track;
            }
            track.ignore();
            ++trackNo;
        }
        return null;
    }

    protected void initEncode(String destName) throws IOException {
        if (this.outputFormat != Format.IMG) {
            this.destStream = NIOUtils.writableFileChannel(destName);
        }
        switch (this.outputFormat) {
            case MKV: {
                this.muxer = new MKVMuxer(this.destStream);
                break;
            }
            case MOV: {
                this.muxer = MP4Muxer.createMP4MuxerToChannel(this.destStream);
                break;
            }
            case IVF: {
                this.muxer = new IVFMuxer(this.destStream);
                break;
            }
            case IMG: {
                this.muxer = new ImageSequenceMuxer(destName);
                break;
            }
            case WAV: {
                this.muxer = new WavMuxer(this.destStream);
            }
        }
        if (this.outputVideoCodec != null) {
            switch (this.outputVideoCodec) {
                case PRORES: {
                    this.videoEncoder = new ProresEncoder(this.profile, (boolean)this.interlaced);
                    break;
                }
                case H264: {
                    this.videoEncoder = H264Encoder.createH264Encoder();
                    break;
                }
                case VP8: {
                    this.videoEncoder = VP8Encoder.createVP8Encoder(10);
                    break;
                }
                case PNG: {
                    this.videoEncoder = new PNGEncoder();
                    break;
                }
                default: {
                    throw new RuntimeException("Could not find encoder for the codec: " + (Object)((Object)this.outputVideoCodec));
                }
            }
            this.filters.add(0, new ColorTransformFilter(this.videoEncoder.getSupportedColorSpaces()[0]));
            this.filters.addAll(this.extraFilters);
        }
    }

    protected void finishEncode() throws IOException {
        if (this.framesOutput) {
            this.muxer.finish();
        } else {
            Logger.warn("No frames output.");
        }
        if (this.destStream != null) {
            IOUtils.closeQuietly(this.destStream);
        }
    }

    protected Picture8Bit createPixelBuffer(ByteBuffer firstFrame) {
        if (this.videoCool == null) {
            DemuxerTrackMeta meta = this.videoInputTrack.getMeta();
            this.videoCool = meta != null && meta.getVideoCodecMeta() != null ? meta.getVideoCodecMeta() : this.videoDecoder.getCodecMeta(firstFrame);
        }
        Size size = this.videoCool.getSize();
        return Picture8Bit.create(size.getWidth() + 15 & 0xFFFFFFF0, size.getHeight() + 15 & 0xFFFFFFF0, this.videoCool.getColor());
    }

    protected Packet inputVideoPacket() throws IOException {
        if (this.videoInputTrack == null) {
            return null;
        }
        Packet nextFrame = this.videoInputTrack.nextFrame();
        if (nextFrame != null) {
            Logger.debug(String.format("Input frame: pts=%d, duration=%d", nextFrame.getPts(), nextFrame.getDuration()));
        }
        if (this.videoDecoder == null) {
            this.videoDecoder = this.createVideoDecoder((Codec)((Object)this.inputVideoCodec.v2), this.downscale, nextFrame.getData(), null);
        }
        if (this.videoCodecCopy && this.videoOutputTrack == null) {
            VideoCodecMeta meta = this.videoDecoder.getCodecMeta(nextFrame.getData());
            this.videoOutputTrack = this.muxer.addVideoTrack((Codec)((Object)this.inputVideoCodec.v2), meta);
        }
        return nextFrame;
    }

    protected void outputVideoPacket(Packet packet) throws IOException {
        this.videoOutputTrack.addFrame(packet);
        this.framesOutput = true;
    }

    protected Picture8Bit decodeVideo(ByteBuffer data, Picture8Bit target1) {
        return this.videoDecoder.decodeFrame8Bit(data, target1.getData());
    }

    protected VideoEncoder.EncodedFrame encodeVideo(Picture8Bit frame, ByteBuffer _out) {
        if (this.videoOutputTrack == null) {
            this.videoOutputTrack = this.muxer.addVideoTrack(this.outputVideoCodec, new VideoCodecMeta(new Size(frame.getWidth(), frame.getHeight()), frame.getColor()));
        }
        return this.videoEncoder.encodeFrame8Bit(frame, _out);
    }

    protected boolean haveAudio() {
        return this.audioInputTrack != null;
    }

    protected Packet inputAudioPacket() throws IOException {
        if (this.audioInputTrack == null) {
            return null;
        }
        Packet packet = this.audioInputTrack.nextFrame();
        if (this.audioDecoder == null) {
            this.audioDecoder = this.createAudioDecoder(packet.getData());
        }
        if (this.audioOutputTrack == null) {
            AudioCodecMeta meta = this.audioDecoder.getCodecMeta(packet.getData());
            this.audioOutputTrack = this.muxer.addAudioTrack(this.outputAudioCodec, meta);
        }
        return packet;
    }

    protected void outputAudioPacket(Packet audioPkt) throws IOException {
        this.audioOutputTrack.addFrame(audioPkt);
        this.framesOutput = true;
    }

    protected ByteBuffer decodeAudio(ByteBuffer audioPkt) throws IOException {
        if (this.inputAudioCodec.v2 == Codec.PCM) {
            AudioFormat format = this.audioInputTrack.getMeta().getAudioCodecMeta().getFormat();
            if (this.audioEncoder == null) {
                this.audioEncoder = this.createAudioEncoder((Codec)((Object)this.inputAudioCodec.v2), format);
            }
            return audioPkt;
        }
        AudioBuffer decodeFrame = this.audioDecoder.decodeFrame(audioPkt, null);
        if (this.audioOutputTrack == null) {
            this.audioOutputTrack = this.muxer.addAudioTrack(this.outputAudioCodec, new AudioCodecMeta(decodeFrame.getFormat()));
        }
        if (this.audioEncoder == null) {
            this.audioEncoder = this.createAudioEncoder(this.outputAudioCodec, decodeFrame.getFormat());
        }
        return decodeFrame.getData();
    }

    private AudioEncoder createAudioEncoder(Codec codec, AudioFormat format) {
        if (codec != Codec.PCM) {
            throw new RuntimeException("Only PCM audio encoding (RAW audio) is supported.");
        }
        return new RawAudioEncoder();
    }

    protected ByteBuffer encodeAudio(ByteBuffer wrap) {
        return this.audioEncoder.encode(wrap, null);
    }

    protected boolean seek(int frame) throws IOException {
        Packet inFrame;
        SeekableDemuxerTrack seekable;
        if (this.videoInputTrack instanceof SeekableDemuxerTrack) {
            seekable = (SeekableDemuxerTrack)this.videoInputTrack;
            seekable.gotoFrame(frame);
            while ((inFrame = this.inputVideoPacket()) != null && !inFrame.isKeyFrame()) {
            }
        } else {
            Logger.error("Can not seek in " + this.videoInputTrack + " container.");
            return false;
        }
        seekable.gotoFrame(inFrame.getFrameNo());
        return true;
    }

    protected int getBufferSize(Picture8Bit frame) {
        return this.videoEncoder.estimateBufferSize(frame);
    }

    protected boolean audioCodecCopy() {
        return this.audioCodecCopy;
    }

    protected boolean videoCodecCopy() {
        return this.videoCodecCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transcode() throws IOException {
        ArrayList<FrameWithPacket> reorderBuffer = new ArrayList<FrameWithPacket>();
        try {
            Packet inVideoPacket;
            this.initDecode(this.sourceName);
            this.initEncode(this.destName);
            int skipFrames = 0;
            if (this.seekFrames > 0 && !this.seek(this.seekFrames)) {
                Logger.warn("Unable to seek, will have to skip.");
                skipFrames = this.seekFrames;
            }
            if (this.maxFrames < Integer.MAX_VALUE) {
                this.maxFrames += this.seekFrames;
            }
            boolean framesDecoded = false;
            PixelStoreImpl pixelsStore = new PixelStoreImpl();
            for (int frameNo = 0; (inVideoPacket = this.inputVideoPacket()) != null && frameNo <= this.maxFrames; ++frameNo) {
                if (skipFrames > 0) {
                    --skipFrames;
                    continue;
                }
                if (!this.videoCodecCopy() && !framesDecoded) {
                    if (inVideoPacket.getFrameType() == Packet.FrameType.UNKOWN) {
                        this.detectFrameType(inVideoPacket);
                    }
                    if (!inVideoPacket.isKeyFrame()) continue;
                }
                framesDecoded = true;
                if (this.haveAudio()) {
                    double endPts = inVideoPacket.getPtsD() + 0.2;
                    this.outputAudioPacketsTo(endPts);
                }
                Picture8Bit decodedFrame = null;
                if (!this.videoCodecCopy()) {
                    Picture8Bit pixelBuffer = this.pixelBufferStore.get();
                    if (pixelBuffer == null) {
                        pixelBuffer = this.createPixelBuffer(inVideoPacket.getData());
                        this.pixelBufferStore.set(pixelBuffer);
                    }
                    if ((decodedFrame = this.decodeVideo(inVideoPacket.getData(), pixelBuffer)) == null) continue;
                    for (Filter filter : this.filters) {
                        decodedFrame = filter.filter(decodedFrame, pixelsStore);
                    }
                }
                this.printLegend(frameNo, this.maxFrames, inVideoPacket);
                if (reorderBuffer.size() > 7) {
                    this.outFrames(reorderBuffer, pixelsStore, 1);
                }
                reorderBuffer.add(new FrameWithPacket(inVideoPacket, decodedFrame));
            }
            if (reorderBuffer.size() > 0) {
                this.outFrames(reorderBuffer, pixelsStore, reorderBuffer.size());
            }
            this.outputAudioPacketsTo(Double.MAX_VALUE);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            this.finishDecode();
            this.finishEncode();
        }
    }

    private void detectFrameType(Packet inVideoPacket) {
        if (this.inputVideoCodec.v2 != Codec.H264) {
            throw new RuntimeException("Input frame type detection is only supported for h.264");
        }
        inVideoPacket.setFrameType(H264Utils.isByteBufferIDRSlice(inVideoPacket.getData()) ? Packet.FrameType.KEY : Packet.FrameType.INTER);
    }

    private void finishDecode() {
        if (this.sourceStream != null) {
            IOUtils.closeQuietly(this.sourceStream);
        }
    }

    private void outputAudioPacketsTo(double endPts) throws IOException {
        Packet audioPkt;
        while ((audioPkt = this.inputAudioPacket()) != null) {
            if (!this.audioCodecCopy()) {
                ByteBuffer decodedAudio = this.decodeAudio(audioPkt.getData());
                this.outputAudioPacket(Packet.createPacketWithData(audioPkt, this.encodeAudio(decodedAudio)));
            } else {
                this.outputAudioPacket(audioPkt);
            }
            if (audioPkt.getPtsD() < endPts) continue;
        }
    }

    private void printLegend(int frameNo, int maxFrames, Packet inVideoPacket) {
        if (frameNo % 100 == 0) {
            System.out.print(String.format("[%6d]\r", frameNo));
        }
    }

    private void outFrames(List<FrameWithPacket> frames, PixelStore pixelStore, int nFrames) throws IOException {
        long duration = this.findDuration(frames);
        System.out.println("\n" + duration);
        if (!this.videoCodecCopy) {
            Collections.sort(frames);
        }
        for (int i = 0; i < nFrames; ++i) {
            Packet outputVideoPacket;
            FrameWithPacket frame = frames.remove(0);
            if (frame.frame != null) {
                ByteBuffer buffer = this.bufferStore.get();
                int bufferSize = this.getBufferSize(frame.frame);
                if (buffer == null || bufferSize < buffer.capacity()) {
                    buffer = ByteBuffer.allocate(bufferSize);
                    this.bufferStore.set(buffer);
                }
                buffer.clear();
                VideoEncoder.EncodedFrame enc = this.encodeVideo(frame.frame, buffer);
                pixelStore.putBack(frame.frame);
                outputVideoPacket = Packet.createPacketWithData(frame.packet, NIOUtils.clone(enc.getData()));
                outputVideoPacket.setFrameType(enc.isKeyFrame() ? Packet.FrameType.KEY : Packet.FrameType.INTER);
            } else {
                outputVideoPacket = Packet.createPacketWithData(frame.packet, NIOUtils.clone(frame.packet.getData()));
            }
            if (duration != -1L) {
                outputVideoPacket.setDuration(duration);
            }
            this.outputVideoPacket(outputVideoPacket);
        }
    }

    private long findDuration(List<FrameWithPacket> frames) {
        long min = Long.MAX_VALUE;
        for (FrameWithPacket frame1 : frames) {
            long pts1 = frame1.packet.getPts();
            for (FrameWithPacket frame2 : frames) {
                long pts2 = frame2.packet.getPts();
                long duration = pts2 - pts1;
                if (duration <= 0L || duration >= min) continue;
                min = duration;
            }
        }
        return min;
    }

    private class FrameWithPacket
    implements Comparable<FrameWithPacket> {
        private Packet packet;
        private Picture8Bit frame;

        public FrameWithPacket(Packet inFrame, Picture8Bit dec2) {
            this.packet = inFrame;
            this.frame = dec2;
        }

        @Override
        public int compareTo(FrameWithPacket arg) {
            long pts2;
            if (arg == null) {
                return -1;
            }
            long pts1 = this.packet.getPts();
            return pts1 > (pts2 = arg.packet.getPts()) ? 1 : (pts1 == pts2 ? 0 : -1);
        }
    }

    private static class RawAudioDecoder
    implements AudioDecoder {
        private AudioFormat format;

        public RawAudioDecoder(AudioFormat format) {
            this.format = format;
        }

        @Override
        public AudioBuffer decodeFrame(ByteBuffer frame, ByteBuffer dst) throws IOException {
            return new AudioBuffer(frame, this.format, frame.remaining() / this.format.getFrameSize());
        }

        @Override
        public AudioCodecMeta getCodecMeta(ByteBuffer data) throws IOException {
            return new AudioCodecMeta(this.format);
        }
    }

    private static class RawAudioEncoder
    implements AudioEncoder {
        private RawAudioEncoder() {
        }

        @Override
        public ByteBuffer encode(ByteBuffer audioPkt, ByteBuffer buf) {
            return audioPkt;
        }
    }

    public static class PixelStoreImpl
    implements PixelStore {
        private List<Picture8Bit> buffers = new ArrayList<Picture8Bit>();

        @Override
        public Picture8Bit getPicture(int width, int height, ColorSpace color) {
            for (Picture8Bit picture8Bit : this.buffers) {
                if (picture8Bit.getWidth() != width || picture8Bit.getHeight() != height || picture8Bit.getColor() != color) continue;
                this.buffers.remove(picture8Bit);
                return picture8Bit;
            }
            return Picture8Bit.create(width, height, color);
        }

        @Override
        public void putBack(Picture8Bit frame) {
            frame.setCrop(null);
            this.buffers.add(frame);
        }
    }

    public static interface PixelStore {
        public Picture8Bit getPicture(int var1, int var2, ColorSpace var3);

        public void putBack(Picture8Bit var1);
    }

    public static interface Filter {
        public Picture8Bit filter(Picture8Bit var1, PixelStore var2);
    }
}

