/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api.transcode.filters;

import org.jcodec.api.transcode.Transcoder;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture8Bit;
import org.jcodec.scale.ColorUtil;
import org.jcodec.scale.Transform8Bit;

public class ColorTransformFilter
implements Transcoder.Filter {
    private Transform8Bit transform;
    private ColorSpace encoderColor;

    public ColorTransformFilter(ColorSpace encoderColor) {
        this.encoderColor = encoderColor;
    }

    @Override
    public Picture8Bit filter(Picture8Bit picture, Transcoder.PixelStore store) {
        if (this.transform == null) {
            this.transform = ColorUtil.getTransform8Bit(picture.getColor(), this.encoderColor);
            Logger.debug("Creating transform: " + this.transform);
        }
        Picture8Bit outFrame = store.getPicture(picture.getWidth(), picture.getHeight(), this.encoderColor);
        outFrame.setCrop(picture.getCrop());
        this.transform.transform(picture, outFrame);
        return outFrame;
    }
}

