/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.POCManager;
import org.jcodec.codecs.h264.decode.DeblockerInput;
import org.jcodec.codecs.h264.decode.FrameReader;
import org.jcodec.codecs.h264.decode.SliceDecoder;
import org.jcodec.codecs.h264.decode.SliceHeaderReader;
import org.jcodec.codecs.h264.decode.SliceReader;
import org.jcodec.codecs.h264.decode.deblock.DeblockingFilter;
import org.jcodec.codecs.h264.io.model.Frame;
import org.jcodec.codecs.h264.io.model.NALUnit;
import org.jcodec.codecs.h264.io.model.NALUnitType;
import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.RefPicMarking;
import org.jcodec.codecs.h264.io.model.RefPicMarkingIDR;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.codecs.h264.io.model.SliceType;
import org.jcodec.common.IntObjectMap;
import org.jcodec.common.VideoCodecMeta;
import org.jcodec.common.VideoDecoder;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Rect;
import org.jcodec.common.model.Size;
import org.jcodec.common.tools.MathUtil;

public class H264Decoder
extends VideoDecoder {
    private Frame[] sRefs;
    private IntObjectMap<Frame> lRefs;
    private List<Frame> pictureBuffer = new ArrayList<Frame>();
    private POCManager poc = new POCManager();
    private FrameReader reader;
    private ExecutorService tp;
    private boolean threaded;

    public H264Decoder() {
        boolean bl = this.threaded = Runtime.getRuntime().availableProcessors() > 1;
        if (this.threaded) {
            this.tp = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        this.reader = new FrameReader();
    }

    public static H264Decoder createH264DecoderFromCodecPrivate(ByteBuffer codecPrivate) {
        H264Decoder d = new H264Decoder();
        for (ByteBuffer bb : H264Utils.splitFrame(codecPrivate.duplicate())) {
            NALUnit nu = NALUnit.read(bb);
            if (nu.type == NALUnitType.SPS) {
                d.reader.addSps(bb);
                continue;
            }
            if (nu.type != NALUnitType.PPS) continue;
            d.reader.addPps(bb);
        }
        return d;
    }

    @Override
    public Frame decodeFrame8Bit(ByteBuffer data, byte[][] buffer) {
        return this.decodeFrame8BitFromNals(H264Utils.splitFrame(data), buffer);
    }

    public Frame decodeFrame8BitFromNals(List<ByteBuffer> nalUnits, byte[][] buffer) {
        return new FrameDecoder(this).decodeFrame(nalUnits, buffer);
    }

    @Deprecated
    public Picture decodeFrameFromNals(List<ByteBuffer> nalUnits, int[][] buffer) {
        Frame frame = new FrameDecoder(this).decodeFrame(nalUnits, this.getSameSizeBuffer(buffer));
        return frame == null ? null : frame.toPictureWithBuffer(8, buffer);
    }

    public static Frame createFrame(SeqParameterSet sps, byte[][] buffer, int frameNum, SliceType frameType, int[][][][] mvs, Frame[][][] refsUsed, int POC) {
        int width = sps.pic_width_in_mbs_minus1 + 1 << 4;
        int height = SeqParameterSet.getPicHeightInMbs(sps) << 4;
        Rect crop = null;
        if (sps.frame_cropping_flag) {
            int sX = sps.frame_crop_left_offset << 1;
            int sY = sps.frame_crop_top_offset << 1;
            int w = width - (sps.frame_crop_right_offset << 1) - sX;
            int h = height - (sps.frame_crop_bottom_offset << 1) - sY;
            crop = new Rect(sX, sY, w, h);
        }
        return new Frame(width, height, buffer, ColorSpace.YUV420, crop, frameNum, frameType, mvs, refsUsed, POC);
    }

    public void addSps(List<ByteBuffer> spsList) {
        this.reader.addSpsList(spsList);
    }

    public void addPps(List<ByteBuffer> ppsList) {
        this.reader.addPpsList(ppsList);
    }

    public static int probe(ByteBuffer data) {
        boolean validSps = false;
        boolean validPps = false;
        boolean validSh = false;
        for (ByteBuffer nalUnit : H264Utils.splitFrame(data.duplicate())) {
            NALUnit marker = NALUnit.read(nalUnit);
            if (marker.type == NALUnitType.IDR_SLICE || marker.type == NALUnitType.NON_IDR_SLICE) {
                BitReader reader = BitReader.createBitReader(nalUnit);
                validSh = H264Decoder.validSh(new SliceHeaderReader().readPart1(reader));
                break;
            }
            if (marker.type == NALUnitType.SPS) {
                validSps = H264Decoder.validSps(SeqParameterSet.read(nalUnit));
                continue;
            }
            if (marker.type != NALUnitType.PPS) continue;
            validPps = H264Decoder.validPps(PictureParameterSet.read(nalUnit));
        }
        return (validSh ? 60 : 0) + (validSps ? 20 : 0) + (validPps ? 20 : 0);
    }

    private static boolean validSh(SliceHeader sh) {
        return sh.first_mb_in_slice == 0 && sh.slice_type != null && sh.pic_parameter_set_id < 2;
    }

    private static boolean validSps(SeqParameterSet sps) {
        return sps.bit_depth_chroma_minus8 < 4 && sps.bit_depth_luma_minus8 < 4 && sps.chroma_format_idc != null && sps.seq_parameter_set_id < 2 && sps.pic_order_cnt_type <= 2;
    }

    private static boolean validPps(PictureParameterSet pps) {
        return pps.pic_init_qp_minus26 <= 26 && pps.seq_parameter_set_id <= 2 && pps.pic_parameter_set_id <= 2;
    }

    @Override
    public VideoCodecMeta getCodecMeta(ByteBuffer data) {
        List<ByteBuffer> rawSPS = H264Utils.getRawSPS(data.duplicate());
        List<ByteBuffer> rawPPS = H264Utils.getRawPPS(data.duplicate());
        if (rawSPS.size() == 0) {
            Logger.warn("Can not extract metadata from the packet not containing an SPS.");
            return null;
        }
        SeqParameterSet sps = SeqParameterSet.read(rawSPS.get(0));
        Size size = H264Utils.getPicSize(sps);
        return new VideoCodecMeta(size, ColorSpace.YUV420);
    }

    static /* synthetic */ Frame[] access$202(H264Decoder x0, Frame[] x1) {
        x0.sRefs = x1;
        return x1;
    }

    static class FrameDecoder {
        private SeqParameterSet activeSps;
        private DeblockingFilter filter;
        private SliceHeader firstSliceHeader;
        private NALUnit firstNu;
        private H264Decoder dec;
        private DeblockerInput di;

        public FrameDecoder(H264Decoder decoder) {
            this.dec = decoder;
        }

        public Frame decodeFrame(List<ByteBuffer> nalUnits, byte[][] buffer) {
            List<SliceReader> sliceReaders = this.dec.reader.readFrame(nalUnits);
            if (sliceReaders == null || sliceReaders.size() == 0) {
                return null;
            }
            Frame result = this.init(sliceReaders.get(0), buffer);
            if (this.dec.threaded && sliceReaders.size() > 1) {
                ArrayList futures = new ArrayList();
                for (SliceReader sliceReader : sliceReaders) {
                    futures.add(this.dec.tp.submit(new SliceDecoderRunnable(this, sliceReader, result)));
                }
                for (Future future : futures) {
                    this.waitForSure(future);
                }
            } else {
                for (SliceReader sliceReader : sliceReaders) {
                    new SliceDecoder(this.activeSps, this.dec.sRefs, this.dec.lRefs, this.di, result).decodeFromReader(sliceReader);
                }
            }
            this.filter.deblockFrame(result);
            this.updateReferences(result);
            return result;
        }

        private void waitForSure(Future<?> future) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void updateReferences(Frame picture) {
            if (this.firstNu.nal_ref_idc != 0) {
                if (this.firstNu.type == NALUnitType.IDR_SLICE) {
                    this.performIDRMarking(this.firstSliceHeader.refPicMarkingIDR, picture);
                } else {
                    this.performMarking(this.firstSliceHeader.refPicMarkingNonIDR, picture);
                }
            }
        }

        private Frame init(SliceReader sliceReader, byte[][] buffer) {
            this.firstNu = sliceReader.getNALUnit();
            this.firstSliceHeader = sliceReader.getSliceHeader();
            this.activeSps = this.firstSliceHeader.sps;
            int picWidthInMbs = this.activeSps.pic_width_in_mbs_minus1 + 1;
            int picHeightInMbs = SeqParameterSet.getPicHeightInMbs(this.activeSps);
            if (this.dec.sRefs == null) {
                H264Decoder.access$202(this.dec, new Frame[1 << this.firstSliceHeader.sps.log2_max_frame_num_minus4 + 4]);
                this.dec.lRefs = new IntObjectMap();
            }
            this.di = new DeblockerInput(this.activeSps);
            Frame result = H264Decoder.createFrame(this.activeSps, buffer, this.firstSliceHeader.frame_num, this.firstSliceHeader.slice_type, this.di.mvs, this.di.refsUsed, this.dec.poc.calcPOC(this.firstSliceHeader, this.firstNu));
            this.filter = new DeblockingFilter(picWidthInMbs, this.activeSps.bit_depth_chroma_minus8 + 8, this.di);
            return result;
        }

        public void performIDRMarking(RefPicMarkingIDR refPicMarkingIDR, Frame picture) {
            this.clearAll();
            this.dec.pictureBuffer.clear();
            Frame saved = this.saveRef(picture);
            if (refPicMarkingIDR.isUseForlongTerm()) {
                this.dec.lRefs.put(0, saved);
                saved.setShortTerm(false);
            } else {
                ((H264Decoder)this.dec).sRefs[this.firstSliceHeader.frame_num] = saved;
            }
        }

        private Frame saveRef(Frame decoded) {
            Frame frame = this.dec.pictureBuffer.size() > 0 ? (Frame)this.dec.pictureBuffer.remove(0) : Frame.createFrame(decoded);
            frame.copyFromFrame(decoded);
            return frame;
        }

        private void releaseRef(Frame picture) {
            if (picture != null) {
                this.dec.pictureBuffer.add(picture);
            }
        }

        public void clearAll() {
            for (int i = 0; i < this.dec.sRefs.length; ++i) {
                this.releaseRef(this.dec.sRefs[i]);
                ((H264Decoder)this.dec).sRefs[i] = null;
            }
            int[] keys = this.dec.lRefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                this.releaseRef((Frame)this.dec.lRefs.get(keys[i]));
            }
            this.dec.lRefs.clear();
        }

        public void performMarking(RefPicMarking refPicMarking, Frame picture) {
            Frame saved = this.saveRef(picture);
            if (refPicMarking != null) {
                RefPicMarking.Instruction[] instructions = refPicMarking.getInstructions();
                block8: for (int i = 0; i < instructions.length; ++i) {
                    RefPicMarking.Instruction instr = instructions[i];
                    switch (instr.getType()) {
                        case REMOVE_SHORT: {
                            this.unrefShortTerm(instr.getArg1());
                            continue block8;
                        }
                        case REMOVE_LONG: {
                            this.unrefLongTerm(instr.getArg1());
                            continue block8;
                        }
                        case CONVERT_INTO_LONG: {
                            this.convert(instr.getArg1(), instr.getArg2());
                            continue block8;
                        }
                        case TRUNK_LONG: {
                            this.truncateLongTerm(instr.getArg1() - 1);
                            continue block8;
                        }
                        case CLEAR: {
                            this.clearAll();
                            continue block8;
                        }
                        case MARK_LONG: {
                            this.saveLong(saved, instr.getArg1());
                            saved = null;
                        }
                    }
                }
            }
            if (saved != null) {
                this.saveShort(saved);
            }
            int maxFrames = 1 << this.activeSps.log2_max_frame_num_minus4 + 4;
            if (refPicMarking == null) {
                int maxShort = Math.max(1, this.activeSps.num_ref_frames - this.dec.lRefs.size());
                int min = Integer.MAX_VALUE;
                int num = 0;
                int minFn = 0;
                for (int i = 0; i < this.dec.sRefs.length; ++i) {
                    if (this.dec.sRefs[i] == null) continue;
                    int fnWrap = this.unwrap(this.firstSliceHeader.frame_num, this.dec.sRefs[i].getFrameNo(), maxFrames);
                    if (fnWrap < min) {
                        min = fnWrap;
                        minFn = this.dec.sRefs[i].getFrameNo();
                    }
                    ++num;
                }
                if (num > maxShort) {
                    this.releaseRef(this.dec.sRefs[minFn]);
                    ((H264Decoder)this.dec).sRefs[minFn] = null;
                }
            }
        }

        private int unwrap(int thisFrameNo, int refFrameNo, int maxFrames) {
            return refFrameNo > thisFrameNo ? refFrameNo - maxFrames : refFrameNo;
        }

        private void saveShort(Frame saved) {
            ((H264Decoder)this.dec).sRefs[this.firstSliceHeader.frame_num] = saved;
        }

        private void saveLong(Frame saved, int longNo) {
            Frame prev = (Frame)this.dec.lRefs.get(longNo);
            if (prev != null) {
                this.releaseRef(prev);
            }
            saved.setShortTerm(false);
            this.dec.lRefs.put(longNo, saved);
        }

        private void truncateLongTerm(int maxLongNo) {
            int[] keys = this.dec.lRefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] <= maxLongNo) continue;
                this.releaseRef((Frame)this.dec.lRefs.get(keys[i]));
                this.dec.lRefs.remove(keys[i]);
            }
        }

        private void convert(int shortNo, int longNo) {
            int ind = MathUtil.wrap(this.firstSliceHeader.frame_num - shortNo, 1 << this.firstSliceHeader.sps.log2_max_frame_num_minus4 + 4);
            this.releaseRef((Frame)this.dec.lRefs.get(longNo));
            this.dec.lRefs.put(longNo, this.dec.sRefs[ind]);
            ((H264Decoder)this.dec).sRefs[ind] = null;
            ((Frame)this.dec.lRefs.get(longNo)).setShortTerm(false);
        }

        private void unrefLongTerm(int longNo) {
            this.releaseRef((Frame)this.dec.lRefs.get(longNo));
            this.dec.lRefs.remove(longNo);
        }

        private void unrefShortTerm(int shortNo) {
            int ind = MathUtil.wrap(this.firstSliceHeader.frame_num - shortNo, 1 << this.firstSliceHeader.sps.log2_max_frame_num_minus4 + 4);
            this.releaseRef(this.dec.sRefs[ind]);
            ((H264Decoder)this.dec).sRefs[ind] = null;
        }
    }

    private static final class SliceDecoderRunnable
    implements Runnable {
        private final SliceReader sliceReader;
        private final Frame result;
        private FrameDecoder fdec;

        private SliceDecoderRunnable(FrameDecoder fdec, SliceReader sliceReader, Frame result) {
            this.fdec = fdec;
            this.sliceReader = sliceReader;
            this.result = result;
        }

        @Override
        public void run() {
            new SliceDecoder(this.fdec.activeSps, this.fdec.dec.sRefs, this.fdec.dec.lRefs, this.fdec.di, this.result).decodeFromReader(this.sliceReader);
        }
    }
}

