/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264;

import java.nio.ByteBuffer;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.encode.DumbRateControl;
import org.jcodec.codecs.h264.encode.EncodedMB;
import org.jcodec.codecs.h264.encode.MBEncoderHelper;
import org.jcodec.codecs.h264.encode.MBEncoderI16x16;
import org.jcodec.codecs.h264.encode.MBEncoderP16x16;
import org.jcodec.codecs.h264.encode.MotionEstimator;
import org.jcodec.codecs.h264.encode.RateControl;
import org.jcodec.codecs.h264.io.CAVLC;
import org.jcodec.codecs.h264.io.model.MBType;
import org.jcodec.codecs.h264.io.model.NALUnit;
import org.jcodec.codecs.h264.io.model.NALUnitType;
import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.RefPicMarkingIDR;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.codecs.h264.io.model.SliceType;
import org.jcodec.codecs.h264.io.write.CAVLCWriter;
import org.jcodec.codecs.h264.io.write.SliceHeaderWriter;
import org.jcodec.common.VideoEncoder;
import org.jcodec.common.io.BitWriter;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture8Bit;
import org.jcodec.common.model.Size;
import org.jcodec.common.tools.MathUtil;

public class H264Encoder
extends VideoEncoder {
    private static final int KEY_INTERVAL_DEFAULT = 25;
    private CAVLC[] cavlc;
    private byte[][] leftRow;
    private byte[][] topLine;
    private RateControl rc;
    private int frameNumber;
    private int keyInterval;
    private int maxPOC;
    private int maxFrameNumber;
    private SeqParameterSet sps;
    private PictureParameterSet pps;
    private MBEncoderI16x16 mbEncoderI16x16;
    private MBEncoderP16x16 mbEncoderP16x16;
    private Picture8Bit ref;
    private Picture8Bit picOut;
    private EncodedMB[] topEncoded;
    private EncodedMB outMB;

    public static H264Encoder createH264Encoder() {
        return new H264Encoder(new DumbRateControl());
    }

    public H264Encoder(RateControl rc) {
        this.rc = rc;
        this.keyInterval = 25;
    }

    public int getKeyInterval() {
        return this.keyInterval;
    }

    public void setKeyInterval(int keyInterval) {
        this.keyInterval = keyInterval;
    }

    @Override
    public VideoEncoder.EncodedFrame encodeFrame8Bit(Picture8Bit pic, ByteBuffer _out) {
        if (this.frameNumber >= this.keyInterval) {
            this.frameNumber = 0;
        }
        SliceType sliceType = this.frameNumber == 0 ? SliceType.I : SliceType.P;
        boolean idr = this.frameNumber == 0;
        ByteBuffer data = this.doEncodeFrame8Bit(pic, _out, idr, this.frameNumber++, sliceType);
        return new VideoEncoder.EncodedFrame(data, idr);
    }

    public ByteBuffer encodeIDRFrame(Picture8Bit pic, ByteBuffer _out) {
        this.frameNumber = 0;
        return this.doEncodeFrame8Bit(pic, _out, true, this.frameNumber, SliceType.I);
    }

    public ByteBuffer encodePFrame(Picture8Bit pic, ByteBuffer _out) {
        ++this.frameNumber;
        return this.doEncodeFrame8Bit(pic, _out, true, this.frameNumber, SliceType.P);
    }

    public ByteBuffer doEncodeFrame8Bit(Picture8Bit pic, ByteBuffer _out, boolean idr, int frameNumber, SliceType frameType) {
        ByteBuffer dup = _out.duplicate();
        if (idr) {
            this.sps = this.initSPS(new Size(pic.getCroppedWidth(), pic.getCroppedHeight()));
            this.pps = this.initPPS();
            this.maxPOC = 1 << this.sps.log2_max_pic_order_cnt_lsb_minus4 + 4;
            this.maxFrameNumber = 1 << this.sps.log2_max_frame_num_minus4 + 4;
        }
        if (idr) {
            dup.putInt(1);
            new NALUnit(NALUnitType.SPS, 3).write(dup);
            this.writeSPS(dup, this.sps);
            dup.putInt(1);
            new NALUnit(NALUnitType.PPS, 3).write(dup);
            this.writePPS(dup, this.pps);
        }
        int mbWidth = this.sps.pic_width_in_mbs_minus1 + 1;
        int mbHeight = this.sps.pic_height_in_map_units_minus1 + 1;
        this.leftRow = new byte[][]{new byte[16], new byte[8], new byte[8]};
        this.topLine = new byte[][]{new byte[mbWidth << 4], new byte[mbWidth << 3], new byte[mbWidth << 3]};
        this.picOut = Picture8Bit.create(mbWidth << 4, mbHeight << 4, pic.getColor());
        this.outMB = new EncodedMB();
        this.topEncoded = new EncodedMB[mbWidth];
        for (int i = 0; i < mbWidth; ++i) {
            this.topEncoded[i] = new EncodedMB();
        }
        this.encodeSlice(this.sps, this.pps, pic, dup, idr, frameNumber, frameType);
        this.putLastMBLine();
        this.ref = this.picOut;
        dup.flip();
        return dup;
    }

    private void writePPS(ByteBuffer dup, PictureParameterSet pps) {
        ByteBuffer tmp = ByteBuffer.allocate(1024);
        pps.write(tmp);
        tmp.flip();
        H264Utils.escapeNAL(tmp, dup);
    }

    private void writeSPS(ByteBuffer dup, SeqParameterSet sps) {
        ByteBuffer tmp = ByteBuffer.allocate(1024);
        sps.write(tmp);
        tmp.flip();
        H264Utils.escapeNAL(tmp, dup);
    }

    public PictureParameterSet initPPS() {
        PictureParameterSet pps = new PictureParameterSet();
        pps.pic_init_qp_minus26 = this.rc.getInitQp(SliceType.I) - 26;
        return pps;
    }

    public SeqParameterSet initSPS(Size sz) {
        SeqParameterSet sps = new SeqParameterSet();
        sps.pic_width_in_mbs_minus1 = (sz.getWidth() + 15 >> 4) - 1;
        sps.pic_height_in_map_units_minus1 = (sz.getHeight() + 15 >> 4) - 1;
        sps.chroma_format_idc = ColorSpace.YUV420J;
        sps.profile_idc = 66;
        sps.level_idc = 40;
        sps.frame_mbs_only_flag = true;
        sps.log2_max_frame_num_minus4 = Math.max(0, MathUtil.log2(this.keyInterval) - 3);
        int codedWidth = sps.pic_width_in_mbs_minus1 + 1 << 4;
        int codedHeight = sps.pic_height_in_map_units_minus1 + 1 << 4;
        sps.frame_cropping_flag = codedWidth != sz.getWidth() || codedHeight != sz.getHeight();
        sps.frame_crop_right_offset = codedWidth - sz.getWidth() + 1 >> 1;
        sps.frame_crop_bottom_offset = codedHeight - sz.getHeight() + 1 >> 1;
        return sps;
    }

    private void encodeSlice(SeqParameterSet sps, PictureParameterSet pps, Picture8Bit pic, ByteBuffer dup, boolean idr, int frameNum, SliceType sliceType) {
        if (idr && sliceType != SliceType.I) {
            idr = false;
            Logger.warn("Illegal value of idr = true when sliceType != I");
        }
        this.cavlc = new CAVLC[]{new CAVLC(sps, pps, 2, 2), new CAVLC(sps, pps, 1, 1), new CAVLC(sps, pps, 1, 1)};
        this.mbEncoderI16x16 = new MBEncoderI16x16(this.cavlc, this.leftRow, this.topLine);
        this.mbEncoderP16x16 = new MBEncoderP16x16(sps, this.ref, this.cavlc, new MotionEstimator(16));
        this.rc.reset();
        int qp = this.rc.getInitQp(sliceType);
        dup.putInt(1);
        new NALUnit(idr ? NALUnitType.IDR_SLICE : NALUnitType.NON_IDR_SLICE, 3).write(dup);
        SliceHeader sh = new SliceHeader();
        sh.slice_type = sliceType;
        if (idr) {
            sh.refPicMarkingIDR = new RefPicMarkingIDR(false, false);
        }
        sh.pps = pps;
        sh.sps = sps;
        sh.pic_order_cnt_lsb = (frameNum << 1) % this.maxPOC;
        sh.frame_num = frameNum % this.maxFrameNumber;
        sh.slice_qp_delta = qp - (pps.pic_init_qp_minus26 + 26);
        ByteBuffer buf = ByteBuffer.allocate(pic.getWidth() * pic.getHeight());
        BitWriter sliceData = new BitWriter(buf);
        new SliceHeaderWriter().write(sh, idr, 2, sliceData);
        for (int mbY = 0; mbY < sps.pic_height_in_map_units_minus1 + 1; ++mbY) {
            for (int mbX = 0; mbX < sps.pic_width_in_mbs_minus1 + 1; ++mbX) {
                int qpDelta;
                BitWriter candidate;
                MBType mbType;
                if (sliceType == SliceType.P) {
                    CAVLCWriter.writeUE(sliceData, 0);
                }
                if ((mbType = this.selectMBType(sliceType)) == MBType.I_16x16) {
                    int predMode = this.mbEncoderI16x16.getPredMode(pic, mbX, mbY);
                    int cbpChroma = this.mbEncoderI16x16.getCbpChroma(pic, mbX, mbY);
                    int cbpLuma = this.mbEncoderI16x16.getCbpLuma(pic, mbX, mbY);
                    int i16x16TypeOffset = cbpLuma / 15 * 12 + cbpChroma * 4 + predMode;
                    int mbTypeOffset = sliceType == SliceType.P ? 5 : 0;
                    CAVLCWriter.writeUE(sliceData, mbTypeOffset + mbType.code() + i16x16TypeOffset);
                } else {
                    CAVLCWriter.writeUE(sliceData, mbType.code());
                }
                do {
                    candidate = sliceData.fork();
                    qpDelta = this.rc.getQpDelta();
                    this.encodeMacroblock(mbType, pic, mbX, mbY, candidate, qp, qpDelta);
                } while (!this.rc.accept(candidate.position() - sliceData.position()));
                sliceData = candidate;
                qp += qpDelta;
                this.collectPredictors(this.outMB.getPixels(), mbX);
                this.addToReference(mbX, mbY);
            }
        }
        sliceData.write1Bit(1);
        sliceData.flush();
        buf = sliceData.getBuffer();
        buf.flip();
        H264Utils.escapeNAL(buf, dup);
    }

    private void encodeMacroblock(MBType mbType, Picture8Bit pic, int mbX, int mbY, BitWriter candidate, int qp, int qpDelta) {
        if (mbType == MBType.I_16x16) {
            this.mbEncoderI16x16.encodeMacroblock(pic, mbX, mbY, candidate, this.outMB, mbX > 0 ? this.topEncoded[mbX - 1] : null, mbY > 0 ? this.topEncoded[mbX] : null, qp + qpDelta, qpDelta);
        } else if (mbType == MBType.P_16x16) {
            this.mbEncoderP16x16.encodeMacroblock(pic, mbX, mbY, candidate, this.outMB, mbX > 0 ? this.topEncoded[mbX - 1] : null, mbY > 0 ? this.topEncoded[mbX] : null, qp + qpDelta, qpDelta);
        } else {
            throw new RuntimeException("Macroblock of type " + mbType + " is not supported.");
        }
    }

    private MBType selectMBType(SliceType sliceType) {
        if (sliceType == SliceType.I) {
            return MBType.I_16x16;
        }
        if (sliceType == SliceType.P) {
            return MBType.P_16x16;
        }
        throw new RuntimeException("Unsupported slice type");
    }

    private void addToReference(int mbX, int mbY) {
        if (mbY > 0) {
            MBEncoderHelper.putBlkPic(this.picOut, this.topEncoded[mbX].getPixels(), mbX << 4, mbY - 1 << 4);
        }
        EncodedMB tmp = this.topEncoded[mbX];
        this.topEncoded[mbX] = this.outMB;
        this.outMB = tmp;
    }

    private void putLastMBLine() {
        int mbWidth = this.sps.pic_width_in_mbs_minus1 + 1;
        int mbHeight = this.sps.pic_height_in_map_units_minus1 + 1;
        for (int mbX = 0; mbX < mbWidth; ++mbX) {
            MBEncoderHelper.putBlkPic(this.picOut, this.topEncoded[mbX].getPixels(), mbX << 4, mbHeight - 1 << 4);
        }
    }

    private void collectPredictors(Picture8Bit outMB, int mbX) {
        System.arraycopy(outMB.getPlaneData(0), 240, this.topLine[0], mbX << 4, 16);
        System.arraycopy(outMB.getPlaneData(1), 56, this.topLine[1], mbX << 3, 8);
        System.arraycopy(outMB.getPlaneData(2), 56, this.topLine[2], mbX << 3, 8);
        this.copyCol(outMB.getPlaneData(0), 15, 16, this.leftRow[0]);
        this.copyCol(outMB.getPlaneData(1), 7, 8, this.leftRow[1]);
        this.copyCol(outMB.getPlaneData(2), 7, 8, this.leftRow[2]);
    }

    private void copyCol(byte[] planeData, int off, int stride, byte[] out) {
        for (int i = 0; i < out.length; ++i) {
            out[i] = planeData[off];
            off += stride;
        }
    }

    @Override
    public ColorSpace[] getSupportedColorSpaces() {
        return new ColorSpace[]{ColorSpace.YUV420J};
    }

    @Override
    public int estimateBufferSize(Picture8Bit frame) {
        return frame.getWidth() * frame.getHeight() / 2;
    }
}

