/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.common.model.ColorSpace;

public class DecoderState {
    int[] chromaQpOffset;
    int qp;
    byte[][] leftRow;
    byte[][] topLine;
    byte[][] topLeft;
    ColorSpace chromaFormat;
    int[][][] mvTop;
    int[][][] mvLeft;
    int[][] mvTopLeft;

    public DecoderState(SliceHeader sh) {
        int mbWidth = sh.sps.pic_width_in_mbs_minus1 + 1;
        this.chromaQpOffset = new int[]{sh.pps.chroma_qp_index_offset, sh.pps.extended != null ? sh.pps.extended.second_chroma_qp_index_offset : sh.pps.chroma_qp_index_offset};
        this.chromaFormat = sh.sps.chroma_format_idc;
        this.mvTop = new int[2][(mbWidth << 2) + 1][3];
        this.mvLeft = new int[2][4][3];
        this.mvTopLeft = new int[2][3];
        this.leftRow = new byte[3][16];
        this.topLeft = new byte[3][4];
        this.topLine = new byte[3][mbWidth << 4];
        this.qp = sh.pps.pic_init_qp_minus26 + 26 + sh.slice_qp_delta;
    }
}

