/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.codecs.common.biari.MDecoder;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.decode.SliceHeaderReader;
import org.jcodec.codecs.h264.decode.SliceReader;
import org.jcodec.codecs.h264.decode.aso.MapManager;
import org.jcodec.codecs.h264.decode.aso.Mapper;
import org.jcodec.codecs.h264.io.CABAC;
import org.jcodec.codecs.h264.io.CAVLC;
import org.jcodec.codecs.h264.io.model.NALUnit;
import org.jcodec.codecs.h264.io.model.NALUnitType;
import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.common.IntObjectMap;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.logging.Logger;

public class FrameReader {
    private IntObjectMap<SeqParameterSet> sps = new IntObjectMap();
    private IntObjectMap<PictureParameterSet> pps = new IntObjectMap();

    public List<SliceReader> readFrame(List<ByteBuffer> nalUnits) {
        ArrayList<SliceReader> result = new ArrayList<SliceReader>();
        for (ByteBuffer nalData : nalUnits) {
            NALUnit nalUnit = NALUnit.read(nalData);
            H264Utils.unescapeNAL(nalData);
            if (NALUnitType.SPS == nalUnit.type) {
                SeqParameterSet _sps = SeqParameterSet.read(nalData);
                this.sps.put(_sps.seq_parameter_set_id, _sps);
                continue;
            }
            if (NALUnitType.PPS == nalUnit.type) {
                PictureParameterSet _pps = PictureParameterSet.read(nalData);
                this.pps.put(_pps.pic_parameter_set_id, _pps);
                continue;
            }
            if (NALUnitType.IDR_SLICE != nalUnit.type && NALUnitType.NON_IDR_SLICE != nalUnit.type) continue;
            if (this.sps.size() == 0 || this.pps.size() == 0) {
                Logger.warn("Skipping frame as no SPS/PPS have been seen so far...");
                return null;
            }
            result.add(this.createSliceReader(nalData, nalUnit));
        }
        return result;
    }

    private SliceReader createSliceReader(ByteBuffer segment, NALUnit nalUnit) {
        BitReader _in = BitReader.createBitReader(segment);
        SliceHeaderReader shr = new SliceHeaderReader();
        SliceHeader sh = shr.readPart1(_in);
        sh.pps = this.pps.get(sh.pic_parameter_set_id);
        sh.sps = this.sps.get(sh.pps.seq_parameter_set_id);
        shr.readPart2(sh, nalUnit, sh.sps, sh.pps, _in);
        Mapper mapper = new MapManager(sh.sps, sh.pps).getMapper(sh);
        CAVLC[] cavlc = new CAVLC[]{new CAVLC(sh.sps, sh.pps, 2, 2), new CAVLC(sh.sps, sh.pps, 1, 1), new CAVLC(sh.sps, sh.pps, 1, 1)};
        int mbWidth = sh.sps.pic_width_in_mbs_minus1 + 1;
        CABAC cabac = new CABAC(mbWidth);
        MDecoder mDecoder = null;
        if (sh.pps.entropy_coding_mode_flag) {
            _in.terminate();
            int[][] cm = new int[2][1024];
            int qp = sh.pps.pic_init_qp_minus26 + 26 + sh.slice_qp_delta;
            cabac.initModels(cm, sh.slice_type, sh.cabac_init_idc, qp);
            mDecoder = new MDecoder(segment, cm);
        }
        return new SliceReader(sh.pps, cabac, cavlc, mDecoder, _in, mapper, sh, nalUnit);
    }

    public void addSpsList(List<ByteBuffer> spsList) {
        for (ByteBuffer byteBuffer : spsList) {
            this.addSps(byteBuffer);
        }
    }

    public void addSps(ByteBuffer byteBuffer) {
        ByteBuffer clone = NIOUtils.clone(byteBuffer);
        H264Utils.unescapeNAL(clone);
        SeqParameterSet s = SeqParameterSet.read(clone);
        this.sps.put(s.seq_parameter_set_id, s);
    }

    public void addPpsList(List<ByteBuffer> ppsList) {
        for (ByteBuffer byteBuffer : ppsList) {
            this.addPps(byteBuffer);
        }
    }

    public void addPps(ByteBuffer byteBuffer) {
        ByteBuffer clone = NIOUtils.clone(byteBuffer);
        H264Utils.unescapeNAL(clone);
        PictureParameterSet p = PictureParameterSet.read(clone);
        this.pps.put(p.pic_parameter_set_id, p);
    }
}

