/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import org.jcodec.codecs.h264.H264Const;
import org.jcodec.codecs.h264.decode.DeblockerInput;
import org.jcodec.codecs.h264.decode.DecoderState;
import org.jcodec.codecs.h264.decode.MBlock;
import org.jcodec.codecs.h264.decode.MBlockDecoderBase;
import org.jcodec.codecs.h264.decode.MBlockDecoderUtils;
import org.jcodec.codecs.h264.decode.PredictionMerger;
import org.jcodec.codecs.h264.decode.aso.Mapper;
import org.jcodec.codecs.h264.io.model.Frame;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.Picture8Bit;
import org.jcodec.common.tools.MathUtil;

public class MBlockDecoderBDirect
extends MBlockDecoderBase {
    private Mapper mapper;

    public MBlockDecoderBDirect(Mapper mapper, SliceHeader sh, DeblockerInput di, int poc, DecoderState decoderState) {
        super(sh, di, poc, decoderState);
        this.mapper = mapper;
    }

    public void decode(MBlock mBlock, Picture8Bit mb, Frame[][] references) {
        int mbX = this.mapper.getMbX(mBlock.mbIdx);
        int mbY = this.mapper.getMbY(mBlock.mbIdx);
        boolean lAvb = this.mapper.leftAvailable(mBlock.mbIdx);
        boolean tAvb = this.mapper.topAvailable(mBlock.mbIdx);
        int mbAddr = this.mapper.getAddress(mBlock.mbIdx);
        boolean tlAvb = this.mapper.topLeftAvailable(mBlock.mbIdx);
        boolean trAvb = this.mapper.topRightAvailable(mBlock.mbIdx);
        int[][][] x = new int[2][16][3];
        for (int i = 0; i < 16; ++i) {
            x[1][i][2] = -1;
            x[0][i][2] = -1;
        }
        H264Const.PartPred[] pp = new H264Const.PartPred[4];
        this.predictBDirect(references, mbX, mbY, lAvb, tAvb, tlAvb, trAvb, x, pp, mb, H264Const.identityMapping4);
        this.predictChromaInter(references, x, mbX << 3, mbY << 3, 1, mb, pp);
        this.predictChromaInter(references, x, mbX << 3, mbY << 3, 2, mb, pp);
        if (mBlock.cbpLuma() > 0 || mBlock.cbpChroma() > 0) {
            this.s.qp = (this.s.qp + mBlock.mbQPDelta + 52) % 52;
        }
        this.di.mbQps[0][mbAddr] = this.s.qp;
        this.residualLuma(mBlock, lAvb, tAvb, mbX, mbY);
        MBlockDecoderUtils.savePrediction8x8(this.s, mbX, x[0], 0);
        MBlockDecoderUtils.savePrediction8x8(this.s, mbX, x[1], 1);
        MBlockDecoderUtils.saveMvs(this.di, x, mbX, mbY);
        int qp1 = this.calcQpChroma(this.s.qp, this.s.chromaQpOffset[0]);
        int qp2 = this.calcQpChroma(this.s.qp, this.s.chromaQpOffset[1]);
        this.decodeChromaResidual(mBlock, lAvb, tAvb, mbX, mbY, qp1, qp2);
        this.di.mbQps[1][mbAddr] = qp1;
        this.di.mbQps[2][mbAddr] = qp2;
        MBlockDecoderUtils.mergeResidual(mb, mBlock.ac, mBlock.transform8x8Used ? H264Const.COMP_BLOCK_8x8_LUT : H264Const.COMP_BLOCK_4x4_LUT, mBlock.transform8x8Used ? H264Const.COMP_POS_8x8_LUT : H264Const.COMP_POS_4x4_LUT);
        MBlockDecoderUtils.collectPredictors(this.s, mb, mbX);
        this.di.mbTypes[mbAddr] = mBlock.curMbType;
        this.di.tr8x8Used[mbAddr] = mBlock.transform8x8Used;
    }

    public void predictBDirect(Frame[][] refs, int mbX, int mbY, boolean lAvb, boolean tAvb, boolean tlAvb, boolean trAvb, int[][][] x, H264Const.PartPred[] pp, Picture8Bit mb, int[] blocks) {
        if (this.sh.direct_spatial_mv_pred_flag) {
            this.predictBSpatialDirect(refs, mbX, mbY, lAvb, tAvb, tlAvb, trAvb, x, pp, mb, blocks);
        } else {
            this.predictBTemporalDirect(refs, mbX, mbY, lAvb, tAvb, tlAvb, trAvb, x, pp, mb, blocks);
        }
    }

    private void predictBTemporalDirect(Frame[][] refs, int mbX, int mbY, boolean lAvb, boolean tAvb, boolean tlAvb, boolean trAvb, int[][][] x, H264Const.PartPred[] pp, Picture8Bit mb, int[] blocks8x8) {
        for (int i = 0; i < blocks8x8.length; ++i) {
            int blk8x8 = blocks8x8[i];
            int blk4x4_0 = H264Const.BLK8x8_BLOCKS[blk8x8][0];
            pp[blk8x8] = H264Const.PartPred.Bi;
            if (!this.sh.sps.direct_8x8_inference_flag) {
                int[] js = H264Const.BLK8x8_BLOCKS[blk8x8];
                for (int j = 0; j < js.length; ++j) {
                    int blk4x4 = js[j];
                    this.predTemp4x4(refs, mbX, mbY, x, blk4x4);
                    int blkIndX = blk4x4 & 3;
                    int blkIndY = blk4x4 >> 2;
                    MBlockDecoderUtils.debugPrint("DIRECT_4x4 [%d, %d]: (%d,%d,%d), (%d,%d,%d)", blkIndY, blkIndX, x[0][blk4x4][0], x[0][blk4x4][1], x[0][blk4x4][2], x[1][blk4x4][0], x[1][blk4x4][1], x[1][blk4x4][2]);
                    int blkPredX = (mbX << 6) + (blkIndX << 4);
                    int blkPredY = (mbY << 6) + (blkIndY << 4);
                    this.interpolator.getBlockLuma(refs[0][x[0][blk4x4][2]], this.mbb[0], H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4], blkPredX + x[0][blk4x4][0], blkPredY + x[0][blk4x4][1], 4, 4);
                    this.interpolator.getBlockLuma(refs[1][0], this.mbb[1], H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4], blkPredX + x[1][blk4x4][0], blkPredY + x[1][blk4x4][1], 4, 4);
                }
            } else {
                int blk4x4Pred = H264Const.BLK_INV_MAP[blk8x8 * 5];
                this.predTemp4x4(refs, mbX, mbY, x, blk4x4Pred);
                this.propagatePred(x, blk8x8, blk4x4Pred);
                int blkIndX = blk4x4_0 & 3;
                int blkIndY = blk4x4_0 >> 2;
                MBlockDecoderUtils.debugPrint("DIRECT_8x8 [%d, %d]: (%d,%d,%d), (%d,%d)", blkIndY, blkIndX, x[0][blk4x4_0][0], x[0][blk4x4_0][1], x[0][blk4x4_0][2], x[1][blk4x4_0][0], x[1][blk4x4_0][1], x[0][blk4x4_0][2]);
                int blkPredX = (mbX << 6) + (blkIndX << 4);
                int blkPredY = (mbY << 6) + (blkIndY << 4);
                this.interpolator.getBlockLuma(refs[0][x[0][blk4x4_0][2]], this.mbb[0], H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4_0], blkPredX + x[0][blk4x4_0][0], blkPredY + x[0][blk4x4_0][1], 8, 8);
                this.interpolator.getBlockLuma(refs[1][0], this.mbb[1], H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4_0], blkPredX + x[1][blk4x4_0][0], blkPredY + x[1][blk4x4_0][1], 8, 8);
            }
            PredictionMerger.mergePrediction(this.sh, x[0][blk4x4_0][2], x[1][blk4x4_0][2], H264Const.PartPred.Bi, 0, this.mbb[0].getPlaneData(0), this.mbb[1].getPlaneData(0), H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4_0], 16, 8, 8, mb.getPlaneData(0), refs, this.poc);
        }
    }

    private void predTemp4x4(Frame[][] refs, int mbX, int mbY, int[][][] x, int blk4x4) {
        Frame refL0;
        int refIdxL0;
        int mbWidth = this.sh.sps.pic_width_in_mbs_minus1 + 1;
        Frame picCol = refs[1][0];
        int blkIndX = blk4x4 & 3;
        int blkIndY = blk4x4 >> 2;
        int blkPosX = (mbX << 2) + blkIndX;
        int blkPosY = (mbY << 2) + blkIndY;
        int[] mvCol = picCol.getMvs()[0][blkPosY][blkPosX];
        if (mvCol[2] == -1) {
            mvCol = picCol.getMvs()[1][blkPosY][blkPosX];
            if (mvCol[2] == -1) {
                refIdxL0 = 0;
                refL0 = refs[0][0];
            } else {
                refL0 = picCol.getRefsUsed()[mbY * mbWidth + mbX][1][mvCol[2]];
                refIdxL0 = this.findPic(refs[0], refL0);
            }
        } else {
            refL0 = picCol.getRefsUsed()[mbY * mbWidth + mbX][0][mvCol[2]];
            refIdxL0 = this.findPic(refs[0], refL0);
        }
        x[0][blk4x4][2] = refIdxL0;
        x[1][blk4x4][2] = 0;
        int td = MathUtil.clip(picCol.getPOC() - refL0.getPOC(), -128, 127);
        if (!refL0.isShortTerm() || td == 0) {
            x[0][blk4x4][0] = mvCol[0];
            x[0][blk4x4][1] = mvCol[1];
            x[1][blk4x4][0] = 0;
            x[1][blk4x4][1] = 0;
        } else {
            int tb = MathUtil.clip(this.poc - refL0.getPOC(), -128, 127);
            int tx = (16384 + Math.abs(td / 2)) / td;
            int dsf = MathUtil.clip(tb * tx + 32 >> 6, -1024, 1023);
            x[0][blk4x4][0] = dsf * mvCol[0] + 128 >> 8;
            x[0][blk4x4][1] = dsf * mvCol[1] + 128 >> 8;
            x[1][blk4x4][0] = x[0][blk4x4][0] - mvCol[0];
            x[1][blk4x4][1] = x[0][blk4x4][1] - mvCol[1];
        }
    }

    private int findPic(Frame[] frames, Frame refL0) {
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i] != refL0) continue;
            return i;
        }
        Logger.error("RefPicList0 shall contain refPicCol");
        return 0;
    }

    private void predictBSpatialDirect(Frame[][] refs, int mbX, int mbY, boolean lAvb, boolean tAvb, boolean tlAvb, boolean trAvb, int[][][] x, H264Const.PartPred[] pp, Picture8Bit mb, int[] blocks8x8) {
        int[] a0 = this.s.mvLeft[0][0];
        int[] a1 = this.s.mvLeft[1][0];
        int[] b0 = this.s.mvTop[0][mbX << 2];
        int[] b1 = this.s.mvTop[1][mbX << 2];
        int[] c0 = this.s.mvTop[0][(mbX << 2) + 4];
        int[] c1 = this.s.mvTop[1][(mbX << 2) + 4];
        int[] d0 = this.s.mvTopLeft[0];
        int[] d1 = this.s.mvTopLeft[1];
        int refIdxL0 = this.calcRef(a0, b0, c0, d0, lAvb, tAvb, tlAvb, trAvb, mbX);
        int refIdxL1 = this.calcRef(a1, b1, c1, d1, lAvb, tAvb, tlAvb, trAvb, mbX);
        if (refIdxL0 < 0 && refIdxL1 < 0) {
            for (int i = 0; i < blocks8x8.length; ++i) {
                int blk8x8 = blocks8x8[i];
                int[] js = H264Const.BLK8x8_BLOCKS[blk8x8];
                for (int j = 0; j < js.length; ++j) {
                    int blk4x4 = js[j];
                    x[1][blk4x4][2] = 0;
                    x[1][blk4x4][1] = 0;
                    x[1][blk4x4][0] = 0;
                    x[0][blk4x4][2] = 0;
                    x[0][blk4x4][1] = 0;
                    x[0][blk4x4][0] = 0;
                }
                pp[blk8x8] = H264Const.PartPred.Bi;
                int blkOffX = (blk8x8 & 1) << 5;
                int blkOffY = blk8x8 >> 1 << 5;
                this.interpolator.getBlockLuma(refs[0][0], this.mbb[0], H264Const.BLK_8x8_MB_OFF_LUMA[blk8x8], (mbX << 6) + blkOffX, (mbY << 6) + blkOffY, 8, 8);
                this.interpolator.getBlockLuma(refs[1][0], this.mbb[1], H264Const.BLK_8x8_MB_OFF_LUMA[blk8x8], (mbX << 6) + blkOffX, (mbY << 6) + blkOffY, 8, 8);
                PredictionMerger.mergePrediction(this.sh, 0, 0, H264Const.PartPred.Bi, 0, this.mbb[0].getPlaneData(0), this.mbb[1].getPlaneData(0), H264Const.BLK_8x8_MB_OFF_LUMA[blk8x8], 16, 8, 8, mb.getPlaneData(0), refs, this.poc);
                MBlockDecoderUtils.debugPrint("DIRECT_8x8 [%d, %d]: (0,0,0), (0,0,0)", blk8x8 & 2, blk8x8 << 1 & 2);
            }
            return;
        }
        int mvX0 = MBlockDecoderUtils.calcMVPredictionMedian(a0, b0, c0, d0, lAvb, tAvb, trAvb, tlAvb, refIdxL0, 0);
        int mvY0 = MBlockDecoderUtils.calcMVPredictionMedian(a0, b0, c0, d0, lAvb, tAvb, trAvb, tlAvb, refIdxL0, 1);
        int mvX1 = MBlockDecoderUtils.calcMVPredictionMedian(a1, b1, c1, d1, lAvb, tAvb, trAvb, tlAvb, refIdxL1, 0);
        int mvY1 = MBlockDecoderUtils.calcMVPredictionMedian(a1, b1, c1, d1, lAvb, tAvb, trAvb, tlAvb, refIdxL1, 1);
        Frame col = refs[1][0];
        H264Const.PartPred partPred = refIdxL0 >= 0 && refIdxL1 >= 0 ? H264Const.PartPred.Bi : (refIdxL0 >= 0 ? H264Const.PartPred.L0 : H264Const.PartPred.L1);
        for (int i = 0; i < blocks8x8.length; ++i) {
            int blk8x8 = blocks8x8[i];
            int blk4x4_0 = H264Const.BLK8x8_BLOCKS[blk8x8][0];
            if (!this.sh.sps.direct_8x8_inference_flag) {
                int[] js = H264Const.BLK8x8_BLOCKS[blk8x8];
                for (int j = 0; j < js.length; ++j) {
                    int blk4x4 = js[j];
                    this.pred4x4(mbX, mbY, x, pp, refIdxL0, refIdxL1, mvX0, mvY0, mvX1, mvY1, col, partPred, blk4x4);
                    int blkIndX = blk4x4 & 3;
                    int blkIndY = blk4x4 >> 2;
                    MBlockDecoderUtils.debugPrint("DIRECT_4x4 [%d, %d]: (%d,%d,%d), (%d,%d," + refIdxL1 + ")", blkIndY, blkIndX, x[0][blk4x4][0], x[0][blk4x4][1], refIdxL0, x[1][blk4x4][0], x[1][blk4x4][1]);
                    int blkPredX = (mbX << 6) + (blkIndX << 4);
                    int blkPredY = (mbY << 6) + (blkIndY << 4);
                    if (refIdxL0 >= 0) {
                        this.interpolator.getBlockLuma(refs[0][refIdxL0], this.mbb[0], H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4], blkPredX + x[0][blk4x4][0], blkPredY + x[0][blk4x4][1], 4, 4);
                    }
                    if (refIdxL1 < 0) continue;
                    this.interpolator.getBlockLuma(refs[1][refIdxL1], this.mbb[1], H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4], blkPredX + x[1][blk4x4][0], blkPredY + x[1][blk4x4][1], 4, 4);
                }
            } else {
                int blk4x4Pred = H264Const.BLK_INV_MAP[blk8x8 * 5];
                this.pred4x4(mbX, mbY, x, pp, refIdxL0, refIdxL1, mvX0, mvY0, mvX1, mvY1, col, partPred, blk4x4Pred);
                this.propagatePred(x, blk8x8, blk4x4Pred);
                int blkIndX = blk4x4_0 & 3;
                int blkIndY = blk4x4_0 >> 2;
                MBlockDecoderUtils.debugPrint("DIRECT_8x8 [%d, %d]: (%d,%d,%d), (%d,%d,%d)", blkIndY, blkIndX, x[0][blk4x4_0][0], x[0][blk4x4_0][1], refIdxL0, x[1][blk4x4_0][0], x[1][blk4x4_0][1], refIdxL1);
                int blkPredX = (mbX << 6) + (blkIndX << 4);
                int blkPredY = (mbY << 6) + (blkIndY << 4);
                if (refIdxL0 >= 0) {
                    this.interpolator.getBlockLuma(refs[0][refIdxL0], this.mbb[0], H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4_0], blkPredX + x[0][blk4x4_0][0], blkPredY + x[0][blk4x4_0][1], 8, 8);
                }
                if (refIdxL1 >= 0) {
                    this.interpolator.getBlockLuma(refs[1][refIdxL1], this.mbb[1], H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4_0], blkPredX + x[1][blk4x4_0][0], blkPredY + x[1][blk4x4_0][1], 8, 8);
                }
            }
            PredictionMerger.mergePrediction(this.sh, x[0][blk4x4_0][2], x[1][blk4x4_0][2], refIdxL0 >= 0 ? (refIdxL1 >= 0 ? H264Const.PartPred.Bi : H264Const.PartPred.L0) : H264Const.PartPred.L1, 0, this.mbb[0].getPlaneData(0), this.mbb[1].getPlaneData(0), H264Const.BLK_4x4_MB_OFF_LUMA[blk4x4_0], 16, 8, 8, mb.getPlaneData(0), refs, this.poc);
        }
    }

    private int calcRef(int[] a0, int[] b0, int[] c0, int[] d0, boolean lAvb, boolean tAvb, boolean tlAvb, boolean trAvb, int mbX) {
        return this.minPos(this.minPos(lAvb ? a0[2] : -1, tAvb ? b0[2] : -1), trAvb ? c0[2] : (tlAvb ? d0[2] : -1));
    }

    private void propagatePred(int[][][] x, int blk8x8, int blk4x4Pred) {
        int b0 = H264Const.BLK8x8_BLOCKS[blk8x8][0];
        int b1 = H264Const.BLK8x8_BLOCKS[blk8x8][1];
        int b2 = H264Const.BLK8x8_BLOCKS[blk8x8][2];
        int b3 = H264Const.BLK8x8_BLOCKS[blk8x8][3];
        int n = x[0][blk4x4Pred][0];
        x[0][b3][0] = n;
        x[0][b2][0] = n;
        x[0][b1][0] = n;
        x[0][b0][0] = n;
        int n2 = x[0][blk4x4Pred][1];
        x[0][b3][1] = n2;
        x[0][b2][1] = n2;
        x[0][b1][1] = n2;
        x[0][b0][1] = n2;
        int n3 = x[0][blk4x4Pred][2];
        x[0][b3][2] = n3;
        x[0][b2][2] = n3;
        x[0][b1][2] = n3;
        x[0][b0][2] = n3;
        int n4 = x[1][blk4x4Pred][0];
        x[1][b3][0] = n4;
        x[1][b2][0] = n4;
        x[1][b1][0] = n4;
        x[1][b0][0] = n4;
        int n5 = x[1][blk4x4Pred][1];
        x[1][b3][1] = n5;
        x[1][b2][1] = n5;
        x[1][b1][1] = n5;
        x[1][b0][1] = n5;
        int n6 = x[1][blk4x4Pred][2];
        x[1][b3][2] = n6;
        x[1][b2][2] = n6;
        x[1][b1][2] = n6;
        x[1][b0][2] = n6;
    }

    private void pred4x4(int mbX, int mbY, int[][][] x, H264Const.PartPred[] pp, int refL0, int refL1, int mvX0, int mvY0, int mvX1, int mvY1, Frame col, H264Const.PartPred partPred, int blk4x4) {
        boolean colZero;
        int blkIndX = blk4x4 & 3;
        int blkIndY = blk4x4 >> 2;
        int blkPosX = (mbX << 2) + blkIndX;
        int blkPosY = (mbY << 2) + blkIndY;
        x[0][blk4x4][2] = refL0;
        x[1][blk4x4][2] = refL1;
        int[] mvCol = col.getMvs()[0][blkPosY][blkPosX];
        if (mvCol[2] == -1) {
            mvCol = col.getMvs()[1][blkPosY][blkPosX];
        }
        boolean bl = colZero = col.isShortTerm() && mvCol[2] == 0 && MathUtil.abs(mvCol[0]) >> 1 == 0 && MathUtil.abs(mvCol[1]) >> 1 == 0;
        if (refL0 > 0 || !colZero) {
            x[0][blk4x4][0] = mvX0;
            x[0][blk4x4][1] = mvY0;
        }
        if (refL1 > 0 || !colZero) {
            x[1][blk4x4][0] = mvX1;
            x[1][blk4x4][1] = mvY1;
        }
        pp[H264Const.BLK_8x8_IND[blk4x4]] = partPred;
    }

    private int minPos(int a, int b) {
        return a >= 0 && b >= 0 ? Math.min(a, b) : Math.max(a, b);
    }
}

