/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import java.util.Arrays;
import org.jcodec.codecs.h264.H264Const;
import org.jcodec.codecs.h264.decode.BlockInterpolator;
import org.jcodec.codecs.h264.decode.ChromaPredictionBuilder;
import org.jcodec.codecs.h264.decode.CoeffTransformer;
import org.jcodec.codecs.h264.decode.DeblockerInput;
import org.jcodec.codecs.h264.decode.DecoderState;
import org.jcodec.codecs.h264.decode.MBlock;
import org.jcodec.codecs.h264.decode.PredictionMerger;
import org.jcodec.codecs.h264.io.model.Frame;
import org.jcodec.codecs.h264.io.model.MBType;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture8Bit;
import org.jcodec.common.tools.MathUtil;

public class MBlockDecoderBase {
    protected DecoderState s;
    protected SliceHeader sh;
    protected DeblockerInput di;
    protected int poc;
    protected BlockInterpolator interpolator = new BlockInterpolator();
    protected Picture8Bit[] mbb;

    public MBlockDecoderBase(SliceHeader sh, DeblockerInput di, int poc, DecoderState decoderState) {
        this.s = decoderState;
        this.sh = sh;
        this.di = di;
        this.poc = poc;
        this.mbb = new Picture8Bit[]{Picture8Bit.create(16, 16, this.s.chromaFormat), Picture8Bit.create(16, 16, this.s.chromaFormat)};
    }

    void residualLuma(MBlock mBlock, boolean leftAvailable, boolean topAvailable, int mbX, int mbY) {
        if (!mBlock.transform8x8Used) {
            this._residualLuma(mBlock);
        } else if (this.sh.pps.entropy_coding_mode_flag) {
            this.residualLuma8x8CABAC(mBlock);
        } else {
            this.residualLuma8x8CAVLC(mBlock);
        }
    }

    private void _residualLuma(MBlock mBlock) {
        for (int i = 0; i < 16; ++i) {
            if ((mBlock.cbpLuma() & 1 << (i >> 2)) == 0) continue;
            CoeffTransformer.dequantizeAC(mBlock.ac[0][i], this.s.qp);
            CoeffTransformer.idct4x4(mBlock.ac[0][i]);
        }
    }

    private void residualLuma8x8CABAC(MBlock mBlock) {
        for (int i = 0; i < 4; ++i) {
            if ((mBlock.cbpLuma() & 1 << i) == 0) continue;
            CoeffTransformer.dequantizeAC8x8(mBlock.ac[0][i], this.s.qp);
            CoeffTransformer.idct8x8(mBlock.ac[0][i]);
        }
    }

    private void residualLuma8x8CAVLC(MBlock mBlock) {
        for (int i = 0; i < 4; ++i) {
            if ((mBlock.cbpLuma() & 1 << i) == 0) continue;
            CoeffTransformer.dequantizeAC8x8(mBlock.ac[0][i], this.s.qp);
            CoeffTransformer.idct8x8(mBlock.ac[0][i]);
        }
    }

    public void decodeChroma(MBlock mBlock, int mbX, int mbY, boolean leftAvailable, boolean topAvailable, Picture8Bit mb, int qp) {
        if (this.s.chromaFormat == ColorSpace.MONO) {
            Arrays.fill(mb.getPlaneData(1), (byte)0);
            Arrays.fill(mb.getPlaneData(2), (byte)0);
            return;
        }
        int qp1 = this.calcQpChroma(qp, this.s.chromaQpOffset[0]);
        int qp2 = this.calcQpChroma(qp, this.s.chromaQpOffset[1]);
        if (mBlock.cbpChroma() != 0) {
            this.decodeChromaResidual(mBlock, leftAvailable, topAvailable, mbX, mbY, qp1, qp2);
        }
        int addr = mbY * (this.sh.sps.pic_width_in_mbs_minus1 + 1) + mbX;
        this.di.mbQps[1][addr] = qp1;
        this.di.mbQps[2][addr] = qp2;
        ChromaPredictionBuilder.predictWithMode(mBlock.ac[1], mBlock.chromaPredictionMode, mbX, leftAvailable, topAvailable, this.s.leftRow[1], this.s.topLine[1], this.s.topLeft[1], mb.getPlaneData(1));
        ChromaPredictionBuilder.predictWithMode(mBlock.ac[2], mBlock.chromaPredictionMode, mbX, leftAvailable, topAvailable, this.s.leftRow[2], this.s.topLine[2], this.s.topLeft[2], mb.getPlaneData(2));
    }

    void decodeChromaResidual(MBlock mBlock, boolean leftAvailable, boolean topAvailable, int mbX, int mbY, int crQp1, int crQp2) {
        if (mBlock.cbpChroma() != 0) {
            if ((mBlock.cbpChroma() & 3) > 0) {
                this.chromaDC(mbX, leftAvailable, topAvailable, mBlock.dc1, 1, crQp1, mBlock.curMbType);
                this.chromaDC(mbX, leftAvailable, topAvailable, mBlock.dc2, 2, crQp2, mBlock.curMbType);
            }
            this.chromaAC(leftAvailable, topAvailable, mbX, mbY, mBlock.dc1, 1, crQp1, mBlock.curMbType, (mBlock.cbpChroma() & 2) > 0, mBlock.ac[1]);
            this.chromaAC(leftAvailable, topAvailable, mbX, mbY, mBlock.dc2, 2, crQp2, mBlock.curMbType, (mBlock.cbpChroma() & 2) > 0, mBlock.ac[2]);
        }
    }

    private void chromaDC(int mbX, boolean leftAvailable, boolean topAvailable, int[] dc, int comp, int crQp, MBType curMbType) {
        CoeffTransformer.invDC2x2(dc);
        CoeffTransformer.dequantizeDC2x2(dc, crQp);
    }

    private void chromaAC(boolean leftAvailable, boolean topAvailable, int mbX, int mbY, int[] dc, int comp, int crQp, MBType curMbType, boolean codedAC, int[][] residualOut) {
        for (int i = 0; i < dc.length; ++i) {
            int[] ac = residualOut[i];
            if (codedAC) {
                CoeffTransformer.dequantizeAC(ac, crQp);
            }
            ac[0] = dc[i];
            CoeffTransformer.idct4x4(ac);
        }
    }

    int calcQpChroma(int qp, int crQpOffset) {
        return H264Const.QP_SCALE_CR[MathUtil.clip(qp + crQpOffset, 0, 51)];
    }

    public void predictChromaInter(Frame[][] refs, int[][][] vectors, int x, int y, int comp, Picture8Bit mb, H264Const.PartPred[] predType) {
        for (int blk8x8 = 0; blk8x8 < 4; ++blk8x8) {
            for (int list = 0; list < 2; ++list) {
                if (!H264Const.usesList(predType[blk8x8], list)) continue;
                for (int blk4x4 = 0; blk4x4 < 4; ++blk4x4) {
                    int i = H264Const.BLK_INV_MAP[(blk8x8 << 2) + blk4x4];
                    int[] mv = vectors[list][i];
                    Frame ref = refs[list][mv[2]];
                    int blkPox = (i & 3) << 1;
                    int blkPoy = i >> 2 << 1;
                    int xx = (x + blkPox << 3) + mv[0];
                    int yy = (y + blkPoy << 3) + mv[1];
                    this.interpolator.getBlockChroma(ref.getPlaneData(comp), ref.getPlaneWidth(comp), ref.getPlaneHeight(comp), this.mbb[list].getPlaneData(comp), blkPoy * mb.getPlaneWidth(comp) + blkPox, mb.getPlaneWidth(comp), xx, yy, 2, 2);
                }
            }
            int blk4x4 = H264Const.BLK8x8_BLOCKS[blk8x8][0];
            PredictionMerger.mergePrediction(this.sh, vectors[0][blk4x4][2], vectors[1][blk4x4][2], predType[blk8x8], comp, this.mbb[0].getPlaneData(comp), this.mbb[1].getPlaneData(comp), H264Const.BLK_8x8_MB_OFF_CHROMA[blk8x8], mb.getPlaneWidth(comp), 4, 4, mb.getPlaneData(comp), refs, this.poc);
        }
    }
}

