/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import java.util.Arrays;
import org.jcodec.codecs.h264.H264Const;
import org.jcodec.codecs.h264.decode.DeblockerInput;
import org.jcodec.codecs.h264.decode.DecoderState;
import org.jcodec.codecs.h264.decode.MBlock;
import org.jcodec.codecs.h264.decode.MBlockDecoderBDirect;
import org.jcodec.codecs.h264.decode.MBlockDecoderBase;
import org.jcodec.codecs.h264.decode.MBlockDecoderUtils;
import org.jcodec.codecs.h264.decode.PredictionMerger;
import org.jcodec.codecs.h264.decode.aso.Mapper;
import org.jcodec.codecs.h264.io.model.Frame;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.codecs.h264.io.model.SliceType;
import org.jcodec.common.model.Picture8Bit;

public class MBlockDecoderInter8x8
extends MBlockDecoderBase {
    private Mapper mapper;
    private MBlockDecoderBDirect bDirectDecoder;

    public MBlockDecoderInter8x8(Mapper mapper, MBlockDecoderBDirect bDirectDecoder, SliceHeader sh, DeblockerInput di, int poc, DecoderState decoderState) {
        super(sh, di, poc, decoderState);
        this.mapper = mapper;
        this.bDirectDecoder = bDirectDecoder;
    }

    public void decode(MBlock mBlock, Frame[][] references, Picture8Bit mb, SliceType sliceType, boolean ref0) {
        int mbX = this.mapper.getMbX(mBlock.mbIdx);
        int mbY = this.mapper.getMbY(mBlock.mbIdx);
        boolean leftAvailable = this.mapper.leftAvailable(mBlock.mbIdx);
        boolean topAvailable = this.mapper.topAvailable(mBlock.mbIdx);
        int mbAddr = this.mapper.getAddress(mBlock.mbIdx);
        boolean topLeftAvailable = this.mapper.topLeftAvailable(mBlock.mbIdx);
        boolean topRightAvailable = this.mapper.topRightAvailable(mBlock.mbIdx);
        int[][][] x = new int[2][16][3];
        H264Const.PartPred[] pp = new H264Const.PartPred[4];
        for (int i = 0; i < 16; ++i) {
            x[1][i][2] = -1;
            x[0][i][2] = -1;
        }
        if (sliceType == SliceType.P) {
            this.predict8x8P(mBlock, references[0], mb, ref0, mbX, mbY, leftAvailable, topAvailable, topLeftAvailable, topRightAvailable, x, pp);
        } else {
            this.predict8x8B(mBlock, references, mb, ref0, mbX, mbY, leftAvailable, topAvailable, topLeftAvailable, topRightAvailable, x, pp);
        }
        this.predictChromaInter(references, x, mbX << 3, mbY << 3, 1, mb, pp);
        this.predictChromaInter(references, x, mbX << 3, mbY << 3, 2, mb, pp);
        if (mBlock.cbpLuma() > 0 || mBlock.cbpChroma() > 0) {
            this.s.qp = (this.s.qp + mBlock.mbQPDelta + 52) % 52;
        }
        this.di.mbQps[0][mbAddr] = this.s.qp;
        this.residualLuma(mBlock, leftAvailable, topAvailable, mbX, mbY);
        MBlockDecoderUtils.saveMvs(this.di, x, mbX, mbY);
        int qp1 = this.calcQpChroma(this.s.qp, this.s.chromaQpOffset[0]);
        int qp2 = this.calcQpChroma(this.s.qp, this.s.chromaQpOffset[1]);
        this.decodeChromaResidual(mBlock, leftAvailable, topAvailable, mbX, mbY, qp1, qp2);
        this.di.mbQps[1][mbAddr] = qp1;
        this.di.mbQps[2][mbAddr] = qp2;
        MBlockDecoderUtils.mergeResidual(mb, mBlock.ac, mBlock.transform8x8Used ? H264Const.COMP_BLOCK_8x8_LUT : H264Const.COMP_BLOCK_4x4_LUT, mBlock.transform8x8Used ? H264Const.COMP_POS_8x8_LUT : H264Const.COMP_POS_4x4_LUT);
        MBlockDecoderUtils.collectPredictors(this.s, mb, mbX);
        this.di.mbTypes[mbAddr] = mBlock.curMbType;
        this.di.tr8x8Used[mbAddr] = mBlock.transform8x8Used;
    }

    private void predict8x8P(MBlock mBlock, Picture8Bit[] references, Picture8Bit mb, boolean ref0, int mbX, int mbY, boolean leftAvailable, boolean topAvailable, boolean tlAvailable, boolean topRightAvailable, int[][][] x, H264Const.PartPred[] pp) {
        this.decodeSubMb8x8(mBlock, 0, mBlock.pb8x8.subMbTypes[0], references, mbX << 6, mbY << 6, x[0], this.s.mvTopLeft[0], this.s.mvTop[0][mbX << 2], this.s.mvTop[0][(mbX << 2) + 1], this.s.mvTop[0][(mbX << 2) + 2], this.s.mvLeft[0][0], this.s.mvLeft[0][1], tlAvailable, topAvailable, topAvailable, leftAvailable, x[0][0], x[0][1], x[0][4], x[0][5], mBlock.pb8x8.refIdx[0][0], mb, 0, 0);
        this.decodeSubMb8x8(mBlock, 1, mBlock.pb8x8.subMbTypes[1], references, (mbX << 6) + 32, mbY << 6, x[0], this.s.mvTop[0][(mbX << 2) + 1], this.s.mvTop[0][(mbX << 2) + 2], this.s.mvTop[0][(mbX << 2) + 3], this.s.mvTop[0][(mbX << 2) + 4], x[0][1], x[0][5], topAvailable, topAvailable, topRightAvailable, true, x[0][2], x[0][3], x[0][6], x[0][7], mBlock.pb8x8.refIdx[0][1], mb, 8, 0);
        this.decodeSubMb8x8(mBlock, 2, mBlock.pb8x8.subMbTypes[2], references, mbX << 6, (mbY << 6) + 32, x[0], this.s.mvLeft[0][1], x[0][4], x[0][5], x[0][6], this.s.mvLeft[0][2], this.s.mvLeft[0][3], leftAvailable, true, true, leftAvailable, x[0][8], x[0][9], x[0][12], x[0][13], mBlock.pb8x8.refIdx[0][2], mb, 128, 0);
        this.decodeSubMb8x8(mBlock, 3, mBlock.pb8x8.subMbTypes[3], references, (mbX << 6) + 32, (mbY << 6) + 32, x[0], x[0][5], x[0][6], x[0][7], null, x[0][9], x[0][13], true, true, false, true, x[0][10], x[0][11], x[0][14], x[0][15], mBlock.pb8x8.refIdx[0][3], mb, 136, 0);
        for (int i = 0; i < 4; ++i) {
            int blk4x4 = H264Const.BLK8x8_BLOCKS[i][0];
            PredictionMerger.weightPrediction(this.sh, x[0][blk4x4][2], 0, mb.getPlaneData(0), H264Const.BLK_8x8_MB_OFF_LUMA[i], 16, 8, 8, mb.getPlaneData(0));
        }
        MBlockDecoderUtils.savePrediction8x8(this.s, mbX, x[0], 0);
        Arrays.fill((Object[])pp, (Object)H264Const.PartPred.L0);
    }

    private void predict8x8B(MBlock mBlock, Frame[][] refs, Picture8Bit mb, boolean ref0, int mbX, int mbY, boolean leftAvailable, boolean topAvailable, boolean tlAvailable, boolean topRightAvailable, int[][][] x, H264Const.PartPred[] p) {
        int i;
        for (int i2 = 0; i2 < 4; ++i2) {
            p[i2] = H264Const.bPartPredModes[mBlock.pb8x8.subMbTypes[i2]];
        }
        int blk8x8X = mbX << 1;
        H264Const.PartPred[] _pp = new H264Const.PartPred[4];
        for (i = 0; i < 4; ++i) {
            if (p[i] != H264Const.PartPred.Direct) continue;
            this.bDirectDecoder.predictBDirect(refs, mbX, mbY, leftAvailable, topAvailable, tlAvailable, topRightAvailable, x, _pp, mb, H264Const.ARRAY[i]);
        }
        for (int list = 0; list < 2; ++list) {
            if (H264Const.usesList(p[0], list)) {
                this.decodeSubMb8x8(mBlock, 0, H264Const.bSubMbTypes[mBlock.pb8x8.subMbTypes[0]], refs[list], mbX << 6, mbY << 6, x[list], this.s.mvTopLeft[list], this.s.mvTop[list][mbX << 2], this.s.mvTop[list][(mbX << 2) + 1], this.s.mvTop[list][(mbX << 2) + 2], this.s.mvLeft[list][0], this.s.mvLeft[list][1], tlAvailable, topAvailable, topAvailable, leftAvailable, x[list][0], x[list][1], x[list][4], x[list][5], mBlock.pb8x8.refIdx[list][0], this.mbb[list], 0, list);
            }
            if (H264Const.usesList(p[1], list)) {
                this.decodeSubMb8x8(mBlock, 1, H264Const.bSubMbTypes[mBlock.pb8x8.subMbTypes[1]], refs[list], (mbX << 6) + 32, mbY << 6, x[list], this.s.mvTop[list][(mbX << 2) + 1], this.s.mvTop[list][(mbX << 2) + 2], this.s.mvTop[list][(mbX << 2) + 3], this.s.mvTop[list][(mbX << 2) + 4], x[list][1], x[list][5], topAvailable, topAvailable, topRightAvailable, true, x[list][2], x[list][3], x[list][6], x[list][7], mBlock.pb8x8.refIdx[list][1], this.mbb[list], 8, list);
            }
            if (H264Const.usesList(p[2], list)) {
                this.decodeSubMb8x8(mBlock, 2, H264Const.bSubMbTypes[mBlock.pb8x8.subMbTypes[2]], refs[list], mbX << 6, (mbY << 6) + 32, x[list], this.s.mvLeft[list][1], x[list][4], x[list][5], x[list][6], this.s.mvLeft[list][2], this.s.mvLeft[list][3], leftAvailable, true, true, leftAvailable, x[list][8], x[list][9], x[list][12], x[list][13], mBlock.pb8x8.refIdx[list][2], this.mbb[list], 128, list);
            }
            if (!H264Const.usesList(p[3], list)) continue;
            this.decodeSubMb8x8(mBlock, 3, H264Const.bSubMbTypes[mBlock.pb8x8.subMbTypes[3]], refs[list], (mbX << 6) + 32, (mbY << 6) + 32, x[list], x[list][5], x[list][6], x[list][7], null, x[list][9], x[list][13], true, true, false, true, x[list][10], x[list][11], x[list][14], x[list][15], mBlock.pb8x8.refIdx[list][3], this.mbb[list], 136, list);
        }
        for (i = 0; i < 4; ++i) {
            int blk4x4 = H264Const.BLK8x8_BLOCKS[i][0];
            PredictionMerger.mergePrediction(this.sh, x[0][blk4x4][2], x[1][blk4x4][2], p[i], 0, this.mbb[0].getPlaneData(0), this.mbb[1].getPlaneData(0), H264Const.BLK_8x8_MB_OFF_LUMA[i], 16, 8, 8, mb.getPlaneData(0), refs, this.poc);
        }
        MBlockDecoderUtils.savePrediction8x8(this.s, mbX, x[0], 0);
        MBlockDecoderUtils.savePrediction8x8(this.s, mbX, x[1], 1);
        for (i = 0; i < 4; ++i) {
            if (p[i] != H264Const.PartPred.Direct) continue;
            p[i] = _pp[i];
        }
    }

    private void decodeSubMb8x8(MBlock mBlock, int partNo, int subMbType, Picture8Bit[] references, int offX, int offY, int[][] x, int[] tl, int[] t0, int[] t1, int[] tr, int[] l0, int[] l1, boolean tlAvb, boolean tAvb, boolean trAvb, boolean lAvb, int[] x00, int[] x01, int[] x10, int[] x11, int refIdx, Picture8Bit mb, int off, int list) {
        x10[2] = x11[2] = refIdx;
        x01[2] = x11[2];
        x00[2] = x11[2];
        switch (subMbType) {
            case 3: {
                this.decodeSub4x4(mBlock, partNo, references, offX, offY, tl, t0, t1, tr, l0, l1, tlAvb, tAvb, trAvb, lAvb, x00, x01, x10, x11, refIdx, mb, off, list);
                break;
            }
            case 2: {
                this.decodeSub4x8(mBlock, partNo, references, offX, offY, tl, t0, t1, tr, l0, tlAvb, tAvb, trAvb, lAvb, x00, x01, x10, x11, refIdx, mb, off, list);
                break;
            }
            case 1: {
                this.decodeSub8x4(mBlock, partNo, references, offX, offY, tl, t0, tr, l0, l1, tlAvb, tAvb, trAvb, lAvb, x00, x01, x10, x11, refIdx, mb, off, list);
                break;
            }
            case 0: {
                this.decodeSub8x8(mBlock, partNo, references, offX, offY, tl, t0, tr, l0, tlAvb, tAvb, trAvb, lAvb, x00, x01, x10, x11, refIdx, mb, off, list);
            }
        }
    }

    private void decodeSub8x8(MBlock mBlock, int partNo, Picture8Bit[] references, int offX, int offY, int[] tl, int[] t0, int[] tr, int[] l0, boolean tlAvb, boolean tAvb, boolean trAvb, boolean lAvb, int[] x00, int[] x01, int[] x10, int[] x11, int refIdx, Picture8Bit mb, int off, int list) {
        int mvpX = MBlockDecoderUtils.calcMVPredictionMedian(l0, t0, tr, tl, lAvb, tAvb, trAvb, tlAvb, refIdx, 0);
        int mvpY = MBlockDecoderUtils.calcMVPredictionMedian(l0, t0, tr, tl, lAvb, tAvb, trAvb, tlAvb, refIdx, 1);
        x10[0] = x11[0] = mBlock.pb8x8.mvdX1[list][partNo] + mvpX;
        x01[0] = x11[0];
        x00[0] = x11[0];
        x10[1] = x11[1] = mBlock.pb8x8.mvdY1[list][partNo] + mvpY;
        x01[1] = x11[1];
        x00[1] = x11[1];
        MBlockDecoderUtils.debugPrint("MVP: (%d, %d), MVD: (%d, %d), MV: (%d,%d,%d)", mvpX, mvpY, mBlock.pb8x8.mvdX1[list][partNo], mBlock.pb8x8.mvdY1[list][partNo], x00[0], x00[1], refIdx);
        this.interpolator.getBlockLuma(references[refIdx], mb, off, offX + x00[0], offY + x00[1], 8, 8);
    }

    private void decodeSub8x4(MBlock mBlock, int partNo, Picture8Bit[] references, int offX, int offY, int[] tl, int[] t0, int[] tr, int[] l0, int[] l1, boolean tlAvb, boolean tAvb, boolean trAvb, boolean lAvb, int[] x00, int[] x01, int[] x10, int[] x11, int refIdx, Picture8Bit mb, int off, int list) {
        int mvpX1 = MBlockDecoderUtils.calcMVPredictionMedian(l0, t0, tr, tl, lAvb, tAvb, trAvb, tlAvb, refIdx, 0);
        int mvpY1 = MBlockDecoderUtils.calcMVPredictionMedian(l0, t0, tr, tl, lAvb, tAvb, trAvb, tlAvb, refIdx, 1);
        x00[0] = x01[0] = mBlock.pb8x8.mvdX1[list][partNo] + mvpX1;
        x00[1] = x01[1] = mBlock.pb8x8.mvdY1[list][partNo] + mvpY1;
        MBlockDecoderUtils.debugPrint("MVP: (%d, %d), MVD: (%d, %d), MV: (%d,%d,%d)", mvpX1, mvpY1, mBlock.pb8x8.mvdX1[list][partNo], mBlock.pb8x8.mvdY1[list][partNo], x00[0], x00[1], refIdx);
        int mvpX2 = MBlockDecoderUtils.calcMVPredictionMedian(l1, x00, MBlockDecoderUtils.NULL_VECTOR, l0, lAvb, true, false, lAvb, refIdx, 0);
        int mvpY2 = MBlockDecoderUtils.calcMVPredictionMedian(l1, x00, MBlockDecoderUtils.NULL_VECTOR, l0, lAvb, true, false, lAvb, refIdx, 1);
        x10[0] = x11[0] = mBlock.pb8x8.mvdX2[list][partNo] + mvpX2;
        x10[1] = x11[1] = mBlock.pb8x8.mvdY2[list][partNo] + mvpY2;
        MBlockDecoderUtils.debugPrint("MVP: (%d, %d), MVD: (%d, %d), MV: (%d,%d,%d)", mvpX2, mvpY2, mBlock.pb8x8.mvdX2[list][partNo], mBlock.pb8x8.mvdY2[list][partNo], x10[0], x10[1], refIdx);
        this.interpolator.getBlockLuma(references[refIdx], mb, off, offX + x00[0], offY + x00[1], 8, 4);
        this.interpolator.getBlockLuma(references[refIdx], mb, off + mb.getWidth() * 4, offX + x10[0], offY + x10[1] + 16, 8, 4);
    }

    private void decodeSub4x8(MBlock mBlock, int partNo, Picture8Bit[] references, int offX, int offY, int[] tl, int[] t0, int[] t1, int[] tr, int[] l0, boolean tlAvb, boolean tAvb, boolean trAvb, boolean lAvb, int[] x00, int[] x01, int[] x10, int[] x11, int refIdx, Picture8Bit mb, int off, int list) {
        int mvpX1 = MBlockDecoderUtils.calcMVPredictionMedian(l0, t0, t1, tl, lAvb, tAvb, tAvb, tlAvb, refIdx, 0);
        int mvpY1 = MBlockDecoderUtils.calcMVPredictionMedian(l0, t0, t1, tl, lAvb, tAvb, tAvb, tlAvb, refIdx, 1);
        x00[0] = x10[0] = mBlock.pb8x8.mvdX1[list][partNo] + mvpX1;
        x00[1] = x10[1] = mBlock.pb8x8.mvdY1[list][partNo] + mvpY1;
        MBlockDecoderUtils.debugPrint("MVP: (%d, %d), MVD: (%d, %d), MV: (%d,%d,%d)", mvpX1, mvpY1, mBlock.pb8x8.mvdX1[list][partNo], mBlock.pb8x8.mvdY1[list][partNo], x00[0], x00[1], refIdx);
        int mvpX2 = MBlockDecoderUtils.calcMVPredictionMedian(x00, t1, tr, t0, true, tAvb, trAvb, tAvb, refIdx, 0);
        int mvpY2 = MBlockDecoderUtils.calcMVPredictionMedian(x00, t1, tr, t0, true, tAvb, trAvb, tAvb, refIdx, 1);
        x01[0] = x11[0] = mBlock.pb8x8.mvdX2[list][partNo] + mvpX2;
        x01[1] = x11[1] = mBlock.pb8x8.mvdY2[list][partNo] + mvpY2;
        MBlockDecoderUtils.debugPrint("MVP: (%d, %d), MVD: (%d, %d), MV: (%d,%d,%d)", mvpX2, mvpY2, mBlock.pb8x8.mvdX2[list][partNo], mBlock.pb8x8.mvdY2[list][partNo], x01[0], x01[1], refIdx);
        this.interpolator.getBlockLuma(references[refIdx], mb, off, offX + x00[0], offY + x00[1], 4, 8);
        this.interpolator.getBlockLuma(references[refIdx], mb, off + 4, offX + x01[0] + 16, offY + x01[1], 4, 8);
    }

    private void decodeSub4x4(MBlock mBlock, int partNo, Picture8Bit[] references, int offX, int offY, int[] tl, int[] t0, int[] t1, int[] tr, int[] l0, int[] l1, boolean tlAvb, boolean tAvb, boolean trAvb, boolean lAvb, int[] x00, int[] x01, int[] x10, int[] x11, int refIdx, Picture8Bit mb, int off, int list) {
        int mvpX1 = MBlockDecoderUtils.calcMVPredictionMedian(l0, t0, t1, tl, lAvb, tAvb, tAvb, tlAvb, refIdx, 0);
        int mvpY1 = MBlockDecoderUtils.calcMVPredictionMedian(l0, t0, t1, tl, lAvb, tAvb, tAvb, tlAvb, refIdx, 1);
        x00[0] = mBlock.pb8x8.mvdX1[list][partNo] + mvpX1;
        x00[1] = mBlock.pb8x8.mvdY1[list][partNo] + mvpY1;
        MBlockDecoderUtils.debugPrint("MVP: (%d, %d), MVD: (%d, %d), MV: (%d,%d,%d)", mvpX1, mvpY1, mBlock.pb8x8.mvdX1[list][partNo], mBlock.pb8x8.mvdY1[list][partNo], x00[0], x00[1], refIdx);
        int mvpX2 = MBlockDecoderUtils.calcMVPredictionMedian(x00, t1, tr, t0, true, tAvb, trAvb, tAvb, refIdx, 0);
        int mvpY2 = MBlockDecoderUtils.calcMVPredictionMedian(x00, t1, tr, t0, true, tAvb, trAvb, tAvb, refIdx, 1);
        x01[0] = mBlock.pb8x8.mvdX2[list][partNo] + mvpX2;
        x01[1] = mBlock.pb8x8.mvdY2[list][partNo] + mvpY2;
        MBlockDecoderUtils.debugPrint("MVP: (%d, %d), MVD: (%d, %d), MV: (%d,%d,%d)", mvpX2, mvpY2, mBlock.pb8x8.mvdX2[list][partNo], mBlock.pb8x8.mvdY2[list][partNo], x01[0], x01[1], refIdx);
        int mvpX3 = MBlockDecoderUtils.calcMVPredictionMedian(l1, x00, x01, l0, lAvb, true, true, lAvb, refIdx, 0);
        int mvpY3 = MBlockDecoderUtils.calcMVPredictionMedian(l1, x00, x01, l0, lAvb, true, true, lAvb, refIdx, 1);
        x10[0] = mBlock.pb8x8.mvdX3[list][partNo] + mvpX3;
        x10[1] = mBlock.pb8x8.mvdY3[list][partNo] + mvpY3;
        MBlockDecoderUtils.debugPrint("MVP: (%d, %d), MVD: (%d, %d), MV: (%d,%d,%d)", mvpX3, mvpY3, mBlock.pb8x8.mvdX3[list][partNo], mBlock.pb8x8.mvdY3[list][partNo], x10[0], x10[1], refIdx);
        int mvpX4 = MBlockDecoderUtils.calcMVPredictionMedian(x10, x01, MBlockDecoderUtils.NULL_VECTOR, x00, true, true, false, true, refIdx, 0);
        int mvpY4 = MBlockDecoderUtils.calcMVPredictionMedian(x10, x01, MBlockDecoderUtils.NULL_VECTOR, x00, true, true, false, true, refIdx, 1);
        x11[0] = mBlock.pb8x8.mvdX4[list][partNo] + mvpX4;
        x11[1] = mBlock.pb8x8.mvdY4[list][partNo] + mvpY4;
        MBlockDecoderUtils.debugPrint("MVP: (%d, %d), MVD: (%d, %d), MV: (%d,%d,%d)", mvpX4, mvpY4, mBlock.pb8x8.mvdX4[list][partNo], mBlock.pb8x8.mvdY4[list][partNo], x11[0], x11[1], refIdx);
        this.interpolator.getBlockLuma(references[refIdx], mb, off, offX + x00[0], offY + x00[1], 4, 4);
        this.interpolator.getBlockLuma(references[refIdx], mb, off + 4, offX + x01[0] + 16, offY + x01[1], 4, 4);
        this.interpolator.getBlockLuma(references[refIdx], mb, off + mb.getWidth() * 4, offX + x10[0], offY + x10[1] + 16, 4, 4);
        this.interpolator.getBlockLuma(references[refIdx], mb, off + mb.getWidth() * 4 + 4, offX + x11[0] + 16, offY + x11[1] + 16, 4, 4);
    }
}

