/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import java.util.Arrays;
import org.jcodec.codecs.h264.H264Const;
import org.jcodec.codecs.h264.decode.DeblockerInput;
import org.jcodec.codecs.h264.decode.DecoderState;
import org.jcodec.codecs.h264.decode.MBlock;
import org.jcodec.codecs.h264.decode.MBlockDecoderBDirect;
import org.jcodec.codecs.h264.decode.MBlockDecoderBase;
import org.jcodec.codecs.h264.decode.MBlockDecoderUtils;
import org.jcodec.codecs.h264.decode.PredictionMerger;
import org.jcodec.codecs.h264.decode.aso.Mapper;
import org.jcodec.codecs.h264.io.model.Frame;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.codecs.h264.io.model.SliceType;
import org.jcodec.common.model.Picture8Bit;

public class MBlockSkipDecoder
extends MBlockDecoderBase {
    private Mapper mapper;
    private MBlockDecoderBDirect bDirectDecoder;

    public MBlockSkipDecoder(Mapper mapper, MBlockDecoderBDirect bDirectDecoder, SliceHeader sh, DeblockerInput di, int poc, DecoderState sharedState) {
        super(sh, di, poc, sharedState);
        this.mapper = mapper;
        this.bDirectDecoder = bDirectDecoder;
    }

    public void decodeSkip(MBlock mBlock, Frame[][] refs, Picture8Bit mb, SliceType sliceType) {
        int mbX = this.mapper.getMbX(mBlock.mbIdx);
        int mbY = this.mapper.getMbY(mBlock.mbIdx);
        int mbAddr = this.mapper.getAddress(mBlock.mbIdx);
        int[][][] x = new int[2][16][3];
        H264Const.PartPred[] pp = new H264Const.PartPred[4];
        for (int i = 0; i < 16; ++i) {
            x[1][i][2] = -1;
            x[0][i][2] = -1;
        }
        if (sliceType == SliceType.P) {
            this.predictPSkip(refs, mbX, mbY, this.mapper.leftAvailable(mBlock.mbIdx), this.mapper.topAvailable(mBlock.mbIdx), this.mapper.topLeftAvailable(mBlock.mbIdx), this.mapper.topRightAvailable(mBlock.mbIdx), x, mb);
            Arrays.fill((Object[])pp, (Object)H264Const.PartPred.L0);
        } else {
            this.bDirectDecoder.predictBDirect(refs, mbX, mbY, this.mapper.leftAvailable(mBlock.mbIdx), this.mapper.topAvailable(mBlock.mbIdx), this.mapper.topLeftAvailable(mBlock.mbIdx), this.mapper.topRightAvailable(mBlock.mbIdx), x, pp, mb, H264Const.identityMapping4);
            MBlockDecoderUtils.savePrediction8x8(this.s, mbX, x[0], 0);
            MBlockDecoderUtils.savePrediction8x8(this.s, mbX, x[1], 1);
        }
        this.decodeChromaSkip(refs, x, pp, mbX, mbY, mb);
        MBlockDecoderUtils.collectPredictors(this.s, mb, mbX);
        MBlockDecoderUtils.saveMvs(this.di, x, mbX, mbY);
        this.di.mbTypes[mbAddr] = mBlock.curMbType;
        this.di.mbQps[0][mbAddr] = this.s.qp;
        this.di.mbQps[1][mbAddr] = this.calcQpChroma(this.s.qp, this.s.chromaQpOffset[0]);
        this.di.mbQps[2][mbAddr] = this.calcQpChroma(this.s.qp, this.s.chromaQpOffset[1]);
    }

    public void predictPSkip(Frame[][] refs, int mbX, int mbY, boolean lAvb, boolean tAvb, boolean tlAvb, boolean trAvb, int[][][] x, Picture8Bit mb) {
        int mvX = 0;
        int mvY = 0;
        if (lAvb && tAvb) {
            int[] b = this.s.mvTop[0][mbX << 2];
            int[] a = this.s.mvLeft[0][0];
            if (!(a[0] == 0 && a[1] == 0 && a[2] == 0 || b[0] == 0 && b[1] == 0 && b[2] == 0)) {
                mvX = MBlockDecoderUtils.calcMVPredictionMedian(a, b, this.s.mvTop[0][(mbX << 2) + 4], this.s.mvTopLeft[0], lAvb, tAvb, trAvb, tlAvb, 0, 0);
                mvY = MBlockDecoderUtils.calcMVPredictionMedian(a, b, this.s.mvTop[0][(mbX << 2) + 4], this.s.mvTopLeft[0], lAvb, tAvb, trAvb, tlAvb, 0, 1);
            }
        }
        int xx = mbX << 2;
        MBlockDecoderUtils.copyVect(this.s.mvTopLeft[0], this.s.mvTop[0][xx + 3]);
        MBlockDecoderUtils.saveVect(this.s.mvTop[0], xx, xx + 4, mvX, mvY, 0);
        MBlockDecoderUtils.saveVect(this.s.mvLeft[0], 0, 4, mvX, mvY, 0);
        for (int i = 0; i < 16; ++i) {
            x[0][i][0] = mvX;
            x[0][i][1] = mvY;
            x[0][i][2] = 0;
        }
        this.interpolator.getBlockLuma(refs[0][0], mb, 0, (mbX << 6) + mvX, (mbY << 6) + mvY, 16, 16);
        PredictionMerger.mergePrediction(this.sh, 0, 0, H264Const.PartPred.L0, 0, mb.getPlaneData(0), null, 0, 16, 16, 16, mb.getPlaneData(0), refs, this.poc);
    }

    public void decodeChromaSkip(Frame[][] reference, int[][][] vectors, H264Const.PartPred[] pp, int mbX, int mbY, Picture8Bit mb) {
        this.predictChromaInter(reference, vectors, mbX << 3, mbY << 3, 1, mb, pp);
        this.predictChromaInter(reference, vectors, mbX << 3, mbY << 3, 2, mb, pp);
    }
}

