/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import org.jcodec.codecs.h264.H264Const;
import org.jcodec.codecs.h264.decode.DeblockerInput;
import org.jcodec.codecs.h264.decode.DecoderState;
import org.jcodec.codecs.h264.decode.MBlock;
import org.jcodec.codecs.h264.decode.MBlockDecoderBDirect;
import org.jcodec.codecs.h264.decode.MBlockDecoderIPCM;
import org.jcodec.codecs.h264.decode.MBlockDecoderInter;
import org.jcodec.codecs.h264.decode.MBlockDecoderInter8x8;
import org.jcodec.codecs.h264.decode.MBlockDecoderIntra16x16;
import org.jcodec.codecs.h264.decode.MBlockDecoderIntraNxN;
import org.jcodec.codecs.h264.decode.MBlockDecoderUtils;
import org.jcodec.codecs.h264.decode.MBlockSkipDecoder;
import org.jcodec.codecs.h264.decode.RefListManager;
import org.jcodec.codecs.h264.decode.SliceReader;
import org.jcodec.codecs.h264.decode.aso.MapManager;
import org.jcodec.codecs.h264.decode.aso.Mapper;
import org.jcodec.codecs.h264.io.model.Frame;
import org.jcodec.codecs.h264.io.model.MBType;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.codecs.h264.io.model.SliceType;
import org.jcodec.common.IntObjectMap;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.Picture8Bit;

public class SliceDecoder {
    private Mapper mapper;
    private MBlockDecoderIntra16x16 decoderIntra16x16;
    private MBlockDecoderIntraNxN decoderIntraNxN;
    private MBlockDecoderInter decoderInter;
    private MBlockDecoderInter8x8 decoderInter8x8;
    private MBlockSkipDecoder skipDecoder;
    private MBlockDecoderBDirect decoderBDirect;
    private RefListManager refListManager;
    private MBlockDecoderIPCM decoderIPCM;
    private SliceReader parser;
    private SeqParameterSet activeSps;
    private Frame frameOut;
    private DecoderState decoderState;
    private DeblockerInput di;
    private IntObjectMap<Frame> lRefs;
    private Frame[] sRefs;

    public SliceDecoder(SeqParameterSet activeSps, Frame[] sRefs, IntObjectMap<Frame> lRefs, DeblockerInput di, Frame result) {
        this.di = di;
        this.activeSps = activeSps;
        this.frameOut = result;
        this.sRefs = sRefs;
        this.lRefs = lRefs;
    }

    public void decodeFromReader(SliceReader sliceReader) {
        this.parser = sliceReader;
        this.initContext();
        MBlockDecoderUtils.debugPrint("============%d============= ", this.frameOut.getPOC());
        Frame[][] refList = this.refListManager.getRefList();
        this.decodeMacroblocks(refList);
    }

    private void initContext() {
        SliceHeader sh = this.parser.getSliceHeader();
        this.decoderState = new DecoderState(sh);
        this.mapper = new MapManager(sh.sps, sh.pps).getMapper(sh);
        this.decoderIntra16x16 = new MBlockDecoderIntra16x16(this.mapper, sh, this.di, this.frameOut.getPOC(), this.decoderState);
        this.decoderIntraNxN = new MBlockDecoderIntraNxN(this.mapper, sh, this.di, this.frameOut.getPOC(), this.decoderState);
        this.decoderInter = new MBlockDecoderInter(this.mapper, sh, this.di, this.frameOut.getPOC(), this.decoderState);
        this.decoderBDirect = new MBlockDecoderBDirect(this.mapper, sh, this.di, this.frameOut.getPOC(), this.decoderState);
        this.decoderInter8x8 = new MBlockDecoderInter8x8(this.mapper, this.decoderBDirect, sh, this.di, this.frameOut.getPOC(), this.decoderState);
        this.skipDecoder = new MBlockSkipDecoder(this.mapper, this.decoderBDirect, sh, this.di, this.frameOut.getPOC(), this.decoderState);
        this.decoderIPCM = new MBlockDecoderIPCM(this.mapper, this.decoderState);
        this.refListManager = new RefListManager(sh, this.sRefs, this.lRefs, this.frameOut);
    }

    private void decodeMacroblocks(Frame[][] refList) {
        Picture8Bit mb = Picture8Bit.create(16, 16, this.activeSps.chroma_format_idc);
        int mbWidth = this.activeSps.pic_width_in_mbs_minus1 + 1;
        MBlock mBlock = new MBlock(this.activeSps.chroma_format_idc);
        while (this.parser.readMacroblock(mBlock)) {
            this.decode(mBlock, this.parser.getSliceHeader().slice_type, mb, refList);
            int mbAddr = this.mapper.getAddress(mBlock.mbIdx);
            int mbX = mbAddr % mbWidth;
            int mbY = mbAddr / mbWidth;
            this.putMacroblock(this.frameOut, mb, mbX, mbY);
            this.di.shs[mbAddr] = this.parser.getSliceHeader();
            this.di.refsUsed[mbAddr] = refList;
            this.fillCoeff(mBlock, mbX, mbY);
            mb.fill(0);
            mBlock.clear();
        }
    }

    private void fillCoeff(MBlock mBlock, int mbX, int mbY) {
        for (int i = 0; i < 16; ++i) {
            int blkOffLeft = H264Const.MB_BLK_OFF_LEFT[i];
            int blkOffTop = H264Const.MB_BLK_OFF_TOP[i];
            int blkX = (mbX << 2) + blkOffLeft;
            int blkY = (mbY << 2) + blkOffTop;
            this.di.nCoeff[blkY][blkX] = mBlock.nCoeff[i];
        }
    }

    public void decode(MBlock mBlock, SliceType sliceType, Picture8Bit mb, Frame[][] references) {
        if (mBlock.skipped) {
            this.skipDecoder.decodeSkip(mBlock, references, mb, sliceType);
        } else if (sliceType == SliceType.I) {
            this.decodeMBlockI(mBlock, mb);
        } else if (sliceType == SliceType.P) {
            this.decodeMBlockP(mBlock, mb, references);
        } else {
            this.decodeMBlockB(mBlock, mb, references);
        }
    }

    private void decodeMBlockI(MBlock mBlock, Picture8Bit mb) {
        this.decodeMBlockIInt(mBlock, mb);
    }

    private void decodeMBlockIInt(MBlock mBlock, Picture8Bit mb) {
        if (mBlock.curMbType == MBType.I_NxN) {
            this.decoderIntraNxN.decode(mBlock, mb);
        } else if (mBlock.curMbType == MBType.I_16x16) {
            this.decoderIntra16x16.decode(mBlock, mb);
        } else {
            Logger.warn("IPCM macroblock found. Not tested, may cause unpredictable behavior.");
            this.decoderIPCM.decode(mBlock, mb);
        }
    }

    private void decodeMBlockP(MBlock mBlock, Picture8Bit mb, Frame[][] references) {
        if (MBType.P_16x16 == mBlock.curMbType) {
            this.decoderInter.decode16x16(mBlock, mb, references, H264Const.PartPred.L0);
        } else if (MBType.P_16x8 == mBlock.curMbType) {
            this.decoderInter.decode16x8(mBlock, mb, references, H264Const.PartPred.L0, H264Const.PartPred.L0);
        } else if (MBType.P_8x16 == mBlock.curMbType) {
            this.decoderInter.decode8x16(mBlock, mb, references, H264Const.PartPred.L0, H264Const.PartPred.L0);
        } else if (MBType.P_8x8 == mBlock.curMbType) {
            this.decoderInter8x8.decode(mBlock, references, mb, SliceType.P, false);
        } else if (MBType.P_8x8ref0 == mBlock.curMbType) {
            this.decoderInter8x8.decode(mBlock, references, mb, SliceType.P, true);
        } else {
            this.decodeMBlockIInt(mBlock, mb);
        }
    }

    private void decodeMBlockB(MBlock mBlock, Picture8Bit mb, Frame[][] references) {
        if (mBlock.curMbType.isIntra()) {
            this.decodeMBlockIInt(mBlock, mb);
        } else if (mBlock.curMbType == MBType.B_Direct_16x16) {
            this.decoderBDirect.decode(mBlock, mb, references);
        } else if (mBlock.mbType <= 3) {
            this.decoderInter.decode16x16(mBlock, mb, references, H264Const.bPredModes[mBlock.mbType][0]);
        } else if (mBlock.mbType == 22) {
            this.decoderInter8x8.decode(mBlock, references, mb, SliceType.B, false);
        } else if ((mBlock.mbType & 1) == 0) {
            this.decoderInter.decode16x8(mBlock, mb, references, H264Const.bPredModes[mBlock.mbType][0], H264Const.bPredModes[mBlock.mbType][1]);
        } else {
            this.decoderInter.decode8x16(mBlock, mb, references, H264Const.bPredModes[mBlock.mbType][0], H264Const.bPredModes[mBlock.mbType][1]);
        }
    }

    public void putMacroblock(Picture8Bit tgt, Picture8Bit decoded, int mbX, int mbY) {
        int i;
        byte[] luma = tgt.getPlaneData(0);
        int stride = tgt.getPlaneWidth(0);
        byte[] cb = tgt.getPlaneData(1);
        byte[] cr = tgt.getPlaneData(2);
        int strideChroma = tgt.getPlaneWidth(1);
        int dOff = 0;
        for (i = 0; i < 16; ++i) {
            System.arraycopy(decoded.getPlaneData(0), dOff, luma, (mbY * 16 + i) * stride + mbX * 16, 16);
            dOff += 16;
        }
        for (i = 0; i < 8; ++i) {
            System.arraycopy(decoded.getPlaneData(1), i * 8, cb, (mbY * 8 + i) * strideChroma + mbX * 8, 8);
        }
        for (i = 0; i < 8; ++i) {
            System.arraycopy(decoded.getPlaneData(2), i * 8, cr, (mbY * 8 + i) * strideChroma + mbX * 8, 8);
        }
    }
}

