/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.encode;

import java.util.Arrays;
import org.jcodec.codecs.h264.H264Const;
import org.jcodec.codecs.h264.decode.BlockInterpolator;
import org.jcodec.codecs.h264.decode.CoeffTransformer;
import org.jcodec.codecs.h264.encode.EncodedMB;
import org.jcodec.codecs.h264.encode.MBDeblocker;
import org.jcodec.codecs.h264.encode.MBEncoderHelper;
import org.jcodec.codecs.h264.encode.MBEncoderI16x16;
import org.jcodec.codecs.h264.encode.MotionEstimator;
import org.jcodec.codecs.h264.io.CAVLC;
import org.jcodec.codecs.h264.io.model.MBType;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.write.CAVLCWriter;
import org.jcodec.common.io.BitWriter;
import org.jcodec.common.model.Picture8Bit;

public class MBEncoderP16x16 {
    private CAVLC[] cavlc;
    private SeqParameterSet sps;
    private Picture8Bit ref;
    private MotionEstimator me;
    private int[] mvTopX;
    private int[] mvTopY;
    private int mvLeftX;
    private int mvLeftY;
    private int mvTopLeftX;
    private int mvTopLeftY;
    private BlockInterpolator interpolator;

    public MBEncoderP16x16(SeqParameterSet sps, Picture8Bit ref, CAVLC[] cavlc, MotionEstimator me) {
        this.sps = sps;
        this.cavlc = cavlc;
        this.ref = ref;
        this.me = me;
        this.mvTopX = new int[sps.pic_width_in_mbs_minus1 + 1];
        this.mvTopY = new int[sps.pic_width_in_mbs_minus1 + 1];
        this.interpolator = new BlockInterpolator();
    }

    public void encodeMacroblock(Picture8Bit pic, int mbX, int mbY, BitWriter out, EncodedMB outMB, EncodedMB leftOutMB, EncodedMB topOutMB, int qp, int qpDelta) {
        int cw = pic.getColor().compWidth[1];
        int ch = pic.getColor().compHeight[1];
        if (this.sps.num_ref_frames > 1) {
            int refIdx = this.decideRef();
            CAVLCWriter.writeTE(out, refIdx, this.sps.num_ref_frames - 1);
        }
        boolean trAvb = mbY > 0 && mbX < this.sps.pic_width_in_mbs_minus1;
        boolean tlAvb = mbX > 0 && mbY > 0;
        int mvpx = this.median(this.mvLeftX, this.mvTopX[mbX], trAvb ? this.mvTopX[mbX + 1] : 0, tlAvb ? this.mvTopLeftX : 0, mbX > 0, mbY > 0, trAvb, tlAvb);
        int mvpy = this.median(this.mvLeftY, this.mvTopY[mbX], trAvb ? this.mvTopY[mbX + 1] : 0, tlAvb ? this.mvTopLeftY : 0, mbX > 0, mbY > 0, trAvb, tlAvb);
        int[] mv = this.mvEstimate(pic, mbX, mbY, mvpx, mvpy);
        this.mvTopLeftX = this.mvTopX[mbX];
        this.mvTopLeftY = this.mvTopY[mbX];
        this.mvTopX[mbX] = mv[0];
        this.mvTopY[mbX] = mv[1];
        this.mvLeftX = mv[0];
        this.mvLeftY = mv[1];
        CAVLCWriter.writeSE(out, mv[0] - mvpx);
        CAVLCWriter.writeSE(out, mv[1] - mvpy);
        Picture8Bit mbRef = Picture8Bit.create(16, 16, this.sps.chroma_format_idc);
        int[][] mb = new int[][]{new int[256], new int[256 >> cw + ch], new int[256 >> cw + ch]};
        this.interpolator.getBlockLuma(this.ref, mbRef, 0, (mbX << 6) + mv[0], (mbY << 6) + mv[1], 16, 16);
        this.interpolator.getBlockChroma(this.ref.getPlaneData(1), this.ref.getPlaneWidth(1), this.ref.getPlaneHeight(1), mbRef.getPlaneData(1), 0, mbRef.getPlaneWidth(1), (mbX << 6) + mv[0], (mbY << 6) + mv[1], 8, 8);
        this.interpolator.getBlockChroma(this.ref.getPlaneData(2), this.ref.getPlaneWidth(2), this.ref.getPlaneHeight(2), mbRef.getPlaneData(2), 0, mbRef.getPlaneWidth(2), (mbX << 6) + mv[0], (mbY << 6) + mv[1], 8, 8);
        MBEncoderHelper.takeSubtract(pic.getPlaneData(0), pic.getPlaneWidth(0), pic.getPlaneHeight(0), mbX << 4, mbY << 4, mb[0], mbRef.getPlaneData(0), 16, 16);
        MBEncoderHelper.takeSubtract(pic.getPlaneData(1), pic.getPlaneWidth(1), pic.getPlaneHeight(1), mbX << 4 - cw, mbY << 4 - ch, mb[1], mbRef.getPlaneData(1), 16 >> cw, 16 >> ch);
        MBEncoderHelper.takeSubtract(pic.getPlaneData(2), pic.getPlaneWidth(2), pic.getPlaneHeight(2), mbX << 4 - cw, mbY << 4 - ch, mb[2], mbRef.getPlaneData(2), 16 >> cw, 16 >> ch);
        int codedBlockPattern = this.getCodedBlockPattern();
        CAVLCWriter.writeUE(out, H264Const.CODED_BLOCK_PATTERN_INTER_COLOR_INV[codedBlockPattern]);
        CAVLCWriter.writeSE(out, qpDelta);
        this.luma(pic, mb[0], mbX, mbY, out, qp, outMB.getNc());
        this.chroma(pic, mb[1], mb[2], mbX, mbY, out, qp);
        MBEncoderHelper.putBlk(outMB.getPixels().getPlaneData(0), mb[0], mbRef.getPlaneData(0), 4, 0, 0, 16, 16);
        MBEncoderHelper.putBlk(outMB.getPixels().getPlaneData(1), mb[1], mbRef.getPlaneData(1), 4 - cw, 0, 0, 16 >> cw, 16 >> ch);
        MBEncoderHelper.putBlk(outMB.getPixels().getPlaneData(2), mb[2], mbRef.getPlaneData(2), 4 - cw, 0, 0, 16 >> cw, 16 >> ch);
        Arrays.fill(outMB.getMx(), mv[0]);
        Arrays.fill(outMB.getMy(), mv[1]);
        outMB.setType(MBType.P_16x16);
        outMB.setQp(qp);
        new MBDeblocker().deblockMBP(outMB, leftOutMB, topOutMB);
    }

    public int median(int a, int b, int c, int d, boolean aAvb, boolean bAvb, boolean cAvb, boolean dAvb) {
        if (!cAvb) {
            c = d;
            cAvb = dAvb;
        }
        if (aAvb && !bAvb && !cAvb) {
            b = c = a;
            bAvb = cAvb = aAvb;
        }
        a = aAvb ? a : 0;
        b = bAvb ? b : 0;
        c = cAvb ? c : 0;
        return a + b + c - Math.min(Math.min(a, b), c) - Math.max(Math.max(a, b), c);
    }

    private int getCodedBlockPattern() {
        return 47;
    }

    private int[] mvEstimate(Picture8Bit pic, int mbX, int mbY, int mvpx, int mvpy) {
        byte[] patch = new byte[256];
        MBEncoderHelper.take(pic.getPlaneData(0), pic.getPlaneWidth(0), pic.getPlaneHeight(0), mbX << 4, mbY << 4, patch, 16, 16);
        return this.me.estimate(this.ref, patch, mbX, mbY, mvpx, mvpy);
    }

    private int decideRef() {
        return 0;
    }

    private void luma(Picture8Bit pic, int[] pix, int mbX, int mbY, BitWriter out, int qp, int[] nc) {
        int j;
        int i;
        int[][] ac = new int[16][16];
        for (i = 0; i < ac.length; ++i) {
            for (j = 0; j < H264Const.PIX_MAP_SPLIT_4x4[i].length; ++j) {
                ac[i][j] = pix[H264Const.PIX_MAP_SPLIT_4x4[i][j]];
            }
            CoeffTransformer.fdct4x4(ac[i]);
        }
        this.writeAC(0, mbX, mbY, out, mbX << 2, mbY << 2, ac, qp);
        for (i = 0; i < ac.length; ++i) {
            CoeffTransformer.dequantizeAC(ac[i], qp);
            CoeffTransformer.idct4x4(ac[i]);
            for (j = 0; j < H264Const.PIX_MAP_SPLIT_4x4[i].length; ++j) {
                pix[H264Const.PIX_MAP_SPLIT_4x4[i][j]] = ac[i][j];
            }
        }
    }

    private void chroma(Picture8Bit pic, int[] pix1, int[] pix2, int mbX, int mbY, BitWriter out, int qp) {
        int j;
        int i;
        int cw = pic.getColor().compWidth[1];
        int ch = pic.getColor().compHeight[1];
        int[][] ac1 = new int[16 >> cw + ch][16];
        int[][] ac2 = new int[16 >> cw + ch][16];
        for (i = 0; i < ac1.length; ++i) {
            for (j = 0; j < H264Const.PIX_MAP_SPLIT_2x2[i].length; ++j) {
                ac1[i][j] = pix1[H264Const.PIX_MAP_SPLIT_2x2[i][j]];
            }
        }
        for (i = 0; i < ac2.length; ++i) {
            for (j = 0; j < H264Const.PIX_MAP_SPLIT_2x2[i].length; ++j) {
                ac2[i][j] = pix2[H264Const.PIX_MAP_SPLIT_2x2[i][j]];
            }
        }
        MBEncoderI16x16.chromaResidual(pic, mbX, mbY, out, qp, ac1, ac2, this.cavlc[1], this.cavlc[2], MBType.P_16x16, MBType.P_16x16);
        for (i = 0; i < ac1.length; ++i) {
            for (j = 0; j < H264Const.PIX_MAP_SPLIT_2x2[i].length; ++j) {
                pix1[H264Const.PIX_MAP_SPLIT_2x2[i][j]] = ac1[i][j];
            }
        }
        for (i = 0; i < ac2.length; ++i) {
            for (j = 0; j < H264Const.PIX_MAP_SPLIT_2x2[i].length; ++j) {
                pix2[H264Const.PIX_MAP_SPLIT_2x2[i][j]] = ac2[i][j];
            }
        }
    }

    private void writeAC(int comp, int mbX, int mbY, BitWriter out, int mbLeftBlk, int mbTopBlk, int[][] ac, int qp) {
        for (int i = 0; i < ac.length; ++i) {
            int blkI = H264Const.BLK_INV_MAP[i];
            CoeffTransformer.quantizeAC(ac[blkI], qp);
            this.cavlc[comp].writeACBlock(out, mbLeftBlk + H264Const.MB_BLK_OFF_LEFT[i], mbTopBlk + H264Const.MB_BLK_OFF_TOP[i], MBType.P_16x16, MBType.P_16x16, ac[blkI], H264Const.totalZeros16, 0, 16, CoeffTransformer.zigzag4x4);
        }
    }
}

