/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.io.model;

public final class NALUnitType {
    public static final NALUnitType NON_IDR_SLICE = new NALUnitType(1, "non IDR slice");
    public static final NALUnitType SLICE_PART_A = new NALUnitType(2, "slice part a");
    public static final NALUnitType SLICE_PART_B = new NALUnitType(3, "slice part b");
    public static final NALUnitType SLICE_PART_C = new NALUnitType(4, "slice part c");
    public static final NALUnitType IDR_SLICE = new NALUnitType(5, "idr slice");
    public static final NALUnitType SEI = new NALUnitType(6, "sei");
    public static final NALUnitType SPS = new NALUnitType(7, "sequence parameter set");
    public static final NALUnitType PPS = new NALUnitType(8, "picture parameter set");
    public static final NALUnitType ACC_UNIT_DELIM = new NALUnitType(9, "access unit delimiter");
    public static final NALUnitType END_OF_SEQ = new NALUnitType(10, "end of sequence");
    public static final NALUnitType END_OF_STREAM = new NALUnitType(11, "end of stream");
    public static final NALUnitType FILLER_DATA = new NALUnitType(12, "filler data");
    public static final NALUnitType SEQ_PAR_SET_EXT = new NALUnitType(13, "sequence parameter set extension");
    public static final NALUnitType AUX_SLICE = new NALUnitType(19, "auxilary slice");
    private static final NALUnitType[] lut;
    private static final NALUnitType[] _values;
    private final int value;
    private final String displayName;

    private NALUnitType(int value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getName() {
        return this.displayName;
    }

    public int getValue() {
        return this.value;
    }

    public static NALUnitType fromValue(int value) {
        return value < lut.length ? lut[value] : null;
    }

    static {
        _values = new NALUnitType[]{NON_IDR_SLICE, SLICE_PART_A, SLICE_PART_B, SLICE_PART_C, IDR_SLICE, SEI, SPS, PPS, ACC_UNIT_DELIM, END_OF_SEQ, END_OF_STREAM, FILLER_DATA, SEQ_PAR_SET_EXT, AUX_SLICE};
        lut = new NALUnitType[256];
        for (int i = 0; i < _values.length; ++i) {
            NALUnitType nalUnitType;
            NALUnitType.lut[nalUnitType.value] = nalUnitType = _values[i];
        }
    }
}

