/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.io.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jcodec.codecs.h264.decode.CAVLCReader;
import org.jcodec.codecs.h264.io.model.ScalingList;
import org.jcodec.codecs.h264.io.model.ScalingMatrix;
import org.jcodec.codecs.h264.io.write.CAVLCWriter;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.BitWriter;
import org.jcodec.platform.Platform;

public class PictureParameterSet {
    public boolean entropy_coding_mode_flag;
    public int[] num_ref_idx_active_minus1 = new int[2];
    public int slice_group_change_rate_minus1;
    public int pic_parameter_set_id;
    public int seq_parameter_set_id;
    public boolean pic_order_present_flag;
    public int num_slice_groups_minus1;
    public int slice_group_map_type;
    public boolean weighted_pred_flag;
    public int weighted_bipred_idc;
    public int pic_init_qp_minus26;
    public int pic_init_qs_minus26;
    public int chroma_qp_index_offset;
    public boolean deblocking_filter_control_present_flag;
    public boolean constrained_intra_pred_flag;
    public boolean redundant_pic_cnt_present_flag;
    public int[] top_left;
    public int[] bottom_right;
    public int[] run_length_minus1;
    public boolean slice_group_change_direction_flag;
    public int[] slice_group_id;
    public PPSExt extended;

    public static PictureParameterSet read(ByteBuffer is) {
        BitReader _in = BitReader.createBitReader(is);
        PictureParameterSet pps = new PictureParameterSet();
        pps.pic_parameter_set_id = CAVLCReader.readUEtrace(_in, "PPS: pic_parameter_set_id");
        pps.seq_parameter_set_id = CAVLCReader.readUEtrace(_in, "PPS: seq_parameter_set_id");
        pps.entropy_coding_mode_flag = CAVLCReader.readBool(_in, "PPS: entropy_coding_mode_flag");
        pps.pic_order_present_flag = CAVLCReader.readBool(_in, "PPS: pic_order_present_flag");
        pps.num_slice_groups_minus1 = CAVLCReader.readUEtrace(_in, "PPS: num_slice_groups_minus1");
        if (pps.num_slice_groups_minus1 > 0) {
            int iGroup;
            pps.slice_group_map_type = CAVLCReader.readUEtrace(_in, "PPS: slice_group_map_type");
            pps.top_left = new int[pps.num_slice_groups_minus1 + 1];
            pps.bottom_right = new int[pps.num_slice_groups_minus1 + 1];
            pps.run_length_minus1 = new int[pps.num_slice_groups_minus1 + 1];
            if (pps.slice_group_map_type == 0) {
                for (iGroup = 0; iGroup <= pps.num_slice_groups_minus1; ++iGroup) {
                    pps.run_length_minus1[iGroup] = CAVLCReader.readUEtrace(_in, "PPS: run_length_minus1");
                }
            } else if (pps.slice_group_map_type == 2) {
                for (iGroup = 0; iGroup < pps.num_slice_groups_minus1; ++iGroup) {
                    pps.top_left[iGroup] = CAVLCReader.readUEtrace(_in, "PPS: top_left");
                    pps.bottom_right[iGroup] = CAVLCReader.readUEtrace(_in, "PPS: bottom_right");
                }
            } else if (pps.slice_group_map_type == 3 || pps.slice_group_map_type == 4 || pps.slice_group_map_type == 5) {
                pps.slice_group_change_direction_flag = CAVLCReader.readBool(_in, "PPS: slice_group_change_direction_flag");
                pps.slice_group_change_rate_minus1 = CAVLCReader.readUEtrace(_in, "PPS: slice_group_change_rate_minus1");
            } else if (pps.slice_group_map_type == 6) {
                int NumberBitsPerSliceGroupId = pps.num_slice_groups_minus1 + 1 > 4 ? 3 : (pps.num_slice_groups_minus1 + 1 > 2 ? 2 : 1);
                int pic_size_in_map_units_minus1 = CAVLCReader.readUEtrace(_in, "PPS: pic_size_in_map_units_minus1");
                pps.slice_group_id = new int[pic_size_in_map_units_minus1 + 1];
                for (int i = 0; i <= pic_size_in_map_units_minus1; ++i) {
                    pps.slice_group_id[i] = CAVLCReader.readU(_in, NumberBitsPerSliceGroupId, "PPS: slice_group_id [" + i + "]f");
                }
            }
        }
        pps.num_ref_idx_active_minus1 = new int[]{CAVLCReader.readUEtrace(_in, "PPS: num_ref_idx_l0_active_minus1"), CAVLCReader.readUEtrace(_in, "PPS: num_ref_idx_l1_active_minus1")};
        pps.weighted_pred_flag = CAVLCReader.readBool(_in, "PPS: weighted_pred_flag");
        pps.weighted_bipred_idc = CAVLCReader.readNBit(_in, 2, "PPS: weighted_bipred_idc");
        pps.pic_init_qp_minus26 = CAVLCReader.readSE(_in, "PPS: pic_init_qp_minus26");
        pps.pic_init_qs_minus26 = CAVLCReader.readSE(_in, "PPS: pic_init_qs_minus26");
        pps.chroma_qp_index_offset = CAVLCReader.readSE(_in, "PPS: chroma_qp_index_offset");
        pps.deblocking_filter_control_present_flag = CAVLCReader.readBool(_in, "PPS: deblocking_filter_control_present_flag");
        pps.constrained_intra_pred_flag = CAVLCReader.readBool(_in, "PPS: constrained_intra_pred_flag");
        pps.redundant_pic_cnt_present_flag = CAVLCReader.readBool(_in, "PPS: redundant_pic_cnt_present_flag");
        if (CAVLCReader.moreRBSPData(_in)) {
            pps.extended = new PPSExt();
            pps.extended.transform_8x8_mode_flag = CAVLCReader.readBool(_in, "PPS: transform_8x8_mode_flag");
            boolean pic_scaling_matrix_present_flag = CAVLCReader.readBool(_in, "PPS: pic_scaling_matrix_present_flag");
            if (pic_scaling_matrix_present_flag) {
                for (int i = 0; i < 6 + 2 * (pps.extended.transform_8x8_mode_flag ? 1 : 0); ++i) {
                    boolean pic_scaling_list_present_flag = CAVLCReader.readBool(_in, "PPS: pic_scaling_list_present_flag");
                    if (!pic_scaling_list_present_flag) continue;
                    pps.extended.scalindMatrix = new ScalingMatrix();
                    pps.extended.scalindMatrix.ScalingList4x4 = new ScalingList[8];
                    pps.extended.scalindMatrix.ScalingList8x8 = new ScalingList[8];
                    if (i < 6) {
                        pps.extended.scalindMatrix.ScalingList4x4[i] = ScalingList.read(_in, 16);
                        continue;
                    }
                    pps.extended.scalindMatrix.ScalingList8x8[i - 6] = ScalingList.read(_in, 64);
                }
            }
            pps.extended.second_chroma_qp_index_offset = CAVLCReader.readSE(_in, "PPS: second_chroma_qp_index_offset");
        }
        return pps;
    }

    public void write(ByteBuffer out) {
        BitWriter writer = new BitWriter(out);
        CAVLCWriter.writeUEtrace(writer, this.pic_parameter_set_id, "PPS: pic_parameter_set_id");
        CAVLCWriter.writeUEtrace(writer, this.seq_parameter_set_id, "PPS: seq_parameter_set_id");
        CAVLCWriter.writeBool(writer, this.entropy_coding_mode_flag, "PPS: entropy_coding_mode_flag");
        CAVLCWriter.writeBool(writer, this.pic_order_present_flag, "PPS: pic_order_present_flag");
        CAVLCWriter.writeUEtrace(writer, this.num_slice_groups_minus1, "PPS: num_slice_groups_minus1");
        if (this.num_slice_groups_minus1 > 0) {
            int iGroup;
            CAVLCWriter.writeUEtrace(writer, this.slice_group_map_type, "PPS: slice_group_map_type");
            int[] top_left = new int[1];
            int[] bottom_right = new int[1];
            int[] run_length_minus1 = new int[1];
            if (this.slice_group_map_type == 0) {
                for (iGroup = 0; iGroup <= this.num_slice_groups_minus1; ++iGroup) {
                    CAVLCWriter.writeUEtrace(writer, run_length_minus1[iGroup], "PPS: ");
                }
            } else if (this.slice_group_map_type == 2) {
                for (iGroup = 0; iGroup < this.num_slice_groups_minus1; ++iGroup) {
                    CAVLCWriter.writeUEtrace(writer, top_left[iGroup], "PPS: ");
                    CAVLCWriter.writeUEtrace(writer, bottom_right[iGroup], "PPS: ");
                }
            } else if (this.slice_group_map_type == 3 || this.slice_group_map_type == 4 || this.slice_group_map_type == 5) {
                CAVLCWriter.writeBool(writer, this.slice_group_change_direction_flag, "PPS: slice_group_change_direction_flag");
                CAVLCWriter.writeUEtrace(writer, this.slice_group_change_rate_minus1, "PPS: slice_group_change_rate_minus1");
            } else if (this.slice_group_map_type == 6) {
                int NumberBitsPerSliceGroupId = this.num_slice_groups_minus1 + 1 > 4 ? 3 : (this.num_slice_groups_minus1 + 1 > 2 ? 2 : 1);
                CAVLCWriter.writeUEtrace(writer, this.slice_group_id.length, "PPS: ");
                for (int i = 0; i <= this.slice_group_id.length; ++i) {
                    CAVLCWriter.writeU(writer, this.slice_group_id[i], NumberBitsPerSliceGroupId);
                }
            }
        }
        CAVLCWriter.writeUEtrace(writer, this.num_ref_idx_active_minus1[0], "PPS: num_ref_idx_l0_active_minus1");
        CAVLCWriter.writeUEtrace(writer, this.num_ref_idx_active_minus1[1], "PPS: num_ref_idx_l1_active_minus1");
        CAVLCWriter.writeBool(writer, this.weighted_pred_flag, "PPS: weighted_pred_flag");
        CAVLCWriter.writeNBit(writer, this.weighted_bipred_idc, 2, "PPS: weighted_bipred_idc");
        CAVLCWriter.writeSEtrace(writer, this.pic_init_qp_minus26, "PPS: pic_init_qp_minus26");
        CAVLCWriter.writeSEtrace(writer, this.pic_init_qs_minus26, "PPS: pic_init_qs_minus26");
        CAVLCWriter.writeSEtrace(writer, this.chroma_qp_index_offset, "PPS: chroma_qp_index_offset");
        CAVLCWriter.writeBool(writer, this.deblocking_filter_control_present_flag, "PPS: deblocking_filter_control_present_flag");
        CAVLCWriter.writeBool(writer, this.constrained_intra_pred_flag, "PPS: constrained_intra_pred_flag");
        CAVLCWriter.writeBool(writer, this.redundant_pic_cnt_present_flag, "PPS: redundant_pic_cnt_present_flag");
        if (this.extended != null) {
            CAVLCWriter.writeBool(writer, this.extended.transform_8x8_mode_flag, "PPS: transform_8x8_mode_flag");
            CAVLCWriter.writeBool(writer, this.extended.scalindMatrix != null, "PPS: scalindMatrix");
            if (this.extended.scalindMatrix != null) {
                for (int i = 0; i < 6 + 2 * (this.extended.transform_8x8_mode_flag ? 1 : 0); ++i) {
                    if (i < 6) {
                        CAVLCWriter.writeBool(writer, this.extended.scalindMatrix.ScalingList4x4[i] != null, "PPS: ");
                        if (this.extended.scalindMatrix.ScalingList4x4[i] == null) continue;
                        this.extended.scalindMatrix.ScalingList4x4[i].write(writer);
                        continue;
                    }
                    CAVLCWriter.writeBool(writer, this.extended.scalindMatrix.ScalingList8x8[i - 6] != null, "PPS: ");
                    if (this.extended.scalindMatrix.ScalingList8x8[i - 6] == null) continue;
                    this.extended.scalindMatrix.ScalingList8x8[i - 6].write(writer);
                }
            }
            CAVLCWriter.writeSEtrace(writer, this.extended.second_chroma_qp_index_offset, "PPS: ");
        }
        CAVLCWriter.writeTrailingBits(writer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bottom_right);
        result = 31 * result + this.chroma_qp_index_offset;
        result = 31 * result + (this.constrained_intra_pred_flag ? 1231 : 1237);
        result = 31 * result + (this.deblocking_filter_control_present_flag ? 1231 : 1237);
        result = 31 * result + (this.entropy_coding_mode_flag ? 1231 : 1237);
        result = 31 * result + (this.extended == null ? 0 : this.extended.hashCode());
        result = 31 * result + this.num_ref_idx_active_minus1[0];
        result = 31 * result + this.num_ref_idx_active_minus1[1];
        result = 31 * result + this.num_slice_groups_minus1;
        result = 31 * result + this.pic_init_qp_minus26;
        result = 31 * result + this.pic_init_qs_minus26;
        result = 31 * result + (this.pic_order_present_flag ? 1231 : 1237);
        result = 31 * result + this.pic_parameter_set_id;
        result = 31 * result + (this.redundant_pic_cnt_present_flag ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.run_length_minus1);
        result = 31 * result + this.seq_parameter_set_id;
        result = 31 * result + (this.slice_group_change_direction_flag ? 1231 : 1237);
        result = 31 * result + this.slice_group_change_rate_minus1;
        result = 31 * result + Arrays.hashCode(this.slice_group_id);
        result = 31 * result + this.slice_group_map_type;
        result = 31 * result + Arrays.hashCode(this.top_left);
        result = 31 * result + this.weighted_bipred_idc;
        result = 31 * result + (this.weighted_pred_flag ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PictureParameterSet other = (PictureParameterSet)obj;
        if (!Platform.arrayEqualsInt(this.bottom_right, other.bottom_right)) {
            return false;
        }
        if (this.chroma_qp_index_offset != other.chroma_qp_index_offset) {
            return false;
        }
        if (this.constrained_intra_pred_flag != other.constrained_intra_pred_flag) {
            return false;
        }
        if (this.deblocking_filter_control_present_flag != other.deblocking_filter_control_present_flag) {
            return false;
        }
        if (this.entropy_coding_mode_flag != other.entropy_coding_mode_flag) {
            return false;
        }
        if (this.extended == null ? other.extended != null : !this.extended.equals(other.extended)) {
            return false;
        }
        if (this.num_ref_idx_active_minus1[0] != other.num_ref_idx_active_minus1[0]) {
            return false;
        }
        if (this.num_ref_idx_active_minus1[1] != other.num_ref_idx_active_minus1[1]) {
            return false;
        }
        if (this.num_slice_groups_minus1 != other.num_slice_groups_minus1) {
            return false;
        }
        if (this.pic_init_qp_minus26 != other.pic_init_qp_minus26) {
            return false;
        }
        if (this.pic_init_qs_minus26 != other.pic_init_qs_minus26) {
            return false;
        }
        if (this.pic_order_present_flag != other.pic_order_present_flag) {
            return false;
        }
        if (this.pic_parameter_set_id != other.pic_parameter_set_id) {
            return false;
        }
        if (this.redundant_pic_cnt_present_flag != other.redundant_pic_cnt_present_flag) {
            return false;
        }
        if (!Platform.arrayEqualsInt(this.run_length_minus1, other.run_length_minus1)) {
            return false;
        }
        if (this.seq_parameter_set_id != other.seq_parameter_set_id) {
            return false;
        }
        if (this.slice_group_change_direction_flag != other.slice_group_change_direction_flag) {
            return false;
        }
        if (this.slice_group_change_rate_minus1 != other.slice_group_change_rate_minus1) {
            return false;
        }
        if (!Platform.arrayEqualsInt(this.slice_group_id, other.slice_group_id)) {
            return false;
        }
        if (this.slice_group_map_type != other.slice_group_map_type) {
            return false;
        }
        if (!Platform.arrayEqualsInt(this.top_left, other.top_left)) {
            return false;
        }
        if (this.weighted_bipred_idc != other.weighted_bipred_idc) {
            return false;
        }
        return this.weighted_pred_flag == other.weighted_pred_flag;
    }

    public PictureParameterSet copy() {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        this.write(buf);
        buf.flip();
        return PictureParameterSet.read(buf);
    }

    public boolean isEntropy_coding_mode_flag() {
        return this.entropy_coding_mode_flag;
    }

    public int[] getNum_ref_idx_active_minus1() {
        return this.num_ref_idx_active_minus1;
    }

    public int getSlice_group_change_rate_minus1() {
        return this.slice_group_change_rate_minus1;
    }

    public int getPic_parameter_set_id() {
        return this.pic_parameter_set_id;
    }

    public int getSeq_parameter_set_id() {
        return this.seq_parameter_set_id;
    }

    public boolean isPic_order_present_flag() {
        return this.pic_order_present_flag;
    }

    public int getNum_slice_groups_minus1() {
        return this.num_slice_groups_minus1;
    }

    public int getSlice_group_map_type() {
        return this.slice_group_map_type;
    }

    public boolean isWeighted_pred_flag() {
        return this.weighted_pred_flag;
    }

    public int getWeighted_bipred_idc() {
        return this.weighted_bipred_idc;
    }

    public int getPic_init_qp_minus26() {
        return this.pic_init_qp_minus26;
    }

    public int getPic_init_qs_minus26() {
        return this.pic_init_qs_minus26;
    }

    public int getChroma_qp_index_offset() {
        return this.chroma_qp_index_offset;
    }

    public boolean isDeblocking_filter_control_present_flag() {
        return this.deblocking_filter_control_present_flag;
    }

    public boolean isConstrained_intra_pred_flag() {
        return this.constrained_intra_pred_flag;
    }

    public boolean isRedundant_pic_cnt_present_flag() {
        return this.redundant_pic_cnt_present_flag;
    }

    public int[] getTop_left() {
        return this.top_left;
    }

    public int[] getBottom_right() {
        return this.bottom_right;
    }

    public int[] getRun_length_minus1() {
        return this.run_length_minus1;
    }

    public boolean isSlice_group_change_direction_flag() {
        return this.slice_group_change_direction_flag;
    }

    public int[] getSlice_group_id() {
        return this.slice_group_id;
    }

    public PPSExt getExtended() {
        return this.extended;
    }

    public static class PPSExt {
        public boolean transform_8x8_mode_flag;
        public ScalingMatrix scalindMatrix;
        public int second_chroma_qp_index_offset;
        public boolean[] pic_scaling_list_present_flag;

        public boolean isTransform_8x8_mode_flag() {
            return this.transform_8x8_mode_flag;
        }

        public ScalingMatrix getScalindMatrix() {
            return this.scalindMatrix;
        }

        public int getSecond_chroma_qp_index_offset() {
            return this.second_chroma_qp_index_offset;
        }

        public boolean[] getPic_scaling_list_present_flag() {
            return this.pic_scaling_list_present_flag;
        }
    }
}

