/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.io.model;

import java.nio.ByteBuffer;
import org.jcodec.codecs.h264.decode.CAVLCReader;
import org.jcodec.codecs.h264.io.model.AspectRatio;
import org.jcodec.codecs.h264.io.model.HRDParameters;
import org.jcodec.codecs.h264.io.model.ScalingList;
import org.jcodec.codecs.h264.io.model.ScalingMatrix;
import org.jcodec.codecs.h264.io.model.VUIParameters;
import org.jcodec.codecs.h264.io.write.CAVLCWriter;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.BitWriter;
import org.jcodec.common.model.ColorSpace;

public class SeqParameterSet {
    public int pic_order_cnt_type;
    public boolean field_pic_flag;
    public boolean delta_pic_order_always_zero_flag;
    public boolean mb_adaptive_frame_field_flag;
    public boolean direct_8x8_inference_flag;
    public ColorSpace chroma_format_idc;
    public int log2_max_frame_num_minus4;
    public int log2_max_pic_order_cnt_lsb_minus4;
    public int pic_height_in_map_units_minus1;
    public int pic_width_in_mbs_minus1;
    public int bit_depth_luma_minus8;
    public int bit_depth_chroma_minus8;
    public boolean qpprime_y_zero_transform_bypass_flag;
    public int profile_idc;
    public boolean constraint_set_0_flag;
    public boolean constraint_set_1_flag;
    public boolean constraint_set_2_flag;
    public boolean constraint_set_3_flag;
    public boolean constraint_set_4_flag;
    public boolean constraint_set_5_flag;
    public int level_idc;
    public int seq_parameter_set_id;
    public boolean residual_color_transform_flag;
    public int offset_for_non_ref_pic;
    public int offset_for_top_to_bottom_field;
    public int num_ref_frames;
    public boolean gaps_in_frame_num_value_allowed_flag;
    public boolean frame_mbs_only_flag;
    public boolean frame_cropping_flag;
    public int frame_crop_left_offset;
    public int frame_crop_right_offset;
    public int frame_crop_top_offset;
    public int frame_crop_bottom_offset;
    public int[] offsetForRefFrame;
    public VUIParameters vuiParams;
    public ScalingMatrix scalingMatrix;
    public int num_ref_frames_in_pic_order_cnt_cycle;

    public static ColorSpace getColor(int id) {
        switch (id) {
            case 0: {
                return ColorSpace.MONO;
            }
            case 1: {
                return ColorSpace.YUV420J;
            }
            case 2: {
                return ColorSpace.YUV422;
            }
            case 3: {
                return ColorSpace.YUV444;
            }
        }
        throw new RuntimeException("Colorspace not supported");
    }

    public static int fromColor(ColorSpace color) {
        if (color == ColorSpace.MONO) {
            return 0;
        }
        if (color == ColorSpace.YUV420J) {
            return 1;
        }
        if (color == ColorSpace.YUV422) {
            return 2;
        }
        if (color == ColorSpace.YUV444) {
            return 3;
        }
        throw new RuntimeException("Colorspace not supported");
    }

    public static SeqParameterSet read(ByteBuffer is) {
        boolean vui_parameters_present_flag;
        BitReader _in = BitReader.createBitReader(is);
        SeqParameterSet sps = new SeqParameterSet();
        sps.profile_idc = CAVLCReader.readNBit(_in, 8, "SPS: profile_idc");
        sps.constraint_set_0_flag = CAVLCReader.readBool(_in, "SPS: constraint_set_0_flag");
        sps.constraint_set_1_flag = CAVLCReader.readBool(_in, "SPS: constraint_set_1_flag");
        sps.constraint_set_2_flag = CAVLCReader.readBool(_in, "SPS: constraint_set_2_flag");
        sps.constraint_set_3_flag = CAVLCReader.readBool(_in, "SPS: constraint_set_3_flag");
        sps.constraint_set_4_flag = CAVLCReader.readBool(_in, "SPS: constraint_set_4_flag");
        sps.constraint_set_5_flag = CAVLCReader.readBool(_in, "SPS: constraint_set_5_flag");
        CAVLCReader.readNBit(_in, 2, "SPS: reserved_zero_2bits");
        sps.level_idc = CAVLCReader.readNBit(_in, 8, "SPS: level_idc");
        sps.seq_parameter_set_id = CAVLCReader.readUEtrace(_in, "SPS: seq_parameter_set_id");
        if (sps.profile_idc == 100 || sps.profile_idc == 110 || sps.profile_idc == 122 || sps.profile_idc == 144) {
            sps.chroma_format_idc = SeqParameterSet.getColor(CAVLCReader.readUEtrace(_in, "SPS: chroma_format_idc"));
            if (sps.chroma_format_idc == ColorSpace.YUV444) {
                sps.residual_color_transform_flag = CAVLCReader.readBool(_in, "SPS: residual_color_transform_flag");
            }
            sps.bit_depth_luma_minus8 = CAVLCReader.readUEtrace(_in, "SPS: bit_depth_luma_minus8");
            sps.bit_depth_chroma_minus8 = CAVLCReader.readUEtrace(_in, "SPS: bit_depth_chroma_minus8");
            sps.qpprime_y_zero_transform_bypass_flag = CAVLCReader.readBool(_in, "SPS: qpprime_y_zero_transform_bypass_flag");
            boolean seqScalingMatrixPresent = CAVLCReader.readBool(_in, "SPS: seq_scaling_matrix_present_lag");
            if (seqScalingMatrixPresent) {
                SeqParameterSet.readScalingListMatrix(_in, sps);
            }
        } else {
            sps.chroma_format_idc = ColorSpace.YUV420J;
        }
        sps.log2_max_frame_num_minus4 = CAVLCReader.readUEtrace(_in, "SPS: log2_max_frame_num_minus4");
        sps.pic_order_cnt_type = CAVLCReader.readUEtrace(_in, "SPS: pic_order_cnt_type");
        if (sps.pic_order_cnt_type == 0) {
            sps.log2_max_pic_order_cnt_lsb_minus4 = CAVLCReader.readUEtrace(_in, "SPS: log2_max_pic_order_cnt_lsb_minus4");
        } else if (sps.pic_order_cnt_type == 1) {
            sps.delta_pic_order_always_zero_flag = CAVLCReader.readBool(_in, "SPS: delta_pic_order_always_zero_flag");
            sps.offset_for_non_ref_pic = CAVLCReader.readSE(_in, "SPS: offset_for_non_ref_pic");
            sps.offset_for_top_to_bottom_field = CAVLCReader.readSE(_in, "SPS: offset_for_top_to_bottom_field");
            sps.num_ref_frames_in_pic_order_cnt_cycle = CAVLCReader.readUEtrace(_in, "SPS: num_ref_frames_in_pic_order_cnt_cycle");
            sps.offsetForRefFrame = new int[sps.num_ref_frames_in_pic_order_cnt_cycle];
            for (int i = 0; i < sps.num_ref_frames_in_pic_order_cnt_cycle; ++i) {
                sps.offsetForRefFrame[i] = CAVLCReader.readSE(_in, "SPS: offsetForRefFrame [" + i + "]");
            }
        }
        sps.num_ref_frames = CAVLCReader.readUEtrace(_in, "SPS: num_ref_frames");
        sps.gaps_in_frame_num_value_allowed_flag = CAVLCReader.readBool(_in, "SPS: gaps_in_frame_num_value_allowed_flag");
        sps.pic_width_in_mbs_minus1 = CAVLCReader.readUEtrace(_in, "SPS: pic_width_in_mbs_minus1");
        sps.pic_height_in_map_units_minus1 = CAVLCReader.readUEtrace(_in, "SPS: pic_height_in_map_units_minus1");
        sps.frame_mbs_only_flag = CAVLCReader.readBool(_in, "SPS: frame_mbs_only_flag");
        if (!sps.frame_mbs_only_flag) {
            sps.mb_adaptive_frame_field_flag = CAVLCReader.readBool(_in, "SPS: mb_adaptive_frame_field_flag");
        }
        sps.direct_8x8_inference_flag = CAVLCReader.readBool(_in, "SPS: direct_8x8_inference_flag");
        sps.frame_cropping_flag = CAVLCReader.readBool(_in, "SPS: frame_cropping_flag");
        if (sps.frame_cropping_flag) {
            sps.frame_crop_left_offset = CAVLCReader.readUEtrace(_in, "SPS: frame_crop_left_offset");
            sps.frame_crop_right_offset = CAVLCReader.readUEtrace(_in, "SPS: frame_crop_right_offset");
            sps.frame_crop_top_offset = CAVLCReader.readUEtrace(_in, "SPS: frame_crop_top_offset");
            sps.frame_crop_bottom_offset = CAVLCReader.readUEtrace(_in, "SPS: frame_crop_bottom_offset");
        }
        if (vui_parameters_present_flag = CAVLCReader.readBool(_in, "SPS: vui_parameters_present_flag")) {
            sps.vuiParams = SeqParameterSet.readVUIParameters(_in);
        }
        return sps;
    }

    private static void readScalingListMatrix(BitReader _in, SeqParameterSet sps) {
        sps.scalingMatrix = new ScalingMatrix();
        for (int i = 0; i < 8; ++i) {
            boolean seqScalingListPresentFlag = CAVLCReader.readBool(_in, "SPS: seqScalingListPresentFlag");
            if (!seqScalingListPresentFlag) continue;
            sps.scalingMatrix.ScalingList4x4 = new ScalingList[8];
            sps.scalingMatrix.ScalingList8x8 = new ScalingList[8];
            if (i < 6) {
                sps.scalingMatrix.ScalingList4x4[i] = ScalingList.read(_in, 16);
                continue;
            }
            sps.scalingMatrix.ScalingList8x8[i - 6] = ScalingList.read(_in, 64);
        }
    }

    private static VUIParameters readVUIParameters(BitReader _in) {
        boolean vcl_hrd_parameters_present_flag;
        boolean nal_hrd_parameters_present_flag;
        VUIParameters vuip = new VUIParameters();
        vuip.aspect_ratio_info_present_flag = CAVLCReader.readBool(_in, "VUI: aspect_ratio_info_present_flag");
        if (vuip.aspect_ratio_info_present_flag) {
            vuip.aspect_ratio = AspectRatio.fromValue(CAVLCReader.readNBit(_in, 8, "VUI: aspect_ratio"));
            if (vuip.aspect_ratio == AspectRatio.Extended_SAR) {
                vuip.sar_width = CAVLCReader.readNBit(_in, 16, "VUI: sar_width");
                vuip.sar_height = CAVLCReader.readNBit(_in, 16, "VUI: sar_height");
            }
        }
        vuip.overscan_info_present_flag = CAVLCReader.readBool(_in, "VUI: overscan_info_present_flag");
        if (vuip.overscan_info_present_flag) {
            vuip.overscan_appropriate_flag = CAVLCReader.readBool(_in, "VUI: overscan_appropriate_flag");
        }
        vuip.video_signal_type_present_flag = CAVLCReader.readBool(_in, "VUI: video_signal_type_present_flag");
        if (vuip.video_signal_type_present_flag) {
            vuip.video_format = CAVLCReader.readNBit(_in, 3, "VUI: video_format");
            vuip.video_full_range_flag = CAVLCReader.readBool(_in, "VUI: video_full_range_flag");
            vuip.colour_description_present_flag = CAVLCReader.readBool(_in, "VUI: colour_description_present_flag");
            if (vuip.colour_description_present_flag) {
                vuip.colour_primaries = CAVLCReader.readNBit(_in, 8, "VUI: colour_primaries");
                vuip.transfer_characteristics = CAVLCReader.readNBit(_in, 8, "VUI: transfer_characteristics");
                vuip.matrix_coefficients = CAVLCReader.readNBit(_in, 8, "VUI: matrix_coefficients");
            }
        }
        vuip.chroma_loc_info_present_flag = CAVLCReader.readBool(_in, "VUI: chroma_loc_info_present_flag");
        if (vuip.chroma_loc_info_present_flag) {
            vuip.chroma_sample_loc_type_top_field = CAVLCReader.readUEtrace(_in, "VUI chroma_sample_loc_type_top_field");
            vuip.chroma_sample_loc_type_bottom_field = CAVLCReader.readUEtrace(_in, "VUI chroma_sample_loc_type_bottom_field");
        }
        vuip.timing_info_present_flag = CAVLCReader.readBool(_in, "VUI: timing_info_present_flag");
        if (vuip.timing_info_present_flag) {
            vuip.num_units_in_tick = CAVLCReader.readNBit(_in, 32, "VUI: num_units_in_tick");
            vuip.time_scale = CAVLCReader.readNBit(_in, 32, "VUI: time_scale");
            vuip.fixed_frame_rate_flag = CAVLCReader.readBool(_in, "VUI: fixed_frame_rate_flag");
        }
        if (nal_hrd_parameters_present_flag = CAVLCReader.readBool(_in, "VUI: nal_hrd_parameters_present_flag")) {
            vuip.nalHRDParams = SeqParameterSet.readHRDParameters(_in);
        }
        if (vcl_hrd_parameters_present_flag = CAVLCReader.readBool(_in, "VUI: vcl_hrd_parameters_present_flag")) {
            vuip.vclHRDParams = SeqParameterSet.readHRDParameters(_in);
        }
        if (nal_hrd_parameters_present_flag || vcl_hrd_parameters_present_flag) {
            vuip.low_delay_hrd_flag = CAVLCReader.readBool(_in, "VUI: low_delay_hrd_flag");
        }
        vuip.pic_struct_present_flag = CAVLCReader.readBool(_in, "VUI: pic_struct_present_flag");
        boolean bitstream_restriction_flag = CAVLCReader.readBool(_in, "VUI: bitstream_restriction_flag");
        if (bitstream_restriction_flag) {
            vuip.bitstreamRestriction = new VUIParameters.BitstreamRestriction();
            vuip.bitstreamRestriction.motion_vectors_over_pic_boundaries_flag = CAVLCReader.readBool(_in, "VUI: motion_vectors_over_pic_boundaries_flag");
            vuip.bitstreamRestriction.max_bytes_per_pic_denom = CAVLCReader.readUEtrace(_in, "VUI max_bytes_per_pic_denom");
            vuip.bitstreamRestriction.max_bits_per_mb_denom = CAVLCReader.readUEtrace(_in, "VUI max_bits_per_mb_denom");
            vuip.bitstreamRestriction.log2_max_mv_length_horizontal = CAVLCReader.readUEtrace(_in, "VUI log2_max_mv_length_horizontal");
            vuip.bitstreamRestriction.log2_max_mv_length_vertical = CAVLCReader.readUEtrace(_in, "VUI log2_max_mv_length_vertical");
            vuip.bitstreamRestriction.num_reorder_frames = CAVLCReader.readUEtrace(_in, "VUI num_reorder_frames");
            vuip.bitstreamRestriction.max_dec_frame_buffering = CAVLCReader.readUEtrace(_in, "VUI max_dec_frame_buffering");
        }
        return vuip;
    }

    private static HRDParameters readHRDParameters(BitReader _in) {
        HRDParameters hrd = new HRDParameters();
        hrd.cpb_cnt_minus1 = CAVLCReader.readUEtrace(_in, "SPS: cpb_cnt_minus1");
        hrd.bit_rate_scale = CAVLCReader.readNBit(_in, 4, "HRD: bit_rate_scale");
        hrd.cpb_size_scale = CAVLCReader.readNBit(_in, 4, "HRD: cpb_size_scale");
        hrd.bit_rate_value_minus1 = new int[hrd.cpb_cnt_minus1 + 1];
        hrd.cpb_size_value_minus1 = new int[hrd.cpb_cnt_minus1 + 1];
        hrd.cbr_flag = new boolean[hrd.cpb_cnt_minus1 + 1];
        for (int SchedSelIdx = 0; SchedSelIdx <= hrd.cpb_cnt_minus1; ++SchedSelIdx) {
            hrd.bit_rate_value_minus1[SchedSelIdx] = CAVLCReader.readUEtrace(_in, "HRD: bit_rate_value_minus1");
            hrd.cpb_size_value_minus1[SchedSelIdx] = CAVLCReader.readUEtrace(_in, "HRD: cpb_size_value_minus1");
            hrd.cbr_flag[SchedSelIdx] = CAVLCReader.readBool(_in, "HRD: cbr_flag");
        }
        hrd.initial_cpb_removal_delay_length_minus1 = CAVLCReader.readNBit(_in, 5, "HRD: initial_cpb_removal_delay_length_minus1");
        hrd.cpb_removal_delay_length_minus1 = CAVLCReader.readNBit(_in, 5, "HRD: cpb_removal_delay_length_minus1");
        hrd.dpb_output_delay_length_minus1 = CAVLCReader.readNBit(_in, 5, "HRD: dpb_output_delay_length_minus1");
        hrd.time_offset_length = CAVLCReader.readNBit(_in, 5, "HRD: time_offset_length");
        return hrd;
    }

    public void write(ByteBuffer out) {
        int i;
        BitWriter writer = new BitWriter(out);
        CAVLCWriter.writeNBit(writer, this.profile_idc, 8, "SPS: profile_idc");
        CAVLCWriter.writeBool(writer, this.constraint_set_0_flag, "SPS: constraint_set_0_flag");
        CAVLCWriter.writeBool(writer, this.constraint_set_1_flag, "SPS: constraint_set_1_flag");
        CAVLCWriter.writeBool(writer, this.constraint_set_2_flag, "SPS: constraint_set_2_flag");
        CAVLCWriter.writeBool(writer, this.constraint_set_3_flag, "SPS: constraint_set_3_flag");
        CAVLCWriter.writeBool(writer, this.constraint_set_4_flag, "SPS: constraint_set_4_flag");
        CAVLCWriter.writeBool(writer, this.constraint_set_5_flag, "SPS: constraint_set_5_flag");
        CAVLCWriter.writeNBit(writer, 0L, 2, "SPS: reserved");
        CAVLCWriter.writeNBit(writer, this.level_idc, 8, "SPS: level_idc");
        CAVLCWriter.writeUEtrace(writer, this.seq_parameter_set_id, "SPS: seq_parameter_set_id");
        if (this.profile_idc == 100 || this.profile_idc == 110 || this.profile_idc == 122 || this.profile_idc == 144) {
            CAVLCWriter.writeUEtrace(writer, SeqParameterSet.fromColor(this.chroma_format_idc), "SPS: chroma_format_idc");
            if (this.chroma_format_idc == ColorSpace.YUV444) {
                CAVLCWriter.writeBool(writer, this.residual_color_transform_flag, "SPS: residual_color_transform_flag");
            }
            CAVLCWriter.writeUEtrace(writer, this.bit_depth_luma_minus8, "SPS: ");
            CAVLCWriter.writeUEtrace(writer, this.bit_depth_chroma_minus8, "SPS: ");
            CAVLCWriter.writeBool(writer, this.qpprime_y_zero_transform_bypass_flag, "SPS: qpprime_y_zero_transform_bypass_flag");
            CAVLCWriter.writeBool(writer, this.scalingMatrix != null, "SPS: ");
            if (this.scalingMatrix != null) {
                for (i = 0; i < 8; ++i) {
                    if (i < 6) {
                        CAVLCWriter.writeBool(writer, this.scalingMatrix.ScalingList4x4[i] != null, "SPS: ");
                        if (this.scalingMatrix.ScalingList4x4[i] == null) continue;
                        this.scalingMatrix.ScalingList4x4[i].write(writer);
                        continue;
                    }
                    CAVLCWriter.writeBool(writer, this.scalingMatrix.ScalingList8x8[i - 6] != null, "SPS: ");
                    if (this.scalingMatrix.ScalingList8x8[i - 6] == null) continue;
                    this.scalingMatrix.ScalingList8x8[i - 6].write(writer);
                }
            }
        }
        CAVLCWriter.writeUEtrace(writer, this.log2_max_frame_num_minus4, "SPS: log2_max_frame_num_minus4");
        CAVLCWriter.writeUEtrace(writer, this.pic_order_cnt_type, "SPS: pic_order_cnt_type");
        if (this.pic_order_cnt_type == 0) {
            CAVLCWriter.writeUEtrace(writer, this.log2_max_pic_order_cnt_lsb_minus4, "SPS: log2_max_pic_order_cnt_lsb_minus4");
        } else if (this.pic_order_cnt_type == 1) {
            CAVLCWriter.writeBool(writer, this.delta_pic_order_always_zero_flag, "SPS: delta_pic_order_always_zero_flag");
            CAVLCWriter.writeSEtrace(writer, this.offset_for_non_ref_pic, "SPS: offset_for_non_ref_pic");
            CAVLCWriter.writeSEtrace(writer, this.offset_for_top_to_bottom_field, "SPS: offset_for_top_to_bottom_field");
            CAVLCWriter.writeUEtrace(writer, this.offsetForRefFrame.length, "SPS: ");
            for (i = 0; i < this.offsetForRefFrame.length; ++i) {
                CAVLCWriter.writeSEtrace(writer, this.offsetForRefFrame[i], "SPS: ");
            }
        }
        CAVLCWriter.writeUEtrace(writer, this.num_ref_frames, "SPS: num_ref_frames");
        CAVLCWriter.writeBool(writer, this.gaps_in_frame_num_value_allowed_flag, "SPS: gaps_in_frame_num_value_allowed_flag");
        CAVLCWriter.writeUEtrace(writer, this.pic_width_in_mbs_minus1, "SPS: pic_width_in_mbs_minus1");
        CAVLCWriter.writeUEtrace(writer, this.pic_height_in_map_units_minus1, "SPS: pic_height_in_map_units_minus1");
        CAVLCWriter.writeBool(writer, this.frame_mbs_only_flag, "SPS: frame_mbs_only_flag");
        if (!this.frame_mbs_only_flag) {
            CAVLCWriter.writeBool(writer, this.mb_adaptive_frame_field_flag, "SPS: mb_adaptive_frame_field_flag");
        }
        CAVLCWriter.writeBool(writer, this.direct_8x8_inference_flag, "SPS: direct_8x8_inference_flag");
        CAVLCWriter.writeBool(writer, this.frame_cropping_flag, "SPS: frame_cropping_flag");
        if (this.frame_cropping_flag) {
            CAVLCWriter.writeUEtrace(writer, this.frame_crop_left_offset, "SPS: frame_crop_left_offset");
            CAVLCWriter.writeUEtrace(writer, this.frame_crop_right_offset, "SPS: frame_crop_right_offset");
            CAVLCWriter.writeUEtrace(writer, this.frame_crop_top_offset, "SPS: frame_crop_top_offset");
            CAVLCWriter.writeUEtrace(writer, this.frame_crop_bottom_offset, "SPS: frame_crop_bottom_offset");
        }
        CAVLCWriter.writeBool(writer, this.vuiParams != null, "SPS: ");
        if (this.vuiParams != null) {
            this.writeVUIParameters(this.vuiParams, writer);
        }
        CAVLCWriter.writeTrailingBits(writer);
    }

    private void writeVUIParameters(VUIParameters vuip, BitWriter writer) {
        CAVLCWriter.writeBool(writer, vuip.aspect_ratio_info_present_flag, "VUI: aspect_ratio_info_present_flag");
        if (vuip.aspect_ratio_info_present_flag) {
            CAVLCWriter.writeNBit(writer, vuip.aspect_ratio.getValue(), 8, "VUI: aspect_ratio");
            if (vuip.aspect_ratio == AspectRatio.Extended_SAR) {
                CAVLCWriter.writeNBit(writer, vuip.sar_width, 16, "VUI: sar_width");
                CAVLCWriter.writeNBit(writer, vuip.sar_height, 16, "VUI: sar_height");
            }
        }
        CAVLCWriter.writeBool(writer, vuip.overscan_info_present_flag, "VUI: overscan_info_present_flag");
        if (vuip.overscan_info_present_flag) {
            CAVLCWriter.writeBool(writer, vuip.overscan_appropriate_flag, "VUI: overscan_appropriate_flag");
        }
        CAVLCWriter.writeBool(writer, vuip.video_signal_type_present_flag, "VUI: video_signal_type_present_flag");
        if (vuip.video_signal_type_present_flag) {
            CAVLCWriter.writeNBit(writer, vuip.video_format, 3, "VUI: video_format");
            CAVLCWriter.writeBool(writer, vuip.video_full_range_flag, "VUI: video_full_range_flag");
            CAVLCWriter.writeBool(writer, vuip.colour_description_present_flag, "VUI: colour_description_present_flag");
            if (vuip.colour_description_present_flag) {
                CAVLCWriter.writeNBit(writer, vuip.colour_primaries, 8, "VUI: colour_primaries");
                CAVLCWriter.writeNBit(writer, vuip.transfer_characteristics, 8, "VUI: transfer_characteristics");
                CAVLCWriter.writeNBit(writer, vuip.matrix_coefficients, 8, "VUI: matrix_coefficients");
            }
        }
        CAVLCWriter.writeBool(writer, vuip.chroma_loc_info_present_flag, "VUI: chroma_loc_info_present_flag");
        if (vuip.chroma_loc_info_present_flag) {
            CAVLCWriter.writeUEtrace(writer, vuip.chroma_sample_loc_type_top_field, "VUI: chroma_sample_loc_type_top_field");
            CAVLCWriter.writeUEtrace(writer, vuip.chroma_sample_loc_type_bottom_field, "VUI: chroma_sample_loc_type_bottom_field");
        }
        CAVLCWriter.writeBool(writer, vuip.timing_info_present_flag, "VUI: timing_info_present_flag");
        if (vuip.timing_info_present_flag) {
            CAVLCWriter.writeNBit(writer, vuip.num_units_in_tick, 32, "VUI: num_units_in_tick");
            CAVLCWriter.writeNBit(writer, vuip.time_scale, 32, "VUI: time_scale");
            CAVLCWriter.writeBool(writer, vuip.fixed_frame_rate_flag, "VUI: fixed_frame_rate_flag");
        }
        CAVLCWriter.writeBool(writer, vuip.nalHRDParams != null, "VUI: ");
        if (vuip.nalHRDParams != null) {
            this.writeHRDParameters(vuip.nalHRDParams, writer);
        }
        CAVLCWriter.writeBool(writer, vuip.vclHRDParams != null, "VUI: ");
        if (vuip.vclHRDParams != null) {
            this.writeHRDParameters(vuip.vclHRDParams, writer);
        }
        if (vuip.nalHRDParams != null || vuip.vclHRDParams != null) {
            CAVLCWriter.writeBool(writer, vuip.low_delay_hrd_flag, "VUI: low_delay_hrd_flag");
        }
        CAVLCWriter.writeBool(writer, vuip.pic_struct_present_flag, "VUI: pic_struct_present_flag");
        CAVLCWriter.writeBool(writer, vuip.bitstreamRestriction != null, "VUI: ");
        if (vuip.bitstreamRestriction != null) {
            CAVLCWriter.writeBool(writer, vuip.bitstreamRestriction.motion_vectors_over_pic_boundaries_flag, "VUI: motion_vectors_over_pic_boundaries_flag");
            CAVLCWriter.writeUEtrace(writer, vuip.bitstreamRestriction.max_bytes_per_pic_denom, "VUI: max_bytes_per_pic_denom");
            CAVLCWriter.writeUEtrace(writer, vuip.bitstreamRestriction.max_bits_per_mb_denom, "VUI: max_bits_per_mb_denom");
            CAVLCWriter.writeUEtrace(writer, vuip.bitstreamRestriction.log2_max_mv_length_horizontal, "VUI: log2_max_mv_length_horizontal");
            CAVLCWriter.writeUEtrace(writer, vuip.bitstreamRestriction.log2_max_mv_length_vertical, "VUI: log2_max_mv_length_vertical");
            CAVLCWriter.writeUEtrace(writer, vuip.bitstreamRestriction.num_reorder_frames, "VUI: num_reorder_frames");
            CAVLCWriter.writeUEtrace(writer, vuip.bitstreamRestriction.max_dec_frame_buffering, "VUI: max_dec_frame_buffering");
        }
    }

    private void writeHRDParameters(HRDParameters hrd, BitWriter writer) {
        CAVLCWriter.writeUEtrace(writer, hrd.cpb_cnt_minus1, "HRD: cpb_cnt_minus1");
        CAVLCWriter.writeNBit(writer, hrd.bit_rate_scale, 4, "HRD: bit_rate_scale");
        CAVLCWriter.writeNBit(writer, hrd.cpb_size_scale, 4, "HRD: cpb_size_scale");
        for (int SchedSelIdx = 0; SchedSelIdx <= hrd.cpb_cnt_minus1; ++SchedSelIdx) {
            CAVLCWriter.writeUEtrace(writer, hrd.bit_rate_value_minus1[SchedSelIdx], "HRD: ");
            CAVLCWriter.writeUEtrace(writer, hrd.cpb_size_value_minus1[SchedSelIdx], "HRD: ");
            CAVLCWriter.writeBool(writer, hrd.cbr_flag[SchedSelIdx], "HRD: ");
        }
        CAVLCWriter.writeNBit(writer, hrd.initial_cpb_removal_delay_length_minus1, 5, "HRD: initial_cpb_removal_delay_length_minus1");
        CAVLCWriter.writeNBit(writer, hrd.cpb_removal_delay_length_minus1, 5, "HRD: cpb_removal_delay_length_minus1");
        CAVLCWriter.writeNBit(writer, hrd.dpb_output_delay_length_minus1, 5, "HRD: dpb_output_delay_length_minus1");
        CAVLCWriter.writeNBit(writer, hrd.time_offset_length, 5, "HRD: time_offset_length");
    }

    public SeqParameterSet copy() {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        this.write(buf);
        buf.flip();
        return SeqParameterSet.read(buf);
    }

    public int getPic_order_cnt_type() {
        return this.pic_order_cnt_type;
    }

    public boolean isField_pic_flag() {
        return this.field_pic_flag;
    }

    public boolean isDelta_pic_order_always_zero_flag() {
        return this.delta_pic_order_always_zero_flag;
    }

    public boolean isMb_adaptive_frame_field_flag() {
        return this.mb_adaptive_frame_field_flag;
    }

    public boolean isDirect_8x8_inference_flag() {
        return this.direct_8x8_inference_flag;
    }

    public ColorSpace getChroma_format_idc() {
        return this.chroma_format_idc;
    }

    public int getLog2_max_frame_num_minus4() {
        return this.log2_max_frame_num_minus4;
    }

    public int getLog2_max_pic_order_cnt_lsb_minus4() {
        return this.log2_max_pic_order_cnt_lsb_minus4;
    }

    public int getPic_height_in_map_units_minus1() {
        return this.pic_height_in_map_units_minus1;
    }

    public int getPic_width_in_mbs_minus1() {
        return this.pic_width_in_mbs_minus1;
    }

    public int getBit_depth_luma_minus8() {
        return this.bit_depth_luma_minus8;
    }

    public int getBit_depth_chroma_minus8() {
        return this.bit_depth_chroma_minus8;
    }

    public boolean isQpprime_y_zero_transform_bypass_flag() {
        return this.qpprime_y_zero_transform_bypass_flag;
    }

    public int getProfile_idc() {
        return this.profile_idc;
    }

    public boolean isConstraint_set_0_flag() {
        return this.constraint_set_0_flag;
    }

    public boolean isConstraint_set_1_flag() {
        return this.constraint_set_1_flag;
    }

    public boolean isConstraint_set_2_flag() {
        return this.constraint_set_2_flag;
    }

    public boolean isConstraint_set_3_flag() {
        return this.constraint_set_3_flag;
    }

    public boolean isConstraint_set_4_flag() {
        return this.constraint_set_4_flag;
    }

    public boolean isConstraint_set_5_flag() {
        return this.constraint_set_5_flag;
    }

    public int getLevel_idc() {
        return this.level_idc;
    }

    public int getSeq_parameter_set_id() {
        return this.seq_parameter_set_id;
    }

    public boolean isResidual_color_transform_flag() {
        return this.residual_color_transform_flag;
    }

    public int getOffset_for_non_ref_pic() {
        return this.offset_for_non_ref_pic;
    }

    public int getOffset_for_top_to_bottom_field() {
        return this.offset_for_top_to_bottom_field;
    }

    public int getNum_ref_frames() {
        return this.num_ref_frames;
    }

    public boolean isGaps_in_frame_num_value_allowed_flag() {
        return this.gaps_in_frame_num_value_allowed_flag;
    }

    public boolean isFrame_mbs_only_flag() {
        return this.frame_mbs_only_flag;
    }

    public boolean isFrame_cropping_flag() {
        return this.frame_cropping_flag;
    }

    public int getFrame_crop_left_offset() {
        return this.frame_crop_left_offset;
    }

    public int getFrame_crop_right_offset() {
        return this.frame_crop_right_offset;
    }

    public int getFrame_crop_top_offset() {
        return this.frame_crop_top_offset;
    }

    public int getFrame_crop_bottom_offset() {
        return this.frame_crop_bottom_offset;
    }

    public int[] getOffsetForRefFrame() {
        return this.offsetForRefFrame;
    }

    public VUIParameters getVuiParams() {
        return this.vuiParams;
    }

    public ScalingMatrix getScalingMatrix() {
        return this.scalingMatrix;
    }

    public int getNum_ref_frames_in_pic_order_cnt_cycle() {
        return this.num_ref_frames_in_pic_order_cnt_cycle;
    }

    public static int getPicHeightInMbs(SeqParameterSet sps) {
        int picHeightInMbs = sps.pic_height_in_map_units_minus1 + 1 << (sps.frame_mbs_only_flag ? 0 : 1);
        return picHeightInMbs;
    }
}

