/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mpeg12;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.jcodec.codecs.mpeg12.FixTimestamp;
import org.jcodec.common.io.IOUtils;
import org.jcodec.common.model.RationalLarge;
import org.jcodec.common.tools.MainUtils;

public class TimestampUtil {
    private static final String STREAM_ALL = "all";
    private static final String STREAM_AUDIO = "audio";
    private static final String STRAM_VIDEO = "video";
    private static final String FLAG_STREAM = "stream";
    private static final String COMMAND_SHIFT = "shift";
    private static final String COMMAND_SCALE = "scale";
    private static final String COMMAND_ROUND = "round";

    public static void main1(String[] args) throws IOException {
        MainUtils.Cmd cmd = MainUtils.parseArguments(args);
        if (cmd.args.length < 3) {
            System.out.println("A utility to tweak MPEG TS timestamps.");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(FLAG_STREAM, "A stream to shift, i.e. 'video' or 'audio' or 'all' [default]");
            MainUtils.printHelp(map, Arrays.asList("command", "arg", "in name", "?out file"));
            System.out.println("Where command is:\n\tshift\tShift timestamps of selected stream by arg.\n\tscale\tScale timestams of selected stream by arg [num:den].\n\tround\tRound timestamps of selected stream to multiples of arg.");
            return;
        }
        File src = new File(cmd.getArg(2));
        if (cmd.argsLength() > 3) {
            File dst = new File(cmd.getArg(3));
            IOUtils.copyFile(src, dst);
            src = dst;
        }
        String command = cmd.getArg(0);
        String stream = cmd.getStringFlagD(FLAG_STREAM, STREAM_ALL);
        if (COMMAND_SHIFT.equalsIgnoreCase(command)) {
            final long shift = Long.parseLong(cmd.getArg(1));
            new BaseCommand(stream){

                @Override
                protected long withTimestamp(long pts, boolean isPts) {
                    return Math.max(pts + shift, 0L);
                }
            }.fix(src);
        } else if (COMMAND_SCALE.equalsIgnoreCase(command)) {
            final RationalLarge scale = RationalLarge.parse(cmd.getArg(1));
            new BaseCommand(stream){

                @Override
                protected long withTimestamp(long pts, boolean isPts) {
                    return scale.multiplyS(pts);
                }
            }.fix(src);
        } else if (COMMAND_ROUND.equalsIgnoreCase(command)) {
            final int precision = Integer.parseInt(cmd.getArg(1));
            new BaseCommand(stream){

                @Override
                protected long withTimestamp(long pts, boolean isPts) {
                    return Math.round((double)pts / (double)precision) * (long)precision;
                }
            }.fix(src);
        }
    }

    private static abstract class BaseCommand
    extends FixTimestamp {
        private String streamSelector;

        public BaseCommand(String stream) {
            this.streamSelector = stream;
        }

        @Override
        protected long doWithTimestamp(int streamId, long pts, boolean isPts) {
            if (TimestampUtil.STREAM_ALL.equals(this.streamSelector) || TimestampUtil.STRAM_VIDEO.equals(this.streamSelector) && this.isVideo(streamId) || TimestampUtil.STREAM_AUDIO.equals(this.streamSelector) && this.isAudio(streamId)) {
                return this.withTimestamp(pts, isPts);
            }
            return pts;
        }

        protected abstract long withTimestamp(long var1, boolean var3);
    }
}

