/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.prores;

import java.nio.ByteBuffer;
import org.jcodec.codecs.prores.ProresConsts;
import org.jcodec.codecs.prores.ProresDecoder;
import org.jcodec.common.dct.IDCT4x4;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture8Bit;

public class ProresToThumb4x4
extends ProresDecoder {
    public static int[] progressive_scan_4x4 = new int[]{0, 1, 4, 5, 2, 3, 6, 7, 8, 9, 12, 13, 11, 12, 14, 15};
    public static int[] interlaced_scan_4x4 = new int[]{0, 4, 1, 5, 8, 12, 9, 13, 2, 6, 3, 7, 10, 14, 11, 15};
    private static final int[] srcIncLuma = new int[]{4, 4, 4, 20, 4, 4, 4, 20};

    @Override
    protected void decodeOnePlane(BitReader bits, int blocksPerSlice, int[] out, int[] qMat, int[] scan, int mbX, int mbY, int plane) {
        ProresToThumb4x4.readDCCoeffs(bits, qMat, out, blocksPerSlice, 16);
        ProresToThumb4x4.readACCoeffs(bits, qMat, out, blocksPerSlice, scan, 16, 4);
        for (int i = 0; i < blocksPerSlice; ++i) {
            IDCT4x4.idct(out, i << 4);
        }
    }

    @Override
    public Picture8Bit decodeFrame8Bit(ByteBuffer data, byte[][] target) {
        ProresConsts.FrameHeader fh = ProresToThumb4x4.readFrameHeader(data);
        int codedWidth = (fh.width + 15 & 0xFFFFFFF0) >> 1;
        int codedHeight = (fh.height + 15 & 0xFFFFFFF0) >> 1;
        int lumaSize = codedWidth * codedHeight;
        int chromaSize = lumaSize >> 1;
        if (target == null || target[0].length < lumaSize || target[1].length < chromaSize || target[2].length < chromaSize) {
            throw new RuntimeException("Provided output picture won't fit into provided buffer");
        }
        if (fh.frameType == 0) {
            this.decodePicture(data, target, codedWidth, codedHeight, codedWidth >> 3, fh.qMatLuma, fh.qMatChroma, progressive_scan_4x4, 0, fh.chromaType);
        } else {
            this.decodePicture(data, target, codedWidth, codedHeight >> 1, codedWidth >> 3, fh.qMatLuma, fh.qMatChroma, interlaced_scan_4x4, fh.topFieldFirst ? 1 : 2, fh.chromaType);
            this.decodePicture(data, target, codedWidth, codedHeight >> 1, codedWidth >> 3, fh.qMatLuma, fh.qMatChroma, interlaced_scan_4x4, fh.topFieldFirst ? 2 : 1, fh.chromaType);
        }
        return Picture8Bit.createPicture8Bit(codedWidth, codedHeight, target, fh.chromaType == 2 ? ColorSpace.YUV422 : ColorSpace.YUV444);
    }

    @Override
    protected void putSlice(byte[][] result, int lumaStride, int mbX, int mbY, int[] y, int[] u, int[] v, int dist, int shift, int chromaType, int sliceMbCount) {
        int chromaStride = lumaStride >> 1;
        this._putLuma(result[0], shift * lumaStride, lumaStride << dist, mbX, mbY, y, sliceMbCount, dist, shift);
        if (chromaType == 2) {
            this._putChroma(result[1], shift * chromaStride, chromaStride << dist, mbX, mbY, u, sliceMbCount, dist, shift);
            this._putChroma(result[2], shift * chromaStride, chromaStride << dist, mbX, mbY, v, sliceMbCount, dist, shift);
        } else {
            this._putLuma(result[1], shift * lumaStride, lumaStride << dist, mbX, mbY, u, sliceMbCount, dist, shift);
            this._putLuma(result[2], shift * lumaStride, lumaStride << dist, mbX, mbY, v, sliceMbCount, dist, shift);
        }
    }

    private void _putLuma(byte[] y, int off, int stride, int mbX, int mbY, int[] luma, int mbPerSlice, int dist, int shift) {
        off += (mbX << 3) + (mbY << 3) * stride;
        int mb = 0;
        int sOff = 0;
        while (mb < mbPerSlice) {
            int _off = off;
            for (int line = 0; line < 8; ++line) {
                y[_off] = this.clipTo8Bit(luma[sOff], 4, 1019);
                y[_off + 1] = this.clipTo8Bit(luma[sOff + 1], 4, 1019);
                y[_off + 2] = this.clipTo8Bit(luma[sOff + 2], 4, 1019);
                y[_off + 3] = this.clipTo8Bit(luma[sOff + 3], 4, 1019);
                y[_off + 4] = this.clipTo8Bit(luma[sOff + 16], 4, 1019);
                y[_off + 5] = this.clipTo8Bit(luma[sOff + 17], 4, 1019);
                y[_off + 6] = this.clipTo8Bit(luma[sOff + 18], 4, 1019);
                y[_off + 7] = this.clipTo8Bit(luma[sOff + 19], 4, 1019);
                sOff += srcIncLuma[line];
                _off += stride;
            }
            ++mb;
            off += 8;
        }
    }

    private void _putChroma(byte[] y, int off, int stride, int mbX, int mbY, int[] chroma, int mbPerSlice, int dist, int shift) {
        off += (mbX << 2) + (mbY << 3) * stride;
        int k = 0;
        int sOff = 0;
        while (k < mbPerSlice) {
            int _off = off;
            for (int line = 0; line < 8; ++line) {
                y[_off] = this.clipTo8Bit(chroma[sOff], 4, 1019);
                y[_off + 1] = this.clipTo8Bit(chroma[sOff + 1], 4, 1019);
                y[_off + 2] = this.clipTo8Bit(chroma[sOff + 2], 4, 1019);
                y[_off + 3] = this.clipTo8Bit(chroma[sOff + 3], 4, 1019);
                sOff += 4;
                _off += stride;
            }
            ++k;
            off += 4;
        }
    }
}

