/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.y4m;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.jcodec.common.model.Picture8Bit;

public class Y4MEncoder {
    private WritableByteChannel ch;
    private boolean headerWritten;
    private int width;
    private int height;
    private byte[] scratchBuffer;
    public static final byte[] frameTag = "FRAME\n".getBytes();

    public Y4MEncoder(WritableByteChannel ch) {
        this.ch = ch;
    }

    public void encodeFrame(Picture8Bit picture) throws IOException {
        if (!this.headerWritten) {
            this.writeHeader(picture);
            this.headerWritten = true;
        }
        if (picture.getWidth() != this.width || picture.getHeight() != this.height) {
            throw new RuntimeException("Changing picture dimentsions is not allowed in Y4M.");
        }
        this.ch.write(ByteBuffer.wrap(frameTag));
        this.ch.write(this.shiftPlane(picture.getPlaneData(0)));
        this.ch.write(this.shiftPlane(picture.getPlaneData(1)));
        this.ch.write(this.shiftPlane(picture.getPlaneData(2)));
    }

    protected void writeHeader(Picture8Bit picture) throws IOException {
        byte[] bytes = String.format("YUV4MPEG2 W%d H%d F25:1 Ip A0:0 C420jpeg XYSCSS=420JPEG\n", picture.getWidth(), picture.getHeight()).getBytes();
        this.ch.write(ByteBuffer.wrap(bytes));
        this.width = picture.getWidth();
        this.height = picture.getHeight();
        this.scratchBuffer = new byte[this.width * this.height];
    }

    protected ByteBuffer shiftPlane(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.scratchBuffer[i] = (byte)(data[i] + 128);
        }
        return ByteBuffer.wrap(this.scratchBuffer, 0, data.length);
    }
}

