/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common;

import java.nio.ByteBuffer;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Picture8Bit;

public abstract class VideoEncoder {
    public EncodedFrame encodeFrame(Picture pic, ByteBuffer _out) {
        return this.encodeFrame8Bit(Picture8Bit.fromPicture(pic), _out);
    }

    public abstract EncodedFrame encodeFrame8Bit(Picture8Bit var1, ByteBuffer var2);

    public abstract ColorSpace[] getSupportedColorSpaces();

    public abstract int estimateBufferSize(Picture8Bit var1);

    public static class EncodedFrame {
        private ByteBuffer data;
        private boolean keyFrame;

        public EncodedFrame(ByteBuffer data, boolean keyFrame) {
            this.data = data;
            this.keyFrame = keyFrame;
        }

        public ByteBuffer getData() {
            return this.data;
        }

        public boolean isKeyFrame() {
            return this.keyFrame;
        }
    }
}

