/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.dct;

public class SimpleIDCT10Bit {
    public static int W1 = 90901;
    public static int W2 = 85627;
    public static int W3 = 77062;
    public static int W4 = 65535;
    public static int W5 = 51491;
    public static int W6 = 35468;
    public static int W7 = 18081;
    public static int ROW_SHIFT = 15;
    public static int COL_SHIFT = 20;
    static double[] coefficients = new double[64];

    public static final void idct10(int[] buf, int off) {
        int i;
        for (i = 0; i < 8; ++i) {
            SimpleIDCT10Bit.idctRow(buf, off + (i << 3));
        }
        for (i = 0; i < 8; ++i) {
            SimpleIDCT10Bit.idctCol(buf, off + i);
        }
    }

    private static final void idctCol(int[] buf, int off) {
        int a0;
        int a1 = a0 = W4 * (buf[off + 0] + (1 << COL_SHIFT - 1) / W4);
        int a2 = a0;
        int a3 = a0;
        a0 += W2 * buf[off + 16];
        a1 += W6 * buf[off + 16];
        a2 += -W6 * buf[off + 16];
        a3 += -W2 * buf[off + 16];
        int b0 = W1 * buf[off + 8];
        int b1 = W3 * buf[off + 8];
        int b2 = W5 * buf[off + 8];
        int b3 = W7 * buf[off + 8];
        b0 += W3 * buf[off + 24];
        b1 += -W7 * buf[off + 24];
        b2 += -W1 * buf[off + 24];
        b3 += -W5 * buf[off + 24];
        if (buf[off + 32] != 0) {
            a0 += W4 * buf[off + 32];
            a1 += -W4 * buf[off + 32];
            a2 += -W4 * buf[off + 32];
            a3 += W4 * buf[off + 32];
        }
        if (buf[off + 40] != 0) {
            b0 += W5 * buf[off + 40];
            b1 += -W1 * buf[off + 40];
            b2 += W7 * buf[off + 40];
            b3 += W3 * buf[off + 40];
        }
        if (buf[off + 48] != 0) {
            a0 += W6 * buf[off + 48];
            a1 += -W2 * buf[off + 48];
            a2 += W2 * buf[off + 48];
            a3 += -W6 * buf[off + 48];
        }
        if (buf[off + 56] != 0) {
            b0 += W7 * buf[off + 56];
            b1 += -W5 * buf[off + 56];
            b2 += W3 * buf[off + 56];
            b3 += -W1 * buf[off + 56];
        }
        buf[off] = a0 + b0 >> COL_SHIFT;
        buf[off + 8] = a1 + b1 >> COL_SHIFT;
        buf[off + 16] = a2 + b2 >> COL_SHIFT;
        buf[off + 24] = a3 + b3 >> COL_SHIFT;
        buf[off + 32] = a3 - b3 >> COL_SHIFT;
        buf[off + 40] = a2 - b2 >> COL_SHIFT;
        buf[off + 48] = a1 - b1 >> COL_SHIFT;
        buf[off + 56] = a0 - b0 >> COL_SHIFT;
    }

    private static final void idctRow(int[] buf, int off) {
        int a0;
        int a1 = a0 = W4 * buf[off] + (1 << ROW_SHIFT - 1);
        int a2 = a0;
        int a3 = a0;
        a0 += W2 * buf[off + 2];
        a1 += W6 * buf[off + 2];
        a2 -= W6 * buf[off + 2];
        a3 -= W2 * buf[off + 2];
        int b0 = W1 * buf[off + 1];
        b0 += W3 * buf[off + 3];
        int b1 = W3 * buf[off + 1];
        b1 += -W7 * buf[off + 3];
        int b2 = W5 * buf[off + 1];
        b2 += -W1 * buf[off + 3];
        int b3 = W7 * buf[off + 1];
        b3 += -W5 * buf[off + 3];
        if (buf[off + 4] != 0 || buf[off + 5] != 0 || buf[off + 6] != 0 || buf[off + 7] != 0) {
            a0 += W4 * buf[off + 4] + W6 * buf[off + 6];
            a1 += -W4 * buf[off + 4] - W2 * buf[off + 6];
            a2 += -W4 * buf[off + 4] + W2 * buf[off + 6];
            a3 += W4 * buf[off + 4] - W6 * buf[off + 6];
            b0 += W5 * buf[off + 5];
            b0 += W7 * buf[off + 7];
            b1 += -W1 * buf[off + 5];
            b1 += -W5 * buf[off + 7];
            b2 += W7 * buf[off + 5];
            b2 += W3 * buf[off + 7];
            b3 += W3 * buf[off + 5];
            b3 += -W1 * buf[off + 7];
        }
        buf[off + 0] = a0 + b0 >> ROW_SHIFT;
        buf[off + 7] = a0 - b0 >> ROW_SHIFT;
        buf[off + 1] = a1 + b1 >> ROW_SHIFT;
        buf[off + 6] = a1 - b1 >> ROW_SHIFT;
        buf[off + 2] = a2 + b2 >> ROW_SHIFT;
        buf[off + 5] = a2 - b2 >> ROW_SHIFT;
        buf[off + 3] = a3 + b3 >> ROW_SHIFT;
        buf[off + 4] = a3 - b3 >> ROW_SHIFT;
    }

    public static void fdct10(byte[] block, int off, int[] dctOut) {
        int k;
        double tmp;
        int j;
        int i;
        double[] out = new double[64];
        for (i = 0; i < 64; i += 8) {
            for (j = 0; j < 8; ++j) {
                tmp = 0.0;
                for (k = 0; k < 8; ++k) {
                    tmp += coefficients[i + k] * (double)(block[k * 8 + j + off] + 128 << 2);
                }
                out[i + j] = tmp * 4.0;
            }
        }
        for (j = 0; j < 8; ++j) {
            for (i = 0; i < 64; i += 8) {
                tmp = 0.0;
                for (k = 0; k < 8; ++k) {
                    tmp += out[i + k] * coefficients[j * 8 + k];
                }
                dctOut[i + j + off] = (int)(tmp + 0.499999999999);
            }
        }
    }

    static {
        for (int j = 0; j < 8; ++j) {
            SimpleIDCT10Bit.coefficients[j] = Math.sqrt(0.125);
            for (int i = 8; i < 64; i += 8) {
                SimpleIDCT10Bit.coefficients[i + j] = 0.5 * Math.cos((double)i * ((double)j + 0.5) * Math.PI / 64.0);
            }
        }
    }
}

