/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.logging;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jcodec.common.logging.LogLevel;
import org.jcodec.common.logging.LogSink;
import org.jcodec.common.logging.Message;
import org.jcodec.common.logging.OutLogSink;

public class Logger {
    private static List<LogSink> stageSinks = new LinkedList<LogSink>();
    private static List<LogSink> sinks;

    public static void debug(String message) {
        Logger.message(LogLevel.DEBUG, message);
    }

    public static void info(String message) {
        Logger.message(LogLevel.INFO, message);
    }

    public static void warn(String message) {
        Logger.message(LogLevel.WARN, message);
    }

    public static void error(String message) {
        Logger.message(LogLevel.ERROR, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void message(LogLevel level, String message) {
        if (sinks == null) {
            Class<Logger> clazz = Logger.class;
            // MONITORENTER : org.jcodec.common.logging.Logger.class
            if (sinks == null) {
                sinks = stageSinks;
                stageSinks = null;
                if (sinks.isEmpty()) {
                    sinks.add(OutLogSink.createOutLogSink());
                }
            }
            // MONITOREXIT : clazz
        }
        StackTraceElement tr = Thread.currentThread().getStackTrace()[3];
        Message msg = new Message(level, tr.getFileName(), tr.getClassName(), tr.getMethodName(), tr.getLineNumber(), message);
        Iterator<LogSink> iterator = sinks.iterator();
        while (iterator.hasNext()) {
            LogSink logSink = iterator.next();
            logSink.postMessage(msg);
        }
    }

    public static void addSink(LogSink sink) {
        if (stageSinks == null) {
            throw new IllegalStateException("Logger already started");
        }
        stageSinks.add(sink);
    }
}

