/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.model;

import java.util.Arrays;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Rect;

public class Picture8Bit {
    private ColorSpace color;
    private int width;
    private int height;
    private byte[][] data;
    private Rect crop;

    public static Picture8Bit createPicture8Bit(int width, int height, byte[][] data, ColorSpace color) {
        return new Picture8Bit(width, height, data, color, new Rect(0, 0, width, height));
    }

    public Picture8Bit(int width, int height, byte[][] data, ColorSpace color, Rect crop) {
        this.width = width;
        this.height = height;
        this.data = data;
        this.color = color;
        this.crop = crop;
        if (color != null) {
            for (int i = 0; i < color.nComp; ++i) {
                int mask = 255 >> 8 - color.compWidth[i];
                if ((width & mask) != 0) {
                    throw new IllegalArgumentException("Component " + i + " width should be a multiple of " + (1 << color.compWidth[i]) + " for colorspace: " + color);
                }
                if (crop != null && (crop.getWidth() & mask) != 0) {
                    throw new IllegalArgumentException("Component " + i + " cropped width should be a multiple of " + (1 << color.compWidth[i]) + " for colorspace: " + color);
                }
                mask = 255 >> 8 - color.compHeight[i];
                if ((height & mask) != 0) {
                    throw new IllegalArgumentException("Component " + i + " height should be a multiple of " + (1 << color.compHeight[i]) + " for colorspace: " + color);
                }
                if (crop == null || (crop.getHeight() & mask) == 0) continue;
                throw new IllegalArgumentException("Component " + i + " cropped height should be a multiple of " + (1 << color.compHeight[i]) + " for colorspace: " + color);
            }
        }
    }

    public static Picture8Bit copyPicture8Bit(Picture8Bit other) {
        return new Picture8Bit(other.width, other.height, other.data, other.color, other.crop);
    }

    public static Picture8Bit create(int width, int height, ColorSpace colorSpace) {
        return Picture8Bit.createCropped(width, height, colorSpace, null);
    }

    public static Picture8Bit createCropped(int width, int height, ColorSpace colorSpace, Rect crop) {
        int[] planeSizes = new int[4];
        for (int i = 0; i < colorSpace.nComp; ++i) {
            int n = colorSpace.compPlane[i];
            planeSizes[n] = planeSizes[n] + (width >> colorSpace.compWidth[i]) * (height >> colorSpace.compHeight[i]);
        }
        int nPlanes = 0;
        for (int i = 0; i < 4; ++i) {
            nPlanes += planeSizes[i] != 0 ? 1 : 0;
        }
        byte[][] data = new byte[nPlanes][];
        int plane = 0;
        for (int i = 0; i < 4; ++i) {
            if (planeSizes[i] == 0) continue;
            data[plane++] = new byte[planeSizes[i]];
        }
        return new Picture8Bit(width, height, data, colorSpace, crop);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getPlaneData(int plane) {
        return this.data[plane];
    }

    public ColorSpace getColor() {
        return this.color;
    }

    public byte[][] getData() {
        return this.data;
    }

    public Rect getCrop() {
        return this.crop;
    }

    public int getPlaneWidth(int plane) {
        return this.width >> this.color.compWidth[plane];
    }

    public int getPlaneHeight(int plane) {
        return this.height >> this.color.compHeight[plane];
    }

    public boolean compatible(Picture8Bit src) {
        return src.color == this.color && src.width == this.width && src.height == this.height;
    }

    public Picture8Bit createCompatible() {
        return Picture8Bit.create(this.width, this.height, this.color);
    }

    public void copyFrom(Picture8Bit src) {
        if (!this.compatible(src)) {
            throw new IllegalArgumentException("Can not copy to incompatible picture");
        }
        for (int plane = 0; plane < this.color.nComp; ++plane) {
            if (this.data[plane] == null) continue;
            System.arraycopy(src.data[plane], 0, this.data[plane], 0, (this.width >> this.color.compWidth[plane]) * (this.height >> this.color.compHeight[plane]));
        }
    }

    public Picture8Bit cloneCropped() {
        if (this.cropNeeded()) {
            return this.cropped();
        }
        Picture8Bit clone = this.createCompatible();
        clone.copyFrom(this);
        return clone;
    }

    public Picture8Bit cropped() {
        if (!this.cropNeeded()) {
            return this;
        }
        Picture8Bit result = Picture8Bit.create(this.crop.getWidth(), this.crop.getHeight(), this.color);
        if (this.color.planar) {
            for (int plane = 0; plane < this.data.length; ++plane) {
                if (this.data[plane] == null) continue;
                this.cropSub(this.data[plane], this.crop.getX() >> this.color.compWidth[plane], this.crop.getY() >> this.color.compHeight[plane], this.crop.getWidth() >> this.color.compWidth[plane], this.crop.getHeight() >> this.color.compHeight[plane], this.width >> this.color.compWidth[plane], this.crop.getWidth() >> this.color.compWidth[plane], result.data[plane]);
            }
        } else {
            this.cropSub(this.data[0], this.crop.getX(), this.crop.getY(), this.crop.getWidth(), this.crop.getHeight(), this.width * this.color.nComp, this.crop.getWidth() * this.color.nComp, result.data[0]);
        }
        return result;
    }

    protected boolean cropNeeded() {
        return this.crop != null && (this.crop.getX() != 0 || this.crop.getY() != 0 || this.crop.getWidth() != this.width || this.crop.getHeight() != this.height);
    }

    private void cropSub(byte[] src, int x, int y, int w, int h, int srcStride, int dstStride, byte[] tgt) {
        int srcOff = y * srcStride + x;
        int dstOff = 0;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < dstStride; ++j) {
                tgt[dstOff + j] = src[srcOff + j];
            }
            srcOff += srcStride;
            dstOff += dstStride;
        }
    }

    public void setCrop(Rect crop) {
        this.crop = crop;
    }

    public int getCroppedWidth() {
        return this.crop == null ? this.width : this.crop.getWidth();
    }

    public int getCroppedHeight() {
        return this.crop == null ? this.height : this.crop.getHeight();
    }

    public static Picture8Bit fromPicture(Picture pic) {
        Picture8Bit create = Picture8Bit.createCropped(pic.getWidth(), pic.getHeight(), pic.getColor(), pic.getCrop());
        for (int i = 0; i < Math.min(pic.getData().length, create.getData().length); ++i) {
            for (int j = 0; j < Math.min(pic.getData()[i].length, create.getData()[i].length); ++j) {
                create.getData()[i][j] = (byte)((pic.getData()[i][j] << 8 >> pic.getBitDepth()) - 128);
            }
        }
        return create;
    }

    public Picture toPicture(int bitDepth) {
        Picture create = Picture.doCreate(this.width, this.height, this.color, bitDepth, this.crop);
        return this.toPictureInternal(bitDepth, create);
    }

    public Picture toPictureWithBuffer(int bitDepth, int[][] buffer) {
        Picture create = new Picture(this.width, this.height, buffer, this.color, bitDepth, this.crop);
        return this.toPictureInternal(bitDepth, create);
    }

    private Picture toPictureInternal(int bitDepth, Picture create) {
        for (int i = 0; i < this.data.length; ++i) {
            int planeSize = this.getPlaneWidth(i) * this.getPlaneHeight(i);
            for (int j = 0; j < planeSize; ++j) {
                create.getData()[i][j] = this.data[i][j] + 128 << bitDepth >> 8;
            }
        }
        return create;
    }

    public void fill(int val) {
        for (int i = 0; i < this.data.length; ++i) {
            Arrays.fill(this.data[i], (byte)val);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Picture8Bit)) {
            return false;
        }
        Picture8Bit other = (Picture8Bit)obj;
        if (other.getCroppedWidth() != this.getCroppedWidth() || other.getCroppedHeight() != this.getCroppedHeight() || other.getColor() != this.color) {
            return false;
        }
        for (int i = 0; i < this.getData().length; ++i) {
            if (this.planeEquals(other, i)) continue;
            return false;
        }
        return true;
    }

    private boolean planeEquals(Picture8Bit other, int plane) {
        int cw = this.color.compWidth[plane];
        int ch = this.color.compHeight[plane];
        int offA = other.getCrop() == null ? 0 : (other.getCrop().getX() >> cw) + (other.getCrop().getY() >> ch) * (other.getWidth() >> cw);
        int offB = this.crop == null ? 0 : (this.crop.getX() >> cw) + (this.crop.getY() >> ch) * (this.width >> cw);
        byte[] planeData = other.getPlaneData(plane);
        int i = 0;
        while (i < this.getCroppedHeight() >> ch) {
            for (int j = 0; j < this.getCroppedWidth() >> cw; ++j) {
                if (planeData[offA + j] == this.data[plane][offB + j]) continue;
                return false;
            }
            ++i;
            offA += other.getWidth() >> cw;
            offB += this.width >> cw;
        }
        return true;
    }
}

