/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.tools;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcodec.common.StringUtils;
import org.jcodec.platform.Platform;

public class MainUtils {
    private static final String JCODEC_LOG_SINK_COLOR = "jcodec.colorPrint";
    public static boolean isColorSupported = System.console() != null || Boolean.parseBoolean(System.getProperty("jcodec.colorPrint"));
    private static Pattern flagPattern = Pattern.compile("^--([^=]+)=(.*)$");

    public static Cmd parseArguments(String[] args) {
        HashMap<String, String> flags = new HashMap<String, String>();
        HashMap<String, String> allFlags = new HashMap<String, String>();
        ArrayList<String> outArgs = new ArrayList<String>();
        ArrayList<HashMap<String, String>> argFlags = new ArrayList<HashMap<String, String>>();
        for (int arg = 0; arg < args.length; ++arg) {
            if (args[arg].startsWith("--")) {
                Matcher matcher = flagPattern.matcher(args[arg]);
                if (matcher.matches()) {
                    flags.put(matcher.group(1), matcher.group(2));
                    continue;
                }
                flags.put(args[arg].substring(2), "true");
                continue;
            }
            if (args[arg].startsWith("-")) {
                flags.put(args[arg].substring(1), args[++arg]);
                continue;
            }
            allFlags.putAll(flags);
            outArgs.add(args[arg]);
            argFlags.add(flags);
        }
        return new Cmd(allFlags, outArgs.toArray(new String[0]), argFlags.toArray((Map[])Array.newInstance(flags.getClass(), 0)));
    }

    public static void printHelpVarArgs(Map<String, String> flags, String ... arguments) {
        MainUtils.printHelpOut(System.out, "", flags, Arrays.asList(arguments));
    }

    public static void printHelpArgs(Map<String, String> flags, String[] arguments) {
        MainUtils.printHelpOut(System.out, "", flags, Arrays.asList(arguments));
    }

    public static void printHelp(Map<String, String> flags, List<String> params) {
        MainUtils.printHelpOut(System.out, "", flags, params);
    }

    public static void printHelpNoFlags(String ... arguments) {
        MainUtils.printHelpOut(System.out, "", new HashMap<String, String>(), Arrays.asList(arguments));
    }

    public static void printHelpCmd(String command, Map<String, String> flags, List<String> params) {
        MainUtils.printHelpOut(System.out, command, flags, params);
    }

    public static void printHelpOut(PrintStream out, String command, Map<String, String> flags, List<String> params) {
        out.print(MainUtils.bold("Syntax: " + command));
        StringBuilder sample = new StringBuilder();
        StringBuilder detail = new StringBuilder();
        for (Map.Entry<String, String> entry : flags.entrySet()) {
            sample.append(" [" + MainUtils.bold(MainUtils.color("--" + entry.getKey() + "=<value>", ANSIColor.MAGENTA)) + "]");
            detail.append("\t" + MainUtils.bold(MainUtils.color("--" + entry.getKey(), ANSIColor.MAGENTA)) + "\t\t" + entry.getValue() + "\n");
        }
        for (String param : params) {
            if (param.charAt(0) != '?') {
                sample.append(MainUtils.bold(" <" + param + ">"));
                continue;
            }
            sample.append(MainUtils.bold(" [" + param.substring(1) + "]"));
        }
        out.println(sample);
        out.println(MainUtils.bold("Where:"));
        out.println(detail);
    }

    public static String bold(String str) {
        return isColorSupported ? "\u001b[1m" + str + "\u001b[0m" : str;
    }

    public static String colorString(String str, String placeholder) {
        return isColorSupported ? "\u001b[" + placeholder + "m" + str + "\u001b[0m" : str;
    }

    public static String color(String str, ANSIColor fg) {
        return isColorSupported ? "\u001b[" + (30 + (fg.ordinal() & 7)) + "m" + str + "\u001b[0m" : str;
    }

    public static String colorBright(String str, ANSIColor fg, boolean bright) {
        return isColorSupported ? "\u001b[" + (30 + (fg.ordinal() & 7)) + ";" + (bright ? 1 : 2) + "m" + str + "\u001b[0m" : str;
    }

    public static String color3(String str, ANSIColor fg, ANSIColor bg) {
        return isColorSupported ? "\u001b[" + (30 + (fg.ordinal() & 7)) + ";" + (40 + (bg.ordinal() & 7)) + ";1m" + str + "\u001b[0m" : str;
    }

    public static String color4(String str, ANSIColor fg, ANSIColor bg, boolean bright) {
        return isColorSupported ? "\u001b[" + (30 + (fg.ordinal() & 7)) + ";" + (40 + (bg.ordinal() & 7)) + ";" + (bright ? 1 : 2) + "m" + str + "\u001b[0m" : str;
    }

    public static File tildeExpand(String path) {
        if (path.startsWith("~")) {
            path = path.replaceFirst("~", System.getProperty("user.home"));
        }
        return new File(path);
    }

    public static enum ANSIColor {
        BLACK,
        RED,
        GREEN,
        BROWN,
        BLUE,
        MAGENTA,
        CYAN,
        GREY;

    }

    public static class Cmd {
        public Map<String, String> flags;
        public String[] args;
        private Map<String, String>[] argFlags;

        public Cmd(Map<String, String> flags, String[] args, Map<String, String>[] argFlags) {
            this.flags = flags;
            this.args = args;
            this.argFlags = argFlags;
        }

        private Long getLongFlagInternal(Map<String, String> flags, String flagName, Long defaultValue) {
            return flags.containsKey(flagName) ? new Long(flags.get(flagName)) : defaultValue;
        }

        private Integer getIntegerFlagInternal(Map<String, String> flags, String flagName, Integer defaultValue) {
            return flags.containsKey(flagName) ? new Integer(flags.get(flagName)) : defaultValue;
        }

        private Boolean getBooleanFlagInternal(Map<String, String> flags, String flagName, Boolean defaultValue) {
            return flags.containsKey(flagName) ? !"false".equalsIgnoreCase(flags.get(flagName)) : defaultValue;
        }

        private Double getDoubleFlagInternal(Map<String, String> flags, String flagName, Double defaultValue) {
            return flags.containsKey(flagName) ? new Double(flags.get(flagName)) : defaultValue;
        }

        private String getStringFlagInternal(Map<String, String> flags, String flagName, String defaultValue) {
            return flags.containsKey(flagName) ? flags.get(flagName) : defaultValue;
        }

        private int[] getMultiIntegerFlagInternal(Map<String, String> flags, String flagName, int[] defaultValue) {
            if (!flags.containsKey(flagName)) {
                return defaultValue;
            }
            String[] split = StringUtils.splitS(flags.get(flagName), ",");
            int[] result = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                result[i] = Integer.parseInt(split[i]);
            }
            return result;
        }

        private <T extends Enum<T>> T getEnumFlagInternal(Map<String, String> flags, String flagName, T defaultValue, Class<T> class1) {
            if (!flags.containsKey(flagName)) {
                return defaultValue;
            }
            String strVal = flags.get(flagName).toLowerCase();
            EnumSet<Enum> allOf = EnumSet.allOf(class1);
            for (Enum val : allOf) {
                if (!val.name().toLowerCase().equals(strVal)) continue;
                return (T)val;
            }
            return null;
        }

        public Long getLongFlagD(String flagName, Long defaultValue) {
            return this.getLongFlagInternal(this.flags, flagName, defaultValue);
        }

        public Long getLongFlag(String flagName) {
            return this.getLongFlagInternal(this.flags, flagName, null);
        }

        public Long getLongFlagID(int arg, String flagName, Long defaultValue) {
            return this.getLongFlagInternal(this.argFlags[arg], flagName, defaultValue);
        }

        public Long getLongFlagI(int arg, String flagName) {
            return this.getLongFlagInternal(this.argFlags[arg], flagName, null);
        }

        public Integer getIntegerFlagD(String flagName, Integer defaultValue) {
            return this.getIntegerFlagInternal(this.flags, flagName, defaultValue);
        }

        public Integer getIntegerFlag(String flagName) {
            return this.getIntegerFlagInternal(this.flags, flagName, null);
        }

        public Integer getIntegerFlagID(int arg, String flagName, Integer defaultValue) {
            return this.getIntegerFlagInternal(this.argFlags[arg], flagName, defaultValue);
        }

        public Integer getIntegerFlagI(int arg, String flagName) {
            return this.getIntegerFlagInternal(this.argFlags[arg], flagName, null);
        }

        public Boolean getBooleanFlagD(String flagName, Boolean defaultValue) {
            return this.getBooleanFlagInternal(this.flags, flagName, defaultValue);
        }

        public Boolean getBooleanFlag(String flagName) {
            return this.getBooleanFlagInternal(this.flags, flagName, false);
        }

        public Boolean getBooleanFlagID(int arg, String flagName, Boolean defaultValue) {
            return this.getBooleanFlagInternal(this.argFlags[arg], flagName, defaultValue);
        }

        public Boolean getBooleanFlagI(int arg, String flagName) {
            return this.getBooleanFlagInternal(this.argFlags[arg], flagName, null);
        }

        public Double getDoubleFlagD(String flagName, Double defaultValue) {
            return this.getDoubleFlagInternal(this.flags, flagName, defaultValue);
        }

        public Double getDoubleFlag(String flagName) {
            return this.getDoubleFlagInternal(this.flags, flagName, null);
        }

        public Double getDoubleFlagID(int arg, String flagName, Double defaultValue) {
            return this.getDoubleFlagInternal(this.argFlags[arg], flagName, defaultValue);
        }

        public Double getDoubleFlagI(int arg, String flagName) {
            return this.getDoubleFlagInternal(this.argFlags[arg], flagName, null);
        }

        public String getStringFlagD(String flagName, String defaultValue) {
            return this.getStringFlagInternal(this.flags, flagName, defaultValue);
        }

        public String getStringFlag(String flagName) {
            return this.getStringFlagInternal(this.flags, flagName, null);
        }

        public String getStringFlagID(int arg, String flagName, String defaultValue) {
            return this.getStringFlagInternal(this.argFlags[arg], flagName, defaultValue);
        }

        public String getStringFlagI(int arg, String flagName) {
            return this.getStringFlagInternal(this.argFlags[arg], flagName, null);
        }

        public int[] getMultiIntegerFlagD(String flagName, int[] defaultValue) {
            return this.getMultiIntegerFlagInternal(this.flags, flagName, defaultValue);
        }

        public int[] getMultiIntegerFlag(String flagName) {
            return this.getMultiIntegerFlagInternal(this.flags, flagName, new int[0]);
        }

        public int[] getMultiIntegerFlagID(int arg, String flagName, int[] defaultValue) {
            return this.getMultiIntegerFlagInternal(this.argFlags[arg], flagName, defaultValue);
        }

        public int[] getMultiIntegerFlagI(int arg, String flagName) {
            return this.getMultiIntegerFlagInternal(this.argFlags[arg], flagName, new int[0]);
        }

        public <T extends Enum<T>> T getEnumFlagD(String flagName, T defaultValue, Class<T> class1) {
            return this.getEnumFlagInternal(this.flags, flagName, defaultValue, class1);
        }

        public <T extends Enum<T>> T getEnumFlag(String flagName, Class<T> class1) {
            return this.getEnumFlagInternal(this.flags, flagName, null, class1);
        }

        public <T extends Enum<T>> T getEnumFlagID(int arg, String flagName, T defaultValue, Class<T> class1) {
            return this.getEnumFlagInternal(this.argFlags[arg], flagName, defaultValue, class1);
        }

        public <T extends Enum<T>> T getEnumFlagI(int arg, String flagName, Class<T> class1) {
            return this.getEnumFlagInternal(this.argFlags[arg], flagName, null, class1);
        }

        public String getArg(int i) {
            return i < this.args.length ? this.args[i] : null;
        }

        public int argsLength() {
            return this.args.length;
        }

        public void popArg() {
            this.args = Platform.copyOfRangeO(this.args, 1, this.args.length);
        }
    }

    public static class Flag {
        private String longName;
        private String shortName;

        public Flag(String longName) {
            this(longName, null);
        }

        public Flag(String longName, String shortName) {
            this.longName = longName;
            this.shortName = shortName;
        }
    }
}

