/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.jcodec.common.Assert;
import org.jcodec.containers.mkv.CuesFactory;
import org.jcodec.containers.mkv.MKVType;
import org.jcodec.containers.mkv.SeekHeadFactory;
import org.jcodec.containers.mkv.boxes.EbmlBase;
import org.jcodec.containers.mkv.boxes.EbmlMaster;
import org.jcodec.containers.mkv.boxes.MkvBlock;
import org.jcodec.containers.mkv.boxes.MkvSegment;
import org.jcodec.containers.mkv.muxer.MKVMuxer;
import org.jcodec.movtool.streaming.AudioCodecMeta;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.MovieSegment;
import org.jcodec.movtool.streaming.VideoCodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;

public class MKVStreamingMuxer {
    private static final int DEFAULT_TIMESCALE = 1000000000;
    private static final int TIMESCALE = 1000000;
    private static final int MULTIPLIER = 1000;
    private static final String VP80_FOURCC = "avc1";
    private EbmlMaster mkvInfo;
    private EbmlMaster mkvTracks;
    private EbmlMaster mkvCues;
    private EbmlMaster mkvSeekHead;
    private EbmlMaster segmentElem;
    public MovieSegment headerChunk;
    private LinkedList<WebmCluster> webmClusters;

    public MovieSegment preparePacket(VirtualTrack track, VirtualPacket pkt, int chunkNo, int trackNo, long previousClustersSize) {
        WebmCluster wmc = new WebmCluster(this, track, pkt, chunkNo, trackNo, previousClustersSize);
        if (this.webmClusters == null) {
            this.webmClusters = new LinkedList();
        }
        this.webmClusters.add(wmc);
        return wmc;
    }

    public MovieSegment prepareHeader(List<MovieSegment> chunks, VirtualTrack[] tracks) throws IOException {
        EbmlMaster ebmlHeader = this.muxEbmlHeader();
        this.segmentElem = (EbmlMaster)MKVType.createByType(MKVType.Segment);
        this.mkvInfo = this.muxInfo(tracks);
        this.mkvTracks = this.muxTracks(tracks);
        this.mkvCues = (EbmlMaster)MKVType.createByType(MKVType.Cues);
        this.mkvSeekHead = this.muxSeekHead();
        this.muxCues(tracks);
        this.segmentElem.add(this.mkvSeekHead);
        this.segmentElem.add(this.mkvInfo);
        this.segmentElem.add(this.mkvTracks);
        this.segmentElem.add(this.mkvCues);
        for (WebmCluster wc : this.webmClusters) {
            this.segmentElem.add(wc.c);
        }
        ArrayList<EbmlMaster> header = new ArrayList<EbmlMaster>();
        header.add(ebmlHeader);
        header.add(this.segmentElem);
        this.headerChunk = new HeaderSegment(header);
        return this.headerChunk;
    }

    private EbmlMaster muxEbmlHeader() {
        EbmlMaster master = (EbmlMaster)MKVType.createByType(MKVType.EBML);
        MKVMuxer.createLong(master, MKVType.EBMLVersion, 1L);
        MKVMuxer.createLong(master, MKVType.EBMLReadVersion, 1L);
        MKVMuxer.createLong(master, MKVType.EBMLMaxIDLength, 4L);
        MKVMuxer.createLong(master, MKVType.EBMLMaxSizeLength, 8L);
        MKVMuxer.createString(master, MKVType.DocType, "webm");
        MKVMuxer.createLong(master, MKVType.DocTypeVersion, 2L);
        MKVMuxer.createLong(master, MKVType.DocTypeReadVersion, 2L);
        return master;
    }

    private EbmlMaster muxInfo(VirtualTrack[] tracks) {
        EbmlMaster master = (EbmlMaster)MKVType.createByType(MKVType.Info);
        MKVMuxer.createLong(master, MKVType.TimecodeScale, 1000000L);
        MKVMuxer.createString(master, MKVType.WritingApp, "JCodec v0.1.7");
        MKVMuxer.createString(master, MKVType.MuxingApp, "JCodec MKVStreamingMuxer v0.1.7");
        WebmCluster lastCluster = this.webmClusters.get(this.webmClusters.size() - 1);
        MKVMuxer.createDouble(master, MKVType.Duration, (lastCluster.pkt.getPts() + lastCluster.pkt.getDuration()) * 1000.0);
        MKVMuxer.createDate(master, MKVType.DateUTC, new Date());
        return master;
    }

    private EbmlMaster muxTracks(VirtualTrack[] tracks) {
        EbmlMaster master = (EbmlMaster)MKVType.createByType(MKVType.Tracks);
        for (int i = 0; i < tracks.length; ++i) {
            VirtualTrack track = tracks[i];
            EbmlMaster trackEntryElem = (EbmlMaster)MKVType.createByType(MKVType.TrackEntry);
            MKVMuxer.createLong(trackEntryElem, MKVType.TrackNumber, i + 1);
            MKVMuxer.createLong(trackEntryElem, MKVType.TrackUID, i + 1);
            CodecMeta codecMeta = track.getCodecMeta();
            if (VP80_FOURCC.equalsIgnoreCase(track.getCodecMeta().getFourcc())) {
                MKVMuxer.createLong(trackEntryElem, MKVType.TrackType, 1L);
                MKVMuxer.createString(trackEntryElem, MKVType.Name, "Track " + (i + 1) + " Video");
                MKVMuxer.createString(trackEntryElem, MKVType.CodecID, "V_VP8");
                MKVMuxer.createBuffer(trackEntryElem, MKVType.CodecPrivate, codecMeta.getCodecPrivate());
                if (codecMeta instanceof VideoCodecMeta) {
                    VideoCodecMeta vcm = (VideoCodecMeta)codecMeta;
                    EbmlMaster trackVideoElem = (EbmlMaster)MKVType.createByType(MKVType.Video);
                    MKVMuxer.createLong(trackVideoElem, MKVType.PixelWidth, vcm.getSize().getWidth());
                    MKVMuxer.createLong(trackVideoElem, MKVType.PixelHeight, vcm.getSize().getHeight());
                    trackEntryElem.add(trackVideoElem);
                }
            } else if ("vrbs".equalsIgnoreCase(track.getCodecMeta().getFourcc())) {
                MKVMuxer.createLong(trackEntryElem, MKVType.TrackType, 2L);
                MKVMuxer.createString(trackEntryElem, MKVType.Name, "Track " + (i + 1) + " Audio");
                MKVMuxer.createString(trackEntryElem, MKVType.CodecID, "A_VORBIS");
                MKVMuxer.createBuffer(trackEntryElem, MKVType.CodecPrivate, codecMeta.getCodecPrivate());
                if (codecMeta instanceof AudioCodecMeta) {
                    AudioCodecMeta acm = (AudioCodecMeta)codecMeta;
                    EbmlMaster trackAudioElem = (EbmlMaster)MKVType.createByType(MKVType.Audio);
                    MKVMuxer.createLong(trackAudioElem, MKVType.Channels, acm.getChannelCount());
                    MKVMuxer.createLong(trackAudioElem, MKVType.BitDepth, acm.getSampleSize());
                    MKVMuxer.createLong(trackAudioElem, MKVType.SamplingFrequency, acm.getSampleRate());
                    trackEntryElem.add(trackAudioElem);
                }
            }
            master.add(trackEntryElem);
        }
        return master;
    }

    private EbmlMaster muxSeekHead() {
        SeekHeadFactory shi = new SeekHeadFactory();
        shi.add(this.mkvInfo);
        shi.add(this.mkvTracks);
        shi.add(this.mkvCues);
        return shi.indexSeekHead();
    }

    private void muxCues(VirtualTrack[] tracks) {
        int trackIndex = MKVStreamingMuxer.findFirstVP8TrackIndex(tracks);
        CuesFactory ci = new CuesFactory(this.mkvSeekHead.size() + this.mkvInfo.size() + this.mkvTracks.size(), ++trackIndex);
        for (WebmCluster aCluster : this.webmClusters) {
            ci.add(CuesFactory.CuePointMock.make(aCluster.c));
        }
        EbmlMaster indexedCues = ci.createCues();
        for (EbmlBase aCuePoint : indexedCues.children) {
            this.mkvCues.add(aCuePoint);
        }
    }

    private static int findFirstVP8TrackIndex(VirtualTrack[] tracks) {
        for (int i = 0; i < tracks.length; ++i) {
            if (!VP80_FOURCC.equalsIgnoreCase(tracks[i].getCodecMeta().getFourcc())) continue;
            return i;
        }
        return -1;
    }

    public static class HeaderSegment
    implements MovieSegment {
        private List<EbmlMaster> header;

        public HeaderSegment(List<EbmlMaster> header) {
            this.header = header;
        }

        @Override
        public long getPos() {
            return 0L;
        }

        @Override
        public int getNo() {
            return 0;
        }

        @Override
        public int getDataLen() throws IOException {
            int size = 0;
            for (EbmlMaster m : this.header) {
                if (MKVType.Segment.equals(m.type)) {
                    size = (int)((long)size + ((MkvSegment)m).getHeaderSize());
                    continue;
                }
                size = (int)((long)size + m.size());
            }
            return size;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            ByteBuffer data = ByteBuffer.allocate(this.getDataLen());
            for (EbmlMaster m : this.header) {
                if (MKVType.Segment.equals(m.type)) {
                    data.put(((MkvSegment)m).getHeader());
                    continue;
                }
                data.put(m.getData());
            }
            data.flip();
            return data;
        }
    }

    public static class WebmCluster
    implements MovieSegment {
        MkvBlock be = (MkvBlock)MKVType.createByType(MKVType.SimpleBlock);
        EbmlMaster c = (EbmlMaster)MKVType.createByType(MKVType.Cluster);
        public VirtualPacket pkt;
        private int chunkNo;
        private int trackNo;
        private long previousClustersSize;
        private MKVStreamingMuxer muxer;

        public WebmCluster(MKVStreamingMuxer muxer, VirtualTrack track, VirtualPacket pkt, int chunkNo, int trackNo, long previousClustersSize) {
            this.muxer = muxer;
            this.pkt = pkt;
            this.chunkNo = chunkNo;
            this.trackNo = trackNo + 1;
            this.previousClustersSize = previousClustersSize;
            long timecode = (long)(pkt.getPts() * 1000.0);
            MKVMuxer.createLong(this.c, MKVType.Timecode, timecode);
            try {
                this.be.frameSizes = new int[]{this.pkt.getDataLen()};
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to read size of the frame", ioe);
            }
            this.be.timecode = 0;
            this.be.trackNumber = this.trackNo;
            this.be.discardable = false;
            this.be.lacingPresent = false;
            this.be.dataLen = this.be.getDataSize();
            this.c.add(this.be);
        }

        @Override
        public ByteBuffer getData() throws IOException {
            this.be.frames = new ByteBuffer[1];
            this.be.frames[0] = this.pkt.getData().duplicate();
            ByteBuffer data = this.c.getData();
            Assert.assertEquals("computed and actuall cluster sizes MUST match", (int)this.c.size(), data.remaining());
            return data;
        }

        @Override
        public int getNo() {
            return this.chunkNo;
        }

        @Override
        public long getPos() {
            try {
                return this.previousClustersSize + (long)this.muxer.headerChunk.getDataLen();
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't compute header length", e);
            }
        }

        @Override
        public int getDataLen() throws IOException {
            return (int)this.c.size();
        }
    }
}

