/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.common.Assert;
import org.jcodec.common.StringUtils;
import org.jcodec.common.UsedViaReflection;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.tools.ToJSON;
import org.jcodec.containers.mp4.IBoxFactory;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.platform.Platform;

public abstract class Box {
    private static final String GET_MODEL_FIELDS = "getModelFields";
    public Header header;
    public static final int MAX_BOX_SIZE = 0x8000000;

    @UsedViaReflection
    public Box(Header header) {
        this.header = header;
    }

    public Header getHeader() {
        return this.header;
    }

    public abstract void parse(ByteBuffer var1);

    public void write(ByteBuffer buf) {
        ByteBuffer dup = buf.duplicate();
        NIOUtils.skip(buf, 8);
        this.doWrite(buf);
        this.header.setBodySize(buf.position() - dup.position() - 8);
        Assert.assertEquals(this.header.headerSize(), 8L);
        this.header.write(dup);
    }

    protected abstract void doWrite(ByteBuffer var1);

    public String getFourcc() {
        return this.header.getFourcc();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dump(sb);
        return sb.toString();
    }

    protected void dump(StringBuilder sb) {
        sb.append("{\"tag\":\"" + this.header.getFourcc() + "\",");
        ArrayList<String> fields = new ArrayList<String>(0);
        this.collectModel(this.getClass(), fields);
        ToJSON.fieldsToJSON(this, sb, fields.toArray(new String[0]));
        sb.append("}");
    }

    protected void collectModel(Class claz, List<String> model) {
        if (Box.class == claz || !Box.class.isAssignableFrom(claz)) {
            return;
        }
        this.collectModel(claz.getSuperclass(), model);
        try {
            Platform.invokeMethod(this, GET_MODEL_FIELDS, new Object[]{model});
        }
        catch (Exception e) {
            this.checkWrongSignature(claz);
            model.addAll(ToJSON.allFields(claz));
        }
    }

    private void checkWrongSignature(Class claz) {
        Method[] declaredMethods = Platform.getDeclaredMethods(claz);
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method method = declaredMethods[i];
            if (!method.getName().equals(GET_MODEL_FIELDS)) continue;
            Logger.warn("Class " + claz.getCanonicalName() + " contains 'getModelFields' of wrong signature.\nDid you mean to define 'protected void " + GET_MODEL_FIELDS + "(List<String> model) ?");
            break;
        }
    }

    public static String[] path(String path) {
        return StringUtils.splitC(path, '.');
    }

    public static LeafBox createLeafBox(Header atom, ByteBuffer data) {
        LeafBox leaf = new LeafBox(atom);
        leaf.data = data;
        return leaf;
    }

    public static Box parseBox(ByteBuffer input, Header childAtom, IBoxFactory factory) {
        Box box = factory.newBox(childAtom);
        if (childAtom.getBodySize() < 0x8000000L) {
            box.parse(input);
            return box;
        }
        return new LeafBox(Header.createHeader("free", 8L));
    }

    public static <T extends Box> T asBox(Class<T> class1, Box box) {
        try {
            Box res = (Box)Platform.newInstance(class1, new Object[]{box.getHeader()});
            ByteBuffer buffer = ByteBuffer.allocate((int)box.getHeader().getBodySize());
            box.doWrite(buffer);
            buffer.flip();
            res.parse(buffer);
            return (T)res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class LeafBox
    extends Box {
        ByteBuffer data;

        public LeafBox(Header atom) {
            super(atom);
        }

        @Override
        public void parse(ByteBuffer input) {
            this.data = NIOUtils.read(input, (int)this.header.getBodySize());
        }

        public ByteBuffer getData() {
            return this.data.duplicate();
        }

        @Override
        protected void doWrite(ByteBuffer out) {
            NIOUtils.write(out, this.data);
        }
    }
}

