/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.containers.mp4.boxes.Edit;
import org.jcodec.containers.mp4.boxes.FullBox;
import org.jcodec.containers.mp4.boxes.Header;

public class EditListBox
extends FullBox {
    private List<Edit> edits;

    public static String fourcc() {
        return "elst";
    }

    public static EditListBox createEditListBox(List<Edit> edits) {
        EditListBox elst = new EditListBox(new Header(EditListBox.fourcc()));
        elst.edits = edits;
        return elst;
    }

    public EditListBox(Header atom) {
        super(atom);
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        this.edits = new ArrayList<Edit>();
        long num = input.getInt();
        int i = 0;
        while ((long)i < num) {
            int duration = input.getInt();
            int mediaTime = input.getInt();
            float rate = (float)input.getInt() / 65536.0f;
            this.edits.add(new Edit(duration, mediaTime, rate));
            ++i;
        }
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(this.edits.size());
        for (Edit edit : this.edits) {
            out.putInt((int)edit.getDuration());
            out.putInt((int)edit.getMediaTime());
            out.putInt((int)(edit.getRate() * 65536.0f));
        }
    }

    public List<Edit> getEdits() {
        return this.edits;
    }
}

