/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import org.jcodec.common.JCodecUtil2;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.containers.mp4.boxes.FullBox;
import org.jcodec.containers.mp4.boxes.Header;

public class HandlerBox
extends FullBox {
    private String componentType;
    private String componentSubType;
    private String componentManufacturer;
    private int componentFlags;
    private int componentFlagsMask;
    private String componentName;

    public HandlerBox(Header atom) {
        super(atom);
    }

    public static String fourcc() {
        return "hdlr";
    }

    public static HandlerBox createHandlerBox(String componentType, String componentSubType, String componentManufacturer, int componentFlags, int componentFlagsMask) {
        HandlerBox hdlr = new HandlerBox(new Header(HandlerBox.fourcc()));
        hdlr.componentType = componentType;
        hdlr.componentSubType = componentSubType;
        hdlr.componentManufacturer = componentManufacturer;
        hdlr.componentFlags = componentFlags;
        hdlr.componentFlagsMask = componentFlagsMask;
        hdlr.componentName = "";
        return hdlr;
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        this.componentType = NIOUtils.readString(input, 4);
        this.componentSubType = NIOUtils.readString(input, 4);
        this.componentManufacturer = NIOUtils.readString(input, 4);
        this.componentFlags = input.getInt();
        this.componentFlagsMask = input.getInt();
        this.componentName = NIOUtils.readString(input, input.remaining());
    }

    @Override
    public void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.put(JCodecUtil2.asciiString(this.componentType));
        out.put(JCodecUtil2.asciiString(this.componentSubType));
        out.put(JCodecUtil2.asciiString(this.componentManufacturer));
        out.putInt(this.componentFlags);
        out.putInt(this.componentFlagsMask);
        if (this.componentName != null) {
            out.put(JCodecUtil2.asciiString(this.componentName));
        }
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getComponentSubType() {
        return this.componentSubType;
    }

    public String getComponentManufacturer() {
        return this.componentManufacturer;
    }

    public int getComponentFlags() {
        return this.componentFlags;
    }

    public int getComponentFlagsMask() {
        return this.componentFlagsMask;
    }
}

