/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import org.jcodec.common.JCodecUtil2;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.Header;

public class SegmentTypeBox
extends Box {
    private String majorBrand;
    private int minorVersion;
    private Collection<String> compBrands = new LinkedList<String>();

    public SegmentTypeBox(Header header) {
        super(header);
    }

    public static String fourcc() {
        return "styp";
    }

    @Override
    public void parse(ByteBuffer input) {
        String brand;
        this.majorBrand = NIOUtils.readString(input, 4);
        this.minorVersion = input.getInt();
        while (input.hasRemaining() && (brand = NIOUtils.readString(input, 4)) != null) {
            this.compBrands.add(brand);
        }
    }

    public String getMajorBrand() {
        return this.majorBrand;
    }

    public Collection<String> getCompBrands() {
        return this.compBrands;
    }

    @Override
    public void doWrite(ByteBuffer out) {
        out.put(JCodecUtil2.asciiString(this.majorBrand));
        out.putInt(this.minorVersion);
        for (String string : this.compBrands) {
            out.put(JCodecUtil2.asciiString(string));
        }
    }
}

