/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.demuxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.codecs.aac.AACUtils;
import org.jcodec.codecs.aac.ADTSParser;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.mp4.AvcCBox;
import org.jcodec.common.AudioCodecMeta;
import org.jcodec.common.Codec;
import org.jcodec.common.DemuxerTrackMeta;
import org.jcodec.common.TrackType;
import org.jcodec.common.VideoCodecMeta;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Packet;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.containers.mp4.MP4TrackType;
import org.jcodec.containers.mp4.QTTimeUtil;
import org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.CompositionOffsetsBox;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.PixelAspectExt;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.SyncSamplesBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;
import org.jcodec.platform.Platform;

public class FramesMP4DemuxerTrack
extends AbstractMP4DemuxerTrack {
    private int[] sizes;
    private long offInChunk;
    private int noInChunk;
    private int[] syncSamples;
    private int[] partialSync;
    private int ssOff;
    private int psOff;
    private CompositionOffsetsBox.Entry[] compOffsets;
    private int cttsInd;
    private int cttsSubInd;
    private SeekableByteChannel input;
    private MovieBox movie;
    private ByteBuffer codecPrivate;
    private AvcCBox avcC;

    public FramesMP4DemuxerTrack(MovieBox mov, TrakBox trak, SeekableByteChannel input) {
        super(trak);
        this.input = input;
        this.movie = mov;
        SampleSizesBox stsz = NodeBox.findFirstPath(trak, SampleSizesBox.class, Box.path("mdia.minf.stbl.stsz"));
        SyncSamplesBox stss = NodeBox.findFirstPath(trak, SyncSamplesBox.class, Box.path("mdia.minf.stbl.stss"));
        SyncSamplesBox stps = NodeBox.findFirstPath(trak, SyncSamplesBox.class, Box.path("mdia.minf.stbl.stps"));
        CompositionOffsetsBox ctts = NodeBox.findFirstPath(trak, CompositionOffsetsBox.class, Box.path("mdia.minf.stbl.ctts"));
        CompositionOffsetsBox.Entry[] entryArray = this.compOffsets = ctts == null ? null : ctts.getEntries();
        if (stss != null) {
            this.syncSamples = stss.getSyncSamples();
        }
        if (stps != null) {
            this.partialSync = stps.getSyncSamples();
        }
        this.sizes = stsz.getSizes();
        if (this.getCodec() == Codec.H264) {
            this.avcC = H264Utils.parseAVCC((VideoSampleEntry)this.getSampleEntries()[0]);
        }
        this.codecPrivate = this.getCodecPrivate();
    }

    @Override
    public synchronized MP4Packet nextFrame() throws IOException {
        if (this.curFrame >= (long)this.sizes.length) {
            return null;
        }
        int size = this.sizes[(int)this.curFrame];
        return this.getNextFrame(ByteBuffer.allocate(size));
    }

    @Override
    public synchronized MP4Packet getNextFrame(ByteBuffer storage) throws IOException {
        boolean sync;
        if (this.curFrame >= (long)this.sizes.length) {
            return null;
        }
        int size = this.sizes[(int)this.curFrame];
        if (storage != null && storage.remaining() < size) {
            throw new IllegalArgumentException("Buffer size is not enough to fit a packet");
        }
        long pktPos = this.chunkOffsets[Math.min(this.chunkOffsets.length - 1, this.stcoInd)] + this.offInChunk;
        ByteBuffer result = this.readPacketData(this.input, storage, pktPos, size);
        if (result != null && result.remaining() < size) {
            return null;
        }
        int duration = this.timeToSamples[this.sttsInd].getSampleDuration();
        boolean bl = sync = this.syncSamples == null;
        if (this.syncSamples != null && this.ssOff < this.syncSamples.length && this.curFrame + 1L == (long)this.syncSamples[this.ssOff]) {
            sync = true;
            ++this.ssOff;
        }
        boolean psync = false;
        if (this.partialSync != null && this.psOff < this.partialSync.length && this.curFrame + 1L == (long)this.partialSync[this.psOff]) {
            psync = true;
            ++this.psOff;
        }
        long realPts = this.pts;
        if (this.compOffsets != null) {
            realPts = this.pts + (long)this.compOffsets[this.cttsInd].getOffset();
            ++this.cttsSubInd;
            if (this.cttsInd < this.compOffsets.length - 1 && this.cttsSubInd == this.compOffsets[this.cttsInd].getCount()) {
                ++this.cttsInd;
                this.cttsSubInd = 0;
            }
        }
        MP4Packet pkt = new MP4Packet(result == null ? null : this.convertPacket(result), QTTimeUtil.mediaToEdited(this.box, realPts, this.movie.getTimescale()), this.timescale, duration, this.curFrame, sync ? Packet.FrameType.KEY : Packet.FrameType.INTER, null, 0, realPts, this.sampleToChunks[this.stscInd].getEntry() - 1, pktPos, size, psync);
        this.offInChunk += (long)size;
        ++this.curFrame;
        ++this.noInChunk;
        if (this.noInChunk >= this.sampleToChunks[this.stscInd].getCount()) {
            this.noInChunk = 0;
            this.offInChunk = 0L;
            this.nextChunk();
        }
        this.shiftPts(1L);
        return pkt;
    }

    @Override
    public ByteBuffer convertPacket(ByteBuffer result) {
        if (this.codecPrivate != null) {
            if (this.getCodec() == Codec.H264) {
                ByteBuffer annexbCoded = H264Utils.decodeMOVPacket(result, this.avcC);
                if (H264Utils.isByteBufferIDRSlice(annexbCoded)) {
                    return NIOUtils.combine(this.codecPrivate, annexbCoded);
                }
                return annexbCoded;
            }
            if (this.getCodec() == Codec.AAC) {
                ADTSParser.Header adts = AACUtils.streamInfoToADTS(this.codecPrivate, true, 1, result.remaining());
                ByteBuffer adtsRaw = ByteBuffer.allocate(7);
                ADTSParser.write(adts, adtsRaw);
                return NIOUtils.combine(adtsRaw, result);
            }
        }
        return result;
    }

    @Override
    public boolean gotoSyncFrame(long frameNo) {
        if (this.syncSamples == null) {
            return this.gotoFrame(frameNo);
        }
        if (frameNo < 0L) {
            throw new IllegalArgumentException("negative frame number");
        }
        if (frameNo >= this.getFrameCount()) {
            return false;
        }
        if (frameNo == this.curFrame) {
            return true;
        }
        for (int i = 0; i < this.syncSamples.length; ++i) {
            if ((long)(this.syncSamples[i] - 1) <= frameNo) continue;
            return this.gotoFrame(this.syncSamples[i - 1] - 1);
        }
        return this.gotoFrame(this.syncSamples[this.syncSamples.length - 1] - 1);
    }

    @Override
    protected void seekPointer(long frameNo) {
        if (this.compOffsets != null) {
            this.cttsSubInd = (int)frameNo;
            this.cttsInd = 0;
            while (this.cttsSubInd >= this.compOffsets[this.cttsInd].getCount()) {
                this.cttsSubInd -= this.compOffsets[this.cttsInd].getCount();
                ++this.cttsInd;
            }
        }
        this.curFrame = (int)frameNo;
        this.stcoInd = 0;
        this.stscInd = 0;
        this.noInChunk = (int)frameNo;
        this.offInChunk = 0L;
        while (this.noInChunk >= this.sampleToChunks[this.stscInd].getCount()) {
            this.noInChunk -= this.sampleToChunks[this.stscInd].getCount();
            this.nextChunk();
        }
        for (int i = 0; i < this.noInChunk; ++i) {
            this.offInChunk += (long)this.sizes[(int)frameNo - this.noInChunk + i];
        }
        if (this.syncSamples != null) {
            this.ssOff = 0;
            while (this.ssOff < this.syncSamples.length && (long)this.syncSamples[this.ssOff] < this.curFrame + 1L) {
                ++this.ssOff;
            }
        }
        if (this.partialSync != null) {
            this.psOff = 0;
            while (this.psOff < this.partialSync.length && (long)this.partialSync[this.psOff] < this.curFrame + 1L) {
                ++this.psOff;
            }
        }
    }

    @Override
    public long getFrameCount() {
        return this.sizes.length;
    }

    public ByteBuffer getCodecPrivate() {
        Codec codec = this.getCodec();
        if (codec == Codec.H264) {
            AvcCBox avcC = H264Utils.parseAVCC((VideoSampleEntry)this.getSampleEntries()[0]);
            return H264Utils.avcCToAnnexB(avcC);
        }
        if (codec == Codec.AAC) {
            return AACUtils.getCodecPrivate(this.getSampleEntries()[0]);
        }
        return null;
    }

    @Override
    public DemuxerTrackMeta getMeta() {
        MP4TrackType type;
        int i;
        int[] seekFrames;
        if (this.syncSamples == null) {
            seekFrames = new int[(int)this.getFrameCount()];
            for (i = 0; i < seekFrames.length; ++i) {
                seekFrames[i] = i;
            }
        } else {
            seekFrames = Platform.copyOfInt(this.syncSamples, this.syncSamples.length);
            i = 0;
            while (i < seekFrames.length) {
                int n = i++;
                seekFrames[n] = seekFrames[n] - 1;
            }
        }
        TrackType t = (type = this.getType()) == MP4TrackType.VIDEO ? TrackType.VIDEO : (type == MP4TrackType.SOUND ? TrackType.AUDIO : TrackType.OTHER);
        VideoCodecMeta videoCodecMeta = null;
        AudioCodecMeta audioCodecMeta = null;
        if (type == MP4TrackType.VIDEO) {
            videoCodecMeta = new VideoCodecMeta(this.box.getCodedSize(), ColorSpace.YUV420);
            PixelAspectExt pasp = NodeBox.findFirst(this.getSampleEntries()[0], PixelAspectExt.class, "pasp");
            if (pasp != null) {
                videoCodecMeta.setPixelAspectRatio(pasp.getRational());
            }
        } else if (type == MP4TrackType.SOUND) {
            AudioSampleEntry ase = (AudioSampleEntry)this.getSampleEntries()[0];
            audioCodecMeta = new AudioCodecMeta(ase.getFormat());
        }
        DemuxerTrackMeta meta = new DemuxerTrackMeta(t, this.getCodec(), (double)this.duration / (double)this.timescale, seekFrames, this.sizes.length, this.getCodecPrivate(), videoCodecMeta, audioCodecMeta);
        return meta;
    }
}

