/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.demuxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jcodec.common.Demuxer;
import org.jcodec.common.DemuxerTrack;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.containers.mp4.MP4TrackType;
import org.jcodec.containers.mp4.MP4Util;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.HandlerBox;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.FramesMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.PCMMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.TimecodeMP4DemuxerTrack;
import org.jcodec.platform.Platform;

public class MP4Demuxer
implements Demuxer {
    private List<AbstractMP4DemuxerTrack> tracks;
    private TimecodeMP4DemuxerTrack timecodeTrack;
    MovieBox movie;
    private SeekableByteChannel input;
    private static int ftyp = MP4Demuxer.intFourcc("ftyp");
    private static int free = MP4Demuxer.intFourcc("free");
    private static int moov = MP4Demuxer.intFourcc("moov");
    private static int mdat = MP4Demuxer.intFourcc("mdat");
    private static int wide = MP4Demuxer.intFourcc("wide");

    public AbstractMP4DemuxerTrack create(TrakBox trak) {
        SampleSizesBox stsz = NodeBox.findFirstPath(trak, SampleSizesBox.class, Box.path("mdia.minf.stbl.stsz"));
        if (stsz.getDefaultSize() == 0) {
            return new FramesMP4DemuxerTrack(this.movie, trak, this.input);
        }
        return new PCMMP4DemuxerTrack(this.movie, trak, this.input);
    }

    public MP4Demuxer(SeekableByteChannel input) throws IOException {
        this.input = input;
        this.tracks = new LinkedList<AbstractMP4DemuxerTrack>();
        this.findMovieBox(input);
    }

    private void findMovieBox(SeekableByteChannel input) throws IOException {
        this.movie = MP4Util.parseMovieChannel(input);
        if (this.movie == null) {
            throw new IOException("Could not find movie meta information box");
        }
        this.processHeader(this.movie);
    }

    private void processHeader(NodeBox moov) throws IOException {
        DemuxerTrack video;
        TrakBox tt = null;
        TrakBox[] trakBoxs = (TrakBox[])NodeBox.findAll((Box)moov, TrakBox.class, (String)"trak");
        for (int i = 0; i < trakBoxs.length; ++i) {
            TrakBox trak = trakBoxs[i];
            SampleEntry se = NodeBox.findFirstPath(trak, SampleEntry.class, new String[]{"mdia", "minf", "stbl", "stsd", null});
            if ("tmcd".equals(se.getFourcc())) {
                tt = trak;
                continue;
            }
            this.tracks.add(this.create(trak));
        }
        if (tt != null && (video = this.getVideoTrack()) != null) {
            this.timecodeTrack = new TimecodeMP4DemuxerTrack(this.movie, tt, this.input);
        }
    }

    public static MP4TrackType getTrackType(TrakBox trak) {
        HandlerBox handler = NodeBox.findFirstPath(trak, HandlerBox.class, Box.path("mdia.hdlr"));
        return MP4TrackType.fromHandler(handler.getComponentSubType());
    }

    public DemuxerTrack getVideoTrack() {
        for (AbstractMP4DemuxerTrack demuxerTrack : this.tracks) {
            if (!demuxerTrack.box.isVideo()) continue;
            return demuxerTrack;
        }
        return null;
    }

    public MovieBox getMovie() {
        return this.movie;
    }

    public AbstractMP4DemuxerTrack getTrack(int no) {
        for (AbstractMP4DemuxerTrack track : this.tracks) {
            if (track.getNo() != no) continue;
            return track;
        }
        return null;
    }

    public List<AbstractMP4DemuxerTrack> getTracks() {
        return new ArrayList<AbstractMP4DemuxerTrack>(this.tracks);
    }

    public List<DemuxerTrack> getVideoTracks() {
        ArrayList<DemuxerTrack> result = new ArrayList<DemuxerTrack>();
        for (AbstractMP4DemuxerTrack demuxerTrack : this.tracks) {
            if (!demuxerTrack.box.isVideo()) continue;
            result.add(demuxerTrack);
        }
        return result;
    }

    public List<DemuxerTrack> getAudioTracks() {
        ArrayList<DemuxerTrack> result = new ArrayList<DemuxerTrack>();
        for (AbstractMP4DemuxerTrack demuxerTrack : this.tracks) {
            if (!demuxerTrack.box.isAudio()) continue;
            result.add(demuxerTrack);
        }
        return result;
    }

    public TimecodeMP4DemuxerTrack getTimecodeTrack() {
        return this.timecodeTrack;
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    private static int intFourcc(String string) {
        byte[] b = Platform.getBytes(string);
        return MP4Demuxer.makeInt(b[0], b[1], b[2], b[3]);
    }

    public static int probe(ByteBuffer b) {
        ByteBuffer fork = b.duplicate();
        int success = 0;
        int total = 0;
        while (fork.remaining() >= 8) {
            long len = (long)fork.getInt() & 0xFFFFFFFFL;
            int fcc = fork.getInt();
            int hdrLen = 8;
            if (len == 1L) {
                len = fork.getLong();
                hdrLen = 16;
            } else if (len < 8L) break;
            if (fcc == ftyp && len < 64L || fcc == moov && len < 0x6400000L || fcc == free || fcc == mdat || fcc == wide) {
                ++success;
            }
            ++total;
            if (len >= Integer.MAX_VALUE) break;
            NIOUtils.skip(fork, (int)(len - (long)hdrLen));
        }
        return total == 0 ? 0 : success * 100 / total;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

