/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.muxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jcodec.codecs.aac.ADTSParser;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.mpeg4.mp4.EsdsBox;
import org.jcodec.common.Assert;
import org.jcodec.common.AudioFormat;
import org.jcodec.common.Codec;
import org.jcodec.common.IntArrayList;
import org.jcodec.common.LongArrayList;
import org.jcodec.common.VideoCodecMeta;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Rational;
import org.jcodec.common.model.Size;
import org.jcodec.common.model.Unit;
import org.jcodec.containers.mp4.MP4TrackType;
import org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.ChunkOffsets64Box;
import org.jcodec.containers.mp4.boxes.CompositionOffsetsBox;
import org.jcodec.containers.mp4.boxes.Edit;
import org.jcodec.containers.mp4.boxes.HandlerBox;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.MediaBox;
import org.jcodec.containers.mp4.boxes.MediaHeaderBox;
import org.jcodec.containers.mp4.boxes.MediaInfoBox;
import org.jcodec.containers.mp4.boxes.MovieHeaderBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.PixelAspectExt;
import org.jcodec.containers.mp4.boxes.SampleDescriptionBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.SampleToChunkBox;
import org.jcodec.containers.mp4.boxes.SyncSamplesBox;
import org.jcodec.containers.mp4.boxes.TimeToSampleBox;
import org.jcodec.containers.mp4.boxes.TrackHeaderBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import org.jcodec.containers.mp4.muxer.AbstractMP4MuxerTrack;
import org.jcodec.containers.mp4.muxer.MP4Muxer;
import org.jcodec.containers.mp4.muxer.TimecodeMP4MuxerTrack;

public class FramesMP4MuxerTrack
extends AbstractMP4MuxerTrack {
    private static Map<Codec, String> codec2fourcc = new HashMap<Codec, String>();
    private List<TimeToSampleBox.TimeToSampleEntry> sampleDurations;
    private long sameDurCount = 0L;
    private long curDuration = -1L;
    private LongArrayList chunkOffsets;
    private IntArrayList sampleSizes;
    private IntArrayList iframes;
    private List<CompositionOffsetsBox.Entry> compositionOffsets;
    private int lastCompositionOffset = 0;
    private int lastCompositionSamples = 0;
    private long ptsEstimate = 0L;
    private int lastEntry = -1;
    private long trackTotalDuration;
    private int curFrame;
    private boolean allIframes = true;
    private TimecodeMP4MuxerTrack timecodeTrack;
    private SeekableByteChannel out;
    private Codec codec;
    private List<ByteBuffer> spsList = new ArrayList<ByteBuffer>();
    private List<ByteBuffer> ppsList = new ArrayList<ByteBuffer>();
    private ADTSParser.Header adtsHeader;

    public FramesMP4MuxerTrack(SeekableByteChannel out, int trackId, MP4TrackType type, Codec codec) {
        super(trackId, type);
        this.sampleDurations = new ArrayList<TimeToSampleBox.TimeToSampleEntry>();
        this.chunkOffsets = LongArrayList.createLongArrayList();
        this.sampleSizes = IntArrayList.createIntArrayList();
        this.iframes = IntArrayList.createIntArrayList();
        this.compositionOffsets = new ArrayList<CompositionOffsetsBox.Entry>();
        this.out = out;
        this.codec = codec;
        this.setTgtChunkDuration(new Rational(1, 1), Unit.FRAME);
    }

    @Override
    public void addFrame(Packet pkt) throws IOException {
        if (this.codec == Codec.H264) {
            ByteBuffer result = pkt.getData();
            if (pkt.frameType == Packet.FrameType.UNKOWN) {
                pkt.setFrameType(H264Utils.isByteBufferIDRSlice(result) ? Packet.FrameType.KEY : Packet.FrameType.INTER);
            }
            H264Utils.wipePSinplace(result, this.spsList, this.ppsList);
            result = H264Utils.encodeMOVPacket(result);
            pkt = Packet.createPacketWithData(pkt, result);
        } else if (this.codec == Codec.AAC) {
            ByteBuffer result = pkt.getData();
            this.adtsHeader = ADTSParser.read(result);
            System.out.println(String.format("crc_absent: %d, num_aac_frames: %d, size: %d, remaining: %d, %d, %d, %d", this.adtsHeader.getCrcAbsent(), this.adtsHeader.getNumAACFrames(), this.adtsHeader.getSize(), result.remaining(), this.adtsHeader.getObjectType(), this.adtsHeader.getSamplingIndex(), this.adtsHeader.getChanConfig()));
            pkt = Packet.createPacketWithData(pkt, result);
        }
        this.addFrameInternal(pkt, 1);
        this.processTimecode(pkt);
    }

    public void addFrameInternal(Packet pkt, int entryNo) throws IOException {
        if (this.finished) {
            throw new IllegalStateException("The muxer track has finished muxing");
        }
        if (this._timescale == -1) {
            this._timescale = this.adtsHeader != null ? this.adtsHeader.getSampleRate() : pkt.getTimescale();
        }
        if (this._timescale != pkt.getTimescale()) {
            pkt.setPts(pkt.getPts() * (long)this._timescale / (long)pkt.getTimescale());
            pkt.setDuration(pkt.getPts() * (long)this._timescale / pkt.getDuration());
        }
        if (this.adtsHeader != null) {
            pkt.setDuration(1024L);
        }
        if (this.type == MP4TrackType.VIDEO) {
            int compositionOffset = (int)(pkt.getPts() - this.ptsEstimate);
            if (compositionOffset != this.lastCompositionOffset) {
                if (this.lastCompositionSamples > 0) {
                    this.compositionOffsets.add(new CompositionOffsetsBox.Entry(this.lastCompositionSamples, this.lastCompositionOffset));
                }
                this.lastCompositionOffset = compositionOffset;
                this.lastCompositionSamples = 0;
            }
            ++this.lastCompositionSamples;
            this.ptsEstimate += pkt.getDuration();
        }
        if (this.lastEntry != -1 && this.lastEntry != entryNo) {
            this.outChunk(this.lastEntry);
            this.samplesInLastChunk = -1;
        }
        this.curChunk.add(pkt.getData());
        if (pkt.isKeyFrame()) {
            this.iframes.add(this.curFrame + 1);
        } else {
            this.allIframes = false;
        }
        ++this.curFrame;
        this.chunkDuration += pkt.getDuration();
        if (this.curDuration != -1L && pkt.getDuration() != this.curDuration) {
            this.sampleDurations.add(new TimeToSampleBox.TimeToSampleEntry((int)this.sameDurCount, (int)this.curDuration));
            this.sameDurCount = 0L;
        }
        this.curDuration = pkt.getDuration();
        ++this.sameDurCount;
        this.trackTotalDuration += pkt.getDuration();
        this.outChunkIfNeeded(entryNo);
        this.lastEntry = entryNo;
    }

    private void processTimecode(Packet pkt) throws IOException {
        if (this.timecodeTrack != null) {
            this.timecodeTrack.addTimecode(pkt);
        }
    }

    private void outChunkIfNeeded(int entryNo) throws IOException {
        Assert.assertTrue(this.tgtChunkDurationUnit == Unit.FRAME || this.tgtChunkDurationUnit == Unit.SEC);
        if (this.tgtChunkDurationUnit == Unit.FRAME && this.curChunk.size() * this.tgtChunkDuration.getDen() == this.tgtChunkDuration.getNum()) {
            this.outChunk(entryNo);
        } else if (this.tgtChunkDurationUnit == Unit.SEC && this.chunkDuration > 0L && this.chunkDuration * (long)this.tgtChunkDuration.getDen() >= (long)(this.tgtChunkDuration.getNum() * this._timescale)) {
            this.outChunk(entryNo);
        }
    }

    void outChunk(int entryNo) throws IOException {
        if (this.curChunk.size() == 0) {
            return;
        }
        this.chunkOffsets.add(this.out.position());
        for (ByteBuffer bs : this.curChunk) {
            this.sampleSizes.add(bs.remaining());
            this.out.write(bs);
        }
        if (this.samplesInLastChunk == -1 || this.samplesInLastChunk != this.curChunk.size()) {
            this.samplesInChunks.add(new SampleToChunkBox.SampleToChunkEntry(this.chunkNo + 1, this.curChunk.size(), entryNo));
        }
        this.samplesInLastChunk = this.curChunk.size();
        ++this.chunkNo;
        this.chunkDuration = 0L;
        this.curChunk.clear();
    }

    @Override
    protected Box finish(MovieHeaderBox mvhd) throws IOException {
        if (this.finished) {
            throw new IllegalStateException("The muxer track has finished muxing");
        }
        if (this.getEntries().isEmpty()) {
            if (this.codec == Codec.H264) {
                SeqParameterSet sps = SeqParameterSet.read(this.spsList.get(0).duplicate());
                Size size = H264Utils.getPicSize(sps);
                VideoCodecMeta meta = new VideoCodecMeta(size, ColorSpace.YUV420);
                this.addVideoSampleEntry(meta);
            } else {
                throw new RuntimeException("Sample entry missing not supported for anything other then H.264");
            }
        }
        this.setCodecPrivateIfNeeded();
        this.outChunk(this.lastEntry);
        if (this.sameDurCount > 0L) {
            this.sampleDurations.add(new TimeToSampleBox.TimeToSampleEntry((int)this.sameDurCount, (int)this.curDuration));
        }
        this.finished = true;
        TrakBox trak = TrakBox.createTrakBox();
        Size dd = this.getDisplayDimensions();
        TrackHeaderBox tkhd = TrackHeaderBox.createTrackHeaderBox(this.trackId, (long)mvhd.getTimescale() * this.trackTotalDuration / (long)this._timescale, dd.getWidth(), dd.getHeight(), new Date().getTime(), new Date().getTime(), 1.0f, (short)0, 0L, new int[]{65536, 0, 0, 0, 65536, 0, 0, 0, 0x40000000});
        tkhd.setFlags(15);
        trak.add(tkhd);
        this.tapt(trak);
        MediaBox media = MediaBox.createMediaBox();
        trak.add(media);
        media.add(MediaHeaderBox.createMediaHeaderBox(this._timescale, this.trackTotalDuration, 0, new Date().getTime(), new Date().getTime(), 0));
        HandlerBox hdlr = HandlerBox.createHandlerBox("mhlr", this.type.getHandler(), "appl", 0, 0);
        media.add(hdlr);
        MediaInfoBox minf = MediaInfoBox.createMediaInfoBox();
        media.add(minf);
        this.mediaHeader(minf, this.type);
        minf.add(HandlerBox.createHandlerBox("dhlr", "url ", "appl", 0, 0));
        this.addDref(minf);
        NodeBox stbl = new NodeBox(new Header("stbl"));
        minf.add(stbl);
        this.putCompositionOffsets(stbl);
        this.putEdits(trak);
        this.putName(trak);
        stbl.add(SampleDescriptionBox.createSampleDescriptionBox(this.sampleEntries.toArray(new SampleEntry[0])));
        stbl.add(SampleToChunkBox.createSampleToChunkBox(this.samplesInChunks.toArray(new SampleToChunkBox.SampleToChunkEntry[0])));
        stbl.add(SampleSizesBox.createSampleSizesBox2(this.sampleSizes.toArray()));
        stbl.add(TimeToSampleBox.createTimeToSampleBox(this.sampleDurations.toArray(new TimeToSampleBox.TimeToSampleEntry[0])));
        stbl.add(ChunkOffsets64Box.createChunkOffsets64Box(this.chunkOffsets.toArray()));
        if (!this.allIframes && this.iframes.size() > 0) {
            stbl.add(SyncSamplesBox.createSyncSamplesBox(this.iframes.toArray()));
        }
        return trak;
    }

    void addVideoSampleEntry(VideoCodecMeta meta) {
        VideoSampleEntry se = MP4Muxer.videoSampleEntry(codec2fourcc.get((Object)this.codec), meta.getSize(), "JCodec");
        if (meta.getPixelAspectRatio() != null) {
            se.add(PixelAspectExt.createPixelAspectExt(meta.getPixelAspectRatio()));
        }
        this.addSampleEntry(se);
    }

    private void putCompositionOffsets(NodeBox stbl) {
        if (this.compositionOffsets.size() > 0) {
            CompositionOffsetsBox.Entry first;
            this.compositionOffsets.add(new CompositionOffsetsBox.Entry(this.lastCompositionSamples, this.lastCompositionOffset));
            int min = FramesMP4MuxerTrack.minOffset(this.compositionOffsets);
            if (min > 0) {
                for (CompositionOffsetsBox.Entry entry : this.compositionOffsets) {
                    entry.offset -= min;
                }
            }
            if ((first = this.compositionOffsets.get(0)).getOffset() > 0) {
                if (this.edits == null) {
                    this.edits = new ArrayList();
                    this.edits.add(new Edit(this.trackTotalDuration, first.getOffset(), 1.0f));
                } else {
                    for (Edit edit : this.edits) {
                        edit.setMediaTime(edit.getMediaTime() + (long)first.getOffset());
                    }
                }
            }
            stbl.add(CompositionOffsetsBox.createCompositionOffsetsBox(this.compositionOffsets.toArray(new CompositionOffsetsBox.Entry[0])));
        }
    }

    public static int minOffset(List<CompositionOffsetsBox.Entry> offs) {
        int min = Integer.MAX_VALUE;
        for (CompositionOffsetsBox.Entry entry : offs) {
            if (entry.getOffset() >= min) continue;
            min = entry.getOffset();
        }
        return min;
    }

    @Override
    public long getTrackTotalDuration() {
        return this.trackTotalDuration;
    }

    public void addSampleEntries(SampleEntry[] sampleEntries) {
        for (int i = 0; i < sampleEntries.length; ++i) {
            SampleEntry se = sampleEntries[i];
            this.addSampleEntry(se);
        }
    }

    public TimecodeMP4MuxerTrack getTimecodeTrack() {
        return this.timecodeTrack;
    }

    public void setTimecode(TimecodeMP4MuxerTrack timecodeTrack) {
        this.timecodeTrack = timecodeTrack;
    }

    public void setCodecPrivateIfNeeded() {
        if (this.codec == Codec.H264) {
            this.getEntries().get(0).add(H264Utils.createAvcCFromPS(this.selectUnique(this.spsList), this.selectUnique(this.ppsList), 4));
        } else if (this.codec == Codec.AAC) {
            this.getEntries().get(0).add(EsdsBox.fromADTS(this.adtsHeader));
        }
    }

    private List<ByteBuffer> selectUnique(List<ByteBuffer> bblist) {
        HashSet<ByteArrayWrapper> all = new HashSet<ByteArrayWrapper>();
        for (ByteBuffer byteBuffer : bblist) {
            all.add(new ByteArrayWrapper(byteBuffer));
        }
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        for (ByteArrayWrapper bs : all) {
            result.add(bs.get());
        }
        return result;
    }

    public static AudioSampleEntry compressedAudioSampleEntry(String fourcc, int drefId, int sampleSize, int channels, int sampleRate, int samplesPerPacket, int bytesPerPacket, int bytesPerFrame) {
        AudioSampleEntry ase = AudioSampleEntry.createAudioSampleEntry(Header.createHeader(fourcc, 0L), (short)drefId, (short)channels, (short)16, sampleRate, (short)0, 0, 65534, 0, samplesPerPacket, bytesPerPacket, bytesPerFrame, 2, (short)0);
        return ase;
    }

    void addAudioSampleEntry(AudioFormat format) {
        AudioSampleEntry ase = FramesMP4MuxerTrack.compressedAudioSampleEntry(codec2fourcc.get((Object)this.codec), 1, 16, format.getChannels(), format.getSampleRate(), 0, 0, 0);
        this.addSampleEntry(ase);
    }

    static {
        codec2fourcc.put(Codec.H264, "avc1");
        codec2fourcc.put(Codec.AAC, "mp4a");
        codec2fourcc.put(Codec.PRORES, "apch");
        codec2fourcc.put(Codec.JPEG, "mjpg");
        codec2fourcc.put(Codec.PNG, "png ");
        codec2fourcc.put(Codec.V210, "v210");
    }

    private static class ByteArrayWrapper {
        private byte[] bytes;

        public ByteArrayWrapper(ByteBuffer bytes) {
            this.bytes = NIOUtils.toArray(bytes);
        }

        public ByteBuffer get() {
            return ByteBuffer.wrap(this.bytes);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ByteArrayWrapper)) {
                return false;
            }
            return Arrays.equals(this.bytes, ((ByteArrayWrapper)obj).bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }
    }
}

